# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.hostname import Hostname
from ...base.types.port import Port
from ...base.types.url_string import UrlString
from .url_category_ids import UrlCategoryIds

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Url(pydantic.BaseModel):
    """
    The Uniform Resource Locator(URL) object describes the characteristics of a URL. Defined in <a target='_blank' href='https://datatracker.ietf.org/doc/html/rfc1738'>RFC 1738</a> and by D3FEND <a target='_blank' href='https://d3fend.mitre.org/dao/artifact/d3f:URL/'>d3f:URL</a>.
    """

    categories: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The Website categorization names, as defined by <code>category_ids</code> enum values.
    """

    category_ids: typing.Optional[typing.List[UrlCategoryIds]] = pydantic.Field(default=None)
    """
    The Website categorization identifiers.
    """

    domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The domain portion of the URL. For example: <code>example.com</code> in <code>https://sub.example.com</code>.
    """

    hostname: typing.Optional[Hostname] = pydantic.Field(default=None)
    """
    The URL host as extracted from the URL. For example: <code>www.example.com</code> from <code>www.example.com/download/trouble</code>.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL path as extracted from the URL. For example: <code>/download/trouble</code> from <code>www.example.com/download/trouble</code>.
    """

    port: typing.Optional[Port] = pydantic.Field(default=None)
    """
    The URL port. For example: <code>80</code>.
    """

    query_string: typing.Optional[str] = pydantic.Field(default=None)
    """
    The query portion of the URL. For example: the query portion of the URL <code>http://www.example.com/search?q=bad&sort=date</code> is <code>q=bad&sort=date</code>.
    """

    resource_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The context in which a resource was retrieved in a web request.
    """

    scheme: typing.Optional[str] = pydantic.Field(default=None)
    """
    The scheme portion of the URL. For example: <code>http</code>, <code>https</code>, <code>ftp</code>, or <code>sftp</code>.
    """

    subdomain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The subdomain portion of the URL. For example: <code>sub</code> in <code>https://sub.example.com</code> or <code>sub2.sub1</code> in <code>https://sub2.sub1.example.com</code>.
    """

    url_string: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The URL string. See RFC 1738. For example: <code>http://www.example.com/download/trouble.exe</code>. Note: The URL path should not populate the URL string.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
