# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.email_address import EmailAddress
from ...base.types.ip_address import IpAddress
from .file import File
from .http_header import HttpHeader
from .url import Url

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Email(pydantic.BaseModel):
    """
    The Email object describes the email metadata such as sender, recipients, and direction, and can include embedded URLs and files.
    """

    cc: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The machine-readable email header Cc values, as defined by RFC 5322. For example <code>example.user@usersdomain.com</code>.
    """

    cc_mailboxes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The human-readable email header Cc Mailbox values. For example <code>'Example User &lt;example.user@usersdomain.com&gt;'</code>.
    """

    delivered_to: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The machine-readable <strong>Delivered-To</strong> email header field. For example <code>example.user@usersdomain.com</code>
    """

    delivered_to_list: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The machine-readable <strong>Delivered-To</strong> email header values. For example <code>example.user@usersdomain.com</code>
    """

    files: typing.Optional[typing.List[File]] = pydantic.Field(default=None)
    """
    The files embedded or attached to the email.
    """

    from_: typing.Optional[EmailAddress] = pydantic.Field(alias="from", default=None)
    """
    The machine-readable email header From values, as defined by RFC 5322. For example <code>example.user@usersdomain.com</code>
    """

    from_mailbox: typing.Optional[str] = pydantic.Field(default=None)
    """
    The human-readable email header From Mailbox value. For example <code>'Example User &lt;example.user@usersdomain.com&gt;'</code>.
    """

    http_headers: typing.Optional[typing.List[HttpHeader]] = pydantic.Field(default=None)
    """
    Additional HTTP headers of an HTTP request or response.
    """

    message_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email header Message-ID value, as defined by RFC 5322.
    """

    raw_header: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email authentication header.
    """

    reply_to: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The machine-readable email header Reply-To values, as defined by RFC 5322. For example <code>example.user@usersdomain.com</code>
    """

    reply_to_mailboxes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The human-readable email header Reply To Mailbox values. For example <code>'Example User &lt;example.user@usersdomain.com&gt;'</code>.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size in bytes of the email, including attachments.
    """

    smtp_from: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The value of the SMTP MAIL FROM command.
    """

    smtp_to: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The value of the SMTP envelope RCPT TO command.
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email header Subject value, as defined by RFC 5322.
    """

    to: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The machine-readable email header To values, as defined by RFC 5322. For example <code>example.user@usersdomain.com</code>
    """

    to_mailboxes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The human-readable email header To Mailbox values. For example <code>'Example User &lt;example.user@usersdomain.com&gt;'</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the email thread.
    """

    urls: typing.Optional[typing.List[Url]] = pydantic.Field(default=None)
    """
    The URLs embedded in the email.
    """

    x_originating_ip: typing.Optional[typing.List[IpAddress]] = pydantic.Field(default=None)
    """
    The X-Originating-IP header identifying the emails originating IP address(es).
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
