# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.url_string import UrlString

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class D3FTactic(pydantic.BaseModel):
    """
    The MITRE D3FEND™ Tactic object describes the tactic ID and/or name that is associated to an attack.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tactic name that is associated with the defensive technique. For example: <code>Isolate</code>.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The versioned permalink of the defensive tactic. For example: <code>https://d3fend.mitre.org/tactic/d3f:Isolate/</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the defensive tactic.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
