# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.url_string import UrlString

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class D3FTechnique(pydantic.BaseModel):
    """
    The MITRE D3FEND™ Technique object describes the leaf defensive technique ID and/or name associated to a countermeasure.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the defensive technique. For example: <code>IO Port Restriction</code>.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The versioned permalink of the defensive technique. For example: <code>https://d3fend.mitre.org/technique/d3f:IOPortRestriction/</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the defensive technique. For example: <code>D3-IOPR</code>.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
