# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.timestamp import Timestamp

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Epss(pydantic.BaseModel):
    """
    The Exploit Prediction Scoring System (EPSS) object describes the estimated probability a vulnerability will be exploited. EPSS is a community-driven effort to combine descriptive information about vulnerabilities (CVEs) with evidence of actual exploitation in-the-wild. (<a target='_blank' href='https://www.first.org/epss/'>EPSS</a>).
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The timestamp indicating when the EPSS score was calculated.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The timestamp indicating when the EPSS score was calculated.
    """

    percentile: typing.Optional[float] = pydantic.Field(default=None)
    """
    The EPSS score's percentile representing relative importance and ranking of the score in the larger EPSS dataset.
    """

    score: str = pydantic.Field()
    """
    The EPSS score representing the probability [0-1] of exploitation in the wild in the next 30 days (following score publication).
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the EPSS model used to calculate the score.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
