# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.timestamp import Timestamp
from ...base.types.url_string import UrlString
from .analytic import Analytic
from .attack import Attack
from .key_value_object import KeyValueObject
from .kill_chain_phase import KillChainPhase
from .product import Product
from .related_event import RelatedEvent
from .trait import Trait

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class FindingInfo(pydantic.BaseModel):
    """
    The Finding Information object describes metadata related to a security finding generated by a security tool or system.
    """

    analytic: typing.Optional[Analytic] = pydantic.Field(default=None)
    """
    The analytic technique used to analyze and derive insights from the data or information that led to the finding or conclusion.
    """

    attacks: typing.Optional[typing.List[Attack]] = pydantic.Field(default=None)
    """
    The <a target='_blank' href='https://attack.mitre.org'>MITRE ATT&CK®</a> technique and associated tactics related to the finding.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was created.
    """

    data_sources: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of data sources utilized in generation of the finding.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the reported finding.
    """

    first_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was first observed. e.g. The time when a vulnerability was first observed. <p>It can differ from the <code>created_time</code> timestamp, which reflects the time this finding was created.</p>
    """

    first_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was first observed. e.g. The time when a vulnerability was first observed. <p>It can differ from the <code>created_time</code> timestamp, which reflects the time this finding was created.</p>
    """

    kill_chain: typing.Optional[typing.List[KillChainPhase]] = pydantic.Field(default=None)
    """
    The <a target='_blank' href='https://www.lockheedmartin.com/en-us/capabilities/cyber/cyber-kill-chain.html'>Cyber Kill Chain®</a> provides a detailed description of each phase and its associated activities within the broader context of a cyber attack.
    """

    last_seen_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was most recently observed. e.g. The time when a vulnerability was most recently observed. <p>It can differ from the <code>modified_time</code> timestamp, which reflects the time this finding was last modified.</p>
    """

    last_seen_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was most recently observed. e.g. The time when a vulnerability was most recently observed. <p>It can differ from the <code>modified_time</code> timestamp, which reflects the time this finding was last modified.</p>
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the finding was last modified.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the finding was last modified.
    """

    product: typing.Optional[Product] = pydantic.Field(default=None)
    """
    Details about the product that reported the finding.
    """

    product_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the product that reported the finding.
    """

    related_analytics: typing.Optional[typing.List[Analytic]] = pydantic.Field(default=None)
    """
    Other analytics related to this finding.
    """

    related_events: typing.Optional[typing.List[RelatedEvent]] = pydantic.Field(default=None)
    """
    Describes events and/or other findings related to the finding as identified by the security product. Note that these events may or may not be in OCSF.
    """

    related_events_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of related events or findings.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The URL pointing to the source of the finding.
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated with the finding.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A title or a brief phrase summarizing the reported finding.
    """

    traits: typing.Optional[typing.List[Trait]] = pydantic.Field(default=None)
    """
    The list of key traits or characteristics extracted from the finding.
    """

    types: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    One or more types of the reported finding.
    """

    uid: str = pydantic.Field()
    """
    The unique identifier of the reported finding.
    """

    uid_alt: typing.Optional[str] = pydantic.Field(default=None)
    """
    The alternative unique identifier of the reported finding.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
