# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.url_string import UrlString
from .d_3_fend import D3Fend

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Mitigation(pydantic.BaseModel):
    """
    The MITRE Mitigation object describes the ATT&CK® or ATLAS™ Mitigation ID and/or name that is associated to an attack.
    """

    countermeasures: typing.Optional[typing.List[D3Fend]] = pydantic.Field(default=None)
    """
    The D3FEND countermeasures that are associated with the attack technique. For example: ATT&CK Technique <code>T1003</code> is addressed by Mitigation <code>M1027</code>, and D3FEND Technique <code>D3-OTP</code>.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Mitigation name that is associated with the attack technique. For example: <code>Password Policies</code>, or <code>Code Signing</code>.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The versioned permalink of the Mitigation. For example: <code>https://attack.mitre.org/versions/v14/mitigations/M1027</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Mitigation ID that is associated with the attack technique. For example: <code>M1027</code>, or <code>AML.M0013</code>.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
