# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Organization(pydantic.BaseModel):
    """
    The Organization object describes characteristics of an organization or company and its division if any. Additionally, it also describes cloud and Software-as-a-Service (SaaS) logical hierarchies such as AWS Organizations, Google Cloud Organizations, Oracle Cloud Tenancies, and similar constructs.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization, Oracle Cloud Tenancy, Google Cloud Organization, or AWS Organization. For example, <code> Widget, Inc. </code> or the <code> AWS Organization name </code>.
    """

    ou_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of an organizational unit, Google Cloud Folder, or AWS Org Unit. For example, the <code> GCP Project Name </code>, or <code> Dev_Prod_OU </code>.
    """

    ou_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of an organizational unit, Google Cloud Folder, or AWS Org Unit. For example, an <code> Oracle Cloud Tenancy ID </code>, <code> AWS OU ID </code>, or <code> GCP Folder ID </code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the organization, Oracle Cloud Tenancy, Google Cloud Organization, or AWS Organization. For example, an <code> AWS Org ID </code> or <code> Oracle Cloud Domain ID </code>.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
