# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.timestamp import Timestamp
from .package import Package
from .product import Product
from .sbom_type_id import SbomTypeId
from .software_component import SoftwareComponent

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Sbom(pydantic.BaseModel):
    """
    The Software Bill of Materials object describes characteristics of a generated SBOM.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the SBOM was created.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the SBOM was created.
    """

    package: Package = pydantic.Field()
    """
    The software package or library that is being discovered or inventoried by an SBOM.
    """

    product: typing.Optional[Product] = pydantic.Field(default=None)
    """
    Details about the upstream product that generated the SBOM e.g. <code>cdxgen</code> or <code>Syft</code>.
    """

    software_components: typing.List[SoftwareComponent] = pydantic.Field()
    """
    The list of software components used in the software package.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of SBOM, normalized to the caption of the <code>type_id</code> value. In the case of 'Other', it is defined by the source.
    """

    type_id: typing.Optional[SbomTypeId] = pydantic.Field(default=None)
    """
    The type of SBOM.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for the SBOM or the SBOM generation by a source tool, such as the SPDX <code>metadata.component.bom-ref</code>.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The specification (spec) version of the particular SBOM, e.g., <code>1.6</code>.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
