# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.timestamp import Timestamp
from .timespan_type_id import TimespanTypeId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Timespan(pydantic.BaseModel):
    """
    The Time Span object represents different time period durations. If a timespan is fractional, i.e. crosses one period, e.g. a week and 3 days, more than one may be populated since each member is of integral type. In that case <code>type_id</code> if present should be set to <code>Other.</code><P>A timespan may also be defined by its time interval boundaries, <code>start_time</code> and <code>end_time</code>.
    """

    duration: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in milliseconds.
    """

    duration_days: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in days.
    """

    duration_hours: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in hours.
    """

    duration_mins: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in minutes.
    """

    duration_months: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in months.
    """

    duration_secs: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in seconds.
    """

    duration_weeks: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in weeks.
    """

    duration_years: typing.Optional[int] = pydantic.Field(default=None)
    """
    The duration of the time span in years.
    """

    end_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The end time or conclusion of the timespan's interval.
    """

    end_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The end time or conclusion of the timespan's interval.
    """

    start_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The start time or beginning of the timespan's interval.
    """

    start_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The start time or beginning of the timespan's interval.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of time span duration the object represents.
    """

    type_id: typing.Optional[TimespanTypeId] = pydantic.Field(default=None)
    """
    The normalized identifier for the time span duration type.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
