# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Trait(pydantic.BaseModel):
    """
    Describes a characteristic or feature of an entity that was observed. For example, this object can be used to represent specific characteristics derived from events or findings that can be surfaced as distinguishing traits of the entity in question.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The high-level grouping or classification this trait belongs to.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the trait.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the trait. For example, this can be used to indicate if the trait acts as a contributing factor (increases risk/severity) or a mitigating factor (decreases risk/severity), in the context of the related finding.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the trait.
    """

    values: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The values of the trait.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
