# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...management.types.additional_mapping import AdditionalMapping
from ...providers_generated.types.provider_config_id import ProviderConfigId
from .additional_mapping_type import AdditionalMappingType

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AdditionalMappingTemplate(AdditionalMapping):
    providers: typing.List[ProviderConfigId] = pydantic.Field()
    """
    A list of provider ID strings that this mapping applies to. Mapping templates must have at least one provider.
    """

    mapping_type: typing.Optional[AdditionalMappingType] = pydantic.Field(default=None)
    """
    This controls the end-user's responsibility for this mapping when creating an integration in this integration point. Default: 'optional'.
    When set to 'fixed' the mapping is always included and can not be overridden by the end-user.
    When 'optional', the end-user can choose to override the mapping.
    When 'recommended', the provider will enter a warning state if the mapping is missing.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
