# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from ...permissionset_base.types.permissions import Permissions
from .api_permission_map import ApiPermissionMap
from .resource_restrictions import ResourceRestrictions

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class PermissionSet(pydantic.BaseModel):
    name: Permissions
    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of when the permission set should be used and what permissions are granted by the permission set.
    """

    resource_restrictions: typing.Optional[typing.List[ResourceRestrictions]] = pydantic.Field(default=None)
    """
    Resources that can be used with this permission set
    """

    permissions: ApiPermissionMap = pydantic.Field()
    """
    API permissions granted by the permission set.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
