# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .open_text_core_application_security_credential import OpenTextCoreApplicationSecurityCredential
from .open_text_core_application_security_url import OpenTextCoreApplicationSecurityUrl

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AppsecOpenTextCoreApplicationSecurity(pydantic.BaseModel):
    """
    Configuration for OpenText Core Application Security (formerly Fortify On Demand) as an application security provider.
    """

    credential: OpenTextCoreApplicationSecurityCredential = pydantic.Field()
    """
    Credentials used for accessing the OpenText Core Application Security API.
    """

    url: OpenTextCoreApplicationSecurityUrl = pydantic.Field()
    """
    Base URL for the OpenText Core Application Security API. This URL should be the same as the URL used to access the OpenText Core Application Security web interface.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
