# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .slack_credential import SlackCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class NotificationsSlack(pydantic.BaseModel):
    """
    Configuration for Slack.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/slack-notification-setup)
    """

    channel: str = pydantic.Field()
    """
    Channel to send notifications to. Must be a valid existing channel.
    """

    credential: SlackCredential
    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the Slack API.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
