# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .aws_security_lake_credential import AwsSecurityLakeCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SinkAwsSecurityLake(pydantic.BaseModel):
    """
    Configuration for Amazon Security Lake as a Sink provider. Events are written directly to an AWS S3 bucket in Apache Parquet format.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/amazon-security-lake-sink-setup)
    """

    credential: AwsSecurityLakeCredential = pydantic.Field()
    """
    AWS Access Keys with write access to the configured S3 bucket.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    Override the default AWS region for this integration. If not present, the region will be inferred from the URL.
    """

    url: str = pydantic.Field()
    """
    URL of the S3 bucket where the Amazon Security Lake events are stored.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
