# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .splunk_hec_token import SplunkHecToken

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SinkSplunk(pydantic.BaseModel):
    """
    Configuration for Splunk as a Sink provider. Allows sending data to Splunk using an HTTP Event Collector (HEC).

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/splunk-setup)
    """

    hec_credential: SplunkHecToken = pydantic.Field()
    """
    Credential to use when connecting to the Splunk HEC service. If not provided, sending events to Splunk is disabled.
    """

    hec_url: str = pydantic.Field()
    """
    URL for the Splunk HEC endpoint. Must include the full path to the HEC endpoint.
    """

    index: typing.Optional[str] = pydantic.Field(default=None)
    """
    Splunk index to send events to. If not provided, will use the default index for the Splunk collector.
    """

    skip_tls_verify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, skips verification of the Splunk TLS certificate.
    """

    source: typing.Optional[str] = pydantic.Field(default=None)
    """
    Splunk source to send events to. If not provided the default source for the Splunk collector is used.
    """

    source_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Splunk source type to send events to. If not provided the default source type for the Splunk collector is used.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
