import sys
import unittest
from contextlib import redirect_stdout
from io import StringIO
from unittest.mock import patch

from apt_toolkit import __version__
from apt_toolkit import cli_root


class AptRootCliTests(unittest.TestCase):
    def test_version_flag_outputs_package_version(self):
        buffer = StringIO()
        with redirect_stdout(buffer):
            exit_code = cli_root.main(["--version"])

        self.assertEqual(exit_code, 0)
        self.assertEqual(buffer.getvalue().strip(), __version__)

    def test_analyzer_delegates_to_cli_main_preserving_arguments(self):
        call_count = {"value": 0}

        def fake_main():
            call_count["value"] += 1
            self.assertEqual(
                sys.argv,
                ["apt-analyzer", "initial-access", "--json"],
            )
            return 0

        with patch("apt_toolkit.cli.main", side_effect=fake_main):
            exit_code = cli_root.main(["analyzer", "initial-access", "--json"])

        self.assertEqual(exit_code, 0)
        self.assertEqual(call_count["value"], 1)

    def test_missing_command_prints_help(self):
        buffer = StringIO()
        with redirect_stdout(buffer):
            exit_code = cli_root.main([])

        self.assertEqual(exit_code, 0)
        self.assertIn("usage: apt", buffer.getvalue())


if __name__ == "__main__":  # pragma: no cover
    unittest.main()
