"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnSchema = exports.toJson_PrimaryKey = exports.toJson_Column = exports.toJson_Grant = exports.toJson_Table = exports.CfnSchemaPropsSqlIdempotency = exports.toJson_User = exports.toJson_Database = exports.toJson_CfnSchemaProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnSchemaProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnSchemaProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ClusterArn': obj.clusterArn,
        'SecretArn': obj.secretArn,
        'Databases': obj.databases?.map(y => toJson_Database(y)),
        'SQL': obj.sql?.map(y => y),
        'Users': obj.users?.map(y => toJson_User(y)),
        'SQLIdempotency': obj.sqlIdempotency,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnSchemaProps = toJson_CfnSchemaProps;
/**
 * Converts an object of type 'Database' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Database(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Tables': obj.tables?.map(y => toJson_Table(y)),
        'Extensions': obj.extensions?.map(y => y),
        'SQL': obj.sql?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Database = toJson_Database;
/**
 * Converts an object of type 'User' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_User(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'SecretId': obj.secretId,
        'SuperUser': obj.superUser,
        'Grants': obj.grants?.map(y => toJson_Grant(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_User = toJson_User;
/* eslint-enable max-len, quote-props */
/**
 * Whether arbitrary SQL statements are executed once (IDEMPOTENT), or on every update (RUN_ONCE).
 *
 * @schema CfnSchemaPropsSqlIdempotency
 */
var CfnSchemaPropsSqlIdempotency;
(function (CfnSchemaPropsSqlIdempotency) {
    /** IDEMPOTENT */
    CfnSchemaPropsSqlIdempotency["IDEMPOTENT"] = "IDEMPOTENT";
    /** RUN_ONCE */
    CfnSchemaPropsSqlIdempotency["RUN_ONCE"] = "RUN_ONCE";
})(CfnSchemaPropsSqlIdempotency = exports.CfnSchemaPropsSqlIdempotency || (exports.CfnSchemaPropsSqlIdempotency = {}));
/**
 * Converts an object of type 'Table' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Table(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Columns': obj.columns?.map(y => toJson_Column(y)),
        'PrimaryKey': toJson_PrimaryKey(obj.primaryKey),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Table = toJson_Table;
/**
 * Converts an object of type 'Grant' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Grant(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Database': obj.database,
        'Table': obj.table,
        'Privileges': obj.privileges?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Grant = toJson_Grant;
/**
 * Converts an object of type 'Column' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Column(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Type': obj.type,
        'Nullable': obj.nullable,
        'Default': obj.default,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Column = toJson_Column;
/**
 * Converts an object of type 'PrimaryKey' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_PrimaryKey(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Type': obj.type,
        'Default': obj.default,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_PrimaryKey = toJson_PrimaryKey;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Generic::Database::Schema`
 *
 * @cloudformationResource Generic::Database::Schema
 * @stability external
 * @link https://github.com/iann0036/cfn-types/tree/master/generic-database-schema
 */
class CfnSchema extends cdk.CfnResource {
    /**
     * Create a new `Generic::Database::Schema`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnSchema.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnSchemaProps(props) });
        this.props = props;
        this.attrExecutionId = cdk.Token.asString(this.getAtt('ExecutionId'));
    }
}
exports.CfnSchema = CfnSchema;
_a = JSII_RTTI_SYMBOL_1;
CfnSchema[_a] = { fqn: "@cdk-cloudformation/generic-database-schema.CfnSchema", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnSchema.CFN_RESOURCE_TYPE_NAME = "Generic::Database::Schema";
//# sourceMappingURL=data:application/json;base64,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