import logging
import pathlib

import requests
from bs4 import BeautifulSoup
from joblib import Memory

path = pathlib.Path("~/.iceberg").expanduser()

CACHE_FILE = path / "oid-lookup"
cache_file = pathlib.Path(CACHE_FILE).expanduser()
cache_file.parent.mkdir(parents=True, exist_ok=True)
oid_cache = Memory(cache_file, verbose=0)

fhir_value_sets = {
    "internal-cholesterol-inl": "example",
    "urn:oid:2.16.840.1.113883.4.642.4.1827": "example",
    "urn:oid:2.16.840.1.113883.4.642.4.1825": "nhin-purposeofuse",
    "urn:oid:2.16.840.1.113883.4.642.4.1821": "summary",
    "urn:oid:2.16.840.1.113883.4.642.4.1820": "example-supplement",
    "urn:oid:2.16.840.1.113883.4.642.4.1822": "example-supplement-2",
    "urn:oid:2.16.840.1.113883.4.642.4.1824": "example-metadata",
    "urn:oid:2.16.840.1.113883.4.642.4.1829": "example-metadata-2",
    "urn:oid:2.16.840.1.113883.4.642.4.1802": "fhir-types",
    "urn:oid:2.16.840.1.113883.4.642.4.1803": "fhirpath-types",
    "urn:oid:2.16.840.1.113883.4.642.4.2": "administrative-gender",
    "urn:oid:2.16.840.1.113883.4.642.4.44": "binding-strength",
    "urn:oid:2.16.840.1.113883.4.642.4.1066": "cdshooks-indicator",
    "urn:oid:2.16.840.1.113883.4.642.4.1986": "concept-map-relationship",
    "urn:oid:2.16.840.1.113883.4.642.4.8": "document-reference-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1310": "FHIR-version",
    "urn:oid:2.16.840.1.113883.4.642.4.16": "note-type",
    "urn:oid:2.16.840.1.113883.4.642.4.4": "publication-status",
    "urn:oid:2.16.840.1.113883.4.642.4.36": "relationship",
    "urn:oid:2.16.840.1.113883.4.642.4.14": "remittance-outcome",
    "urn:oid:2.16.840.1.113883.4.642.4.12": "search-param-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1798": "usage-context-agreement-scope",
    "urn:oid:2.16.840.1.113883.4.642.4.1823": "restful-interaction",
    "urn:oid:2.16.840.1.113883.4.642.4.1819": "safety-entries",
    "urn:oid:2.16.840.1.113883.4.642.4.1826": "concept-properties",
    "urn:oid:2.16.840.1.113883.4.642.4.1844": "w3c-provenance-activity-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1845": "extra-activity-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1828": "resource-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1801": "tldc",
    "urn:oid:2.16.840.1.113883.4.642.4.1808": "etsi-signature-type",
    "urn:oid:2.16.840.1.113883.4.642.4.64": "astm-signature-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1800": "sample-security-structural-roles",
    "urn:oid:2.16.840.1.113883.4.642.4.1911": "fhir-format-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2113": "fhir-old-types",
    "urn:oid:2.16.840.1.113883.4.642.4.2120": "color-names",
    "urn:oid:2.16.840.1.113883.4.642.4.2121": "color-rgb",
    "urn:oid:2.16.840.1.113883.4.642.1.1271": "conformance-expectation",
    "urn:oid:2.16.840.1.113883.4.642.1.839": "conformance-expectation",
    "urn:oid:2.16.840.1.113883.4.642.4.1884": "related-artifact-type-expanded",
    "urn:oid:2.16.840.1.113883.4.642.4.56": "narrative-status",
    "urn:oid:2.16.840.1.113883.4.642.1.58": "identifier-use",
    "urn:oid:2.16.840.1.113883.4.642.4.60": "quantity-comparator",
    "urn:oid:2.16.840.1.113883.4.642.4.66": "name-use",
    "urn:oid:2.16.840.1.113883.4.642.1.68": "address-use",
    "urn:oid:2.16.840.1.113883.4.642.1.70": "address-type",
    "urn:oid:2.16.840.1.113883.4.642.1.72": "contact-point-system",
    "urn:oid:2.16.840.1.113883.4.642.1.74": "contact-point-use",
    "urn:oid:2.16.840.1.113883.4.642.1.76": "event-timing",
    "urn:oid:2.16.840.1.113883.4.642.4.513": "days-of-week",
    "urn:oid:2.16.840.1.113883.4.642.4.1809": "virtual-service-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1807": "price-component-type",
    "urn:oid:2.16.840.1.113883.4.642.1.94": "contributor-type",
    "urn:oid:2.16.840.1.113883.4.642.4.980": "sort-direction",
    "urn:oid:2.16.840.1.113883.4.642.4.509": "operation-parameter-use",
    "urn:oid:2.16.840.1.113883.4.642.4.100": "related-artifact-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1982": "citation-artifact-classifier",
    "urn:oid:2.16.840.1.113883.4.642.4.104": "trigger-type",
    "urn:oid:2.16.840.1.113883.4.642.1.82": "constraint-severity",
    "urn:oid:2.16.840.1.113883.4.642.4.84": "resource-slicing-rules",
    "urn:oid:2.16.840.1.113883.4.642.4.86": "resource-aggregation-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.88": "property-representation",
    "urn:oid:2.16.840.1.113883.4.642.4.90": "reference-version-rules",
    "urn:oid:2.16.840.1.113883.4.642.1.92": "discriminator-type",
    "urn:oid:2.16.840.1.113883.4.642.4.110": "event-status",
    "urn:oid:2.16.840.1.113883.4.642.4.112": "request-status",
    "urn:oid:2.16.840.1.113883.4.642.4.114": "request-intent",
    "urn:oid:2.16.840.1.113883.4.642.4.116": "request-priority",
    "urn:oid:2.16.840.1.113883.4.642.4.903": "product-status",
    "urn:oid:2.16.840.1.113883.4.642.4.119": "resource-validation-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.1989": "version-algorithm",
    "urn:oid:2.16.840.1.113883.4.642.4.121": "flag-status",
    "urn:oid:2.16.840.1.113883.4.642.4.132": "allergy-intolerance-type",
    "urn:oid:2.16.840.1.113883.4.642.4.134": "allergy-intolerance-category",
    "urn:oid:2.16.840.1.113883.4.642.4.130": "allergy-intolerance-criticality",
    "urn:oid:2.16.840.1.113883.4.642.4.136": "reaction-event-severity",
    "urn:oid:2.16.840.1.113883.4.642.4.154": "care-team-status",
    "urn:oid:2.16.840.1.113883.4.642.4.199": "capability-statement-kind",
    "urn:oid:2.16.840.1.113883.4.642.4.177": "restful-capability-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.1079": "restful-security-service",
    "urn:oid:2.16.840.1.113883.4.642.4.191": "versioning-policy",
    "urn:oid:2.16.840.1.113883.4.642.4.201": "conditional-read-status",
    "urn:oid:2.16.840.1.113883.4.642.4.195": "conditional-delete-status",
    "urn:oid:2.16.840.1.113883.4.642.4.203": "reference-handling-policy",
    "urn:oid:2.16.840.1.113883.4.642.4.1080": "message-transport",
    "urn:oid:2.16.840.1.113883.4.642.4.183": "event-capability-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.187": "document-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.2026": "detectedissue-status",
    "urn:oid:2.16.840.1.113883.4.642.4.207": "detectedissue-severity",
    "urn:oid:2.16.840.1.113883.4.642.4.212": "udi-entry-type",
    "urn:oid:2.16.840.1.113883.4.642.4.210": "device-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2048": "device-availability-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1084": "device-nametype",
    "urn:oid:2.16.840.1.113883.4.642.4.2105": "device-category",
    "urn:oid:2.16.840.1.113883.4.642.4.2054": "device-specification-category",
    "urn:oid:2.16.840.1.113883.4.642.4.2107": "device-operation-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.2059": "deviceusage-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1854": "deviceusage-adherence-code",
    "urn:oid:2.16.840.1.113883.4.642.4.1855": "deviceusage-adherence-reason",
    "urn:oid:2.16.840.1.113883.4.642.4.220": "sequence-type",
    "urn:oid:2.16.840.1.113883.4.642.4.988": "orientation-type",
    "urn:oid:2.16.840.1.113883.4.642.4.986": "strand-type",
    "urn:oid:2.16.840.1.113883.4.642.4.236": "diagnostic-report-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1890": "citation-summary-style",
    "urn:oid:2.16.840.1.113883.4.642.4.1888": "citation-classification-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1878": "citation-status-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1892": "cited-artifact-status-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1875": "title-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1879": "cited-artifact-abstract-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1877": "cited-artifact-part-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1887": "published-in-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1881": "cited-medium",
    "urn:oid:2.16.840.1.113883.4.642.4.1876": "artifact-url-classifier",
    "urn:oid:2.16.840.1.113883.4.642.4.1885": "cited-artifact-classification-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1891": "artifact-contribution-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1880": "contributor-role",
    "urn:oid:2.16.840.1.113883.4.642.4.1874": "artifact-contribution-instance-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1893": "contributor-summary-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1882": "contributor-summary-style",
    "urn:oid:2.16.840.1.113883.4.642.4.1886": "contributor-summary-source",
    "urn:oid:2.16.840.1.113883.4.642.4.1957": "evidence-report-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1960": "focus-characteristic-code",
    "urn:oid:2.16.840.1.113883.4.642.4.1958": "report-relation-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1961": "evidence-report-section",
    "urn:oid:2.16.840.1.113883.4.642.4.1959": "evidence-classifier-code",
    "urn:oid:2.16.840.1.113883.4.642.4.242": "composition-status",
    "urn:oid:2.16.840.1.113883.4.642.4.239": "composition-attestation-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.2013": "catalogType",
    "urn:oid:2.16.840.1.113883.4.642.4.245": "document-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.4.247": "encounter-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2114": "encounter-reason-use",
    "urn:oid:2.16.840.1.113883.4.642.4.2115": "encounter-diagnosis-use",
    "urn:oid:2.16.840.1.113883.4.642.4.263": "encounter-location-status",
    "urn:oid:2.16.840.1.113883.4.642.4.268": "history-status",
    "urn:oid:2.16.840.1.113883.4.642.4.272": "goal-status",
    "urn:oid:2.16.840.1.113883.4.642.4.283": "graph-compartment-use",
    "urn:oid:2.16.840.1.113883.4.642.4.281": "graph-compartment-rule",
    "urn:oid:2.16.840.1.113883.4.642.4.285": "group-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1962": "group-membership-basis",
    "urn:oid:2.16.840.1.113883.4.642.4.1985": "imagingselection-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1984": "imagingselection-2dgraphictype",
    "urn:oid:2.16.840.1.113883.4.642.4.1983": "imagingselection-3dgraphictype",
    "urn:oid:2.16.840.1.113883.4.642.4.991": "imagingstudy-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1027": "spdx-license",
    "urn:oid:2.16.840.1.113883.4.642.4.999": "guide-page-generation",
    "urn:oid:2.16.840.1.113883.4.642.4.997": "guide-parameter-code",
    "urn:oid:2.16.840.1.113883.4.642.4.315": "linkage-type",
    "urn:oid:2.16.840.1.113883.4.642.4.327": "list-status",
    "urn:oid:2.16.840.1.113883.4.642.4.319": "list-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.321": "list-item-flag",
    "urn:oid:2.16.840.1.113883.4.642.4.333": "location-status",
    "urn:oid:2.16.840.1.113883.4.642.4.331": "location-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.1970": "location-characteristic",
    "urn:oid:2.16.840.1.113883.4.642.4.2000": "medication-admin-status",
    "urn:oid:2.16.840.1.113883.4.642.4.343": "reason-medication-not-given-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.2001": "administration-subpotent-reason",
    "urn:oid:2.16.840.1.113883.4.642.4.1971": "medicationdispense-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1973": "medicationdispense-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.4.1972": "medicationdispense-admin-location",
    "urn:oid:2.16.840.1.113883.4.642.4.1377": "medicationrequest-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1378": "medicationrequest-intent",
    "urn:oid:2.16.840.1.113883.4.642.4.2074": "medication-intended-performer-role",
    "urn:oid:2.16.840.1.113883.4.642.4.2075": "medication-dose-aid",
    "urn:oid:2.16.840.1.113883.4.642.4.1980": "medication-statement-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1981": "medication-statement-adherence",
    "urn:oid:2.16.840.1.113883.4.642.4.1380": "medication-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2062": "medication-ingredientstrength",
    "urn:oid:2.16.840.1.113883.4.642.4.381": "response-code",
    "urn:oid:2.16.840.1.113883.4.642.4.2098": "observation-triggeredbytype",
    "urn:oid:2.16.840.1.113883.4.642.4.401": "observation-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2099": "observation-referencerange-normalvalue",
    "urn:oid:2.16.840.1.113883.4.642.1.1126": "observation-statistics",
    "urn:oid:2.16.840.1.113883.4.642.4.409": "issue-severity",
    "urn:oid:2.16.840.1.113883.4.642.4.411": "issue-type",
    "urn:oid:2.16.840.1.113883.4.642.4.424": "link-type",
    "urn:oid:2.16.840.1.113883.4.642.4.426": "device-action",
    "urn:oid:2.16.840.1.113883.4.642.4.437": "provenance-entity-role",
    "urn:oid:2.16.840.1.113883.4.642.4.445": "item-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1006": "questionnaire-enable-operator",
    "urn:oid:2.16.840.1.113883.4.642.4.1008": "questionnaire-enable-behavior",
    "urn:oid:2.16.840.1.113883.4.642.4.2016": "questionnaire-disabled-display",
    "urn:oid:2.16.840.1.113883.4.642.4.2019": "questionnaire-answer-constraint",
    "urn:oid:2.16.840.1.113883.4.642.4.448": "questionnaire-answers-status",
    "urn:oid:2.16.840.1.113883.4.642.4.453": "audit-event-action",
    "urn:oid:2.16.840.1.113883.4.642.4.1894": "audit-event-severity",
    "urn:oid:2.16.840.1.113883.4.642.4.472": "specimen-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2061": "specimen-combined",
    "urn:oid:2.16.840.1.113883.4.642.4.2060": "specimen-role",
    "urn:oid:2.16.840.1.113883.4.642.4.475": "substance-status",
    "urn:oid:2.16.840.1.113883.4.642.4.479": "filter-operator",
    "urn:oid:2.16.840.1.113883.4.642.4.2118": "conceptmap-property-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2119": "conceptmap-attribute-type",
    "urn:oid:2.16.840.1.113883.4.642.4.481": "conceptmap-unmapped-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.483": "slotstatus",
    "urn:oid:2.16.840.1.113883.4.642.4.485": "appointmentstatus",
    "urn:oid:2.16.840.1.113883.4.642.4.487": "participationstatus",
    "urn:oid:2.16.840.1.113883.4.642.4.1906": "week-of-month",
    "urn:oid:2.16.840.1.113883.4.642.4.491": "namingsystem-type",
    "urn:oid:2.16.840.1.113883.4.642.4.493": "namingsystem-identifier-type",
    "urn:oid:2.16.840.1.113883.4.642.4.495": "endpoint-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2041": "endpoint-environment",
    "urn:oid:2.16.840.1.113883.4.642.4.2022": "subscription-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2021": "subscription-payload-content",
    "urn:oid:2.16.840.1.113883.4.642.4.2027": "subscription-notification-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2034": "subscriptiontopic-cr-behavior",
    "urn:oid:2.16.840.1.113883.4.642.4.507": "operation-kind",
    "urn:oid:2.16.840.1.113883.4.642.4.2055": "operation-parameter-scope",
    "urn:oid:2.16.840.1.113883.4.642.4.2116": "service-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.2077": "coverage-kind",
    "urn:oid:2.16.840.1.113883.4.642.4.593": "fm-status",
    "urn:oid:2.16.840.1.113883.4.642.4.545": "claim-use",
    "urn:oid:2.16.840.1.113883.4.642.4.575": "icd-10-procedures",
    "urn:oid:2.16.840.1.113883.4.642.4.1897": "claim-outcome",
    "urn:oid:2.16.840.1.113883.4.642.4.1896": "claim-decision",
    "urn:oid:2.16.840.1.113883.4.642.4.619": "explanationofbenefit-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1183": "eligibilityrequest-purpose",
    "urn:oid:2.16.840.1.113883.4.642.4.621": "bundle-type",
    "urn:oid:2.16.840.1.113883.4.642.4.623": "search-entry-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.625": "http-verb",
    "urn:oid:2.16.840.1.113883.4.642.4.638": "search-comparator",
    "urn:oid:2.16.840.1.113883.4.642.4.640": "search-modifier-code",
    "urn:oid:2.16.840.1.113883.4.642.4.1185": "eligibilityresponse-purpose",
    "urn:oid:2.16.840.1.113883.4.642.4.2072": "eligibility-outcome",
    "urn:oid:2.16.840.1.113883.4.642.4.1974": "enrollment-outcome",
    "urn:oid:2.16.840.1.113883.4.642.4.2056": "payment-kind",
    "urn:oid:2.16.840.1.113883.4.642.4.2057": "payment-issuertype",
    "urn:oid:2.16.840.1.113883.4.642.4.2058": "payment-outcome",
    "urn:oid:2.16.840.1.113883.4.642.4.647": "metric-operational-status",
    "urn:oid:2.16.840.1.113883.4.642.4.649": "metric-category",
    "urn:oid:2.16.840.1.113883.4.642.4.651": "metric-calibration-type",
    "urn:oid:2.16.840.1.113883.4.642.4.653": "metric-calibration-state",
    "urn:oid:2.16.840.1.113883.4.642.4.657": "identity-assuranceLevel",
    "urn:oid:2.16.840.1.113883.4.642.4.661": "vision-eye-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.663": "vision-base-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.665": "episode-of-care-status",
    "urn:oid:2.16.840.1.113883.4.642.4.669": "structure-definition-kind",
    "urn:oid:2.16.840.1.113883.4.642.4.1013": "extension-context-type",
    "urn:oid:2.16.840.1.113883.4.642.4.674": "type-derivation-rule",
    "urn:oid:2.16.840.1.113883.4.642.4.676": "map-model-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.688": "map-group-type-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.678": "map-input-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.684": "map-source-list-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.686": "map-target-list-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.682": "map-transform",
    "urn:oid:2.16.840.1.113883.4.642.4.696": "supplyrequest-status",
    "urn:oid:2.16.840.1.113883.4.642.4.701": "supplydelivery-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1905": "supplydelivery-supplyitemtype",
    "urn:oid:2.16.840.1.113883.4.642.4.1949": "testscript-scope-conformance-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.1950": "testscript-scope-phase-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.717": "http-operations",
    "urn:oid:2.16.840.1.113883.4.642.4.707": "assert-direction-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.703": "assert-manual-completion-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.709": "assert-operator-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.711": "assert-response-code-types",
    "urn:oid:2.16.840.1.113883.4.642.4.725": "report-status-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.719": "report-result-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.723": "report-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.4.721": "report-action-result-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.727": "account-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2063": "account-billing-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2066": "account-relationship",
    "urn:oid:2.16.840.1.113883.4.642.4.2065": "account-aggregate",
    "urn:oid:2.16.840.1.113883.4.642.4.2064": "account-balance-term",
    "urn:oid:2.16.840.1.113883.4.642.4.2037": "condition-precondition-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2036": "condition-questionnaire-purpose",
    "urn:oid:2.16.840.1.113883.4.642.4.744": "contract-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1207": "contract-legalstate",
    "urn:oid:2.16.840.1.113883.4.642.4.1215": "contract-expiration-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1217": "contract-scope",
    "urn:oid:2.16.840.1.113883.4.642.4.1211": "contract-definition-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1213": "contract-definition-subtype",
    "urn:oid:2.16.840.1.113883.4.642.4.1209": "contract-publicationstatus",
    "urn:oid:2.16.840.1.113883.4.642.4.1219": "contract-security-classification",
    "urn:oid:2.16.840.1.113883.4.642.4.1221": "contract-security-category",
    "urn:oid:2.16.840.1.113883.4.642.4.1223": "contract-security-control",
    "urn:oid:2.16.840.1.113883.4.642.4.1225": "contract-party-role",
    "urn:oid:2.16.840.1.113883.4.642.4.1292": "contract-decision-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.1294": "contract-assetscope",
    "urn:oid:2.16.840.1.113883.4.642.4.1300": "contract-assettype",
    "urn:oid:2.16.840.1.113883.4.642.4.1302": "contract-assetsubtype",
    "urn:oid:2.16.840.1.113883.4.642.4.1298": "contract-assetcontext",
    "urn:oid:2.16.840.1.113883.4.642.4.1296": "asset-availability",
    "urn:oid:2.16.840.1.113883.4.642.4.1304": "contract-actionstatus",
    "urn:oid:2.16.840.1.113883.4.642.4.756": "consent-state-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.758": "consent-provision-type",
    "urn:oid:2.16.840.1.113883.4.642.4.760": "consent-data-meaning",
    "urn:oid:2.16.840.1.113883.4.642.4.2043": "measure-definition-example",
    "urn:oid:2.16.840.1.113883.4.642.4.2045": "measure-group-example",
    "urn:oid:2.16.840.1.113883.4.642.4.2044": "measure-aggregate-method",
    "urn:oid:2.16.840.1.113883.4.642.4.2047": "measure-stratifier-example",
    "urn:oid:2.16.840.1.113883.4.642.4.2046": "measure-supplemental-data-example",
    "urn:oid:2.16.840.1.113883.4.642.4.777": "measure-report-status",
    "urn:oid:2.16.840.1.113883.4.642.4.779": "measure-report-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1948": "submit-data-update-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1947": "measurereport-stratifier-value-example",
    "urn:oid:2.16.840.1.113883.4.642.4.785": "codesystem-hierarchy-meaning",
    "urn:oid:2.16.840.1.113883.4.642.4.783": "codesystem-content-mode",
    "urn:oid:2.16.840.1.113883.4.642.4.781": "concept-property-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1239": "concept-subsumption-outcome",
    "urn:oid:2.16.840.1.113883.4.642.4.787": "compartment-type",
    "urn:oid:2.16.840.1.113883.4.642.4.791": "task-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2042": "task-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.4.1241": "task-intent",
    "urn:oid:2.16.840.1.113883.4.642.4.1397": "task-code",
    "urn:oid:2.16.840.1.113883.4.642.4.812": "action-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1944": "action-code",
    "urn:oid:2.16.840.1.113883.4.642.4.1945": "action-reason-code",
    "urn:oid:2.16.840.1.113883.4.642.4.816": "action-condition-kind",
    "urn:oid:2.16.840.1.113883.4.642.4.814": "action-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1946": "action-participant-function",
    "urn:oid:2.16.840.1.113883.4.642.4.800": "action-grouping-behavior",
    "urn:oid:2.16.840.1.113883.4.642.4.802": "action-selection-behavior",
    "urn:oid:2.16.840.1.113883.4.642.4.804": "action-required-behavior",
    "urn:oid:2.16.840.1.113883.4.642.4.806": "action-precheck-behavior",
    "urn:oid:2.16.840.1.113883.4.642.4.808": "action-cardinality-behavior",
    "urn:oid:2.16.840.1.113883.4.642.4.2103": "guidance-module-code",
    "urn:oid:2.16.840.1.113883.4.642.4.818": "guidance-response-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1967": "research-study-classifiers",
    "urn:oid:2.16.840.1.113883.4.642.4.1968": "research-study-party-role",
    "urn:oid:2.16.840.1.113883.4.642.4.820": "research-study-status",
    "urn:oid:2.16.840.1.113883.4.642.4.189": "message-significance-category",
    "urn:oid:2.16.840.1.113883.4.642.4.925": "messageheader-response-request",
    "urn:oid:2.16.840.1.113883.4.642.4.832": "adverse-event-actuality",
    "urn:oid:2.16.840.1.113883.4.642.4.847": "chargeitem-status",
    "urn:oid:2.16.840.1.113883.4.642.4.853": "specimen-contained-preference",
    "urn:oid:2.16.840.1.113883.4.642.4.1332": "permitted-data-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1334": "observation-range-category",
    "urn:oid:2.16.840.1.113883.4.642.4.859": "examplescenario-actor-type",
    "urn:oid:2.16.840.1.113883.4.642.4.861": "code-search-support",
    "urn:oid:2.16.840.1.113883.4.642.4.867": "invoice-status",
    "urn:oid:2.16.840.1.113883.4.642.4.881": "organization-role",
    "urn:oid:2.16.840.1.113883.4.642.4.2069": "verificationresult-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1916": "medicinal-product-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1917": "medicinal-product-domain",
    "urn:oid:2.16.840.1.113883.4.642.4.1923": "combined-dose-form",
    "urn:oid:2.16.840.1.113883.4.642.4.1912": "legal-status-of-supply",
    "urn:oid:2.16.840.1.113883.4.642.4.1919": "medicinal-product-additional-monitoring",
    "urn:oid:2.16.840.1.113883.4.642.4.1915": "medicinal-product-special-measures",
    "urn:oid:2.16.840.1.113883.4.642.4.1914": "medicinal-product-pediatric-use",
    "urn:oid:2.16.840.1.113883.4.642.4.1918": "medicinal-product-package-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1925": "medicinal-product-contact-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1922": "medicinal-product-name-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1924": "medicinal-product-name-part-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1921": "medicinal-product-cross-reference-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1913": "medicinal-product-confidentiality",
    "urn:oid:2.16.840.1.113883.4.642.4.1963": "package-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1966": "packaging-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1964": "package-material",
    "urn:oid:2.16.840.1.113883.4.642.4.1935": "manufactured-dose-form",
    "urn:oid:2.16.840.1.113883.4.642.4.2032": "administrable-dose-form",
    "urn:oid:2.16.840.1.113883.4.642.4.2031": "unit-of-presentation",
    "urn:oid:2.16.840.1.113883.4.642.4.2030": "target-species",
    "urn:oid:2.16.840.1.113883.4.642.4.2033": "animal-tissue-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1909": "regulated-authorization-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1908": "product-intended-use",
    "urn:oid:2.16.840.1.113883.4.642.4.1907": "regulated-authorization-basis",
    "urn:oid:2.16.840.1.113883.4.642.4.1910": "regulated-authorization-case-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2080": "ingredient-role",
    "urn:oid:2.16.840.1.113883.4.642.4.2079": "ingredient-function",
    "urn:oid:2.16.840.1.113883.4.642.4.2078": "ingredient-manufacturer-role",
    "urn:oid:2.16.840.1.113883.4.642.4.2085": "substance-grade",
    "urn:oid:2.16.840.1.113883.4.642.4.2087": "substance-stereochemistry",
    "urn:oid:2.16.840.1.113883.4.642.4.2096": "substance-optical-activity",
    "urn:oid:2.16.840.1.113883.4.642.4.2086": "substance-amount-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2082": "substance-structure-technique",
    "urn:oid:2.16.840.1.113883.4.642.4.2111": "substance-form",
    "urn:oid:2.16.840.1.113883.4.642.4.2091": "substance-weight-method",
    "urn:oid:2.16.840.1.113883.4.642.4.2083": "substance-weight-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2092": "substance-representation-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2081": "substance-representation-format",
    "urn:oid:2.16.840.1.113883.4.642.4.2094": "substance-name-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2089": "substance-name-domain",
    "urn:oid:2.16.840.1.113883.4.642.4.2095": "substance-name-authority",
    "urn:oid:2.16.840.1.113883.4.642.4.2088": "substance-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2097": "substance-source-material-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2093": "substance-source-material-genus",
    "urn:oid:2.16.840.1.113883.4.642.4.2090": "substance-source-material-species",
    "urn:oid:2.16.840.1.113883.4.642.4.2084": "substance-source-material-part",
    "urn:oid:2.16.840.1.113883.4.642.4.901": "product-category",
    "urn:oid:2.16.840.1.113883.4.642.4.1998": "biologicallyderived-productcodes",
    "urn:oid:2.16.840.1.113883.4.642.4.1997": "biologicallyderived-product-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1818": "biologicallyderived-product-property-type-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.2067": "medicationknowledge-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2068": "medication-cost-category",
    "urn:oid:2.16.840.1.113883.4.642.4.2109": "devicedefinition-regulatory-identifier-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1933": "devicedefinition-relationtype",
    "urn:oid:2.16.840.1.113883.4.642.4.1932": "device-correctiveactionscope",
    "urn:oid:2.16.840.1.113883.4.642.4.1953": "definition-method",
    "urn:oid:2.16.840.1.113883.4.642.4.1954": "characteristic-offset",
    "urn:oid:2.16.840.1.113883.4.642.4.1952": "characteristic-combination",
    "urn:oid:2.16.840.1.113883.4.642.4.1955": "evidence-variable-event",
    "urn:oid:2.16.840.1.113883.4.642.4.1956": "variable-handling",
    "urn:oid:2.16.840.1.113883.4.642.4.1990": "clinical-use-definition-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1993": "clinical-use-definition-category",
    "urn:oid:2.16.840.1.113883.4.642.4.1994": "therapy-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1992": "interaction-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1991": "interaction-incidence",
    "urn:oid:2.16.840.1.113883.4.642.4.1995": "undesirable-effect-frequency",
    "urn:oid:2.16.840.1.113883.4.642.4.1996": "warning-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1938": "statistic-model-code",
    "urn:oid:2.16.840.1.113883.4.642.4.1939": "certainty-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1941": "certainty-rating",
    "urn:oid:2.16.840.1.113883.4.642.4.2104": "nutritionproduct-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2071": "permission-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2070": "permission-rule-combining",
    "urn:oid:2.16.840.1.113883.4.642.4.1927": "inventoryreport-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1926": "inventoryreport-counttype",
    "urn:oid:2.16.840.1.113883.4.642.4.2020": "devicedispense-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2110": "devicedispense-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.4.2025": "artifactassessment-information-type",
    "urn:oid:2.16.840.1.113883.4.642.4.2023": "artifactassessment-workflow-status",
    "urn:oid:2.16.840.1.113883.4.642.4.2024": "artifactassessment-disposition",
    "urn:oid:2.16.840.1.113883.4.642.4.1929": "transport-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1930": "transport-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.4.1928": "transport-intent",
    "urn:oid:2.16.840.1.113883.4.642.4.1931": "transport-code",
    "urn:oid:2.16.840.1.113883.4.642.4.1976": "genomicstudy-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1975": "genomicstudy-type",
    "urn:oid:2.16.840.1.113883.4.642.4.1979": "genomicstudy-methodtype",
    "urn:oid:2.16.840.1.113883.4.642.4.1977": "genomicstudy-changetype",
    "urn:oid:2.16.840.1.113883.4.642.4.1978": "genomicstudy-dataformat",
    "urn:oid:2.16.840.1.113883.4.642.4.1988": "formularyitem-status",
    "urn:oid:2.16.840.1.113883.4.642.4.1864": "knowledge-representation-level",
    "loinc-cholesterol-int": "example",
    "urn:oid:2.16.840.1.113883.4.642.3.3292": "example",
    "loinc-cholesterol-ext": "example-intensional",
    "urn:oid:2.16.840.1.113883.4.642.3.3145": "example-intensional",
    "urn:oid:2.16.840.1.113883.4.642.3.3148": "example-filter",
    "urn:oid:2.16.840.1.113883.4.642.3.3141": "example-expansion",
    "urn:oid:2.16.840.1.113883.4.642.3.3144": "ucum-common",
    "urn:oid:2.16.840.1.113883.4.642.3.3138": "example-cpt-all",
    "urn:oid:2.16.840.1.113883.4.642.3.3149": "yesnodontknow",
    "urn:oid:2.16.840.1.113883.4.642.3.3142": "nhin-purposeofuse",
    "urn:oid:2.16.840.1.113883.4.642.3.3146": "inactive",
    "urn:oid:2.16.840.1.113883.4.642.3.3139": "example-metadata",
    "urn:oid:2.16.840.1.113883.4.642.3.3143": "example-metadata-2",
    "urn:oid:2.16.840.1.113883.4.642.3.200": "conditional-read-status",
    "urn:oid:2.16.840.1.113883.4.642.3.295": "immunization-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3014": "medicinal-product-package-type",
    "urn:oid:2.16.840.1.113883.4.642.3.206": "detectedissue-severity",
    "urn:oid:2.16.840.1.113883.4.642.3.253": "encounter-special-arrangements",
    "urn:oid:2.16.840.1.113883.4.642.3.880": "organization-role",
    "urn:oid:2.16.840.1.113883.4.642.3.259": "encounter-discharge-disposition",
    "urn:oid:2.16.840.1.113883.4.642.3.480": "conceptmap-unmapped-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.1169": "ex-diagnosis-on-admission",
    "urn:oid:2.16.840.1.113883.4.642.3.332": "location-status",
    "urn:oid:2.16.840.1.113883.4.642.3.600": "payment-adjustment-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.544": "claim-use",
    "urn:oid:2.16.840.1.113883.4.642.3.3235": "adverse-event-participant-function",
    "urn:oid:2.16.840.1.113883.4.642.3.307": "immunization-recommendation-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.255": "encounter-diet",
    "urn:oid:2.16.840.1.113883.4.642.3.261": "encounter-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.3049": "certainty-rating",
    "urn:oid:2.16.840.1.113883.4.642.3.87": "property-representation",
    "urn:oid:2.16.840.1.113883.4.642.3.992": "immunization-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.4.3322": "service-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.3073": "package-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3158": "detectedissue-status",
    "urn:oid:2.16.840.1.113883.4.642.3.580": "claim-exception",
    "urn:oid:2.16.840.1.113883.4.642.3.819": "research-study-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3190": "measure-definition-example",
    "urn:oid:2.16.840.1.113883.4.642.3.3127": "medication-admin-location",
    "urn:oid:2.16.840.1.113883.4.642.3.2987": "capability-format-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3309": "device-operation-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.516": "service-category",
    "urn:oid:2.16.840.1.113883.4.642.3.3017": "legal-status-of-supply",
    "urn:oid:2.16.840.1.113883.4.642.3.2959": "artifact-contribution-type",
    "urn:oid:2.16.840.1.113883.4.642.3.677": "map-input-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.301": "immunization-evaluation-dose-status",
    "urn:oid:2.16.840.1.113883.4.642.3.27": "resource-types",
    "urn:oid:2.16.840.1.113883.4.642.3.117": "resource-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3071": "package-material",
    "urn:oid:2.16.840.1.113883.4.642.3.594": "ex-revenue-center",
    "urn:oid:2.16.840.1.113883.4.642.3.440": "questionnaire-answers-status",
    "urn:oid:2.16.840.1.113883.4.642.3.153": "care-team-status",
    "urn:oid:2.16.840.1.113883.4.642.3.434": "servicerequest-category",
    "urn:oid:2.16.840.1.113883.4.642.3.454": "audit-event-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.2978": "not-consumed-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.771": "measure-data-usage",
    "urn:oid:2.16.840.1.113883.4.642.3.687": "map-group-type-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.3059": "definition-method",
    "urn:oid:2.16.840.1.113883.4.642.3.508": "operation-parameter-use",
    "urn:oid:2.16.840.1.113883.4.642.3.3114": "disease-symptom-procedure",
    "urn:oid:2.16.840.1.113883.4.642.3.612": "benefit-term",
    "urn:oid:2.16.840.1.113883.4.642.3.1222": "contract-security-control",
    "urn:oid:2.16.840.1.113883.4.642.3.3118": "undesirable-effect-frequency",
    "urn:oid:2.16.840.1.113883.4.642.3.1083": "device-nametype",
    "urn:oid:2.16.840.1.113883.4.642.3.262": "encounter-location-status",
    "urn:oid:2.16.840.1.113883.4.642.3.2963": "artifact-contribution-instance-type",
    "urn:oid:2.16.840.1.113883.4.642.3.858": "examplescenario-actor-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3312": "devicedispense-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.478": "filter-operator",
    "urn:oid:2.16.840.1.113883.4.642.3.3164": "communication-request-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.462": "audit-event-type",
    "urn:oid:2.16.840.1.113883.4.642.3.801": "action-selection-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.3078": "research-study-arm-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3180": "condition-questionnaire-purpose",
    "urn:oid:2.16.840.1.113883.4.642.3.3083": "genomicstudy-status",
    "urn:oid:2.16.840.1.113883.4.642.3.552": "process-priority",
    "urn:oid:2.16.840.1.113883.4.642.3.502": "subscription-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3081": "enrollment-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.3077": "research-study-party-organization-type",
    "urn:oid:2.16.840.1.113883.4.642.3.168": "condition-severity",
    "urn:oid:2.16.840.1.113883.4.642.3.3063": "evidence-variable-event",
    "urn:oid:2.16.840.1.113883.4.642.3.3255": "substance-source-material-part",
    "urn:oid:2.16.840.1.113883.4.642.3.1401": "verificationresult-communication-method",
    "urn:oid:2.16.840.1.113883.4.642.3.3019": "combined-dose-form",
    "urn:oid:2.16.840.1.113883.4.642.3.115": "request-priority",
    "urn:oid:2.16.840.1.113883.4.642.3.3178": "consent-verification",
    "urn:oid:2.16.840.1.113883.4.642.3.1293": "contract-assetscope",
    "urn:oid:2.16.840.1.113883.4.642.3.95": "additional-instruction-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.77": "units-of-time",
    "urn:oid:2.16.840.1.113883.4.642.3.19": "age-units",
    "urn:oid:2.16.840.1.113883.4.642.3.2972": "citation-status-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1240": "task-intent",
    "urn:oid:2.16.840.1.113883.4.642.3.388": "modified-foodtype",
    "urn:oid:2.16.840.1.113883.4.642.3.778": "measure-report-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3044": "statistic-type",
    "urn:oid:2.16.840.1.113883.4.642.3.586": "claim-careteamrole",
    "urn:oid:2.16.840.1.113883.4.642.3.763": "library-type",
    "urn:oid:2.16.840.1.113883.4.642.3.186": "document-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.568": "related-claim-relationship",
    "urn:oid:2.16.840.1.113883.4.642.3.3262": "substance-grade",
    "urn:oid:2.16.840.1.113883.4.642.3.1337": "medicationknowledge-characteristic",
    "urn:oid:2.16.840.1.113883.4.642.3.291": "immunization-program-eligibility",
    "urn:oid:2.16.840.1.113883.4.642.3.998": "guide-page-generation",
    "urn:oid:2.16.840.1.113883.4.642.3.397": "referencerange-meaning",
    "urn:oid:2.16.840.1.113883.4.642.3.105": "expression-language",
    "urn:oid:2.16.840.1.113883.4.642.3.1026": "spdx-license",
    "urn:oid:2.16.840.1.113883.4.642.3.65": "name-use",
    "urn:oid:2.16.840.1.113883.4.642.3.558": "claim-type",
    "urn:oid:2.16.840.1.113883.4.642.3.2979": "audit-event-outcome-detail",
    "urn:oid:2.16.840.1.113883.4.642.3.3046": "statistic-model-code",
    "urn:oid:2.16.840.1.113883.3.88.12.80.67": "c80-facilitycodes",
    "urn:oid:2.16.840.1.113883.4.642.3.3207": "payment-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.155": "care-team-category",
    "urn:oid:2.16.840.1.113883.4.642.3.1331": "permitted-data-type",
    "urn:oid:2.16.840.1.113883.4.642.3.957": "ucum-bodytemp",
    "urn:oid:2.16.840.1.113883.4.642.3.3080": "medicationdispense-admin-location",
    "urn:oid:2.16.840.1.113883.4.642.3.582": "claim-informationcategory",
    "urn:oid:2.16.840.1.113883.4.642.3.3263": "substance-weight-method",
    "urn:oid:2.16.840.1.113883.4.642.3.213": "device-safety",
    "urn:oid:2.16.840.1.113883.4.642.3.133": "allergy-intolerance-category",
    "urn:oid:2.16.840.1.113883.4.642.3.3241": "medication-dose-aid",
    "urn:oid:2.16.840.1.113883.4.642.3.1210": "contract-definition-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3032": "inventoryreport-counttype",
    "urn:oid:2.16.840.1.113883.4.642.3.293": "immunization-funding-source",
    "urn:oid:2.16.840.1.113883.4.642.3.1056": "definition-resource-types",
    "urn:oid:2.16.840.1.113883.4.642.3.856": "rejection-criteria",
    "urn:oid:2.16.840.1.113883.4.642.3.3106": "undesirable-effect-symptom",
    "urn:oid:2.16.840.1.113883.4.642.3.2999": "regulated-authorization-type",
    "urn:oid:2.16.840.1.113883.4.642.3.656": "identity-assuranceLevel",
    "urn:oid:2.16.840.1.113883.4.642.3.697": "supplyrequest-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.702": "assert-manual-completion-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.662": "vision-base-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.3297": "country",
    "urn:oid:2.16.840.1.113883.4.642.3.884": "verificationresult-status",
    "urn:oid:2.16.840.1.113883.4.642.3.176": "restful-capability-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.3065": "evidence-report-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3020": "medicinal-product-additional-monitoring",
    "urn:oid:2.16.840.1.113883.4.642.3.378": "message-reason-encounter",
    "urn:oid:2.16.840.1.113883.4.642.3.797": "plan-definition-type",
    "urn:oid:2.16.840.1.113883.3.88.12.80.22": "vaccine-code",
    "urn:oid:2.16.840.1.113883.4.642.3.3281": "research-study-classifiers",
    "urn:oid:2.16.840.1.113883.4.642.3.540": "tooth",
    "urn:oid:2.16.840.1.113883.4.642.3.118": "resource-validation-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.3041": "device-correctiveactionscope",
    "urn:oid:2.16.840.1.113883.4.642.3.620": "bundle-type",
    "urn:oid:2.16.840.1.113883.4.642.3.724": "report-status-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.3013": "security-label-data-examples",
    "urn:oid:2.16.840.1.113883.4.642.3.990": "imagingstudy-status",
    "urn:oid:2.16.840.1.113883.4.642.3.794": "definition-topic",
    "urn:oid:2.16.840.1.113883.4.642.3.2973": "published-in-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3023": "substance-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.894": "verificationresult-validation-status",
    "urn:oid:2.16.840.1.113883.4.642.3.896": "verificationresult-can-push-updates",
    "urn:oid:2.16.840.1.113883.4.642.3.3230": "medication-cost-category",
    "urn:oid:2.16.840.1.113883.4.642.3.3094": "virtual-service-type",
    "urn:oid:2.16.840.1.113883.4.642.3.98": "route-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.3167": "administrable-dose-form",
    "urn:oid:2.16.840.1.113883.4.642.3.745": "contract-content-derivative",
    "urn:oid:2.16.840.1.113883.4.642.3.71": "contact-point-system",
    "urn:oid:2.16.840.1.113883.4.642.3.436": "provenance-entity-role",
    "urn:oid:2.16.840.1.113883.4.642.3.3248": "substance-source-material-species",
    "urn:oid:2.16.840.1.113883.4.642.3.3233": "eligibility-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.2977": "edible-substance-type",
    "urn:oid:2.16.840.1.113883.4.642.3.2995": "appointment-recurrrence-type",
    "urn:oid:2.16.840.1.113883.4.642.3.284": "group-type",
    "urn:oid:2.16.840.1.113883.4.642.3.622": "search-entry-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.432": "procedure-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.2998": "regulated-authorization-case-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3306": "value-filter-comparator",
    "urn:oid:2.16.840.1.113883.4.642.3.328": "location-form",
    "urn:oid:2.16.840.1.113883.4.642.3.514": "service-provision-conditions",
    "urn:oid:2.16.840.1.113883.4.642.3.3254": "substance-structure-technique",
    "urn:oid:2.16.840.1.113883.4.642.3.3038": "transport-code",
    "urn:oid:2.16.840.1.113883.4.642.3.29": "marital-status",
    "urn:oid:2.16.840.1.113883.4.642.3.809": "action-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3025": "medicinal-product-pediatric-use",
    "urn:oid:2.16.840.1.113883.4.642.3.2996": "product-intended-use",
    "urn:oid:2.16.840.1.113883.4.642.3.3048": "variable-role",
    "urn:oid:2.16.840.1.113883.4.642.3.3018": "medicinal-product-domain",
    "urn:oid:2.16.840.1.113883.4.642.3.169": "manifestation-or-symptom",
    "urn:oid:2.16.840.1.113883.4.642.3.722": "report-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.3.280": "graph-compartment-rule",
    "urn:oid:2.16.840.1.113883.4.642.3.1058": "request-resource-types",
    "urn:oid:2.16.840.1.113883.4.642.3.1383": "program",
    "urn:oid:2.16.840.1.113883.4.642.3.1047": "immunization-target-disease",
    "urn:oid:2.16.840.1.113883.4.642.3.765": "measure-population",
    "urn:oid:2.16.840.1.113883.4.642.3.3159": "encounter-subject-status",
    "urn:oid:2.16.840.1.113883.4.642.3.390": "supplement-type",
    "urn:oid:2.16.840.1.113883.4.642.3.449": "relatedperson-relationshiptype",
    "urn:oid:2.16.840.1.113883.4.642.3.342": "reason-medication-not-given-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.427": "procedure-code",
    "urn:oid:2.16.840.1.113883.4.642.3.113": "request-intent",
    "urn:oid:2.16.840.1.113883.4.642.3.751": "consent-category",
    "urn:oid:2.16.840.1.113883.4.642.3.407": "referencerange-appliesto",
    "urn:oid:2.16.840.1.113883.4.642.3.2968": "contributor-summary-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1212": "contract-definition-subtype",
    "urn:oid:2.16.840.1.113883.4.642.3.729": "contract-type",
    "urn:oid:2.16.840.1.113883.4.642.3.296": "immunization-origin",
    "urn:oid:2.16.840.1.113883.4.642.3.316": "list-example-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.1190": "definition-use",
    "urn:oid:2.16.840.1.113883.4.642.3.3227": "account-aggregate",
    "urn:oid:2.16.840.1.113883.4.642.3.3112": "therapy",
    "urn:oid:2.16.840.1.113883.4.642.3.21": "all-languages",
    "urn:oid:2.16.840.1.113883.4.642.3.2984": "claim-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.3051": "action-code",
    "urn:oid:2.16.840.1.113883.4.642.3.164": "condition-clinical",
    "urn:oid:2.16.840.1.113883.4.642.3.142": "bodystructure-code",
    "urn:oid:2.16.840.1.113883.4.642.3.1174": "ex-benefitcategory",
    "urn:oid:2.16.840.1.113883.4.642.3.170": "condition-stage",
    "urn:oid:2.16.840.1.113883.4.642.3.3211": "lipid-ldl-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.1320": "medicationrequest-status",
    "urn:oid:2.16.840.1.113883.4.642.3.1236": "measure-improvement-notation",
    "urn:oid:2.16.840.1.113883.4.642.3.854": "handling-condition",
    "urn:oid:2.16.840.1.113883.4.642.3.956": "ucum-bodyweight",
    "urn:oid:2.16.840.1.113883.4.642.3.69": "address-type",
    "urn:oid:2.16.840.1.113883.4.642.3.423": "link-type",
    "urn:oid:2.16.840.1.113883.4.642.3.542": "service-uscls",
    "urn:oid:2.16.840.1.113883.4.642.3.1": "administrative-gender",
    "urn:oid:2.16.840.1.113883.4.642.3.716": "http-operations",
    "urn:oid:2.16.840.1.113883.4.642.3.3107": "clinical-use-definition-type",
    "urn:oid:2.16.840.1.113883.4.642.3.926": "provenance-history-record-activity",
    "urn:oid:2.16.840.1.113883.4.642.3.1324": "medicationrequest-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.3082": "genomicstudy-type",
    "urn:oid:2.16.840.1.113883.4.642.3.566": "claim-subtype",
    "urn:oid:2.16.840.1.113883.4.642.3.166": "condition-ver-status",
    "urn:oid:2.16.840.1.113883.4.642.3.838": "adverse-event-seriousness",
    "urn:oid:2.16.840.1.113883.4.642.3.2966": "artifact-url-classifier",
    "urn:oid:2.16.840.1.113883.4.642.3.536": "claim-modifiers",
    "urn:oid:2.16.840.1.113883.4.642.3.385": "diet-type",
    "urn:oid:2.16.840.1.113883.4.642.3.476": "substance-category",
    "urn:oid:2.16.840.1.113883.4.642.3.93": "contributor-type",
    "urn:oid:2.16.840.1.113883.4.642.3.91": "discriminator-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3160": "subscription-error",
    "urn:oid:2.16.840.1.113883.4.642.3.109": "event-status",
    "urn:oid:2.16.840.1.113883.4.642.3.748": "consent-content-code",
    "urn:oid:2.16.840.1.113883.4.642.3.1214": "contract-expiration-type",
    "urn:oid:2.16.840.1.113883.4.642.3.693": "supplyrequest-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.51": "provider-taxonomy",
    "urn:oid:2.16.840.1.113883.4.642.3.3250": "substance-optical-activity",
    "urn:oid:2.16.840.1.113883.4.642.3.2962": "cited-artifact-abstract-type",
    "urn:oid:2.16.840.1.113883.4.642.3.737": "contract-signer-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3259": "substance-name-authority",
    "urn:oid:2.16.840.1.113883.4.642.3.3028": "medicinal-product-name-part-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3069": "group-membership-basis",
    "urn:oid:2.16.840.1.113883.4.642.3.376": "medication-status",
    "urn:oid:2.16.840.1.113883.4.642.3.733": "contract-term-type",
    "urn:oid:2.16.840.1.113883.4.642.3.81": "constraint-severity",
    "urn:oid:2.16.840.1.113883.4.642.3.700": "supplydelivery-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3187": "measure-stratifier-example",
    "urn:oid:2.16.840.1.113883.4.642.3.728": "account-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1370": "allergyintolerance-verification",
    "urn:oid:2.16.840.1.113883.4.642.3.799": "action-grouping-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.425": "device-action",
    "urn:oid:2.16.840.1.113883.4.642.3.842": "adverse-event-causality-method",
    "urn:oid:2.16.840.1.113883.4.642.3.755": "consent-state-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.140": "bodystructure-relative-location",
    "urn:oid:2.16.840.1.113883.4.642.3.1014": "consent-policy",
    "urn:oid:2.16.840.1.113883.4.642.3.3266": "guidance-module-code",
    "urn:oid:2.16.840.1.113883.4.642.3.430": "procedure-category",
    "urn:oid:2.16.840.1.113883.4.642.3.446": "questionnaire-answers",
    "urn:oid:2.16.840.1.113883.4.642.3.2980": "audit-event-severity",
    "urn:oid:2.16.840.1.113883.4.642.3.668": "structure-definition-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.3197": "device-specification-category",
    "urn:oid:2.16.840.1.113883.4.642.3.741": "contract-actorrole",
    "urn:oid:2.16.840.1.113883.4.642.3.3054": "measurereport-stratifier-value-example",
    "urn:oid:2.16.840.1.113883.4.642.3.400": "observation-status",
    "urn:oid:2.16.840.1.113883.4.642.3.712": "testscript-profile-origin-types",
    "urn:oid:2.16.840.1.113883.4.642.3.3189": "measure-supplemental-data-example",
    "urn:oid:2.16.840.1.113883.4.642.3.673": "type-derivation-rule",
    "urn:oid:2.16.840.1.113883.3.88.12.80.62": "observation-vitalsignresult",
    "urn:oid:2.16.840.1.113883.4.642.3.3271": "nutritionproduct-status",
    "urn:oid:2.16.840.1.113883.4.642.3.49": "diagnosis-role",
    "urn:oid:2.16.840.1.113883.4.642.3.1316": "medicationdispense-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.269": "history-absent-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.1036": "timezones",
    "urn:oid:2.16.840.1.113883.4.642.3.3008": "security-label-event-examples",
    "urn:oid:2.16.840.1.113883.4.642.3.995": "immunization-function",
    "urn:oid:2.16.840.1.113883.4.642.3.1328": "coverage-financial-exception",
    "urn:oid:2.16.840.1.113883.4.642.3.1005": "questionnaire-enable-operator",
    "urn:oid:2.16.840.1.113883.4.642.3.805": "action-precheck-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.753": "consent-action",
    "urn:oid:2.16.840.1.113883.4.642.3.3162": "immunization-vaccine-funding-program",
    "urn:oid:2.16.840.1.113883.4.642.3.431": "procedure-not-performed-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.3037": "transport-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.3151": "questionnaire-answer-constraint",
    "urn:oid:2.16.840.1.113883.4.642.3.840": "adverse-event-causality-assess",
    "urn:oid:2.16.840.1.113883.4.642.3.892": "verificationresult-primary-source-type",
    "urn:oid:2.16.840.1.113883.4.642.3.412": "operation-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.180": "type-restful-interaction",
    "urn:oid:2.16.840.1.113883.4.642.3.290": "immunization-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.232": "clinical-findings",
    "urn:oid:2.16.840.1.113883.4.642.3.993": "immunization-subpotent-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.3179": "condition-precondition-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3225": "account-relationship",
    "urn:oid:2.16.840.1.113883.4.642.3.3110": "interaction-management",
    "urn:oid:2.16.840.1.113883.4.642.3.3161": "subscription-notification-type",
    "urn:oid:2.16.840.1.113883.4.642.3.720": "report-action-result-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.289": "immunization-route",
    "urn:oid:2.16.840.1.113883.4.642.3.648": "metric-category",
    "urn:oid:2.16.840.1.113883.4.642.3.823": "research-study-objective-type",
    "urn:oid:2.16.840.1.113883.4.642.3.43": "binding-strength",
    "urn:oid:2.16.840.1.113883.4.642.3.3057": "testscript-scope-conformance-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.3125": "biologicallyderived-productcodes",
    "urn:oid:2.16.840.1.113883.4.642.3.996": "guide-parameter-code",
    "urn:oid:2.16.840.1.113883.4.642.3.3320": "conceptmap-property-type",
    "urn:oid:2.16.840.1.113883.4.642.3.639": "search-modifier-code",
    "urn:oid:2.16.840.1.113883.4.642.3.3056": "testscript-scope-phase-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.1301": "contract-assetsubtype",
    "urn:oid:2.16.840.1.113883.4.642.3.618": "explanationofbenefit-status",
    "urn:oid:2.16.840.1.113883.4.642.3.464": "audit-event-sub-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1953": "medication-ingredientstrength",
    "urn:oid:2.16.840.1.113883.4.642.3.492": "namingsystem-identifier-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3168": "unit-of-presentation",
    "urn:oid:2.16.840.1.113883.4.642.3.2976": "citation-summary-style",
    "urn:oid:2.16.840.1.113883.4.642.3.1007": "questionnaire-enable-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.486": "participationstatus",
    "urn:oid:2.16.840.1.113883.4.642.3.825": "research-study-reason-stopped",
    "urn:oid:2.16.840.1.113883.4.642.3.20": "languages",
    "urn:oid:2.16.840.1.113883.4.642.3.610": "benefit-unit",
    "urn:oid:2.16.840.1.113883.4.642.3.209": "device-status",
    "urn:oid:2.16.840.1.113883.4.642.3.182": "event-capability-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.3316": "related-artifact-type-all",
    "urn:oid:2.16.840.1.113883.4.642.3.3275": "referenced-item-category",
    "urn:oid:2.16.840.1.113883.4.642.3.13": "remittance-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.408": "issue-severity",
    "urn:oid:2.16.840.1.113883.4.642.3.3236": "adverse-event-status",
    "urn:oid:2.16.840.1.113883.4.642.3.757": "consent-provision-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1297": "contract-assetcontext",
    "urn:oid:2.16.840.1.113883.4.642.3.318": "list-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.374": "medication-form-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.3191": "measure-group-example",
    "urn:oid:2.16.840.1.113883.4.642.3.122": "flag-category",
    "urn:oid:2.16.840.1.113883.4.642.3.3192": "measure-aggregate-method",
    "urn:oid:2.16.840.1.113883.4.642.3.1381": "appointment-cancellation-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.3261": "substance-representation-type",
    "urn:oid:2.16.840.1.113883.4.642.3.704": "testscript-operation-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.658": "vision-product",
    "urn:oid:2.16.840.1.113883.4.642.3.3260": "substance-name-domain",
    "urn:oid:2.16.840.1.113883.4.642.3.3111": "interaction-effect",
    "urn:oid:2.16.840.1.113883.4.642.3.570": "provider-qualification",
    "urn:oid:2.16.840.1.113883.4.642.3.252": "encounter-special-courtesy",
    "urn:oid:2.16.840.1.113883.4.642.3.314": "linkage-type",
    "urn:oid:2.16.840.1.113883.4.642.3.11": "search-param-type",
    "urn:oid:2.16.840.1.113883.4.642.3.735": "contract-term-subtype",
    "urn:oid:2.16.840.1.113883.4.642.3.3105": "interactant",
    "urn:oid:2.16.840.1.113883.4.642.3.73": "contact-point-use",
    "urn:oid:2.16.840.1.113883.4.642.3.3011": "security-label-examples",
    "urn:oid:2.16.840.1.113883.4.642.3.267": "history-status",
    "urn:oid:2.16.840.1.113883.4.642.3.846": "chargeitem-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3270": "nutrition-product-nutrient",
    "urn:oid:2.16.840.1.113883.4.642.3.3244": "coverage-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.708": "assert-operator-codes",
    "urn:oid:2.16.840.1.113883.11.21013": "namingsystem-identifier-system-type",
    "urn:oid:2.16.840.1.113883.4.642.3.386": "nutrient-code",
    "urn:oid:2.16.840.1.113883.4.642.3.3055": "submit-data-update-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3096": "imagingselection-status",
    "urn:oid:2.16.840.1.113883.4.642.3.598": "adjudication-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.3252": "substance-name-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3185": "task-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.275": "goal-category",
    "urn:oid:2.16.840.1.113883.4.642.3.103": "trigger-type",
    "urn:oid:2.16.840.1.113883.4.642.3.75": "event-timing",
    "urn:oid:2.16.840.1.113883.4.642.3.54": "participation-role-type",
    "urn:oid:2.16.840.1.113883.4.642.3.641": "payment-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3117": "disease-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3206": "operation-parameter-scope",
    "urn:oid:2.16.840.1.113883.4.642.3.384": "food-type",
    "urn:oid:2.16.840.1.113883.4.642.3.308": "immunization-recommendation-date-criterion",
    "urn:oid:2.16.840.1.113883.4.642.3.234": "diagnostic-service-sections",
    "urn:oid:2.16.840.1.113883.4.642.3.2971": "citation-classification-type",
    "urn:oid:2.16.840.1.113883.4.642.3.739": "contract-action",
    "urn:oid:2.16.840.1.113883.4.642.3.494": "endpoint-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3251": "substance-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.3.888": "verificationresult-validation-process",
    "urn:oid:2.16.840.1.113883.4.642.3.1024": "mimetypes",
    "urn:oid:2.16.840.1.113883.4.642.3.983": "communication-topic",
    "urn:oid:2.16.840.1.113883.4.642.3.2988": "supplydelivery-supplyitemtype",
    "urn:oid:2.16.840.1.113883.4.642.3.576": "ex-program-code",
    "urn:oid:2.16.840.1.113883.4.642.3.428": "procedure-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.714": "testscript-profile-destination-types",
    "urn:oid:2.16.840.1.113883.4.642.3.171": "condition-stage-type",
    "urn:oid:2.16.840.1.113883.4.642.3.2965": "contributor-summary-source",
    "urn:oid:2.16.840.1.113883.4.642.3.2994": "week-of-month",
    "urn:oid:2.16.840.1.113883.4.642.3.3184": "endpoint-environment",
    "urn:oid:2.16.840.1.113883.4.642.3.3061": "characteristic-offset",
    "urn:oid:2.16.840.1.113883.4.642.3.3113": "therapy-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3245": "ingredient-function",
    "urn:oid:2.16.840.1.113883.4.642.3.592": "fm-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3256": "substance-source-material-type",
    "urn:oid:2.16.840.1.113883.4.642.3.807": "action-cardinality-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.1387": "ex-procedure-type",
    "urn:oid:2.16.840.1.113883.4.642.3.238": "composition-attestation-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.3123": "biologicallyderived-product-property-type-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.57": "identifier-use",
    "urn:oid:2.16.840.1.113883.4.642.3.3079": "location-characteristic",
    "urn:oid:2.16.840.1.113883.4.642.3.3242": "medicationrequest-admin-location",
    "urn:oid:2.16.840.1.113883.4.642.3.1295": "asset-availability",
    "urn:oid:2.16.840.1.113883.4.642.3.330": "location-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.3128": "administration-subpotent-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.172": "communication-category",
    "urn:oid:2.16.840.1.113883.4.642.3.452": "audit-event-action",
    "urn:oid:2.16.840.1.113883.4.642.3.3216": "specimen-role",
    "urn:oid:2.16.840.1.113883.4.642.3.695": "supplyrequest-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3246": "ingredient-role",
    "urn:oid:2.16.840.1.113883.4.642.3.1220": "contract-security-category",
    "urn:oid:2.16.840.1.113883.4.642.3.326": "list-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3267": "nutrition-product-category",
    "urn:oid:2.16.840.1.113883.4.642.3.1060": "event-resource-types",
    "urn:oid:2.16.840.1.113883.4.642.3.3195": "device-property-type",
    "urn:oid:2.16.840.1.113883.4.642.3.198": "capability-statement-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.1216": "contract-scope",
    "urn:oid:2.16.840.1.113883.4.642.3.546": "surface",
    "urn:oid:2.16.840.1.113883.4.642.3.773": "composite-measure-scoring",
    "urn:oid:2.16.840.1.113883.4.642.3.174": "communication-not-done-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.39": "adjudication-error",
    "urn:oid:2.16.840.1.113883.4.642.3.2974": "title-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3027": "medicinal-product-contact-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3088": "medication-statement-status",
    "urn:oid:2.16.840.1.113883.4.642.3.2983": "claim-decision",
    "urn:oid:2.16.840.1.113883.4.642.3.590": "ex-diagnosistype",
    "urn:oid:2.16.840.1.113883.4.642.3.131": "allergy-intolerance-type",
    "urn:oid:2.16.840.1.113883.4.642.3.344": "reason-medication-given-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.860": "code-search-support",
    "urn:oid:2.16.840.1.113883.4.642.3.3131": "research-subject-state",
    "urn:oid:2.16.840.1.113883.4.642.3.3238": "adverse-event-preventive-action",
    "urn:oid:2.16.840.1.113883.4.642.3.3296": "concrete-fhir-types",
    "urn:oid:2.16.840.1.113883.4.642.3.460": "object-role",
    "urn:oid:2.16.840.1.113883.4.642.3.769": "measure-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3095": "imagingselection-2dgraphictype",
    "urn:oid:2.16.840.1.113883.4.642.3.3224": "account-billing-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3183": "clinicalimpression-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.3198": "device-availability-status",
    "urn:oid:2.16.840.1.113883.4.642.3.26": "message-events",
    "urn:oid:2.16.840.1.113883.4.642.3.3045": "study-design",
    "urn:oid:2.16.840.1.113883.4.642.3.2969": "cited-medium",
    "urn:oid:2.16.840.1.113883.4.642.3.3066": "report-relation-type",
    "urn:oid:2.16.840.1.113883.3.88.12.80.72": "c80-practice-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.831": "adverse-event-actuality",
    "urn:oid:2.16.840.1.113883.4.642.3.0": "insuranceplan-applicability",
    "urn:oid:2.16.840.1.113883.4.642.3.2997": "regulated-authorization-basis",
    "urn:oid:2.16.840.1.113883.4.642.3.429": "procedure-followup",
    "urn:oid:2.16.840.1.113883.4.642.3.2958": "cited-artifact-classification-type",
    "urn:oid:2.16.840.1.113883.4.642.3.815": "action-condition-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.786": "compartment-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1333": "observation-range-category",
    "urn:oid:2.16.840.1.113883.4.642.3.3166": "target-species",
    "urn:oid:2.16.840.1.113883.4.642.3.3067": "evidence-classifier-code",
    "urn:oid:2.16.840.1.113883.4.642.3.473": "substance-code",
    "urn:oid:2.16.840.1.113883.4.642.3.211": "udi-entry-type",
    "urn:oid:2.16.840.1.113883.4.642.3.161": "condition-code",
    "urn:oid:2.16.840.1.113883.4.642.3.148": "care-plan-category",
    "urn:oid:2.16.840.1.113883.4.642.3.3072": "packaging-type",
    "urn:oid:2.16.840.1.113883.4.642.3.811": "action-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.3.484": "appointmentstatus",
    "urn:oid:2.16.840.1.113883.4.642.3.380": "response-code",
    "urn:oid:2.16.840.1.113883.4.642.3.666": "episodeofcare-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1372": "allergyintolerance-clinical",
    "urn:oid:2.16.840.1.113883.4.642.3.305": "immunization-recommendation-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3124": "biologicallyderived-product-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3034": "transport-intent",
    "urn:oid:2.16.840.1.113883.4.642.3.443": "questionnaire-questions",
    "urn:oid:2.16.840.1.113883.4.642.3.624": "http-verb",
    "urn:oid:2.16.840.1.113883.4.642.3.3015": "medicinal-product-name-type",
    "urn:oid:2.16.840.1.113883.4.642.3.784": "codesystem-hierarchy-meaning",
    "urn:oid:2.16.840.1.113883.4.642.3.3042": "manufactured-dose-form",
    "urn:oid:2.16.840.1.113883.4.642.3.3299": "fhir-types",
    "urn:oid:2.16.840.1.113883.4.642.3.2964": "cited-artifact-part-type",
    "urn:oid:2.16.840.1.113883.4.642.3.237": "doc-section-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.3108": "interaction-incidence",
    "urn:oid:2.16.840.1.113883.4.642.3.743": "contract-status",
    "urn:oid:2.16.840.1.113883.4.642.3.178": "restful-security-service",
    "urn:oid:2.16.840.1.113883.4.642.3.955": "ucum-vitals-common",
    "urn:oid:2.16.840.1.113883.4.642.3.120": "flag-status",
    "urn:oid:2.16.840.1.113883.4.642.3.1335": "medicationknowledge-status",
    "urn:oid:2.16.840.1.113883.4.642.3.902": "product-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3154": "subscription-payload-content",
    "urn:oid:2.16.840.1.113883.4.642.3.205": "detectedissue-mitigation-action",
    "urn:oid:2.16.840.1.113883.4.642.3.924": "messageheader-response-request",
    "urn:oid:2.16.840.1.113883.4.642.3.3165": "animal-tissue-type",
    "urn:oid:2.16.840.1.113883.4.642.3.96": "medication-as-needed-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.912": "ucum-units",
    "urn:oid:2.16.840.1.113883.4.642.3.3104": "warning-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3090": "medication-statement-adherence",
    "urn:oid:2.16.840.1.113883.4.642.3.22": "data-types",
    "urn:oid:2.16.840.1.113883.4.642.3.1208": "contract-publicationstatus",
    "urn:oid:2.16.840.1.113883.4.642.3.3039": "device-productidentifierinudi",
    "urn:oid:2.16.840.1.113883.4.642.3.55": "narrative-status",
    "urn:oid:2.16.840.1.113883.4.642.3.403": "observation-category",
    "urn:oid:2.16.840.1.113883.4.642.3.2961": "contributor-role",
    "urn:oid:2.16.840.1.113883.4.642.3.512": "days-of-week",
    "urn:oid:2.16.840.1.113883.4.642.3.438": "provenance-activity-type",
    "urn:oid:2.16.840.1.113883.4.642.3.246": "encounter-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3029": "medicinal-product-cross-reference-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1612": "substance-amount-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3182": "clinicalimpression-change-pattern",
    "urn:oid:2.16.840.1.113883.4.642.3.233": "report-codes",
    "urn:oid:2.16.840.1.113883.4.642.4.3320": "encounter-reason-use",
    "urn:oid:2.16.840.1.113883.4.642.3.731": "contract-subtype",
    "urn:oid:2.16.840.1.113883.4.642.3.850": "container-cap",
    "urn:oid:2.16.840.1.113883.4.642.3.3173": "interaction-trigger",
    "urn:oid:2.16.840.1.113883.4.642.3.31": "payeetype",
    "urn:oid:2.16.840.1.113883.4.642.3.3300": "fhirpath-types",
    "urn:oid:2.16.840.1.113883.4.642.3.392": "entformula-additive",
    "urn:oid:2.16.840.1.113883.4.642.3.699": "supply-item",
    "urn:oid:2.16.840.1.113883.4.642.3.821": "research-study-phase",
    "urn:oid:2.16.840.1.113883.4.642.3.848": "chargeitem-billingcodes",
    "urn:oid:2.16.840.1.113883.4.642.3.471": "specimen-status",
    "urn:oid:2.16.840.1.113883.4.642.3.389": "consistency-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3174": "subscriptiontopic-cr-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.637": "search-comparator",
    "urn:oid:2.16.840.1.113883.4.642.3.645": "devicemetric-type",
    "urn:oid:2.16.840.1.113883.6.24": "devicemetric-type",
    "urn:oid:2.16.840.1.113883.4.642.3.646": "metric-operational-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3086": "genomicstudy-changetype",
    "urn:oid:2.16.840.1.113883.4.642.3.1309": "FHIR-version",
    "urn:oid:2.16.840.1.113883.4.642.3.898": "verificationresult-push-type-available",
    "urn:oid:2.16.840.1.113883.4.642.3.3097": "imagingselection-3dgraphictype",
    "urn:oid:2.16.840.1.113883.4.642.3.3132": "research-subject-state-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3226": "account-balance-term",
    "urn:oid:2.16.840.1.113883.4.642.3.606": "benefit-type",
    "urn:oid:2.16.840.1.113883.4.642.3.62": "distance-units",
    "urn:oid:2.16.840.1.113883.4.642.3.78": "timing-abbreviation",
    "urn:oid:2.16.840.1.113883.4.642.3.989": "series-performer-function",
    "urn:oid:2.16.840.1.113883.4.642.3.706": "assert-direction-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.1009": "coverage-class",
    "urn:oid:2.16.840.1.113883.4.642.3.675": "map-model-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.3092": "citation-artifact-classifier",
    "urn:oid:2.16.840.1.113883.4.642.3.264": "designation-use",
    "urn:oid:2.16.840.1.113883.4.642.3.498": "endpoint-connection-type",
    "urn:oid:2.16.840.1.113883.4.642.3.474": "substance-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3155": "artifactassessment-disposition",
    "urn:oid:2.16.840.1.113883.4.642.3.235": "diagnostic-report-status",
    "urn:oid:2.16.840.1.113883.4.642.3.450": "risk-probability",
    "urn:oid:2.16.840.1.113883.4.642.3.3052": "action-participant-function",
    "urn:oid:2.16.840.1.113883.4.642.3.3006": "examplescenario-instance-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1218": "contract-security-classification",
    "urn:oid:2.16.840.1.113883.4.642.3.250": "encounter-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.3.468": "specimen-collection-method",
    "urn:oid:2.16.840.1.113883.4.642.3.2970": "contributor-summary-style",
    "urn:oid:2.16.840.1.113883.4.642.3.1385": "subscriber-relationship",
    "urn:oid:2.16.840.1.113883.4.642.3.1398": "specimen-collection",
    "urn:oid:2.16.840.1.113883.4.642.3.813": "action-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.3.59": "quantity-comparator",
    "urn:oid:2.16.840.1.113883.4.642.3.588": "ex-diagnosisrelatedgroup",
    "urn:oid:2.16.840.1.113883.4.642.3.3217": "specimen-combined",
    "urn:oid:2.16.840.1.113883.4.642.3.726": "account-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3040": "devicedefinition-relationtype",
    "urn:oid:2.16.840.1.113883.4.642.3.1025": "currencies",
    "urn:oid:2.16.840.1.113883.4.642.3.7": "document-reference-status",
    "urn:oid:2.16.840.1.113883.4.642.3.643": "payment-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3075": "research-study-party-role",
    "urn:oid:2.16.840.1.113883.4.642.3.3202": "device-versiontype",
    "urn:oid:2.16.840.1.113883.4.642.3.271": "goal-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3313": "substance-form",
    "urn:oid:2.16.840.1.113883.4.642.3.248": "encounter-type",
    "urn:oid:2.16.840.1.113883.4.642.3.299": "immunization-evaluation-status",
    "urn:oid:2.16.840.1.113883.4.642.3.322": "list-empty-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.83": "resource-slicing-rules",
    "urn:oid:2.16.840.1.113883.4.642.3.160": "clinicalimpression-prognosis",
    "urn:oid:2.16.840.1.113883.4.642.3.89": "reference-version-rules",
    "urn:oid:2.16.840.1.113883.4.642.3.3152": "questionnaire-disabled-display",
    "urn:oid:2.16.840.1.113883.4.642.3.664": "episode-of-care-status",
    "urn:oid:2.16.840.1.113883.4.642.3.866": "invoice-status",
    "urn:oid:2.16.840.1.113883.4.642.3.890": "verificationresult-failure-action",
    "urn:oid:2.16.840.1.113883.4.642.3.111": "request-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3103": "version-algorithm",
    "urn:oid:2.16.840.1.113883.4.642.3.1291": "contract-decision-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.520": "coverage-type",
    "urn:oid:2.16.840.1.113883.4.642.3.681": "map-transform",
    "urn:oid:2.16.840.1.113883.4.642.3.3026": "medicinal-product-confidentiality",
    "urn:oid:2.16.840.1.113883.4.642.3.3294": "all-resource-types",
    "urn:oid:2.16.840.1.113883.4.642.3.190": "versioning-policy",
    "urn:oid:2.16.840.1.113883.4.642.3.1312": "medicationdispense-status",
    "urn:oid:2.16.840.1.113883.4.642.3.985": "strand-type",
    "urn:oid:2.16.840.1.113883.4.642.3.490": "namingsystem-type",
    "urn:oid:2.16.840.1.113883.4.642.3.710": "assert-response-code-types",
    "urn:oid:2.16.840.1.113883.4.642.3.616": "ex-paymenttype",
    "urn:oid:2.16.840.1.113883.4.642.3.395": "observation-methods",
    "urn:oid:2.16.840.1.113883.4.642.3.817": "guidance-response-status",
    "urn:oid:2.16.840.1.113883.4.642.3.28": "use-context",
    "urn:oid:2.16.840.1.113883.4.642.3.2960": "cited-artifact-status-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3204": "device-specification-type",
    "urn:oid:2.16.840.1.113883.4.642.3.747": "consent-content-class",
    "urn:oid:2.16.840.1.113883.4.642.3.141": "body-site",
    "urn:oid:2.16.840.1.113883.4.642.3.3208": "payment-issuertype",
    "urn:oid:2.16.840.1.113883.4.642.3.836": "adverse-event-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.835": "adverse-event-type",
    "urn:oid:2.16.840.1.113883.4.642.3.61": "duration-units",
    "urn:oid:2.16.840.1.113883.4.642.3.3043": "certainty-type",
    "urn:oid:2.16.840.1.113883.4.642.3.85": "resource-aggregation-mode",
    "urn:oid:1.2.840.10065.1.12": "signature-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1393": "coverageeligibilityresponse-ex-auth-support",
    "urn:oid:2.16.840.1.113883.4.642.3.257": "encounter-admit-source",
    "urn:oid:2.16.840.1.113883.4.642.3.410": "issue-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1238": "concept-subsumption-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.282": "graph-compartment-use",
    "urn:oid:2.16.840.1.113883.4.642.3.3265": "observation-triggeredbytype",
    "urn:oid:2.16.840.1.113883.4.642.3.3232": "permission-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3325": "conceptmap-attribute-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1182": "eligibilityrequest-purpose",
    "urn:oid:2.16.840.1.113883.4.642.3.564": "service-place",
    "urn:oid:2.16.840.1.113883.4.642.3.3153": "devicedispense-status",
    "urn:oid:2.16.840.1.113883.4.642.3.184": "message-transport",
    "urn:oid:2.16.840.1.113883.4.642.3.320": "list-item-flag",
    "urn:oid:2.16.840.1.113883.4.642.3.3295": "concept-map-relationship",
    "urn:oid:2.16.840.1.113883.4.642.3.482": "slotstatus",
    "urn:oid:2.16.840.1.113883.4.642.3.3298": "elementdefinition-types",
    "urn:oid:2.16.840.1.113883.4.642.3.1065": "cdshooks-indicator",
    "urn:oid:2.16.840.1.113883.4.642.3.181": "system-restful-interaction",
    "urn:oid:2.16.840.1.113883.4.642.3.927": "provenance-history-agent-type",
    "urn:oid:2.16.840.1.113883.4.642.3.470": "specimen-container-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3012": "performer-function",
    "urn:oid:2.16.840.1.113883.4.642.3.340": "medication-admin-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3156": "artifactassessment-information-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1206": "contract-legalstate",
    "urn:oid:2.16.840.1.113883.4.642.3.303": "immunization-evaluation-dose-status-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.15": "note-type",
    "urn:oid:2.16.840.1.113883.4.642.3.683": "map-source-list-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.124": "flag-code",
    "urn:oid:2.16.840.1.113883.4.642.3.1318": "medicationdispense-performer-function",
    "urn:oid:2.16.840.1.113883.4.642.3.3231": "permission-rule-combining",
    "urn:oid:2.16.840.1.113883.4.642.3.978": "security-role-type",
    "urn:oid:2.16.840.1.113883.4.642.3.608": "benefit-network",
    "urn:oid:2.16.840.1.113883.4.642.3.394": "enteral-route",
    "urn:oid:2.16.840.1.113883.4.642.3.3060": "characteristic-combination",
    "urn:oid:2.16.840.1.113883.4.642.3.3253": "substance-source-material-genus",
    "urn:oid:2.16.840.1.113883.4.642.3.79": "common-tags",
    "urn:oid:2.16.840.1.113883.4.642.3.3022": "medicinal-product-type",
    "urn:oid:2.16.840.1.113883.4.642.3.241": "composition-status",
    "urn:oid:2.16.840.1.113883.4.642.3.886": "verificationresult-validation-type",
    "urn:oid:2.16.840.1.113883.4.642.3.444": "item-type",
    "urn:oid:2.16.840.1.113883.4.642.3.1012": "extension-context-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3024": "medicinal-product-special-measures",
    "urn:oid:2.16.840.1.113883.4.642.3.803": "action-required-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.3115": "interaction-type",
    "urn:oid:2.16.840.1.113883.4.642.3.650": "metric-calibration-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3084": "genomicstudy-dataformat",
    "urn:oid:2.16.840.1.113883.4.642.3.3085": "genomicstudy-methodtype",
    "urn:oid:2.16.840.1.113883.4.642.3.288": "immunization-site",
    "urn:oid:2.16.840.1.113883.4.642.3.968": "catalogType",
    "urn:oid:2.16.840.1.113883.4.642.3.1374": "goal-achievement",
    "urn:oid:2.16.840.1.113883.4.642.3.3268": "allergen-class",
    "urn:oid:2.16.840.1.113883.4.642.3.1979": "medication-intended-performer-role",
    "urn:oid:2.16.840.1.113883.4.642.3.1303": "contract-actionstatus",
    "urn:oid:2.16.840.1.113883.4.642.3.1396": "task-code",
    "urn:oid:2.16.840.1.113883.4.642.3.3215": "specimen-processing-method",
    "urn:oid:2.16.840.1.113883.4.642.3.3213": "deviceusage-adherence-code",
    "urn:oid:2.16.840.1.113883.4.642.3.37": "forms",
    "urn:oid:2.16.840.1.113883.4.642.3.3311": "devicedefinition-regulatory-identifier-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3093": "price-component-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3050": "attribute-estimate-type",
    "urn:oid:2.16.840.1.113883.4.642.3.399": "observation-interpretation",
    "urn:oid:2.16.840.1.113883.4.642.3.433": "performer-role",
    "urn:oid:2.16.840.1.113883.4.642.3.790": "task-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3302": "usage-context-agreement-scope",
    "urn:oid:2.16.840.1.113883.4.642.3.45": "identifier-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3214": "deviceusage-adherence-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.387": "texture-code",
    "urn:oid:2.16.840.1.113883.4.642.3.35": "relationship",
    "urn:oid:2.16.840.1.113883.4.642.3.219": "sequence-type",
    "urn:oid:2.16.840.1.113883.4.642.3.194": "conditional-delete-status",
    "urn:oid:2.16.840.1.113883.4.642.3.244": "document-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.3.500": "subscription-channel-type",
    "urn:oid:2.16.840.1.113883.4.642.3.375": "medication-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.3307": "device-category",
    "urn:oid:2.16.840.1.113883.4.642.3.780": "concept-property-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3076": "research-study-focus-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3301": "participant-resource-types",
    "urn:oid:2.16.840.1.113883.4.642.3.129": "allergy-intolerance-criticality",
    "urn:oid:2.16.840.1.113883.4.642.3.414": "organization-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3068": "evidence-report-section",
    "urn:oid:2.16.840.1.113883.4.642.3.202": "reference-handling-policy",
    "urn:oid:2.16.840.1.113883.4.642.3.1326": "medicationrequest-course-of-therapy",
    "urn:oid:2.16.840.1.113883.4.642.3.852": "specimen-contained-preference",
    "urn:oid:2.16.840.1.113883.4.642.3.48": "jurisdiction",
    "urn:oid:2.16.840.1.113883.4.642.3.3064": "focus-characteristic-code",
    "urn:oid:2.16.840.1.113883.4.642.3.506": "operation-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.33": "fundsreserve",
    "urn:oid:2.16.840.1.113883.4.642.3.1224": "contract-party-role",
    "urn:oid:2.16.840.1.113883.4.642.3.3133": "research-subject-milestone",
    "urn:oid:2.16.840.1.113883.4.642.3.396": "observation-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.882": "verificationresult-need",
    "urn:oid:2.16.840.1.113883.4.642.3.3109": "clinical-use-definition-category",
    "urn:oid:2.16.840.1.113883.4.642.3.3247": "ingredient-manufacturer-role",
    "urn:oid:2.16.840.1.113883.4.642.3.1299": "contract-assettype",
    "urn:oid:2.16.840.1.113883.4.642.3.527": "coverage-copay-type",
    "urn:oid:2.16.840.1.113883.4.642.3.97": "administration-method-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.3016": "product-characteristic-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.534": "missing-tooth-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.782": "codesystem-content-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.3000": "care-plan-activity-performed",
    "urn:oid:2.16.840.1.113883.4.642.3.1376": "device-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3188": "measure-scoring-unit",
    "urn:oid:2.16.840.1.113883.4.642.3.240": "doc-typecodes",
    "urn:oid:2.16.840.1.113883.4.642.3.652": "metric-calibration-state",
    "urn:oid:2.16.840.1.113883.4.642.3.3237": "adverse-event-contributing-factor",
    "urn:oid:2.16.840.1.113883.4.642.3.5": "data-absent-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.99": "related-artifact-type",
    "urn:oid:2.16.840.1.113883.4.642.3.827": "research-study-prim-purp-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3234": "adverse-event-mitigating-action",
    "urn:oid:2.16.840.1.113883.4.642.3.3209": "payment-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.3053": "action-reason-code",
    "urn:oid:2.16.840.1.113883.4.642.3.188": "message-significance-category",
    "urn:oid:2.16.840.1.113883.4.642.3.979": "sort-direction",
    "urn:oid:2.16.840.1.113883.4.642.3.3249": "substance-weight-type",
    "urn:oid:2.16.840.1.113883.4.642.3.439": "practitioner-role",
    "urn:oid:2.16.840.1.113883.4.642.3.1130": "patient-contactrelationship",
    "urn:oid:2.16.840.1.113883.4.642.3.324": "list-order",
    "urn:oid:2.16.840.1.113883.4.642.3.574": "icd-10-procedures",
    "urn:oid:2.16.840.1.113883.4.642.3.138": "basic-resource-type",
    "urn:oid:2.16.840.1.113883.4.642.3.135": "reaction-event-severity",
    "urn:oid:2.16.840.1.113883.4.642.3.1184": "eligibilityresponse-purpose",
    "urn:oid:2.16.840.1.113883.4.642.3.759": "consent-data-meaning",
    "urn:oid:2.16.840.1.113883.4.642.3.660": "vision-eye-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.900": "product-category",
    "urn:oid:2.16.840.1.113883.4.642.3.3031": "inventoryreport-status",
    "urn:oid:2.16.840.1.113883.4.642.3.279": "goal-start-event",
    "urn:oid:2.16.840.1.113883.4.642.3.346": "approach-site-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.833": "adverse-event-category",
    "urn:oid:2.16.840.1.113883.4.642.3.3062": "variable-handling",
    "urn:oid:2.16.840.1.113883.4.642.3.3099": "formularyitem-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3035": "transport-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3221": "knowledge-representation-level",
    "urn:oid:2.16.840.1.113883.4.642.4.3321": "encounter-diagnosis-use",
    "urn:oid:2.16.840.1.113883.4.642.3.3269": "measurement-property",
    "urn:oid:2.16.840.1.113883.4.642.3.349": "med-admin-perform-function",
    "urn:oid:2.16.840.1.113883.4.642.3.510": "service-referral-method",
    "urn:oid:2.16.840.1.113883.4.642.3.3116": "undesirable-effect-classification",
    "urn:oid:2.16.840.1.113883.4.642.3.531": "icd-10",
    "urn:oid:2.16.840.1.113883.4.642.3.162": "condition-category",
    "urn:oid:2.16.840.1.113883.4.642.3.1321": "medicationrequest-intent",
    "urn:oid:2.16.840.1.113883.4.642.3.3258": "substance-stereochemistry",
    "urn:oid:2.16.840.1.113883.4.642.3.987": "orientation-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3157": "artifactassessment-workflow-status",
    "urn:oid:2.16.840.1.113883.4.642.3.47": "security-labels",
    "urn:oid:2.16.840.1.113883.4.642.3.496": "endpoint-payload-type",
    "urn:oid:2.16.840.1.113883.4.642.3.3264": "observation-referencerange-normalvalue",
    "urn:oid:2.16.840.1.113883.4.642.3.3257": "substance-representation-format",
    "urn:oid:2.16.840.1.113883.4.642.3.369": "reason-medication-status-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.3": "publication-status",
    "urn:oid:2.16.840.1.113883.4.642.3.2981": "security-source-type",
    "urn:oid:2.16.840.1.113883.4.642.3.150": "care-plan-intent",
    "urn:oid:2.16.840.1.113883.4.642.3.405": "observation-statistics",
    "urn:oid:2.16.840.1.113883.4.642.3.1400": "container-material",
    "urn:oid:2.16.840.1.113883.4.642.3.152": "participant-role",
    "urn:oid:2.16.840.1.113883.4.642.3.137": "allergyintolerance-code",
    "urn:oid:2.16.840.1.113883.4.642.3.776": "measure-report-status",
    "urn:oid:2.16.840.1.113883.4.642.3.3212": "deviceusage-status",
    "urn:oid:2.16.840.1.113883.4.642.3.391": "entformula-type",
    "urn:oid:2.16.840.1.113883.4.642.3.596": "adjudication",
    "urn:oid:2.16.840.1.113883.4.642.3.958": "ucum-bodylength",
    "urn:oid:2.16.840.1.113883.4.642.3.273": "goal-priority",
    "urn:oid:2.16.840.1.113883.4.642.3.3239": "adverse-event-supporting-info",
    "urn:oid:2.16.840.1.113883.4.642.3.1399": "prepare-patient-prior-specimen-collection",
    "urn:oid:2.16.840.1.113883.4.642.3.67": "address-use",
    "urn:oid:2.16.840.1.113883.4.642.3.518": "service-type",
    "urn:oid:2.16.840.1.113883.4.642.3.685": "map-target-list-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.204": "detectedissue-category",
    "urn:oid:2.16.840.1.113883.4.642.3.718": "report-result-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.870": "insuranceplan-type",
    "urn:oid:2.16.840.1.113883.4.642.4.3318": "version-independent-resource-types",
    "urn:oid:2.16.840.1.113883.4.642.3.2975": "related-artifact-type-expanded",
    "urn:oid:2.16.840.1.113883.4.642.3.3314": "appointmentresponse-status",
    "urn:oid:2.16.840.1.113883.4.642.4.3319": "subscription-types",
    "urn:oid:2.16.840.1.113883.4.642.3.967": "condition-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.3304": "all-time-units",
    "urn:oid:2.16.840.1.113883.4.642.3.3303": "all-distance-units",
    "urn:oid:2.16.840.1.113883.4.642.3.3010": "written-languages",
    "urn:oid:2.16.840.1.113883.4.642.3.919": "conformance-expectation",
    "urn:oid:2.16.840.1.113883.4.642.4.3324": "version-independent-all-resource-types"
}

fhir_value_sets_old = {
    "urn:oid:2.16.840.1.113883.4.642.1.35": "relationship",
    "urn:oid:2.16.840.1.113883.4.642.2.23": "relationship",
    "urn:oid:2.16.840.1.113883.4.642.1.57": "astm-signature-type",
    "urn:oid:2.16.840.1.113883.4.642.2.381": "conformance-expectation",
    "urn:oid:2.16.840.1.113883.4.642.1.507": "days-of-week",
    "urn:oid:2.16.840.1.113883.4.642.2.302": "days-of-week",
    "urn:oid:2.16.840.1.113883.4.642.1.502": "operation-parameter-use",
    "urn:oid:2.16.840.1.113883.4.642.2.298": "operation-parameter-use",
    "urn:oid:2.16.840.1.113883.4.642.1.109": "resource-validation-mode",
    "urn:oid:2.16.840.1.113883.4.642.2.48": "resource-validation-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.111": "flag-status",
    "urn:oid:2.16.840.1.113883.4.642.2.49": "flag-status",
    "urn:oid:2.16.840.1.113883.4.642.1.122": "allergy-intolerance-type",
    "urn:oid:2.16.840.1.113883.4.642.2.52": "allergy-intolerance-type",
    "urn:oid:2.16.840.1.113883.4.642.1.124": "allergy-intolerance-category",
    "urn:oid:2.16.840.1.113883.4.642.2.53": "allergy-intolerance-category",
    "urn:oid:2.16.840.1.113883.4.642.1.120": "allergy-intolerance-criticality",
    "urn:oid:2.16.840.1.113883.4.642.2.51": "allergy-intolerance-criticality",
    "urn:oid:2.16.840.1.113883.4.642.1.126": "reaction-event-severity",
    "urn:oid:2.16.840.1.113883.4.642.2.56": "reaction-event-severity",
    "urn:oid:2.16.840.1.113883.4.642.1.145": "care-team-status",
    "urn:oid:2.16.840.1.113883.4.642.1.189": "capability-statement-kind",
    "urn:oid:2.16.840.1.113883.4.642.1.167": "restful-capability-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.181": "versioning-policy",
    "urn:oid:2.16.840.1.113883.4.642.2.89": "versioning-policy",
    "urn:oid:2.16.840.1.113883.4.642.1.191": "conditional-read-status",
    "urn:oid:2.16.840.1.113883.4.642.1.185": "conditional-delete-status",
    "urn:oid:2.16.840.1.113883.4.642.2.91": "conditional-delete-status",
    "urn:oid:2.16.840.1.113883.4.642.1.193": "reference-handling-policy",
    "urn:oid:2.16.840.1.113883.4.642.1.173": "event-capability-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.177": "document-mode",
    "urn:oid:2.16.840.1.113883.4.642.2.87": "document-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.197": "detectedissue-severity",
    "urn:oid:2.16.840.1.113883.4.642.2.105": "detectedissue-severity",
    "urn:oid:2.16.840.1.113883.4.642.1.202": "udi-entry-type",
    "urn:oid:2.16.840.1.113883.4.642.1.200": "device-status",
    "urn:oid:2.16.840.1.113883.4.642.1.215": "sequence-type",
    "urn:oid:2.16.840.1.113883.4.642.1.231": "diagnostic-report-status",
    "urn:oid:2.16.840.1.113883.4.642.2.118": "diagnostic-report-status",
    "urn:oid:2.16.840.1.113883.4.642.1.237": "composition-status",
    "urn:oid:2.16.840.1.113883.4.642.2.123": "composition-status",
    "urn:oid:2.16.840.1.113883.4.642.1.234": "composition-attestation-mode",
    "urn:oid:2.16.840.1.113883.4.642.2.120": "composition-attestation-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.240": "document-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.2.133": "document-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.1.242": "encounter-status",
    "urn:oid:2.16.840.1.113883.4.642.1.258": "encounter-location-status",
    "urn:oid:2.16.840.1.113883.4.642.2.147": "encounter-location-status",
    "urn:oid:2.16.840.1.113883.4.642.1.263": "history-status",
    "urn:oid:2.16.840.1.113883.4.642.2.409": "history-status",
    "urn:oid:2.16.840.1.113883.4.642.1.267": "goal-status",
    "urn:oid:2.16.840.1.113883.4.642.2.150": "goal-status",
    "urn:oid:2.16.840.1.113883.4.642.1.276": "graph-compartment-rule",
    "urn:oid:2.16.840.1.113883.4.642.1.278": "group-type",
    "urn:oid:2.16.840.1.113883.4.642.2.156": "group-type",
    "urn:oid:2.16.840.1.113883.4.642.1.306": "linkage-type",
    "urn:oid:2.16.840.1.113883.4.642.1.318": "list-status",
    "urn:oid:2.16.840.1.113883.4.642.2.178": "list-status",
    "urn:oid:2.16.840.1.113883.4.642.1.310": "list-mode",
    "urn:oid:2.16.840.1.113883.4.642.2.174": "list-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.312": "list-item-flag",
    "urn:oid:2.16.840.1.113883.4.642.2.175": "list-item-flag",
    "urn:oid:2.16.840.1.113883.4.642.1.324": "location-status",
    "urn:oid:2.16.840.1.113883.4.642.2.182": "location-status",
    "urn:oid:2.16.840.1.113883.4.642.1.322": "location-mode",
    "urn:oid:2.16.840.1.113883.4.642.2.181": "location-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.333": "reason-medication-not-given-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.187": "reason-medication-not-given-codes",
    "urn:oid:2.16.840.1.113883.4.642.1.368": "response-code",
    "urn:oid:2.16.840.1.113883.4.642.2.203": "response-code",
    "urn:oid:2.16.840.1.113883.4.642.1.388": "observation-status",
    "urn:oid:2.16.840.1.113883.4.642.2.219": "observation-status",
    "urn:oid:2.16.840.1.113883.4.642.1.395": "observation-statistics",
    "urn:oid:2.16.840.1.113883.4.642.1.398": "issue-severity",
    "urn:oid:2.16.840.1.113883.4.642.2.223": "issue-severity",
    "urn:oid:2.16.840.1.113883.4.642.1.400": "issue-type",
    "urn:oid:2.16.840.1.113883.4.642.2.224": "issue-type",
    "urn:oid:2.16.840.1.113883.4.642.1.413": "link-type",
    "urn:oid:2.16.840.1.113883.4.642.2.234": "link-type",
    "urn:oid:2.16.840.1.113883.4.642.1.417": "device-action",
    "urn:oid:2.16.840.1.113883.4.642.2.236": "device-action",
    "urn:oid:2.16.840.1.113883.4.642.1.428": "provenance-entity-role",
    "urn:oid:2.16.840.1.113883.4.642.2.247": "provenance-entity-role",
    "urn:oid:2.16.840.1.113883.4.642.1.438": "item-type",
    "urn:oid:2.16.840.1.113883.4.642.1.441": "questionnaire-answers-status",
    "urn:oid:2.16.840.1.113883.4.642.2.258": "questionnaire-answers-status",
    "urn:oid:2.16.840.1.113883.4.642.1.446": "audit-event-action",
    "urn:oid:2.16.840.1.113883.4.642.2.263": "audit-event-action",
    "urn:oid:2.16.840.1.113883.4.642.1.465": "specimen-status",
    "urn:oid:2.16.840.1.113883.4.642.2.426": "specimen-status",
    "urn:oid:2.16.840.1.113883.4.642.1.468": "substance-status",
    "urn:oid:2.16.840.1.113883.4.642.1.472": "filter-operator",
    "urn:oid:2.16.840.1.113883.4.642.2.280": "filter-operator",
    "urn:oid:2.16.840.1.113883.4.642.1.474": "conceptmap-unmapped-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.476": "slotstatus",
    "urn:oid:2.16.840.1.113883.4.642.2.283": "slotstatus",
    "urn:oid:2.16.840.1.113883.4.642.1.478": "appointmentstatus",
    "urn:oid:2.16.840.1.113883.4.642.2.284": "appointmentstatus",
    "urn:oid:2.16.840.1.113883.4.642.1.480": "participationstatus",
    "urn:oid:2.16.840.1.113883.4.642.2.285": "participationstatus",
    "urn:oid:2.16.840.1.113883.4.642.1.484": "namingsystem-type",
    "urn:oid:2.16.840.1.113883.4.642.2.290": "namingsystem-type",
    "urn:oid:2.16.840.1.113883.4.642.1.486": "namingsystem-identifier-type",
    "urn:oid:2.16.840.1.113883.4.642.2.293": "namingsystem-identifier-type",
    "urn:oid:2.16.840.1.113883.4.642.1.488": "endpoint-status",
    "urn:oid:2.16.840.1.113883.4.642.1.500": "operation-kind",
    "urn:oid:2.16.840.1.113883.4.642.2.297": "operation-kind",
    "urn:oid:2.16.840.1.113883.4.642.1.585": "fm-status",
    "urn:oid:2.16.840.1.113883.4.642.1.537": "claim-use",
    "urn:oid:2.16.840.1.113883.4.642.1.567": "icd-10-procedures",
    "urn:oid:2.16.840.1.113883.4.642.1.611": "explanationofbenefit-status",
    "urn:oid:2.16.840.1.113883.4.642.1.613": "bundle-type",
    "urn:oid:2.16.840.1.113883.4.642.2.327": "bundle-type",
    "urn:oid:2.16.840.1.113883.4.642.1.615": "search-entry-mode",
    "urn:oid:2.16.840.1.113883.4.642.2.328": "search-entry-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.617": "http-verb",
    "urn:oid:2.16.840.1.113883.4.642.2.329": "http-verb",
    "urn:oid:2.16.840.1.113883.4.642.1.623": "search-comparator",
    "urn:oid:2.16.840.1.113883.4.642.1.625": "search-modifier-code",
    "urn:oid:2.16.840.1.113883.4.642.2.92": "search-modifier-code",
    "urn:oid:2.16.840.1.113883.4.642.1.631": "metric-operational-status",
    "urn:oid:2.16.840.1.113883.4.642.2.337": "metric-operational-status",
    "urn:oid:2.16.840.1.113883.4.642.1.633": "metric-category",
    "urn:oid:2.16.840.1.113883.4.642.2.338": "metric-category",
    "urn:oid:2.16.840.1.113883.4.642.1.635": "metric-calibration-type",
    "urn:oid:2.16.840.1.113883.4.642.2.339": "metric-calibration-type",
    "urn:oid:2.16.840.1.113883.4.642.1.637": "metric-calibration-state",
    "urn:oid:2.16.840.1.113883.4.642.2.340": "metric-calibration-state",
    "urn:oid:2.16.840.1.113883.4.642.1.641": "identity-assuranceLevel",
    "urn:oid:2.16.840.1.113883.4.642.2.342": "identity-assuranceLevel",
    "urn:oid:2.16.840.1.113883.4.642.1.645": "vision-eye-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.344": "vision-eye-codes",
    "urn:oid:2.16.840.1.113883.4.642.1.647": "vision-base-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.345": "vision-base-codes",
    "urn:oid:2.16.840.1.113883.4.642.1.649": "episode-of-care-status",
    "urn:oid:2.16.840.1.113883.4.642.2.346": "episode-of-care-status",
    "urn:oid:2.16.840.1.113883.4.642.1.655": "structure-definition-kind",
    "urn:oid:2.16.840.1.113883.4.642.2.348": "structure-definition-kind",
    "urn:oid:2.16.840.1.113883.4.642.1.660": "type-derivation-rule",
    "urn:oid:2.16.840.1.113883.4.642.1.662": "map-model-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.674": "map-group-type-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.664": "map-input-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.670": "map-source-list-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.672": "map-target-list-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.668": "map-transform",
    "urn:oid:2.16.840.1.113883.4.642.1.682": "supplyrequest-status",
    "urn:oid:2.16.840.1.113883.4.642.2.354": "supplyrequest-status",
    "urn:oid:2.16.840.1.113883.4.642.1.687": "supplydelivery-status",
    "urn:oid:2.16.840.1.113883.4.642.2.355": "supplydelivery-status",
    "urn:oid:2.16.840.1.113883.4.642.1.705": "http-operations",
    "urn:oid:2.16.840.1.113883.4.642.1.695": "assert-direction-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.359": "assert-direction-codes",
    "urn:oid:2.16.840.1.113883.4.642.1.697": "assert-operator-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.360": "assert-operator-codes",
    "urn:oid:2.16.840.1.113883.4.642.1.699": "assert-response-code-types",
    "urn:oid:2.16.840.1.113883.4.642.2.361": "assert-response-code-types",
    "urn:oid:2.16.840.1.113883.4.642.1.713": "report-status-codes",
    "urn:oid:2.16.840.1.113883.4.642.1.707": "report-result-codes",
    "urn:oid:2.16.840.1.113883.4.642.1.711": "report-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.1.709": "report-action-result-codes",
    "urn:oid:2.16.840.1.113883.4.642.1.715": "account-status",
    "urn:oid:2.16.840.1.113883.4.642.2.362": "account-status",
    "urn:oid:2.16.840.1.113883.4.642.1.732": "contract-status",
    "urn:oid:2.16.840.1.113883.4.642.1.740": "consent-state-codes",
    "urn:oid:2.16.840.1.113883.4.642.1.744": "consent-data-meaning",
    "urn:oid:2.16.840.1.113883.4.642.1.760": "measure-report-status",
    "urn:oid:2.16.840.1.113883.4.642.1.762": "measure-report-type",
    "urn:oid:2.16.840.1.113883.4.642.1.768": "codesystem-hierarchy-meaning",
    "urn:oid:2.16.840.1.113883.4.642.1.766": "codesystem-content-mode",
    "urn:oid:2.16.840.1.113883.4.642.1.764": "concept-property-type",
    "urn:oid:2.16.840.1.113883.4.642.1.770": "compartment-type",
    "urn:oid:2.16.840.1.113883.4.642.1.774": "task-status",
    "urn:oid:2.16.840.1.113883.4.642.1.795": "action-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.1.799": "action-condition-kind",
    "urn:oid:2.16.840.1.113883.4.642.1.797": "action-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.1.783": "action-grouping-behavior",
    "urn:oid:2.16.840.1.113883.4.642.1.785": "action-selection-behavior",
    "urn:oid:2.16.840.1.113883.4.642.1.787": "action-required-behavior",
    "urn:oid:2.16.840.1.113883.4.642.1.789": "action-precheck-behavior",
    "urn:oid:2.16.840.1.113883.4.642.1.791": "action-cardinality-behavior",
    "urn:oid:2.16.840.1.113883.4.642.1.801": "guidance-response-status",
    "urn:oid:2.16.840.1.113883.4.642.1.803": "research-study-status",
    "urn:oid:2.16.840.1.113883.4.642.1.179": "message-significance-category",
    "urn:oid:2.16.840.1.113883.4.642.2.88": "message-significance-category",
    "urn:oid:2.16.840.1.113883.4.642.1.844": "messageheader-response-request",
    "urn:oid:2.16.840.1.113883.4.642.1.822": "chargeitem-status",
    "urn:oid:2.16.840.1.113883.4.642.3.190": "conditional-read-status",
    "urn:oid:2.16.840.1.113883.4.642.3.292": "immunization-status",
    "urn:oid:2.16.840.1.113883.4.642.3.196": "detectedissue-severity",
    "urn:oid:2.16.840.1.113883.4.642.3.248": "encounter-special-arrangements",
    "urn:oid:2.16.840.1.113883.4.642.2.141": "encounter-special-arrangements",
    "urn:oid:2.16.840.1.113883.4.642.3.254": "encounter-discharge-disposition",
    "urn:oid:2.16.840.1.113883.4.642.2.145": "encounter-discharge-disposition",
    "urn:oid:2.16.840.1.113883.4.642.3.473": "conceptmap-unmapped-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.323": "location-status",
    "urn:oid:2.16.840.1.113883.4.642.3.592": "payment-adjustment-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.536": "claim-use",
    "urn:oid:2.16.840.1.113883.4.642.3.250": "encounter-diet",
    "urn:oid:2.16.840.1.113883.4.642.2.142": "encounter-diet",
    "urn:oid:2.16.840.1.113883.4.642.3.256": "encounter-reason",
    "urn:oid:2.16.840.1.113883.4.642.2.146": "encounter-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.572": "claim-exception",
    "urn:oid:2.16.840.1.113883.4.642.2.307": "claim-exception",
    "urn:oid:2.16.840.1.113883.4.642.3.802": "research-study-status",
    "urn:oid:2.16.840.1.113883.4.642.3.510": "service-category",
    "urn:oid:2.16.840.1.113883.4.642.3.663": "map-input-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.586": "ex-revenue-center",
    "urn:oid:2.16.840.1.113883.4.642.3.144": "care-team-status",
    "urn:oid:2.16.840.1.113883.4.642.3.447": "audit-event-outcome",
    "urn:oid:2.16.840.1.113883.4.642.2.264": "audit-event-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.755": "measure-data-usage",
    "urn:oid:2.16.840.1.113883.4.642.3.673": "map-group-type-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.501": "operation-parameter-use",
    "urn:oid:2.16.840.1.113883.4.642.3.604": "benefit-term",
    "urn:oid:2.16.840.1.113883.4.642.3.257": "encounter-location-status",
    "urn:oid:2.16.840.1.113883.4.642.3.471": "filter-operator",
    "urn:oid:2.16.840.1.113883.4.642.3.455": "audit-event-type",
    "urn:oid:2.16.840.1.113883.4.642.2.269": "audit-event-type",
    "urn:oid:2.16.840.1.113883.4.642.3.784": "action-selection-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.544": "process-priority",
    "urn:oid:2.16.840.1.113883.4.642.2.319": "process-priority",
    "urn:oid:2.16.840.1.113883.4.642.3.495": "subscription-status",
    "urn:oid:2.16.840.1.113883.4.642.2.295": "subscription-status",
    "urn:oid:2.16.840.1.113883.4.642.3.159": "condition-severity",
    "urn:oid:2.16.840.1.113883.4.642.2.76": "condition-severity",
    "urn:oid:2.16.840.1.113883.4.642.3.375": "modified-foodtype",
    "urn:oid:2.16.840.1.113883.4.642.2.209": "modified-foodtype",
    "urn:oid:2.16.840.1.113883.4.642.3.761": "measure-report-type",
    "urn:oid:2.16.840.1.113883.4.642.3.578": "claim-careteamrole",
    "urn:oid:2.16.840.1.113883.4.642.3.747": "library-type",
    "urn:oid:2.16.840.1.113883.4.642.3.176": "document-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.560": "related-claim-relationship",
    "urn:oid:2.16.840.1.113883.4.642.3.384": "referencerange-meaning",
    "urn:oid:2.16.840.1.113883.4.642.2.217": "referencerange-meaning",
    "urn:oid:2.16.840.1.113883.4.642.3.550": "claim-type",
    "urn:oid:2.16.840.1.113883.4.642.2.131": "c80-facilitycodes",
    "urn:oid:2.16.840.1.113883.4.642.3.146": "care-team-category",
    "urn:oid:2.16.840.1.113883.4.642.3.872": "ucum-bodytemp",
    "urn:oid:2.16.840.1.113883.4.642.3.574": "claim-informationcategory",
    "urn:oid:2.16.840.1.113883.4.642.3.893": "device-safety",
    "urn:oid:2.16.840.1.113883.4.642.3.123": "allergy-intolerance-category",
    "urn:oid:2.16.840.1.113883.4.642.3.640": "identity-assuranceLevel",
    "urn:oid:2.16.840.1.113883.4.642.3.683": "supplyrequest-reason",
    "urn:oid:2.16.840.1.113883.4.642.2.464": "supplyrequest-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.646": "vision-base-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.166": "restful-capability-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.365": "message-reason-encounter",
    "urn:oid:2.16.840.1.113883.4.642.2.202": "message-reason-encounter",
    "urn:oid:2.16.840.1.113883.4.642.3.780": "plan-definition-type",
    "urn:oid:2.16.840.1.113883.4.642.2.414": "vaccine-code",
    "urn:oid:2.16.840.1.113883.4.642.3.532": "tooth",
    "urn:oid:2.16.840.1.113883.4.642.2.313": "tooth",
    "urn:oid:2.16.840.1.113883.4.642.3.108": "resource-validation-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.612": "bundle-type",
    "urn:oid:2.16.840.1.113883.4.642.3.712": "report-status-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.777": "definition-topic",
    "urn:oid:2.16.840.1.113883.4.642.3.733": "contract-content-derivative",
    "urn:oid:2.16.840.1.113883.4.642.3.427": "provenance-entity-role",
    "urn:oid:2.16.840.1.113883.4.642.3.277": "group-type",
    "urn:oid:2.16.840.1.113883.4.642.3.614": "search-entry-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.423": "procedure-reason",
    "urn:oid:2.16.840.1.113883.4.642.2.419": "procedure-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.508": "service-provision-conditions",
    "urn:oid:2.16.840.1.113883.4.642.2.303": "service-provision-conditions",
    "urn:oid:2.16.840.1.113883.4.642.3.792": "action-type",
    "urn:oid:2.16.840.1.113883.4.642.3.160": "manifestation-or-symptom",
    "urn:oid:2.16.840.1.113883.4.642.2.77": "manifestation-or-symptom",
    "urn:oid:2.16.840.1.113883.4.642.3.710": "report-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.3.275": "graph-compartment-rule",
    "urn:oid:2.16.840.1.113883.4.642.3.749": "measure-population",
    "urn:oid:2.16.840.1.113883.4.642.3.377": "supplement-type",
    "urn:oid:2.16.840.1.113883.4.642.2.211": "supplement-type",
    "urn:oid:2.16.840.1.113883.4.642.3.442": "relatedperson-relationshiptype",
    "urn:oid:2.16.840.1.113883.4.642.2.259": "relatedperson-relationshiptype",
    "urn:oid:2.16.840.1.113883.4.642.3.332": "reason-medication-not-given-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.418": "procedure-code",
    "urn:oid:2.16.840.1.113883.4.642.2.417": "procedure-code",
    "urn:oid:2.16.840.1.113883.4.642.3.735": "consent-category",
    "urn:oid:2.16.840.1.113883.4.642.3.396": "referencerange-appliesto",
    "urn:oid:2.16.840.1.113883.4.642.3.717": "contract-type",
    "urn:oid:2.16.840.1.113883.4.642.2.95": "contract-type",
    "urn:oid:2.16.840.1.113883.4.642.3.293": "immunization-origin",
    "urn:oid:2.16.840.1.113883.4.642.3.307": "list-example-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.173": "list-example-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.155": "condition-clinical",
    "urn:oid:2.16.840.1.113883.4.642.2.74": "condition-clinical",
    "urn:oid:2.16.840.1.113883.4.642.3.161": "condition-stage",
    "urn:oid:2.16.840.1.113883.4.642.2.408": "condition-stage",
    "urn:oid:2.16.840.1.113883.4.642.3.871": "ucum-bodyweight",
    "urn:oid:2.16.840.1.113883.4.642.3.412": "link-type",
    "urn:oid:2.16.840.1.113883.4.642.3.534": "service-uscls",
    "urn:oid:2.16.840.1.113883.4.642.2.314": "service-uscls",
    "urn:oid:2.16.840.1.113883.4.642.3.704": "http-operations",
    "urn:oid:2.16.840.1.113883.4.642.3.558": "claim-subtype",
    "urn:oid:2.16.840.1.113883.4.642.3.157": "condition-ver-status",
    "urn:oid:2.16.840.1.113883.4.642.2.75": "condition-ver-status",
    "urn:oid:2.16.840.1.113883.4.642.3.811": "adverse-event-seriousness",
    "urn:oid:2.16.840.1.113883.4.642.3.528": "claim-modifiers",
    "urn:oid:2.16.840.1.113883.4.642.2.311": "claim-modifiers",
    "urn:oid:2.16.840.1.113883.4.642.3.372": "diet-type",
    "urn:oid:2.16.840.1.113883.4.642.2.206": "diet-type",
    "urn:oid:2.16.840.1.113883.4.642.3.469": "substance-category",
    "urn:oid:2.16.840.1.113883.4.642.2.279": "substance-category",
    "urn:oid:2.16.840.1.113883.4.642.3.746": "consent-content-code",
    "urn:oid:2.16.840.1.113883.4.642.3.679": "supplyrequest-kind",
    "urn:oid:2.16.840.1.113883.4.642.2.353": "supplyrequest-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.725": "contract-signer-type",
    "urn:oid:2.16.840.1.113883.4.642.2.99": "contract-signer-type",
    "urn:oid:2.16.840.1.113883.4.642.3.363": "medication-status",
    "urn:oid:2.16.840.1.113883.4.642.3.721": "contract-term-type",
    "urn:oid:2.16.840.1.113883.4.642.2.97": "contract-term-type",
    "urn:oid:2.16.840.1.113883.4.642.3.686": "supplydelivery-status",
    "urn:oid:2.16.840.1.113883.4.642.3.716": "account-type",
    "urn:oid:2.16.840.1.113883.4.642.3.782": "action-grouping-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.416": "device-action",
    "urn:oid:2.16.840.1.113883.4.642.3.817": "adverse-event-causality-method",
    "urn:oid:2.16.840.1.113883.4.642.3.739": "consent-state-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.421": "procedure-category",
    "urn:oid:2.16.840.1.113883.4.642.2.241": "procedure-category",
    "urn:oid:2.16.840.1.113883.4.642.3.439": "questionnaire-answers",
    "urn:oid:2.16.840.1.113883.4.642.2.423": "questionnaire-answers",
    "urn:oid:2.16.840.1.113883.4.642.3.654": "structure-definition-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.729": "contract-actorrole",
    "urn:oid:2.16.840.1.113883.4.642.2.102": "contract-actorrole",
    "urn:oid:2.16.840.1.113883.4.642.3.387": "observation-status",
    "urn:oid:2.16.840.1.113883.4.642.3.700": "testscript-profile-origin-types",
    "urn:oid:2.16.840.1.113883.4.642.3.659": "type-derivation-rule",
    "urn:oid:2.16.840.1.113883.4.642.3.788": "action-precheck-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.737": "consent-action",
    "urn:oid:2.16.840.1.113883.4.642.3.422": "procedure-not-performed-reason",
    "urn:oid:2.16.840.1.113883.4.642.2.418": "procedure-not-performed-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.815": "adverse-event-causality-assess",
    "urn:oid:2.16.840.1.113883.4.642.3.170": "type-restful-interaction",
    "urn:oid:2.16.840.1.113883.4.642.2.83": "type-restful-interaction",
    "urn:oid:2.16.840.1.113883.4.642.3.285": "immunization-reason",
    "urn:oid:2.16.840.1.113883.4.642.2.163": "immunization-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.227": "clinical-findings",
    "urn:oid:2.16.840.1.113883.4.642.2.115": "clinical-findings",
    "urn:oid:2.16.840.1.113883.4.642.3.708": "report-action-result-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.284": "immunization-route",
    "urn:oid:2.16.840.1.113883.4.642.2.162": "immunization-route",
    "urn:oid:2.16.840.1.113883.4.642.3.632": "metric-category",
    "urn:oid:2.16.840.1.113883.4.642.3.624": "search-modifier-code",
    "urn:oid:2.16.840.1.113883.4.642.3.610": "explanationofbenefit-status",
    "urn:oid:2.16.840.1.113883.4.642.3.457": "audit-event-sub-type",
    "urn:oid:2.16.840.1.113883.4.642.2.270": "audit-event-sub-type",
    "urn:oid:2.16.840.1.113883.4.642.3.485": "namingsystem-identifier-type",
    "urn:oid:2.16.840.1.113883.4.642.3.479": "participationstatus",
    "urn:oid:2.16.840.1.113883.4.642.3.891": "languages",
    "urn:oid:2.16.840.1.113883.4.642.3.602": "benefit-unit",
    "urn:oid:2.16.840.1.113883.4.642.3.199": "device-status",
    "urn:oid:2.16.840.1.113883.4.642.3.172": "event-capability-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.397": "issue-severity",
    "urn:oid:2.16.840.1.113883.4.642.3.309": "list-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.359": "medication-form-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.198": "medication-form-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.112": "flag-category",
    "urn:oid:2.16.840.1.113883.4.642.2.403": "flag-category",
    "urn:oid:2.16.840.1.113883.4.642.3.690": "testscript-operation-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.357": "testscript-operation-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.642": "vision-product",
    "urn:oid:2.16.840.1.113883.4.642.2.343": "vision-product",
    "urn:oid:2.16.840.1.113883.4.642.3.562": "provider-qualification",
    "urn:oid:2.16.840.1.113883.4.642.3.247": "encounter-special-courtesy",
    "urn:oid:2.16.840.1.113883.4.642.2.140": "encounter-special-courtesy",
    "urn:oid:2.16.840.1.113883.4.642.3.305": "linkage-type",
    "urn:oid:2.16.840.1.113883.4.642.3.723": "contract-term-subtype",
    "urn:oid:2.16.840.1.113883.4.642.2.98": "contract-term-subtype",
    "urn:oid:2.16.840.1.113883.4.642.3.262": "history-status",
    "urn:oid:2.16.840.1.113883.4.642.3.821": "chargeitem-status",
    "urn:oid:2.16.840.1.113883.4.642.3.696": "assert-operator-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.373": "nutrient-code",
    "urn:oid:2.16.840.1.113883.4.642.2.207": "nutrient-code",
    "urn:oid:2.16.840.1.113883.4.642.3.590": "adjudication-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.270": "goal-category",
    "urn:oid:2.16.840.1.113883.4.642.2.411": "goal-category",
    "urn:oid:2.16.840.1.113883.4.642.3.626": "payment-type",
    "urn:oid:2.16.840.1.113883.4.642.2.333": "payment-type",
    "urn:oid:2.16.840.1.113883.4.642.3.371": "food-type",
    "urn:oid:2.16.840.1.113883.4.642.2.205": "food-type",
    "urn:oid:2.16.840.1.113883.4.642.3.298": "immunization-recommendation-date-criterion",
    "urn:oid:2.16.840.1.113883.4.642.2.169": "immunization-recommendation-date-criterion",
    "urn:oid:2.16.840.1.113883.4.642.3.229": "diagnostic-service-sections",
    "urn:oid:2.16.840.1.113883.4.642.2.117": "diagnostic-service-sections",
    "urn:oid:2.16.840.1.113883.4.642.3.727": "contract-action",
    "urn:oid:2.16.840.1.113883.4.642.2.100": "contract-action",
    "urn:oid:2.16.840.1.113883.4.642.3.487": "endpoint-status",
    "urn:oid:2.16.840.1.113883.4.642.3.568": "ex-program-code",
    "urn:oid:2.16.840.1.113883.4.642.3.419": "procedure-outcome",
    "urn:oid:2.16.840.1.113883.4.642.2.239": "procedure-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.702": "testscript-profile-destination-types",
    "urn:oid:2.16.840.1.113883.4.642.3.584": "fm-status",
    "urn:oid:2.16.840.1.113883.4.642.3.790": "action-cardinality-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.233": "composition-attestation-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.321": "location-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.162": "communication-category",
    "urn:oid:2.16.840.1.113883.4.642.3.445": "audit-event-action",
    "urn:oid:2.16.840.1.113883.4.642.3.681": "supplyrequest-status",
    "urn:oid:2.16.840.1.113883.4.642.3.317": "list-status",
    "urn:oid:2.16.840.1.113883.4.642.3.188": "capability-statement-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.538": "surface",
    "urn:oid:2.16.840.1.113883.4.642.2.316": "surface",
    "urn:oid:2.16.840.1.113883.4.642.3.757": "composite-measure-scoring",
    "urn:oid:2.16.840.1.113883.4.642.3.164": "communication-not-done-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.582": "ex-diagnosistype",
    "urn:oid:2.16.840.1.113883.4.642.3.121": "allergy-intolerance-type",
    "urn:oid:2.16.840.1.113883.4.642.3.334": "reason-medication-given-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.188": "reason-medication-given-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.453": "object-role",
    "urn:oid:2.16.840.1.113883.4.642.2.267": "object-role",
    "urn:oid:2.16.840.1.113883.4.642.3.753": "measure-type",
    "urn:oid:2.16.840.1.113883.4.642.2.134": "c80-practice-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.420": "procedure-followup",
    "urn:oid:2.16.840.1.113883.4.642.2.240": "procedure-followup",
    "urn:oid:2.16.840.1.113883.4.642.3.798": "action-condition-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.769": "compartment-type",
    "urn:oid:2.16.840.1.113883.4.642.3.466": "substance-code",
    "urn:oid:2.16.840.1.113883.4.642.2.57": "substance-code",
    "urn:oid:2.16.840.1.113883.4.642.3.201": "udi-entry-type",
    "urn:oid:2.16.840.1.113883.4.642.3.152": "condition-code",
    "urn:oid:2.16.840.1.113883.4.642.2.72": "condition-code",
    "urn:oid:2.16.840.1.113883.4.642.3.136": "care-plan-category",
    "urn:oid:2.16.840.1.113883.4.642.2.67": "care-plan-category",
    "urn:oid:2.16.840.1.113883.4.642.3.794": "action-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.3.477": "appointmentstatus",
    "urn:oid:2.16.840.1.113883.4.642.3.367": "response-code",
    "urn:oid:2.16.840.1.113883.4.642.3.650": "episodeofcare-type",
    "urn:oid:2.16.840.1.113883.4.642.3.296": "immunization-recommendation-status",
    "urn:oid:2.16.840.1.113883.4.642.2.168": "immunization-recommendation-status",
    "urn:oid:2.16.840.1.113883.4.642.3.434": "questionnaire-questions",
    "urn:oid:2.16.840.1.113883.4.642.2.255": "questionnaire-questions",
    "urn:oid:2.16.840.1.113883.4.642.3.616": "http-verb",
    "urn:oid:2.16.840.1.113883.4.642.3.767": "codesystem-hierarchy-meaning",
    "urn:oid:2.16.840.1.113883.4.642.3.232": "doc-section-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.119": "doc-section-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.731": "contract-status",
    "urn:oid:2.16.840.1.113883.4.642.3.168": "restful-security-service",
    "urn:oid:2.16.840.1.113883.4.642.2.82": "restful-security-service",
    "urn:oid:2.16.840.1.113883.4.642.3.870": "ucum-vitals-common",
    "urn:oid:2.16.840.1.113883.4.642.3.110": "flag-status",
    "urn:oid:2.16.840.1.113883.4.642.3.195": "detectedissue-mitigation-action",
    "urn:oid:2.16.840.1.113883.4.642.2.104": "detectedissue-mitigation-action",
    "urn:oid:2.16.840.1.113883.4.642.3.843": "messageheader-response-request",
    "urn:oid:2.16.840.1.113883.4.642.3.89": "medication-as-needed-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.392": "observation-category",
    "urn:oid:2.16.840.1.113883.4.642.2.222": "observation-category",
    "urn:oid:2.16.840.1.113883.4.642.3.506": "days-of-week",
    "urn:oid:2.16.840.1.113883.4.642.3.429": "provenance-activity-type",
    "urn:oid:2.16.840.1.113883.4.642.3.241": "encounter-status",
    "urn:oid:2.16.840.1.113883.4.642.3.228": "report-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.116": "report-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.719": "contract-subtype",
    "urn:oid:2.16.840.1.113883.4.642.2.96": "contract-subtype",
    "urn:oid:2.16.840.1.113883.4.642.3.379": "entformula-additive",
    "urn:oid:2.16.840.1.113883.4.642.2.213": "entformula-additive",
    "urn:oid:2.16.840.1.113883.4.642.3.685": "supply-item",
    "urn:oid:2.16.840.1.113883.4.642.3.823": "chargeitem-billingcodes",
    "urn:oid:2.16.840.1.113883.4.642.3.464": "specimen-status",
    "urn:oid:2.16.840.1.113883.4.642.3.376": "consistency-type",
    "urn:oid:2.16.840.1.113883.4.642.2.210": "consistency-type",
    "urn:oid:2.16.840.1.113883.4.642.3.622": "search-comparator",
    "urn:oid:2.16.840.1.113883.4.642.3.895": "devicemetric-type",
    "urn:oid:2.16.840.1.113883.4.642.3.630": "metric-operational-status",
    "urn:oid:2.16.840.1.113883.4.642.3.598": "benefit-type",
    "urn:oid:2.16.840.1.113883.4.642.3.694": "assert-direction-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.661": "map-model-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.259": "designation-use",
    "urn:oid:2.16.840.1.113883.4.642.2.281": "designation-use",
    "urn:oid:2.16.840.1.113883.4.642.3.491": "endpoint-connection-type",
    "urn:oid:2.16.840.1.113883.4.642.3.467": "substance-status",
    "urn:oid:2.16.840.1.113883.4.642.3.230": "diagnostic-report-status",
    "urn:oid:2.16.840.1.113883.4.642.3.443": "risk-probability",
    "urn:oid:2.16.840.1.113883.4.642.2.262": "risk-probability",
    "urn:oid:2.16.840.1.113883.4.642.3.245": "encounter-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.2.139": "encounter-participant-type",
    "urn:oid:2.16.840.1.113883.4.642.3.461": "specimen-collection-method",
    "urn:oid:2.16.840.1.113883.4.642.2.275": "specimen-collection-method",
    "urn:oid:2.16.840.1.113883.4.642.3.796": "action-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.3.580": "ex-diagnosisrelatedgroup",
    "urn:oid:2.16.840.1.113883.4.642.3.714": "account-status",
    "urn:oid:2.16.840.1.113883.4.642.3.628": "payment-status",
    "urn:oid:2.16.840.1.113883.4.642.2.334": "payment-status",
    "urn:oid:2.16.840.1.113883.4.642.3.266": "goal-status",
    "urn:oid:2.16.840.1.113883.4.642.3.243": "encounter-type",
    "urn:oid:2.16.840.1.113883.4.642.2.137": "encounter-type",
    "urn:oid:2.16.840.1.113883.4.642.3.313": "list-empty-reason",
    "urn:oid:2.16.840.1.113883.4.642.2.176": "list-empty-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.151": "clinicalimpression-prognosis",
    "urn:oid:2.16.840.1.113883.4.642.3.648": "episode-of-care-status",
    "urn:oid:2.16.840.1.113883.4.642.3.514": "coverage-type",
    "urn:oid:2.16.840.1.113883.4.642.3.667": "map-transform",
    "urn:oid:2.16.840.1.113883.4.642.3.180": "versioning-policy",
    "urn:oid:2.16.840.1.113883.4.642.3.483": "namingsystem-type",
    "urn:oid:2.16.840.1.113883.4.642.3.698": "assert-response-code-types",
    "urn:oid:2.16.840.1.113883.4.642.3.608": "ex-paymenttype",
    "urn:oid:2.16.840.1.113883.4.642.3.382": "observation-methods",
    "urn:oid:2.16.840.1.113883.4.642.2.215": "observation-methods",
    "urn:oid:2.16.840.1.113883.4.642.3.800": "guidance-response-status",
    "urn:oid:2.16.840.1.113883.4.642.3.745": "consent-content-class",
    "urn:oid:2.16.840.1.113883.4.642.3.653": "body-site",
    "urn:oid:2.16.840.1.113883.4.642.2.78": "body-site",
    "urn:oid:2.16.840.1.113883.4.642.3.809": "adverse-event-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.808": "adverse-event-type",
    "urn:oid:2.16.840.1.113883.4.642.3.252": "encounter-admit-source",
    "urn:oid:2.16.840.1.113883.4.642.2.144": "encounter-admit-source",
    "urn:oid:2.16.840.1.113883.4.642.3.399": "issue-type",
    "urn:oid:2.16.840.1.113883.4.642.3.556": "service-place",
    "urn:oid:2.16.840.1.113883.4.642.3.174": "message-transport",
    "urn:oid:2.16.840.1.113883.4.642.2.86": "message-transport",
    "urn:oid:2.16.840.1.113883.4.642.3.311": "list-item-flag",
    "urn:oid:2.16.840.1.113883.4.642.3.475": "slotstatus",
    "urn:oid:2.16.840.1.113883.4.642.3.171": "system-restful-interaction",
    "urn:oid:2.16.840.1.113883.4.642.2.84": "system-restful-interaction",
    "urn:oid:2.16.840.1.113883.4.642.3.463": "specimen-container-type",
    "urn:oid:2.16.840.1.113883.4.642.2.277": "specimen-container-type",
    "urn:oid:2.16.840.1.113883.4.642.3.330": "medication-admin-status",
    "urn:oid:2.16.840.1.113883.4.642.2.186": "medication-admin-status",
    "urn:oid:2.16.840.1.113883.4.642.3.669": "map-source-list-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.114": "flag-code",
    "urn:oid:2.16.840.1.113883.4.642.2.404": "flag-code",
    "urn:oid:2.16.840.1.113883.4.642.3.600": "benefit-network",
    "urn:oid:2.16.840.1.113883.4.642.3.381": "enteral-route",
    "urn:oid:2.16.840.1.113883.4.642.2.214": "enteral-route",
    "urn:oid:2.16.840.1.113883.4.642.3.236": "composition-status",
    "urn:oid:2.16.840.1.113883.4.642.3.437": "item-type",
    "urn:oid:2.16.840.1.113883.4.642.3.786": "action-required-behavior",
    "urn:oid:2.16.840.1.113883.4.642.3.634": "metric-calibration-type",
    "urn:oid:2.16.840.1.113883.4.642.3.283": "immunization-site",
    "urn:oid:2.16.840.1.113883.4.642.2.161": "immunization-site",
    "urn:oid:2.16.840.1.113883.4.642.3.386": "observation-interpretation",
    "urn:oid:2.16.840.1.113883.4.642.2.218": "observation-interpretation",
    "urn:oid:2.16.840.1.113883.4.642.3.424": "performer-role",
    "urn:oid:2.16.840.1.113883.4.642.2.420": "performer-role",
    "urn:oid:2.16.840.1.113883.4.642.3.773": "task-status",
    "urn:oid:2.16.840.1.113883.4.642.3.374": "texture-code",
    "urn:oid:2.16.840.1.113883.4.642.2.208": "texture-code",
    "urn:oid:2.16.840.1.113883.4.642.3.214": "sequence-type",
    "urn:oid:2.16.840.1.113883.4.642.3.184": "conditional-delete-status",
    "urn:oid:2.16.840.1.113883.4.642.3.239": "document-relationship-type",
    "urn:oid:2.16.840.1.113883.4.642.3.493": "subscription-channel-type",
    "urn:oid:2.16.840.1.113883.4.642.2.294": "subscription-channel-type",
    "urn:oid:2.16.840.1.113883.4.642.3.360": "medication-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.199": "medication-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.763": "concept-property-type",
    "urn:oid:2.16.840.1.113883.4.642.3.119": "allergy-intolerance-criticality",
    "urn:oid:2.16.840.1.113883.4.642.3.403": "organization-type",
    "urn:oid:2.16.840.1.113883.4.642.2.228": "organization-type",
    "urn:oid:2.16.840.1.113883.4.642.3.192": "reference-handling-policy",
    "urn:oid:2.16.840.1.113883.4.642.3.499": "operation-kind",
    "urn:oid:2.16.840.1.113883.4.642.3.383": "observation-codes",
    "urn:oid:2.16.840.1.113883.4.642.2.216": "observation-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.90": "administration-method-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.526": "missing-tooth-reason",
    "urn:oid:2.16.840.1.113883.4.642.2.310": "missing-tooth-reason",
    "urn:oid:2.16.840.1.113883.4.642.3.765": "codesystem-content-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.235": "doc-typecodes",
    "urn:oid:2.16.840.1.113883.4.642.2.121": "doc-typecodes",
    "urn:oid:2.16.840.1.113883.4.642.3.636": "metric-calibration-state",
    "urn:oid:2.16.840.1.113883.4.642.3.178": "message-significance-category",
    "urn:oid:2.16.840.1.113883.4.642.3.430": "practitioner-role",
    "urn:oid:2.16.840.1.113883.4.642.2.251": "practitioner-role",
    "urn:oid:2.16.840.1.113883.4.642.3.315": "list-order",
    "urn:oid:2.16.840.1.113883.4.642.2.177": "list-order",
    "urn:oid:2.16.840.1.113883.4.642.3.566": "icd-10-procedures",
    "urn:oid:2.16.840.1.113883.4.642.3.128": "basic-resource-type",
    "urn:oid:2.16.840.1.113883.4.642.2.59": "basic-resource-type",
    "urn:oid:2.16.840.1.113883.4.642.3.125": "reaction-event-severity",
    "urn:oid:2.16.840.1.113883.4.642.3.743": "consent-data-meaning",
    "urn:oid:2.16.840.1.113883.4.642.3.644": "vision-eye-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.274": "goal-start-event",
    "urn:oid:2.16.840.1.113883.4.642.2.413": "goal-start-event",
    "urn:oid:2.16.840.1.113883.4.642.3.806": "adverse-event-category",
    "urn:oid:2.16.840.1.113883.4.642.3.504": "service-referral-method",
    "urn:oid:2.16.840.1.113883.4.642.2.301": "service-referral-method",
    "urn:oid:2.16.840.1.113883.4.642.3.523": "icd-10",
    "urn:oid:2.16.840.1.113883.4.642.2.308": "icd-10",
    "urn:oid:2.16.840.1.113883.4.642.3.153": "condition-category",
    "urn:oid:2.16.840.1.113883.4.642.2.73": "condition-category",
    "urn:oid:2.16.840.1.113883.4.642.3.46": "security-labels",
    "urn:oid:2.16.840.1.113883.4.642.2.31": "security-labels",
    "urn:oid:2.16.840.1.113883.4.642.3.489": "endpoint-payload-type",
    "urn:oid:2.16.840.1.113883.4.642.3.141": "care-plan-intent",
    "urn:oid:2.16.840.1.113883.4.642.3.394": "observation-statistics",
    "urn:oid:2.16.840.1.113883.4.642.3.143": "participant-role",
    "urn:oid:2.16.840.1.113883.4.642.2.61": "participant-role",
    "urn:oid:2.16.840.1.113883.4.642.3.127": "allergyintolerance-code",
    "urn:oid:2.16.840.1.113883.4.642.3.759": "measure-report-status",
    "urn:oid:2.16.840.1.113883.4.642.3.378": "entformula-type",
    "urn:oid:2.16.840.1.113883.4.642.2.212": "entformula-type",
    "urn:oid:2.16.840.1.113883.4.642.3.588": "adjudication",
    "urn:oid:2.16.840.1.113883.4.642.2.325": "adjudication",
    "urn:oid:2.16.840.1.113883.4.642.3.873": "ucum-bodylength",
    "urn:oid:2.16.840.1.113883.4.642.3.268": "goal-priority",
    "urn:oid:2.16.840.1.113883.4.642.2.151": "goal-priority",
    "urn:oid:2.16.840.1.113883.4.642.3.512": "service-type",
    "urn:oid:2.16.840.1.113883.4.642.3.671": "map-target-list-mode",
    "urn:oid:2.16.840.1.113883.4.642.3.194": "detectedissue-category",
    "urn:oid:2.16.840.1.113883.4.642.2.103": "detectedissue-category",
    "urn:oid:2.16.840.1.113883.4.642.3.706": "report-result-codes",
    "urn:oid:2.16.840.1.113883.4.642.3.881": "condition-outcome",
    "urn:oid:2.16.840.1.113883.4.642.2.149": "condition-outcome",
    "urn:oid:2.16.840.1.113883.4.642.3.838": "conformance-expectation",
    "urn:oid:2.16.840.1.113883.4.642.3.3326": "color-codes"
}

# manually looked up
fhir_value_sets["urn:oid:2.16.840.1.113883.4.642.19.4"] = 'administer-zika-virus-exposure-assessment'
# https://cts.nlm.nih.gov/fhir/res/ValueSet/2.16.840.1.113883.11.20.9.46?_format=json


@oid_cache.cache
def get_oid(oid: str) -> (str, str):
    """Lookup a human-readable name for urn:oid strings"""
    oid = oid.strip()

    if f"urn:oid:{oid}" in fhir_value_sets:
        return fhir_value_sets[f"urn:oid:{oid}"], None
    if f"urn:oid:{oid}" in fhir_value_sets_old:
        return fhir_value_sets_old[f"urn:oid:{oid}"], None

    name = None
    content = None

    try:
        assert all([_.isnumeric() for _ in oid.split('.')]), f"unexpected oid format, {oid}"
        url = f'http://oid-info.com/get/{oid}'
        html_text = requests.get(url).text
        soup = BeautifulSoup(html_text, 'html.parser')

        contents = [_['content'] for _ in soup.find_all('meta') if _.attrs.get('name', None) == 'description']

        assert len(contents) > 0
        content = contents[0]
        # e.g. 'OID repository - 2.16.840.1.113883.2.4.6.3 = {joint-iso-itu-t(2) country(16) us(840) organization(1) hl7(113883) affiliate(2) hl7-netherlands(4) 6 bsn(3)}'  # noqa
        if 'Sorry' in content:
            return None, content
        assert '=' in content, content
        asn_string: str = content.split(' = ')[1]
        asn_string = asn_string.strip()
        assert len(asn_string) > 1 and asn_string.startswith('{') and asn_string.endswith('}')
        asn_string = asn_string.removeprefix('{').removesuffix('}')
        # e.g. 'joint-iso-itu-t(2) country(16) us(840) organization(1) hl7(113883) affiliate(2) hl7-netherlands(4) 6 bsn(3)'

        tags = [_.split('(')[0] for _ in asn_string.split() if '(' in _]
        number_of_tags = 2
        if len(tags) < 8:
            number_of_tags = 1

        name = '_'.join(tags[-number_of_tags:]).replace('-', '_')
        # e.g. 'hl7_netherlands_bsn'
    except Exception as e:
        logging.getLogger(__name__).debug(str(e))
    return name, content
