# Copyright (c) Saga Inc.
# Distributed under the terms of the GNU Affero General Public License v3.0 License.

from typing import Dict, TypedDict, List


class DatabaseConfig(TypedDict, total=False):
    drivers: List[str]
    tables_query: str
    columns_query: str


SUPPORTED_DATABASES: Dict[str, DatabaseConfig] = {
    "mssql": {
        "drivers": ["pyodbc"],
        "tables_query": "SELECT table_name FROM information_schema.tables WHERE table_schema = 'dbo'",
        "columns_query": "SELECT column_name, data_type FROM information_schema.columns WHERE table_name = :table",
    },
    "mysql": {
        "drivers": ["PyMySQL"],
        "tables_query": "SHOW TABLES",
        "columns_query": "SHOW COLUMNS FROM {table}",
    },
    "oracle": {
        "drivers": ["oracledb"],
        "tables_query": "SELECT table_name FROM user_tables",
        "columns_query": "SELECT column_name, data_type FROM user_tab_columns WHERE table_name = :table",
    },
    "postgres": {
        "drivers": ["psycopg2-binary"],
        "tables_query": "SELECT table_name FROM information_schema.tables WHERE table_schema = :schema",
        "columns_query": "SELECT column_name, data_type FROM information_schema.columns WHERE table_name = :table",
    },
    "snowflake": {
        "drivers": ["snowflake-sqlalchemy"],
        # Queries handled in the snowflake.py file.
    },
    "sqlite": {
        "drivers": [],
        "tables_query": "SELECT name FROM sqlite_master WHERE type='table'",
        "columns_query": "SELECT name, type FROM pragma_table_info(:table)",
    },
}
