(self["webpackChunkmito_ai"] = self["webpackChunkmito_ai"] || []).push([["vendors-node_modules_aws-amplify_ui-react_dist_esm_index_mjs"],{

/***/ "./node_modules/@aws-amplify/auth/dist/esm/Errors.mjs":
/*!************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/Errors.mjs ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthError: () => (/* binding */ AuthError),
/* harmony export */   NoUserPoolError: () => (/* binding */ NoUserPoolError),
/* harmony export */   authErrorMessages: () => (/* binding */ authErrorMessages)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/Logger/ConsoleLogger.mjs");
/* harmony import */ var _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./common/AuthErrorStrings.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/common/AuthErrorStrings.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
// TODO: delete this module when the Auth class is removed.
const logger = new _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.ConsoleLogger('AuthError');
class AuthError extends Error {
    constructor(type) {
        const { message, log } = authErrorMessages[type];
        super(message);
        // Hack for making the custom error class work when transpiled to es5
        // TODO: Delete the following 2 lines after we change the build target to >= es2015
        this.constructor = AuthError;
        Object.setPrototypeOf(this, AuthError.prototype);
        this.name = 'AuthError';
        this.log = log || message;
        logger.error(this.log);
    }
}
class NoUserPoolError extends AuthError {
    constructor(type) {
        super(type);
        // Hack for making the custom error class work when transpiled to es5
        // TODO: Delete the following 2 lines after we change the build target to >= es2015
        this.constructor = NoUserPoolError;
        Object.setPrototypeOf(this, NoUserPoolError.prototype);
        this.name = 'NoUserPoolError';
    }
}
const authErrorMessages = {
    oauthSignInError: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.OAUTH_ERROR,
        log: 'Make sure Cognito Hosted UI has been configured correctly',
    },
    noConfig: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.DEFAULT_MSG,
        log: `
            Error: Amplify has not been configured correctly.
            This error is typically caused by one of the following scenarios:

            1. Make sure you're passing the awsconfig object to Amplify.configure() in your app's entry point
                See https://aws-amplify.github.io/docs/js/authentication#configure-your-app for more information
            
            2. There might be multiple conflicting versions of amplify packages in your node_modules.
				Refer to our docs site for help upgrading Amplify packages (https://docs.amplify.aws/lib/troubleshooting/upgrading/q/platform/js)
        `,
    },
    missingAuthConfig: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.DEFAULT_MSG,
        log: `
            Error: Amplify has not been configured correctly. 
            The configuration object is missing required auth properties.
            This error is typically caused by one of the following scenarios:

            1. Did you run \`amplify push\` after adding auth via \`amplify add auth\`?
                See https://aws-amplify.github.io/docs/js/authentication#amplify-project-setup for more information

            2. This could also be caused by multiple conflicting versions of amplify packages, see (https://docs.amplify.aws/lib/troubleshooting/upgrading/q/platform/js) for help upgrading Amplify packages.
        `,
    },
    emptyUsername: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.EMPTY_USERNAME,
    },
    // TODO: should include a list of valid sign-in types
    invalidUsername: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.INVALID_USERNAME,
    },
    emptyPassword: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.EMPTY_PASSWORD,
    },
    emptyCode: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.EMPTY_CODE,
    },
    signUpError: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.SIGN_UP_ERROR,
        log: 'The first parameter should either be non-null string or object',
    },
    noMFA: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.NO_MFA,
    },
    invalidMFA: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.INVALID_MFA,
    },
    emptyChallengeResponse: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.EMPTY_CHALLENGE,
    },
    noUserSession: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.NO_USER_SESSION,
    },
    deviceConfig: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.DEVICE_CONFIG,
    },
    networkError: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.NETWORK_ERROR,
    },
    autoSignInError: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.AUTOSIGNIN_ERROR,
    },
    default: {
        message: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorStrings.DEFAULT_MSG,
    },
};


//# sourceMappingURL=Errors.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/shared/handlePasswordSRP.mjs":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/flows/shared/handlePasswordSRP.mjs ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handlePasswordSRP: () => (/* binding */ handlePasswordSRP)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _providers_cognito_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../providers/cognito/utils/userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _providers_cognito_utils_srp_getAuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../providers/cognito/utils/srp/getAuthenticationHelper.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getAuthenticationHelper.mjs");
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createInitiateAuthClient_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createInitiateAuthClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createInitiateAuthClient.mjs");
/* harmony import */ var _providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _providers_cognito_utils_handlePasswordVerifierChallenge_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../providers/cognito/utils/handlePasswordVerifierChallenge.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/handlePasswordVerifierChallenge.mjs");
/* harmony import */ var _providers_cognito_utils_retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../providers/cognito/utils/retryOnResourceNotFoundException.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/retryOnResourceNotFoundException.mjs");
/* harmony import */ var _providers_cognito_utils_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../providers/cognito/utils/setActiveSignInUsername.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/setActiveSignInUsername.mjs");





















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Handles the Password SRP (Secure Remote Password) authentication flow.
 * This function can be used with both USER_SRP_AUTH and USER_AUTH flows.
 *
 * @param {Object} params - The parameters for the Password SRP authentication
 * @param {string} params.username - The username for authentication
 * @param {string} params.password - The user's password
 * @param {ClientMetadata} [params.clientMetadata] - Optional metadata to be sent with auth requests
 * @param {CognitoUserPoolConfig} params.config - Cognito User Pool configuration
 * @param {AuthTokenOrchestrator} params.tokenOrchestrator - Token orchestrator for managing auth tokens
 * @param {AuthFlowType} params.authFlow - The type of authentication flow ('USER_SRP_AUTH' or 'USER_AUTH')
 * @param {AuthFactorType} [params.preferredChallenge] - Optional preferred challenge type when using USER_AUTH flow
 *
 * @returns {Promise<RespondToAuthChallengeCommandOutput>} The authentication response
 */
async function handlePasswordSRP({ username, password, clientMetadata, config, tokenOrchestrator, authFlow, preferredChallenge, }) {
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    const userPoolName = userPoolId?.split('_')[1] || '';
    const authenticationHelper = await (0,_providers_cognito_utils_srp_getAuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_1__.getAuthenticationHelper)(userPoolName);
    const authParameters = {
        USERNAME: username,
        SRP_A: authenticationHelper.A.toString(16),
    };
    if (authFlow === 'USER_AUTH' && preferredChallenge) {
        authParameters.PREFERRED_CHALLENGE = preferredChallenge;
    }
    const UserContextData = (0,_providers_cognito_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_2__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const jsonReq = {
        AuthFlow: authFlow,
        AuthParameters: authParameters,
        ClientMetadata: clientMetadata,
        ClientId: userPoolClientId,
        UserContextData,
    };
    const initiateAuth = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createInitiateAuthClient_mjs__WEBPACK_IMPORTED_MODULE_3__.createInitiateAuthClient)({
        endpointResolver: (0,_providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_4__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const resp = await initiateAuth({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_5__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_6__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_7__.AuthAction.SignIn),
    }, jsonReq);
    const { ChallengeParameters: challengeParameters, Session: session } = resp;
    const activeUsername = challengeParameters?.USERNAME ?? username;
    (0,_providers_cognito_utils_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_8__.setActiveSignInUsername)(activeUsername);
    if (resp.ChallengeName === 'PASSWORD_VERIFIER') {
        return (0,_providers_cognito_utils_retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_9__.retryOnResourceNotFoundException)(_providers_cognito_utils_handlePasswordVerifierChallenge_mjs__WEBPACK_IMPORTED_MODULE_10__.handlePasswordVerifierChallenge, [
            password,
            challengeParameters,
            clientMetadata,
            session,
            authenticationHelper,
            config,
            tokenOrchestrator,
        ], activeUsername, tokenOrchestrator);
    }
    return resp;
}


//# sourceMappingURL=handlePasswordSRP.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleSelectChallenge.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleSelectChallenge.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   initiateSelectedChallenge: () => (/* binding */ initiateSelectedChallenge)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs");
/* harmony import */ var _providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");














// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Handles the SELECT_CHALLENGE response for authentication.
 * Initiates the selected authentication challenge based on user choice.
 *
 * @param {Object} params - The parameters for handling the selected challenge
 * @param {string} params.username - The username for authentication
 * @param {string} params.session - The current authentication session token
 * @param {string} params.selectedChallenge - The challenge type selected by the user
 * @param {CognitoUserPoolConfig} params.config - Cognito User Pool configuration
 * @param {ClientMetadata} [params.clientMetadata] - Optional metadata to be sent with auth requests
 *
 * @returns {Promise<RespondToAuthChallengeCommandOutput>} The challenge response
 */
async function initiateSelectedChallenge({ username, session, selectedChallenge, config, clientMetadata, }) {
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_0__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_1__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: config.userPoolEndpoint,
        }),
    });
    return respondToAuthChallenge({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_2__.getRegionFromUserPoolId)(config.userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_3__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_4__.AuthAction.ConfirmSignIn),
    }, {
        ChallengeName: 'SELECT_CHALLENGE',
        ChallengeResponses: {
            USERNAME: username,
            ANSWER: selectedChallenge,
        },
        ClientId: config.userPoolClientId,
        Session: session,
        ClientMetadata: clientMetadata,
    });
}


//# sourceMappingURL=handleSelectChallenge.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleSelectChallengeWithPassword.mjs":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleSelectChallengeWithPassword.mjs ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleSelectChallengeWithPassword: () => (/* binding */ handleSelectChallengeWithPassword)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs");
/* harmony import */ var _providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _providers_cognito_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../providers/cognito/utils/userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _providers_cognito_utils_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../providers/cognito/utils/setActiveSignInUsername.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/setActiveSignInUsername.mjs");
















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Handles the SELECT_CHALLENGE response specifically for Password authentication.
 * This function combines the SELECT_CHALLENGE flow with standard password authentication.
 *
 * @param {string} username - The username for authentication
 * @param {string} password - The user's password
 * @param {ClientMetadata} [clientMetadata] - Optional metadata to be sent with auth requests
 * @param {CognitoUserPoolConfig} config - Cognito User Pool configuration
 * @param {string} session - The current authentication session token
 *
 * @returns {Promise<RespondToAuthChallengeCommandOutput>} The challenge response
 */
async function handleSelectChallengeWithPassword(username, password, clientMetadata, config, session) {
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    const authParameters = {
        ANSWER: 'PASSWORD',
        USERNAME: username,
        PASSWORD: password,
    };
    const userContextData = (0,_providers_cognito_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_0__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_1__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_2__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const response = await respondToAuthChallenge({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_3__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_4__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_5__.AuthAction.ConfirmSignIn),
    }, {
        ChallengeName: 'SELECT_CHALLENGE',
        ChallengeResponses: authParameters,
        ClientId: userPoolClientId,
        ClientMetadata: clientMetadata,
        Session: session,
        UserContextData: userContextData,
    });
    const activeUsername = response.ChallengeParameters?.USERNAME ?? username;
    (0,_providers_cognito_utils_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_6__.setActiveSignInUsername)(activeUsername);
    return response;
}


//# sourceMappingURL=handleSelectChallengeWithPassword.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleSelectChallengeWithPasswordSRP.mjs":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleSelectChallengeWithPasswordSRP.mjs ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleSelectChallengeWithPasswordSRP: () => (/* binding */ handleSelectChallengeWithPasswordSRP)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs");
/* harmony import */ var _providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _providers_cognito_utils_srp_getAuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../providers/cognito/utils/srp/getAuthenticationHelper.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getAuthenticationHelper.mjs");
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _providers_cognito_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../providers/cognito/utils/userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _providers_cognito_utils_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../providers/cognito/utils/setActiveSignInUsername.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/setActiveSignInUsername.mjs");
/* harmony import */ var _providers_cognito_utils_retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../providers/cognito/utils/retryOnResourceNotFoundException.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/retryOnResourceNotFoundException.mjs");
/* harmony import */ var _providers_cognito_utils_handlePasswordVerifierChallenge_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../providers/cognito/utils/handlePasswordVerifierChallenge.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/handlePasswordVerifierChallenge.mjs");





















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Handles the SELECT_CHALLENGE response specifically for Password SRP authentication.
 * This function combines the SELECT_CHALLENGE flow with Password SRP protocol.
 *
 * @param {string} username - The username for authentication
 * @param {string} password - The user's password
 * @param {ClientMetadata} [clientMetadata] - Optional metadata to be sent with auth requests
 * @param {CognitoUserPoolConfig} config - Cognito User Pool configuration
 * @param {string} session - The current authentication session token
 * @param {AuthTokenOrchestrator} tokenOrchestrator - Token orchestrator for managing auth tokens
 *
 * @returns {Promise<RespondToAuthChallengeCommandOutput>} The challenge response
 */
async function handleSelectChallengeWithPasswordSRP(username, password, clientMetadata, config, session, tokenOrchestrator) {
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    const userPoolName = userPoolId.split('_')[1] || '';
    const authenticationHelper = await (0,_providers_cognito_utils_srp_getAuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_1__.getAuthenticationHelper)(userPoolName);
    const authParameters = {
        ANSWER: 'PASSWORD_SRP',
        USERNAME: username,
        SRP_A: authenticationHelper.A.toString(16),
    };
    const userContextData = (0,_providers_cognito_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_2__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_3__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_4__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const response = await respondToAuthChallenge({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_5__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_6__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_7__.AuthAction.ConfirmSignIn),
    }, {
        ChallengeName: 'SELECT_CHALLENGE',
        ChallengeResponses: authParameters,
        ClientId: userPoolClientId,
        ClientMetadata: clientMetadata,
        Session: session,
        UserContextData: userContextData,
    });
    const activeUsername = response.ChallengeParameters?.USERNAME ?? username;
    (0,_providers_cognito_utils_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_8__.setActiveSignInUsername)(activeUsername);
    if (response.ChallengeName === 'PASSWORD_VERIFIER') {
        return (0,_providers_cognito_utils_retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_9__.retryOnResourceNotFoundException)(_providers_cognito_utils_handlePasswordVerifierChallenge_mjs__WEBPACK_IMPORTED_MODULE_10__.handlePasswordVerifierChallenge, [
            password,
            response.ChallengeParameters,
            clientMetadata,
            response.Session,
            authenticationHelper,
            config,
            tokenOrchestrator,
        ], activeUsername, tokenOrchestrator);
    }
    return response;
}


//# sourceMappingURL=handleSelectChallengeWithPasswordSRP.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleUserAuthFlow.mjs":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleUserAuthFlow.mjs ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleUserAuthFlow: () => (/* binding */ handleUserAuthFlow)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _providers_cognito_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../providers/cognito/utils/userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createInitiateAuthClient_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createInitiateAuthClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createInitiateAuthClient.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _shared_handlePasswordSRP_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../shared/handlePasswordSRP.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/shared/handlePasswordSRP.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _providers_cognito_utils_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../providers/cognito/utils/setActiveSignInUsername.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/setActiveSignInUsername.mjs");


















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Handles user authentication flow with configurable challenge preferences.
 * Supports AuthFactorType challenges through the USER_AUTH flow.
 *
 * @param {HandleUserAuthFlowInput} params - Authentication flow parameters
 * @param {string} params.username - The username for authentication
 * @param {Record<string, string>} [params.clientMetadata] - Optional metadata to pass to authentication service
 * @param {CognitoUserPoolConfig} params.config - Cognito User Pool configuration
 * @param {AuthTokenOrchestrator} params.tokenOrchestrator - Manages authentication tokens and device tracking
 * @param {AuthFactorType} [params.preferredChallenge] - Optional preferred authentication method
 * @param {string} [params.password] - Required when preferredChallenge is 'PASSWORD' or 'PASSWORD_SRP'
 *
 * @returns {Promise<InitiateAuthCommandOutput>} The authentication response from Cognito
 */
async function handleUserAuthFlow({ username, clientMetadata, config, tokenOrchestrator, preferredChallenge, password, session, }) {
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    const UserContextData = (0,_providers_cognito_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_0__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const authParameters = { USERNAME: username };
    if (preferredChallenge) {
        if (preferredChallenge === 'PASSWORD_SRP') {
            (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_1__.assertValidationError)(!!password, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_2__.AuthValidationErrorCode.EmptySignInPassword);
            return (0,_shared_handlePasswordSRP_mjs__WEBPACK_IMPORTED_MODULE_3__.handlePasswordSRP)({
                username,
                password,
                clientMetadata,
                config,
                tokenOrchestrator,
                authFlow: 'USER_AUTH',
                preferredChallenge,
            });
        }
        if (preferredChallenge === 'PASSWORD') {
            (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_1__.assertValidationError)(!!password, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_2__.AuthValidationErrorCode.EmptySignInPassword);
            authParameters.PASSWORD = password;
        }
        authParameters.PREFERRED_CHALLENGE = preferredChallenge;
    }
    const jsonReq = {
        AuthFlow: 'USER_AUTH',
        AuthParameters: authParameters,
        ClientMetadata: clientMetadata,
        ClientId: userPoolClientId,
        UserContextData,
    };
    if (session) {
        jsonReq.Session = session;
    }
    const initiateAuth = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createInitiateAuthClient_mjs__WEBPACK_IMPORTED_MODULE_4__.createInitiateAuthClient)({
        endpointResolver: (0,_providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_5__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const response = await initiateAuth({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_6__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_7__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_8__.AuthAction.SignIn),
    }, jsonReq);
    // Set the active username immediately after successful authentication attempt
    // If a user starts a new sign-in while another sign-in is incomplete,
    // this ensures we're tracking the correct user for subsequent auth challenges.
    (0,_providers_cognito_utils_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_9__.setActiveSignInUsername)(username);
    return response;
}


//# sourceMappingURL=handleUserAuthFlow.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleWebAuthnSignInResult.mjs":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleWebAuthnSignInResult.mjs ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleWebAuthnSignInResult: () => (/* binding */ handleWebAuthnSignInResult)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/AuthErrorStrings.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/common/AuthErrorStrings.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _providers_cognito_tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../providers/cognito/tokenProvider/cacheTokens.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/cacheTokens.mjs");
/* harmony import */ var _providers_cognito_utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../providers/cognito/utils/dispatchSignedInHubEvent.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/dispatchSignedInHubEvent.mjs");
/* harmony import */ var _utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/store/signInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _utils_passkey_errors_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/passkey/errors.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/errors.mjs");
/* harmony import */ var _utils_passkey_getPasskey_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/passkey/getPasskey.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/getPasskey.mjs");
/* harmony import */ var _providers_cognito_utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../providers/cognito/utils/getNewDeviceMetadata.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/getNewDeviceMetadata.mjs");






















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
async function handleWebAuthnSignInResult(challengeParameters) {
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const { username, signInSession, signInDetails, challengeName } = _utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_2__.signInStore.getState();
    if (challengeName !== 'WEB_AUTHN' || !username) {
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthError({
            name: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_4__.AuthErrorCodes.SignInException,
            message: 'Unable to proceed due to invalid sign in state.',
        });
    }
    const { CREDENTIAL_REQUEST_OPTIONS: credentialRequestOptions } = challengeParameters;
    (0,_utils_passkey_errors_mjs__WEBPACK_IMPORTED_MODULE_5__.assertPasskeyError)(!!credentialRequestOptions, _utils_passkey_errors_mjs__WEBPACK_IMPORTED_MODULE_5__.PasskeyErrorCode.InvalidPasskeyAuthenticationOptions);
    const cred = await (0,_utils_passkey_getPasskey_mjs__WEBPACK_IMPORTED_MODULE_6__.getPasskey)(JSON.parse(credentialRequestOptions));
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_7__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_providers_cognito_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_8__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: authConfig.userPoolEndpoint,
        }),
    });
    const { ChallengeName: nextChallengeName, ChallengeParameters: nextChallengeParameters, AuthenticationResult: authenticationResult, Session: nextSession, } = await respondToAuthChallenge({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_9__.getRegionFromUserPoolId)(authConfig.userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_10__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_11__.AuthAction.ConfirmSignIn),
    }, {
        ChallengeName: 'WEB_AUTHN',
        ChallengeResponses: {
            USERNAME: username,
            CREDENTIAL: JSON.stringify(cred),
        },
        ClientId: authConfig.userPoolClientId,
        Session: signInSession,
    });
    (0,_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_2__.setActiveSignInState)({
        signInSession: nextSession,
        username,
        challengeName: nextChallengeName,
        signInDetails,
    });
    if (authenticationResult) {
        await (0,_providers_cognito_tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_12__.cacheCognitoTokens)({
            ...authenticationResult,
            username,
            NewDeviceMetadata: await (0,_providers_cognito_utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_13__.getNewDeviceMetadata)({
                userPoolId: authConfig.userPoolId,
                userPoolEndpoint: authConfig.userPoolEndpoint,
                newDeviceMetadata: authenticationResult.NewDeviceMetadata,
                accessToken: authenticationResult.AccessToken,
            }),
            signInDetails,
        });
        _utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_2__.signInStore.dispatch({ type: 'RESET_STATE' });
        await (0,_providers_cognito_utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_14__.dispatchSignedInHubEvent)();
        return {
            isSignedIn: true,
            nextStep: { signInStep: 'DONE' },
        };
    }
    if (nextChallengeName === 'WEB_AUTHN') {
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthError({
            name: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_4__.AuthErrorCodes.SignInException,
            message: 'Sequential WEB_AUTHN challenges returned from underlying service cannot be handled.',
        });
    }
    return {
        challengeName: nextChallengeName,
        challengeParameters: nextChallengeParameters,
    };
}


//# sourceMappingURL=handleWebAuthnSignInResult.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/errors.mjs":
/*!*********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/errors.mjs ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PasskeyError: () => (/* binding */ PasskeyError),
/* harmony export */   PasskeyErrorCode: () => (/* binding */ PasskeyErrorCode),
/* harmony export */   assertPasskeyError: () => (/* binding */ assertPasskeyError),
/* harmony export */   handlePasskeyAuthenticationError: () => (/* binding */ handlePasskeyAuthenticationError),
/* harmony export */   handlePasskeyRegistrationError: () => (/* binding */ handlePasskeyRegistrationError)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/errors/AmplifyError.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/errors/createAssertionFunction.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/types/errors.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
class PasskeyError extends _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.AmplifyError {
    constructor(params) {
        super(params);
        // Hack for making the custom error class work when transpiled to es5
        // TODO: Delete the following 2 lines after we change the build target to >= es2015
        this.constructor = PasskeyError;
        Object.setPrototypeOf(this, PasskeyError.prototype);
    }
}
var PasskeyErrorCode;
(function (PasskeyErrorCode) {
    // not supported
    PasskeyErrorCode["PasskeyNotSupported"] = "PasskeyNotSupported";
    // duplicate passkey
    PasskeyErrorCode["PasskeyAlreadyExists"] = "PasskeyAlreadyExists";
    // misconfigurations
    PasskeyErrorCode["InvalidPasskeyRegistrationOptions"] = "InvalidPasskeyRegistrationOptions";
    PasskeyErrorCode["InvalidPasskeyAuthenticationOptions"] = "InvalidPasskeyAuthenticationOptions";
    PasskeyErrorCode["RelyingPartyMismatch"] = "RelyingPartyMismatch";
    // failed credential creation / retrieval
    PasskeyErrorCode["PasskeyRegistrationFailed"] = "PasskeyRegistrationFailed";
    PasskeyErrorCode["PasskeyRetrievalFailed"] = "PasskeyRetrievalFailed";
    // cancel / aborts
    PasskeyErrorCode["PasskeyRegistrationCanceled"] = "PasskeyRegistrationCanceled";
    PasskeyErrorCode["PasskeyAuthenticationCanceled"] = "PasskeyAuthenticationCanceled";
    PasskeyErrorCode["PasskeyOperationAborted"] = "PasskeyOperationAborted";
})(PasskeyErrorCode || (PasskeyErrorCode = {}));
const notSupportedRecoverySuggestion = 'Passkeys may not be supported on this device. Ensure your application is running in a secure context (HTTPS) and Web Authentication API is supported.';
const abortOrCancelRecoverySuggestion = 'User may have canceled the ceremony or another interruption has occurred. Check underlying error for details.';
const misconfigurationRecoverySuggestion = 'Ensure your user pool is configured to support the WEB_AUTHN as an authentication factor.';
const passkeyErrorMap = {
    [PasskeyErrorCode.PasskeyNotSupported]: {
        message: 'Passkeys may not be supported on this device.',
        recoverySuggestion: notSupportedRecoverySuggestion,
    },
    [PasskeyErrorCode.InvalidPasskeyRegistrationOptions]: {
        message: 'Invalid passkey registration options.',
        recoverySuggestion: misconfigurationRecoverySuggestion,
    },
    [PasskeyErrorCode.InvalidPasskeyAuthenticationOptions]: {
        message: 'Invalid passkey authentication options.',
        recoverySuggestion: misconfigurationRecoverySuggestion,
    },
    [PasskeyErrorCode.PasskeyRegistrationFailed]: {
        message: 'Device failed to create passkey.',
        recoverySuggestion: notSupportedRecoverySuggestion,
    },
    [PasskeyErrorCode.PasskeyRetrievalFailed]: {
        message: 'Device failed to retrieve passkey.',
        recoverySuggestion: 'Passkeys may not be available on this device. Try an alternative authentication factor like PASSWORD, EMAIL_OTP, or SMS_OTP.',
    },
    [PasskeyErrorCode.PasskeyAlreadyExists]: {
        message: 'Passkey already exists in authenticator.',
        recoverySuggestion: 'Proceed with existing passkey or try again after deleting the credential.',
    },
    [PasskeyErrorCode.PasskeyRegistrationCanceled]: {
        message: 'Passkey registration ceremony has been canceled.',
        recoverySuggestion: abortOrCancelRecoverySuggestion,
    },
    [PasskeyErrorCode.PasskeyAuthenticationCanceled]: {
        message: 'Passkey authentication ceremony has been canceled.',
        recoverySuggestion: abortOrCancelRecoverySuggestion,
    },
    [PasskeyErrorCode.PasskeyOperationAborted]: {
        message: 'Passkey operation has been aborted.',
        recoverySuggestion: abortOrCancelRecoverySuggestion,
    },
    [PasskeyErrorCode.RelyingPartyMismatch]: {
        message: 'Relying party does not match current domain.',
        recoverySuggestion: 'Ensure relying party identifier matches current domain.',
    },
};
const assertPasskeyError = (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.createAssertionFunction)(passkeyErrorMap, PasskeyError);
/**
 * Handle Passkey Authentication Errors
 * https://w3c.github.io/webauthn/#sctn-get-request-exceptions
 *
 * @param err unknown
 * @returns PasskeyError
 */
const handlePasskeyAuthenticationError = (err) => {
    if (err instanceof PasskeyError) {
        return err;
    }
    if (err instanceof Error) {
        if (err.name === 'NotAllowedError') {
            const { message, recoverySuggestion } = passkeyErrorMap[PasskeyErrorCode.PasskeyAuthenticationCanceled];
            return new PasskeyError({
                name: PasskeyErrorCode.PasskeyAuthenticationCanceled,
                message,
                recoverySuggestion,
                underlyingError: err,
            });
        }
    }
    return handlePasskeyError(err);
};
/**
 * Handle Passkey Registration Errors
 * https://w3c.github.io/webauthn/#sctn-create-request-exceptions
 *
 * @param err unknown
 * @returns PasskeyError
 */
const handlePasskeyRegistrationError = (err) => {
    if (err instanceof PasskeyError) {
        return err;
    }
    if (err instanceof Error) {
        // Duplicate Passkey
        if (err.name === 'InvalidStateError') {
            const { message, recoverySuggestion } = passkeyErrorMap[PasskeyErrorCode.PasskeyAlreadyExists];
            return new PasskeyError({
                name: PasskeyErrorCode.PasskeyAlreadyExists,
                message,
                recoverySuggestion,
                underlyingError: err,
            });
        }
        // User Cancels Ceremony / Generic Catch All
        if (err.name === 'NotAllowedError') {
            const { message, recoverySuggestion } = passkeyErrorMap[PasskeyErrorCode.PasskeyRegistrationCanceled];
            return new PasskeyError({
                name: PasskeyErrorCode.PasskeyRegistrationCanceled,
                message,
                recoverySuggestion,
                underlyingError: err,
            });
        }
    }
    return handlePasskeyError(err);
};
/**
 * Handles Overlapping Passkey Errors Between Registration & Authentication
 * https://w3c.github.io/webauthn/#sctn-create-request-exceptions
 * https://w3c.github.io/webauthn/#sctn-get-request-exceptions
 *
 * @param err unknown
 * @returns PasskeyError
 */
const handlePasskeyError = (err) => {
    if (err instanceof Error) {
        // Passkey Operation Aborted
        if (err.name === 'AbortError') {
            const { message, recoverySuggestion } = passkeyErrorMap[PasskeyErrorCode.PasskeyOperationAborted];
            return new PasskeyError({
                name: PasskeyErrorCode.PasskeyOperationAborted,
                message,
                recoverySuggestion,
                underlyingError: err,
            });
        }
        // Relying Party / Domain Mismatch
        if (err.name === 'SecurityError') {
            const { message, recoverySuggestion } = passkeyErrorMap[PasskeyErrorCode.RelyingPartyMismatch];
            return new PasskeyError({
                name: PasskeyErrorCode.RelyingPartyMismatch,
                message,
                recoverySuggestion,
                underlyingError: err,
            });
        }
    }
    return new PasskeyError({
        name: _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__.AmplifyErrorCode.Unknown,
        message: 'An unknown error has occurred.',
        underlyingError: err,
    });
};


//# sourceMappingURL=errors.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/getIsPasskeySupported.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/getIsPasskeySupported.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getIsPasskeySupported: () => (/* binding */ getIsPasskeySupported)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/isBrowser.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Determines if passkey is supported in current context
 * Will return false if executed in non-secure context
 * @returns boolean
 */
const getIsPasskeySupported = () => {
    return ((0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.isBrowser)() &&
        window.isSecureContext &&
        'credentials' in navigator &&
        typeof window.PublicKeyCredential === 'function');
};


//# sourceMappingURL=getIsPasskeySupported.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/getPasskey.mjs":
/*!*************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/getPasskey.mjs ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getPasskey: () => (/* binding */ getPasskey)
/* harmony export */ });
/* harmony import */ var _errors_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./errors.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/errors.mjs");
/* harmony import */ var _getIsPasskeySupported_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getIsPasskeySupported.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/getIsPasskeySupported.mjs");
/* harmony import */ var _serde_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serde.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/serde.mjs");
/* harmony import */ var _types_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./types/index.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/types/index.mjs");





// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const getPasskey = async (input) => {
    try {
        const isPasskeySupported = (0,_getIsPasskeySupported_mjs__WEBPACK_IMPORTED_MODULE_0__.getIsPasskeySupported)();
        (0,_errors_mjs__WEBPACK_IMPORTED_MODULE_1__.assertPasskeyError)(isPasskeySupported, _errors_mjs__WEBPACK_IMPORTED_MODULE_1__.PasskeyErrorCode.PasskeyNotSupported);
        const passkeyGetOptions = (0,_serde_mjs__WEBPACK_IMPORTED_MODULE_2__.deserializeJsonToPkcGetOptions)(input);
        const credential = await navigator.credentials.get({
            publicKey: passkeyGetOptions,
        });
        (0,_types_index_mjs__WEBPACK_IMPORTED_MODULE_3__.assertCredentialIsPkcWithAuthenticatorAssertionResponse)(credential);
        return (0,_serde_mjs__WEBPACK_IMPORTED_MODULE_2__.serializePkcWithAssertionToJson)(credential);
    }
    catch (err) {
        throw (0,_errors_mjs__WEBPACK_IMPORTED_MODULE_1__.handlePasskeyAuthenticationError)(err);
    }
};


//# sourceMappingURL=getPasskey.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/serde.mjs":
/*!********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/serde.mjs ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   deserializeJsonToPkcCreationOptions: () => (/* binding */ deserializeJsonToPkcCreationOptions),
/* harmony export */   deserializeJsonToPkcGetOptions: () => (/* binding */ deserializeJsonToPkcGetOptions),
/* harmony export */   serializePkcWithAssertionToJson: () => (/* binding */ serializePkcWithAssertionToJson),
/* harmony export */   serializePkcWithAttestationToJson: () => (/* binding */ serializePkcWithAttestationToJson)
/* harmony export */ });
/* harmony import */ var _foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../foundation/convert/base64url/convertArrayBufferToBase64Url.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/convert/base64url/convertArrayBufferToBase64Url.mjs");
/* harmony import */ var _foundation_convert_base64url_convertBase64UrlToArrayBuffer_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../foundation/convert/base64url/convertBase64UrlToArrayBuffer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/convert/base64url/convertBase64UrlToArrayBuffer.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Deserializes Public Key Credential Creation Options JSON
 * @param input PasskeyCreateOptionsJson
 * @returns PublicKeyCredentialCreationOptions
 */
const deserializeJsonToPkcCreationOptions = (input) => {
    const userIdBuffer = (0,_foundation_convert_base64url_convertBase64UrlToArrayBuffer_mjs__WEBPACK_IMPORTED_MODULE_0__.convertBase64UrlToArrayBuffer)(input.user.id);
    const challengeBuffer = (0,_foundation_convert_base64url_convertBase64UrlToArrayBuffer_mjs__WEBPACK_IMPORTED_MODULE_0__.convertBase64UrlToArrayBuffer)(input.challenge);
    const excludeCredentialsWithBuffer = (input.excludeCredentials || []).map(excludeCred => ({
        ...excludeCred,
        id: (0,_foundation_convert_base64url_convertBase64UrlToArrayBuffer_mjs__WEBPACK_IMPORTED_MODULE_0__.convertBase64UrlToArrayBuffer)(excludeCred.id),
    }));
    return {
        ...input,
        excludeCredentials: excludeCredentialsWithBuffer,
        challenge: challengeBuffer,
        user: {
            ...input.user,
            id: userIdBuffer,
        },
    };
};
/**
 * Serializes a Public Key Credential With Attestation to JSON
 * @param input PasskeyCreateResult
 * @returns PasskeyCreateResultJson
 */
const serializePkcWithAttestationToJson = (input) => {
    const response = {
        clientDataJSON: (0,_foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__.convertArrayBufferToBase64Url)(input.response.clientDataJSON),
        attestationObject: (0,_foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__.convertArrayBufferToBase64Url)(input.response.attestationObject),
        transports: input.response.getTransports(),
        publicKeyAlgorithm: input.response.getPublicKeyAlgorithm(),
        authenticatorData: (0,_foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__.convertArrayBufferToBase64Url)(input.response.getAuthenticatorData()),
    };
    const publicKey = input.response.getPublicKey();
    if (publicKey) {
        response.publicKey = (0,_foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__.convertArrayBufferToBase64Url)(publicKey);
    }
    const resultJson = {
        type: input.type,
        id: input.id,
        rawId: (0,_foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__.convertArrayBufferToBase64Url)(input.rawId),
        clientExtensionResults: input.getClientExtensionResults(),
        response,
    };
    if (input.authenticatorAttachment) {
        resultJson.authenticatorAttachment = input.authenticatorAttachment;
    }
    return resultJson;
};
/**
 * Deserializes Public Key Credential Get Options JSON
 * @param input PasskeyGetOptionsJson
 * @returns PublicKeyCredentialRequestOptions
 */
const deserializeJsonToPkcGetOptions = (input) => {
    const challengeBuffer = (0,_foundation_convert_base64url_convertBase64UrlToArrayBuffer_mjs__WEBPACK_IMPORTED_MODULE_0__.convertBase64UrlToArrayBuffer)(input.challenge);
    const allowedCredentialsWithBuffer = (input.allowCredentials || []).map(allowedCred => ({
        ...allowedCred,
        id: (0,_foundation_convert_base64url_convertBase64UrlToArrayBuffer_mjs__WEBPACK_IMPORTED_MODULE_0__.convertBase64UrlToArrayBuffer)(allowedCred.id),
    }));
    return {
        ...input,
        challenge: challengeBuffer,
        allowCredentials: allowedCredentialsWithBuffer,
    };
};
/**
 * Serializes a Public Key Credential With Attestation to JSON
 * @param input PasskeyGetResult
 * @returns PasskeyGetResultJson
 */
const serializePkcWithAssertionToJson = (input) => {
    const response = {
        clientDataJSON: (0,_foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__.convertArrayBufferToBase64Url)(input.response.clientDataJSON),
        authenticatorData: (0,_foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__.convertArrayBufferToBase64Url)(input.response.authenticatorData),
        signature: (0,_foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__.convertArrayBufferToBase64Url)(input.response.signature),
    };
    if (input.response.userHandle) {
        response.userHandle = (0,_foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__.convertArrayBufferToBase64Url)(input.response.userHandle);
    }
    const resultJson = {
        id: input.id,
        rawId: (0,_foundation_convert_base64url_convertArrayBufferToBase64Url_mjs__WEBPACK_IMPORTED_MODULE_1__.convertArrayBufferToBase64Url)(input.rawId),
        type: input.type,
        clientExtensionResults: input.getClientExtensionResults(),
        response,
    };
    if (input.authenticatorAttachment) {
        resultJson.authenticatorAttachment = input.authenticatorAttachment;
    }
    return resultJson;
};


//# sourceMappingURL=serde.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/types/index.mjs":
/*!**************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/types/index.mjs ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   assertCredentialIsPkcWithAuthenticatorAssertionResponse: () => (/* binding */ assertCredentialIsPkcWithAuthenticatorAssertionResponse),
/* harmony export */   assertCredentialIsPkcWithAuthenticatorAttestationResponse: () => (/* binding */ assertCredentialIsPkcWithAuthenticatorAttestationResponse),
/* harmony export */   assertValidCredentialCreationOptions: () => (/* reexport safe */ _shared_mjs__WEBPACK_IMPORTED_MODULE_0__.assertValidCredentialCreationOptions)
/* harmony export */ });
/* harmony import */ var _errors_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../errors.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/errors.mjs");
/* harmony import */ var _shared_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./shared.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/types/shared.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function assertCredentialIsPkcWithAuthenticatorAttestationResponse(credential) {
    (0,_errors_mjs__WEBPACK_IMPORTED_MODULE_1__.assertPasskeyError)(credential &&
        credential instanceof PublicKeyCredential &&
        credential.response instanceof AuthenticatorAttestationResponse, _errors_mjs__WEBPACK_IMPORTED_MODULE_1__.PasskeyErrorCode.PasskeyRegistrationFailed);
}
function assertCredentialIsPkcWithAuthenticatorAssertionResponse(credential) {
    (0,_errors_mjs__WEBPACK_IMPORTED_MODULE_1__.assertPasskeyError)(credential &&
        credential instanceof PublicKeyCredential &&
        credential.response instanceof AuthenticatorAssertionResponse, _errors_mjs__WEBPACK_IMPORTED_MODULE_1__.PasskeyErrorCode.PasskeyRetrievalFailed);
}


//# sourceMappingURL=index.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/types/shared.mjs":
/*!***************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/types/shared.mjs ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   assertValidCredentialCreationOptions: () => (/* binding */ assertValidCredentialCreationOptions)
/* harmony export */ });
/* harmony import */ var _errors_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../errors.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/passkey/errors.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function assertValidCredentialCreationOptions(credentialCreationOptions) {
    (0,_errors_mjs__WEBPACK_IMPORTED_MODULE_0__.assertPasskeyError)([
        !!credentialCreationOptions,
        !!credentialCreationOptions?.challenge,
        !!credentialCreationOptions?.user,
        !!credentialCreationOptions?.rp,
        !!credentialCreationOptions?.pubKeyCredParams,
    ].every(Boolean), _errors_mjs__WEBPACK_IMPORTED_MODULE_0__.PasskeyErrorCode.InvalidPasskeyRegistrationOptions);
}


//# sourceMappingURL=shared.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/autoSignInStore.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/autoSignInStore.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   autoSignInStore: () => (/* binding */ autoSignInStore)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function defaultState() {
    return {
        active: false,
    };
}
const autoSignInReducer = (state, action) => {
    switch (action.type) {
        case 'SET_USERNAME':
            return {
                ...state,
                username: action.value,
            };
        case 'SET_SESSION':
            return {
                ...state,
                session: action.value,
            };
        case 'START':
            return {
                ...state,
                active: true,
            };
        case 'RESET':
            return defaultState();
        default:
            return state;
    }
};
const createAutoSignInStore = (reducer) => {
    let currentState = reducer(defaultState(), { type: 'RESET' });
    return {
        getState: () => currentState,
        dispatch: action => {
            currentState = reducer(currentState, action);
        },
    };
};
const autoSignInStore = createAutoSignInStore(autoSignInReducer);


//# sourceMappingURL=autoSignInStore.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs":
/*!************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   persistSignInState: () => (/* binding */ persistSignInState),
/* harmony export */   resetActiveSignInState: () => (/* binding */ resetActiveSignInState),
/* harmony export */   setActiveSignInState: () => (/* binding */ setActiveSignInState),
/* harmony export */   signInStore: () => (/* binding */ signInStore)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/storage/index.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
// Minutes until stored session invalidates is defaulted to 3 minutes
// to maintain parity with Amazon Cognito user pools API behavior
const MS_TO_EXPIRY = 3 * 60 * 1000;
const TGT_STATE = 'CognitoSignInState';
const SIGN_IN_STATE_KEYS = {
    username: `${TGT_STATE}.username`,
    challengeName: `${TGT_STATE}.challengeName`,
    signInSession: `${TGT_STATE}.signInSession`,
    expiry: `${TGT_STATE}.expiry`,
};
const signInReducer = (state, action) => {
    switch (action.type) {
        case 'SET_SIGN_IN_SESSION':
            persistSignInState({ signInSession: action.value });
            return {
                ...state,
                signInSession: action.value,
            };
        case 'SET_SIGN_IN_STATE':
            persistSignInState(action.value);
            return {
                ...action.value,
            };
        case 'SET_CHALLENGE_NAME':
            persistSignInState({ challengeName: action.value });
            return {
                ...state,
                challengeName: action.value,
            };
        case 'SET_USERNAME':
            persistSignInState({ username: action.value });
            return {
                ...state,
                username: action.value,
            };
        case 'SET_INITIAL_STATE':
            return getInitialState();
        case 'RESET_STATE':
            clearPersistedSignInState();
            return getDefaultState();
        // this state is never reachable
        default:
            return state;
    }
};
const isExpired = (expiryDate) => {
    const expiryTimestamp = Number(expiryDate);
    const currentTimestamp = Date.now();
    return expiryTimestamp <= currentTimestamp;
};
const resetActiveSignInState = () => {
    signInStore.dispatch({ type: 'RESET_STATE' });
};
const clearPersistedSignInState = () => {
    for (const stateKey of Object.values(SIGN_IN_STATE_KEYS)) {
        _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.syncSessionStorage.removeItem(stateKey);
    }
};
const getDefaultState = () => ({
    username: undefined,
    challengeName: undefined,
    signInSession: undefined,
});
// Hydrate signInStore from syncSessionStorage if the session has not expired
const getInitialState = () => {
    const expiry = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.syncSessionStorage.getItem(SIGN_IN_STATE_KEYS.expiry);
    if (!expiry || isExpired(expiry)) {
        clearPersistedSignInState();
        return getDefaultState();
    }
    const username = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.syncSessionStorage.getItem(SIGN_IN_STATE_KEYS.username) ?? undefined;
    const challengeName = (_aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.syncSessionStorage.getItem(SIGN_IN_STATE_KEYS.challengeName) ?? undefined);
    const signInSession = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.syncSessionStorage.getItem(SIGN_IN_STATE_KEYS.signInSession) ?? undefined;
    return {
        username,
        challengeName,
        signInSession,
    };
};
const createStore = reducer => {
    let currentState = reducer(getDefaultState(), { type: 'SET_INITIAL_STATE' });
    return {
        getState: () => currentState,
        dispatch: action => {
            currentState = reducer(currentState, action);
        },
    };
};
const signInStore = createStore(signInReducer);
function setActiveSignInState(state) {
    signInStore.dispatch({
        type: 'SET_SIGN_IN_STATE',
        value: state,
    });
}
// Save local state into Session Storage
const persistSignInState = ({ challengeName, signInSession, username, }) => {
    username && _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.syncSessionStorage.setItem(SIGN_IN_STATE_KEYS.username, username);
    challengeName &&
        _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.syncSessionStorage.setItem(SIGN_IN_STATE_KEYS.challengeName, challengeName);
    if (signInSession) {
        _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.syncSessionStorage.setItem(SIGN_IN_STATE_KEYS.signInSession, signInSession);
        // Updates expiry when session is passed
        _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.syncSessionStorage.setItem(SIGN_IN_STATE_KEYS.expiry, String(Date.now() + MS_TO_EXPIRY));
    }
};


//# sourceMappingURL=signInStore.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/common/AuthErrorStrings.mjs":
/*!*****************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/common/AuthErrorStrings.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthErrorCodes: () => (/* binding */ AuthErrorCodes),
/* harmony export */   AuthErrorStrings: () => (/* binding */ AuthErrorStrings),
/* harmony export */   validationErrorMap: () => (/* binding */ validationErrorMap)
/* harmony export */ });
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const validationErrorMap = {
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyChallengeResponse]: {
        message: 'challengeResponse is required to confirmSignIn',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyConfirmResetPasswordUsername]: {
        message: 'username is required to confirmResetPassword',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyConfirmSignUpCode]: {
        message: 'code is required to confirmSignUp',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyConfirmSignUpUsername]: {
        message: 'username is required to confirmSignUp',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyConfirmResetPasswordConfirmationCode]: {
        message: 'confirmationCode is required to confirmResetPassword',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyConfirmResetPasswordNewPassword]: {
        message: 'newPassword is required to confirmResetPassword',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyResendSignUpCodeUsername]: {
        message: 'username is required to confirmSignUp',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyResetPasswordUsername]: {
        message: 'username is required to resetPassword',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptySignInPassword]: {
        message: 'password is required to signIn',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptySignInUsername]: {
        message: 'username is required to signIn',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptySignUpPassword]: {
        message: 'password is required to signUp',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptySignUpUsername]: {
        message: 'username is required to signUp',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.CustomAuthSignInPassword]: {
        message: 'A password is not needed when signing in with CUSTOM_WITHOUT_SRP',
        recoverySuggestion: 'Do not include a password in your signIn call.',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.IncorrectMFAMethod]: {
        message: 'Incorrect MFA method was chosen. It should be either SMS, TOTP, or EMAIL',
        recoverySuggestion: 'Try to pass SMS, TOTP, or EMAIL as the challengeResponse',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyVerifyTOTPSetupCode]: {
        message: 'code is required to verifyTotpSetup',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyUpdatePassword]: {
        message: 'oldPassword and newPassword are required to changePassword',
    },
    [_errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthValidationErrorCode.EmptyConfirmUserAttributeCode]: {
        message: 'confirmation code is required to confirmUserAttribute',
    },
};
// TODO: delete this code when the Auth class is removed.
var AuthErrorStrings;
(function (AuthErrorStrings) {
    AuthErrorStrings["DEFAULT_MSG"] = "Authentication Error";
    AuthErrorStrings["EMPTY_EMAIL"] = "Email cannot be empty";
    AuthErrorStrings["EMPTY_PHONE"] = "Phone number cannot be empty";
    AuthErrorStrings["EMPTY_USERNAME"] = "Username cannot be empty";
    AuthErrorStrings["INVALID_USERNAME"] = "The username should either be a string or one of the sign in types";
    AuthErrorStrings["EMPTY_PASSWORD"] = "Password cannot be empty";
    AuthErrorStrings["EMPTY_CODE"] = "Confirmation code cannot be empty";
    AuthErrorStrings["SIGN_UP_ERROR"] = "Error creating account";
    AuthErrorStrings["NO_MFA"] = "No valid MFA method provided";
    AuthErrorStrings["INVALID_MFA"] = "Invalid MFA type";
    AuthErrorStrings["EMPTY_CHALLENGE"] = "Challenge response cannot be empty";
    AuthErrorStrings["NO_USER_SESSION"] = "Failed to get the session because the user is empty";
    AuthErrorStrings["NETWORK_ERROR"] = "Network Error";
    AuthErrorStrings["DEVICE_CONFIG"] = "Device tracking has not been configured in this User Pool";
    AuthErrorStrings["AUTOSIGNIN_ERROR"] = "Please use your credentials to sign in";
    AuthErrorStrings["OAUTH_ERROR"] = "Couldn't finish OAuth flow, check your User Pool HostedUI settings";
})(AuthErrorStrings || (AuthErrorStrings = {}));
var AuthErrorCodes;
(function (AuthErrorCodes) {
    AuthErrorCodes["SignInException"] = "SignInException";
    AuthErrorCodes["OAuthSignInError"] = "OAuthSignInException";
})(AuthErrorCodes || (AuthErrorCodes = {}));


//# sourceMappingURL=AuthErrorStrings.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs":
/*!*****************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthValidationErrorCode: () => (/* binding */ AuthValidationErrorCode)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
var AuthValidationErrorCode;
(function (AuthValidationErrorCode) {
    AuthValidationErrorCode["EmptySignInUsername"] = "EmptySignInUsername";
    AuthValidationErrorCode["EmptySignInPassword"] = "EmptySignInPassword";
    AuthValidationErrorCode["CustomAuthSignInPassword"] = "CustomAuthSignInPassword";
    AuthValidationErrorCode["EmptySignUpUsername"] = "EmptySignUpUsername";
    AuthValidationErrorCode["EmptySignUpPassword"] = "EmptySignUpPassword";
    AuthValidationErrorCode["EmptyConfirmSignUpUsername"] = "EmptyConfirmSignUpUsername";
    AuthValidationErrorCode["EmptyConfirmSignUpCode"] = "EmptyConfirmSignUpCode";
    AuthValidationErrorCode["EmptyResendSignUpCodeUsername"] = "EmptyresendSignUpCodeUsername";
    AuthValidationErrorCode["EmptyChallengeResponse"] = "EmptyChallengeResponse";
    AuthValidationErrorCode["EmptyConfirmResetPasswordUsername"] = "EmptyConfirmResetPasswordUsername";
    AuthValidationErrorCode["EmptyConfirmResetPasswordNewPassword"] = "EmptyConfirmResetPasswordNewPassword";
    AuthValidationErrorCode["EmptyConfirmResetPasswordConfirmationCode"] = "EmptyConfirmResetPasswordConfirmationCode";
    AuthValidationErrorCode["EmptyResetPasswordUsername"] = "EmptyResetPasswordUsername";
    AuthValidationErrorCode["EmptyVerifyTOTPSetupCode"] = "EmptyVerifyTOTPSetupCode";
    AuthValidationErrorCode["EmptyConfirmUserAttributeCode"] = "EmptyConfirmUserAttributeCode";
    AuthValidationErrorCode["IncorrectMFAMethod"] = "IncorrectMFAMethod";
    AuthValidationErrorCode["EmptyUpdatePassword"] = "EmptyUpdatePassword";
})(AuthValidationErrorCode || (AuthValidationErrorCode = {}));


//# sourceMappingURL=validation.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   assertValidationError: () => (/* binding */ assertValidationError)
/* harmony export */ });
/* harmony import */ var _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/AuthErrorStrings.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/common/AuthErrorStrings.mjs");
/* harmony import */ var _AuthError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function assertValidationError(assertion, name) {
    const { message, recoverySuggestion } = _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_0__.validationErrorMap[name];
    if (!assertion) {
        throw new _AuthError_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthError({ name, message, recoverySuggestion });
    }
}


//# sourceMappingURL=assertValidationError.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/convert/base64url/convertArrayBufferToBase64Url.mjs":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/convert/base64url/convertArrayBufferToBase64Url.mjs ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertArrayBufferToBase64Url: () => (/* binding */ convertArrayBufferToBase64Url)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/base64Encoder.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
// https://datatracker.ietf.org/doc/html/rfc4648#page-7
/**
 * Converts an ArrayBuffer to a base64url encoded string
 * @param buffer - the ArrayBuffer instance of a Uint8Array
 * @returns string - a base64url encoded string
 */
const convertArrayBufferToBase64Url = (buffer) => {
    return _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.base64Encoder.convert(new Uint8Array(buffer), {
        urlSafe: true,
        skipPadding: true,
    });
};


//# sourceMappingURL=convertArrayBufferToBase64Url.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/convert/base64url/convertBase64UrlToArrayBuffer.mjs":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/convert/base64url/convertBase64UrlToArrayBuffer.mjs ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   convertBase64UrlToArrayBuffer: () => (/* binding */ convertBase64UrlToArrayBuffer)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/base64Decoder.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Converts a base64url encoded string to an ArrayBuffer
 * @param base64url - a base64url encoded string
 * @returns ArrayBuffer
 */
const convertBase64UrlToArrayBuffer = (base64url) => {
    return Uint8Array.from(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.base64Decoder.convert(base64url, { urlSafe: true }), x => x.charCodeAt(0)).buffer;
};


//# sourceMappingURL=convertBase64UrlToArrayBuffer.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createAssociateSoftwareTokenClient.mjs":
/*!****************************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createAssociateSoftwareTokenClient.mjs ***!
  \****************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createAssociateSoftwareTokenClient: () => (/* binding */ createAssociateSoftwareTokenClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createAssociateSoftwareTokenClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('AssociateSoftwareToken'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createAssociateSoftwareTokenClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createChangePasswordClient.mjs":
/*!********************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createChangePasswordClient.mjs ***!
  \********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createChangePasswordClient: () => (/* binding */ createChangePasswordClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createChangePasswordClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('ChangePassword'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createChangePasswordClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmDeviceClient.mjs":
/*!*******************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmDeviceClient.mjs ***!
  \*******************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createConfirmDeviceClient: () => (/* binding */ createConfirmDeviceClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createConfirmDeviceClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('ConfirmDevice'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createConfirmDeviceClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmForgotPasswordClient.mjs":
/*!***************************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmForgotPasswordClient.mjs ***!
  \***************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createConfirmForgotPasswordClient: () => (/* binding */ createConfirmForgotPasswordClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createConfirmForgotPasswordClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('ConfirmForgotPassword'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createConfirmForgotPasswordClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmSignUpClient.mjs":
/*!*******************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmSignUpClient.mjs ***!
  \*******************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createConfirmSignUpClient: () => (/* binding */ createConfirmSignUpClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createConfirmSignUpClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('ConfirmSignUp'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createConfirmSignUpClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createDeleteUserClient.mjs":
/*!****************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createDeleteUserClient.mjs ***!
  \****************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createDeleteUserClient: () => (/* binding */ createDeleteUserClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createEmptyResponseDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createEmptyResponseDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createEmptyResponseDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createDeleteUserClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('DeleteUser'), (0,_shared_serde_createEmptyResponseDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createEmptyResponseDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createDeleteUserClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createForgotPasswordClient.mjs":
/*!********************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createForgotPasswordClient.mjs ***!
  \********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createForgotPasswordClient: () => (/* binding */ createForgotPasswordClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createForgotPasswordClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('ForgotPassword'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createForgotPasswordClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createGetUserAttributeVerificationCodeClient.mjs":
/*!**************************************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createGetUserAttributeVerificationCodeClient.mjs ***!
  \**************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createGetUserAttributeVerificationCodeClient: () => (/* binding */ createGetUserAttributeVerificationCodeClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createGetUserAttributeVerificationCodeClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('GetUserAttributeVerificationCode'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createGetUserAttributeVerificationCodeClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createGetUserClient.mjs":
/*!*************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createGetUserClient.mjs ***!
  \*************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createGetUserClient: () => (/* binding */ createGetUserClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createGetUserClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('GetUser'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createGetUserClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createInitiateAuthClient.mjs":
/*!******************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createInitiateAuthClient.mjs ***!
  \******************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createInitiateAuthClient: () => (/* binding */ createInitiateAuthClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createInitiateAuthClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('InitiateAuth'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createInitiateAuthClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createResendConfirmationCodeClient.mjs":
/*!****************************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createResendConfirmationCodeClient.mjs ***!
  \****************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createResendConfirmationCodeClient: () => (/* binding */ createResendConfirmationCodeClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createResendConfirmationCodeClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('ResendConfirmationCode'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createResendConfirmationCodeClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs":
/*!****************************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs ***!
  \****************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createRespondToAuthChallengeClient: () => (/* binding */ createRespondToAuthChallengeClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createRespondToAuthChallengeClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('RespondToAuthChallenge'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createRespondToAuthChallengeClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createSignUpClient.mjs":
/*!************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createSignUpClient.mjs ***!
  \************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createSignUpClient: () => (/* binding */ createSignUpClient),
/* harmony export */   createSignUpClientDeserializer: () => (/* binding */ createSignUpClientDeserializer)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils */ "./node_modules/@aws-amplify/core/dist/esm/clients/serde/json.mjs");
/* harmony import */ var _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../common/AuthErrorStrings.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/common/AuthErrorStrings.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../errors/utils/assertServiceError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertServiceError.mjs");
/* harmony import */ var _providers_cognito_types_errors_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../providers/cognito/types/errors.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/types/errors.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");











// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createSignUpClientDeserializer = () => async (response) => {
    if (response.statusCode >= 300) {
        const error = await (0,_aws_amplify_core_internals_aws_client_utils__WEBPACK_IMPORTED_MODULE_0__.parseJsonError)(response);
        (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_1__.assertServiceError)(error);
        if (
        // Missing Password Error
        // 1 validation error detected: Value at 'password'failed to satisfy constraint: Member must not be null
        error.name === _providers_cognito_types_errors_mjs__WEBPACK_IMPORTED_MODULE_2__.SignUpException.InvalidParameterException &&
            /'password'/.test(error.message) &&
            /Member must not be null/.test(error.message)) {
            const name = _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptySignUpPassword;
            const { message, recoverySuggestion } = _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_4__.validationErrorMap[name];
            throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_5__.AuthError({
                name,
                message,
                recoverySuggestion,
            });
        }
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_5__.AuthError({ name: error.name, message: error.message });
    }
    return (0,_aws_amplify_core_internals_aws_client_utils__WEBPACK_IMPORTED_MODULE_0__.parseJsonBody)(response);
};
const createSignUpClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_6__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_7__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_8__.createUserPoolSerializer)('SignUp'), createSignUpClientDeserializer(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_9__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createSignUpClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createVerifySoftwareTokenClient.mjs":
/*!*************************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createVerifySoftwareTokenClient.mjs ***!
  \*************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createVerifySoftwareTokenClient: () => (/* binding */ createVerifySoftwareTokenClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createVerifySoftwareTokenClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('VerifySoftwareToken'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createVerifySoftwareTokenClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createVerifyUserAttributeClient.mjs":
/*!*************************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createVerifyUserAttributeClient.mjs ***!
  \*************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createVerifyUserAttributeClient: () => (/* binding */ createVerifyUserAttributeClient)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils/composers */ "./node_modules/@aws-amplify/core/dist/esm/clients/internal/composeServiceApi.mjs");
/* harmony import */ var _shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./shared/handler/cognitoUserPoolTransferHandler.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/handler/cognitoUserPoolTransferHandler.mjs");
/* harmony import */ var _shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./shared/serde/createUserPoolSerializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolSerializer.mjs");
/* harmony import */ var _shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./shared/serde/createUserPoolDeserializer.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createUserPoolDeserializer.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/constants.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createVerifyUserAttributeClient = (config) => (0,_aws_amplify_core_internals_aws_client_utils_composers__WEBPACK_IMPORTED_MODULE_0__.composeServiceApi)(_shared_handler_cognitoUserPoolTransferHandler_mjs__WEBPACK_IMPORTED_MODULE_1__.cognitoUserPoolTransferHandler, (0,_shared_serde_createUserPoolSerializer_mjs__WEBPACK_IMPORTED_MODULE_2__.createUserPoolSerializer)('VerifyUserAttribute'), (0,_shared_serde_createUserPoolDeserializer_mjs__WEBPACK_IMPORTED_MODULE_3__.createUserPoolDeserializer)(), {
    ..._constants_mjs__WEBPACK_IMPORTED_MODULE_4__.DEFAULT_SERVICE_CLIENT_API_CONFIG,
    ...config,
});


//# sourceMappingURL=createVerifyUserAttributeClient.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createEmptyResponseDeserializer.mjs":
/*!**************************************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/shared/serde/createEmptyResponseDeserializer.mjs ***!
  \**************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createEmptyResponseDeserializer: () => (/* binding */ createEmptyResponseDeserializer)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_aws_client_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/aws-client-utils */ "./node_modules/@aws-amplify/core/dist/esm/clients/serde/json.mjs");
/* harmony import */ var _errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../../errors/utils/assertServiceError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertServiceError.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");




// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createEmptyResponseDeserializer = () => async (response) => {
    if (response.statusCode >= 300) {
        const error = await (0,_aws_amplify_core_internals_aws_client_utils__WEBPACK_IMPORTED_MODULE_0__.parseJsonError)(response);
        (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_1__.assertServiceError)(error);
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_2__.AuthError({ name: error.name, message: error.message });
    }
    else {
        return undefined;
    }
};


//# sourceMappingURL=createEmptyResponseDeserializer.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/autoSignIn.mjs":
/*!***************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/autoSignIn.mjs ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   autoSignIn: () => (/* binding */ autoSignIn),
/* harmony export */   resetAutoSignIn: () => (/* binding */ resetAutoSignIn),
/* harmony export */   setAutoSignIn: () => (/* binding */ setAutoSignIn)
/* harmony export */ });
/* harmony import */ var _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../client/utils/store/autoSignInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/autoSignInStore.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _errors_constants_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../errors/constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/constants.mjs");





// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const initialAutoSignIn = async () => {
    throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthError({
        name: _errors_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.AUTO_SIGN_IN_EXCEPTION,
        message: 'The autoSignIn flow has not started, or has been cancelled/completed.',
        recoverySuggestion: 'Please try to use the signIn API or log out before starting a new autoSignIn flow.',
    });
};
/**
 * Signs a user in automatically after finishing the sign-up process.
 *
 * This API will automatically sign a user in if the autoSignIn flow has been completed in the following cases:
 * - User confirmed their account with a verification code sent to their phone or email (default option).
 * - User confirmed their account with a verification link sent to their phone or email. In order to
 * enable this option you need to go to the Amazon Cognito [console](https://aws.amazon.com/pm/cognito),
 * look for your userpool, then go to the `Messaging` tab and enable `link` mode inside the `Verification message` option.
 * Finally you need to define the `signUpVerificationMethod` in your `Auth` config.
 *
 * @example
 * ```typescript
 *  Amplify.configure({
 *    Auth: {
 *     Cognito: {
 *    ...cognitoConfig,
 *    signUpVerificationMethod: "link" // the default value is "code"
 *   }
 *	}});
 * ```
 *
 * @throws AutoSignInException - Thrown when the autoSignIn flow has not started, or has been cancelled/completed.
 * @returns The signInOutput.
 *
 * @example
 * ```typescript
 *  // handleSignUp.ts
 * async function handleSignUp(
 *   username:string,
 *   password:string
 * ){
 *   try {
 *     const { nextStep } = await signUp({
 *       username,
 *       password,
 *       options: {
 *         userAttributes:{ email:'email@email.com'},
 *         autoSignIn: true // This enables the auto sign-in flow.
 *       },
 *     });
 *
 *     handleSignUpStep(nextStep);
 *
 *   } catch (error) {
 *     console.log(error);
 *   }
 * }
 *
 * // handleConfirmSignUp.ts
 * async function handleConfirmSignUp(username:string, confirmationCode:string) {
 *   try {
 *     const { nextStep } = await confirmSignUp({
 *       username,
 *       confirmationCode,
 *     });
 *
 *     handleSignUpStep(nextStep);
 *   } catch (error) {
 *     console.log(error);
 *   }
 * }
 *
 * // signUpUtils.ts
 * async function handleSignUpStep( step: SignUpOutput["nextStep"]) {
 * switch (step.signUpStep) {
 *   case "CONFIRM_SIGN_UP":
 *
 *    // Redirect end-user to confirm-sign up screen.
 *
 *   case "COMPLETE_AUTO_SIGN_IN":
 *	   const codeDeliveryDetails = step.codeDeliveryDetails;
 *     if (codeDeliveryDetails) {
 *      // Redirect user to confirm-sign-up with link screen.
 *     }
 *     const signInOutput = await autoSignIn();
 *   // handle sign-in steps
 * }
 *
 * ```
 */
// TODO(Eslint): can this be refactored not using `let` on exported member?
// eslint-disable-next-line import/no-mutable-exports
let autoSignIn = initialAutoSignIn;
/**
 * Sets the context of autoSignIn at run time.
 * @internal
 */
function setAutoSignIn(callback) {
    autoSignIn = callback;
}
/**
 * Resets the context
 *
 * @internal
 */
function resetAutoSignIn(resetCallback = true) {
    if (resetCallback) {
        autoSignIn = initialAutoSignIn;
    }
    _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_2__.autoSignInStore.dispatch({ type: 'RESET' });
}


//# sourceMappingURL=autoSignIn.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/confirmResetPassword.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/confirmResetPassword.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   confirmResetPassword: () => (/* binding */ confirmResetPassword)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createConfirmForgotPasswordClient_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmForgotPasswordClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmForgotPasswordClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Confirms the new password and verification code to reset the password.
 *
 * @param input -  The ConfirmResetPasswordInput object.
 * @throws -{@link ConfirmForgotPasswordException }
 * Thrown due to an invalid confirmation code or password.
 * @throws -{@link AuthValidationErrorCode }
 * Thrown due to an empty confirmation code, password or username.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function confirmResetPassword(input) {
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const { userPoolClientId, userPoolId, userPoolEndpoint } = authConfig;
    const { username, newPassword } = input;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!username, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptyConfirmResetPasswordUsername);
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!newPassword, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptyConfirmResetPasswordNewPassword);
    const code = input.confirmationCode;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!code, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptyConfirmResetPasswordConfirmationCode);
    const metadata = input.options?.clientMetadata;
    const UserContextData = (0,_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_4__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const confirmForgotPassword = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createConfirmForgotPasswordClient_mjs__WEBPACK_IMPORTED_MODULE_5__.createConfirmForgotPasswordClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    await confirmForgotPassword({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_7__.getRegionFromUserPoolId)(authConfig.userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_8__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_9__.AuthAction.ConfirmResetPassword),
    }, {
        Username: username,
        ConfirmationCode: code,
        Password: newPassword,
        ClientMetadata: metadata,
        ClientId: authConfig.userPoolClientId,
        UserContextData,
    });
}


//# sourceMappingURL=confirmResetPassword.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/confirmSignIn.mjs":
/*!******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/confirmSignIn.mjs ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   confirmSignIn: () => (/* binding */ confirmSignIn)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../client/utils/store/signInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/signInHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signInHelpers.mjs");
/* harmony import */ var _errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../errors/utils/assertServiceError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertServiceError.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/AuthErrorStrings.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/common/AuthErrorStrings.mjs");
/* harmony import */ var _tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../tokenProvider/cacheTokens.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/cacheTokens.mjs");
/* harmony import */ var _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../tokenProvider/tokenProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/tokenProvider.mjs");
/* harmony import */ var _utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../utils/dispatchSignedInHubEvent.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/dispatchSignedInHubEvent.mjs");
/* harmony import */ var _utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/getNewDeviceMetadata.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/getNewDeviceMetadata.mjs");


















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Continues or completes the sign in process when required by the initial call to `signIn`.
 *
 * @param input -  The ConfirmSignInInput object
 * @returns ConfirmSignInOutput
 * @throws  -{@link VerifySoftwareTokenException }:
 * Thrown due to an invalid MFA token.
 * @throws  -{@link RespondToAuthChallengeException }:
 * Thrown due to an invalid auth challenge response.
 * @throws  -{@link AssociateSoftwareTokenException}:
 * Thrown due to a service error during the MFA setup process.
 * @throws  -{@link AuthValidationErrorCode }:
 * Thrown when `challengeResponse` is not defined.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function confirmSignIn(input) {
    const { challengeResponse, options } = input;
    const { username, challengeName, signInSession, signInDetails } = _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_0__.signInStore.getState();
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__.assertTokenProviderConfig)(authConfig);
    const clientMetaData = options?.clientMetadata;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_3__.assertValidationError)(!!challengeResponse, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_4__.AuthValidationErrorCode.EmptyChallengeResponse);
    if (!username || !challengeName || !signInSession)
        // TODO: remove this error message for production apps
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_5__.AuthError({
            name: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_6__.AuthErrorCodes.SignInException,
            message: `
			An error occurred during the sign in process.

			This most likely occurred due to:
			1. signIn was not called before confirmSignIn.
			2. signIn threw an exception.
			3. page was refreshed during the sign in flow and session has expired.
			`,
            recoverySuggestion: 'Make sure a successful call to signIn is made before calling confirmSignIn' +
                'and that the session has not expired.',
        });
    try {
        const { Session, ChallengeName: handledChallengeName, AuthenticationResult, ChallengeParameters: handledChallengeParameters, } = await (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_7__.handleChallengeName)(username, challengeName, signInSession, challengeResponse, authConfig, _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_8__.tokenOrchestrator, clientMetaData, options);
        // sets up local state used during the sign-in process
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_0__.setActiveSignInState)({
            signInSession: Session,
            username,
            challengeName: handledChallengeName,
            signInDetails,
        });
        if (AuthenticationResult) {
            await (0,_tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_9__.cacheCognitoTokens)({
                username,
                ...AuthenticationResult,
                NewDeviceMetadata: await (0,_utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_10__.getNewDeviceMetadata)({
                    userPoolId: authConfig.userPoolId,
                    userPoolEndpoint: authConfig.userPoolEndpoint,
                    newDeviceMetadata: AuthenticationResult.NewDeviceMetadata,
                    accessToken: AuthenticationResult.AccessToken,
                }),
                signInDetails,
            });
            (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_0__.resetActiveSignInState)();
            await (0,_utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_11__.dispatchSignedInHubEvent)();
            return {
                isSignedIn: true,
                nextStep: { signInStep: 'DONE' },
            };
        }
        return (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_7__.getSignInResult)({
            challengeName: handledChallengeName,
            challengeParameters: handledChallengeParameters,
        });
    }
    catch (error) {
        (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_12__.assertServiceError)(error);
        const result = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_7__.getSignInResultFromError)(error.name);
        if (result)
            return result;
        throw error;
    }
}


//# sourceMappingURL=confirmSignIn.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/confirmSignUp.mjs":
/*!******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/confirmSignUp.mjs ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   confirmSignUp: () => (/* binding */ confirmSignUp)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Hub/index.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createConfirmSignUpClient_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmSignUpClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmSignUpClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../client/utils/store/autoSignInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/autoSignInStore.mjs");
/* harmony import */ var _autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./autoSignIn.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/autoSignIn.mjs");



















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Confirms a new user account.
 *
 * @param input -  The ConfirmSignUpInput object.
 * @returns ConfirmSignUpOutput
 * @throws -{@link ConfirmSignUpException }
 * Thrown due to an invalid confirmation code.
 * @throws -{@link AuthValidationErrorCode }
 * Thrown due to an empty confirmation code
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function confirmSignUp(input) {
    const { username, confirmationCode, options } = input;
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const { userPoolId, userPoolClientId, userPoolEndpoint } = authConfig;
    const clientMetadata = options?.clientMetadata;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!username, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptyConfirmSignUpUsername);
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!confirmationCode, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptyConfirmSignUpCode);
    const UserContextData = (0,_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_4__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const confirmSignUpClient = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createConfirmSignUpClient_mjs__WEBPACK_IMPORTED_MODULE_5__.createConfirmSignUpClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const { Session: session } = await confirmSignUpClient({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_7__.getRegionFromUserPoolId)(authConfig.userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_8__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_9__.AuthAction.ConfirmSignUp),
    }, {
        Username: username,
        ConfirmationCode: confirmationCode,
        ClientMetadata: clientMetadata,
        ForceAliasCreation: options?.forceAliasCreation,
        ClientId: authConfig.userPoolClientId,
        UserContextData,
    });
    return new Promise((resolve, reject) => {
        try {
            const signUpOut = {
                isSignUpComplete: true,
                nextStep: {
                    signUpStep: 'DONE',
                },
            };
            const autoSignInStoreState = _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_10__.autoSignInStore.getState();
            if (!autoSignInStoreState.active ||
                autoSignInStoreState.username !== username) {
                resolve(signUpOut);
                (0,_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_11__.resetAutoSignIn)();
                return;
            }
            _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_10__.autoSignInStore.dispatch({ type: 'SET_SESSION', value: session });
            const stopListener = _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_12__.HubInternal.listen('auth-internal', ({ payload }) => {
                switch (payload.event) {
                    case 'autoSignIn':
                        resolve({
                            isSignUpComplete: true,
                            nextStep: {
                                signUpStep: 'COMPLETE_AUTO_SIGN_IN',
                            },
                        });
                        stopListener();
                }
            });
            _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_12__.HubInternal.dispatch('auth-internal', {
                event: 'confirmSignUp',
                data: signUpOut,
            });
        }
        catch (error) {
            reject(error);
        }
    });
}


//# sourceMappingURL=confirmSignUp.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/confirmUserAttribute.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/confirmUserAttribute.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   confirmUserAttribute: () => (/* binding */ confirmUserAttribute)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/apis/fetchAuthSession.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_types_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/types.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/types.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createVerifyUserAttributeClient_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createVerifyUserAttributeClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createVerifyUserAttributeClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Confirms a user attribute with the confirmation code.
 *
 * @param input -  The ConfirmUserAttributeInput object
 * @throws  -{@link AuthValidationErrorCode } -
 * Thrown when `confirmationCode` is not defined.
 * @throws  -{@link VerifyUserAttributeException } - Thrown due to an invalid confirmation code or attribute.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function confirmUserAttribute(input) {
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const { userPoolEndpoint, userPoolId } = authConfig;
    const { confirmationCode, userAttributeKey } = input;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!confirmationCode, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptyConfirmUserAttributeCode);
    const { tokens } = await (0,_aws_amplify_core__WEBPACK_IMPORTED_MODULE_4__.fetchAuthSession)({ forceRefresh: false });
    (0,_utils_types_mjs__WEBPACK_IMPORTED_MODULE_5__.assertAuthTokens)(tokens);
    const verifyUserAttribute = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createVerifyUserAttributeClient_mjs__WEBPACK_IMPORTED_MODULE_6__.createVerifyUserAttributeClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_7__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    await verifyUserAttribute({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_8__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_9__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_10__.AuthAction.ConfirmUserAttribute),
    }, {
        AccessToken: tokens.accessToken.toString(),
        AttributeName: userAttributeKey,
        Code: confirmationCode,
    });
}


//# sourceMappingURL=confirmUserAttribute.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/deleteUser.mjs":
/*!***************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/deleteUser.mjs ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   deleteUser: () => (/* binding */ deleteUser)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/apis/fetchAuthSession.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_types_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/types.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/types.mjs");
/* harmony import */ var _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../tokenProvider/tokenProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/tokenProvider.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createDeleteUserClient_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createDeleteUserClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createDeleteUserClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _signOut_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./signOut.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signOut.mjs");



















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Deletes a user from the user pool while authenticated.
 *
 * @throws - {@link DeleteUserException}
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function deleteUser() {
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const { userPoolEndpoint, userPoolId } = authConfig;
    const { tokens } = await (0,_aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__.fetchAuthSession)();
    (0,_utils_types_mjs__WEBPACK_IMPORTED_MODULE_3__.assertAuthTokens)(tokens);
    const serviceDeleteUser = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createDeleteUserClient_mjs__WEBPACK_IMPORTED_MODULE_4__.createDeleteUserClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_5__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    await serviceDeleteUser({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_6__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_7__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_8__.AuthAction.DeleteUser),
    }, {
        AccessToken: tokens.accessToken.toString(),
    });
    await _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_9__.tokenOrchestrator.clearDeviceMetadata();
    await (0,_signOut_mjs__WEBPACK_IMPORTED_MODULE_10__.signOut)();
}


//# sourceMappingURL=deleteUser.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/fetchUserAttributes.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/fetchUserAttributes.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fetchUserAttributes: () => (/* binding */ fetchUserAttributes)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _internal_fetchUserAttributes_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/fetchUserAttributes.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/internal/fetchUserAttributes.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Fetches the current user attributes while authenticated.
 *
 * @throws - {@link GetUserException} - Cognito service errors thrown when the service is not able to get the user.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
const fetchUserAttributes = () => {
    return (0,_internal_fetchUserAttributes_mjs__WEBPACK_IMPORTED_MODULE_0__.fetchUserAttributes)(_aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__.Amplify);
};


//# sourceMappingURL=fetchUserAttributes.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/getCurrentUser.mjs":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/getCurrentUser.mjs ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getCurrentUser: () => (/* binding */ getCurrentUser)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _internal_getCurrentUser_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./internal/getCurrentUser.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/internal/getCurrentUser.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Gets the current user from the idToken.
 *
 * @param input -  The GetCurrentUserInput object.
 * @returns GetCurrentUserOutput
 * @throws - {@link InitiateAuthException} - Thrown when the service fails to refresh the tokens.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
const getCurrentUser = async () => {
    return (0,_internal_getCurrentUser_mjs__WEBPACK_IMPORTED_MODULE_0__.getCurrentUser)(_aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__.Amplify);
};


//# sourceMappingURL=getCurrentUser.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/internal/fetchUserAttributes.mjs":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/internal/fetchUserAttributes.mjs ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fetchUserAttributes: () => (/* binding */ fetchUserAttributes)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/apis/internal/fetchAuthSession.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_types_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/types.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/types.mjs");
/* harmony import */ var _utils_apiHelpers_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/apiHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/apiHelpers.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createGetUserClient_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../foundation/factories/serviceClients/cognitoIdentityProvider/createGetUserClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createGetUserClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const fetchUserAttributes = async (amplify) => {
    const authConfig = amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.assertTokenProviderConfig)(authConfig);
    const { userPoolEndpoint, userPoolId } = authConfig;
    const { tokens } = await (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.fetchAuthSession)(amplify, {
        forceRefresh: false,
    });
    (0,_utils_types_mjs__WEBPACK_IMPORTED_MODULE_2__.assertAuthTokens)(tokens);
    const getUser = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createGetUserClient_mjs__WEBPACK_IMPORTED_MODULE_3__.createGetUserClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_4__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const { UserAttributes } = await getUser({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_5__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_6__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_7__.AuthAction.FetchUserAttributes),
    }, {
        AccessToken: tokens.accessToken.toString(),
    });
    return (0,_utils_apiHelpers_mjs__WEBPACK_IMPORTED_MODULE_8__.toAuthUserAttribute)(UserAttributes);
};


//# sourceMappingURL=fetchUserAttributes.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/internal/getCurrentUser.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/internal/getCurrentUser.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getCurrentUser: () => (/* binding */ getCurrentUser)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _utils_types_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/types.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/types.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const getCurrentUser = async (amplify) => {
    const authConfig = amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.assertTokenProviderConfig)(authConfig);
    const tokens = await amplify.Auth.getTokens({ forceRefresh: false });
    (0,_utils_types_mjs__WEBPACK_IMPORTED_MODULE_1__.assertAuthTokens)(tokens);
    const { 'cognito:username': username, sub } = tokens.idToken?.payload ?? {};
    const authUser = {
        username: username,
        userId: sub,
    };
    const signInDetails = getSignInDetailsFromTokens(tokens);
    if (signInDetails) {
        authUser.signInDetails = signInDetails;
    }
    return authUser;
};
function getSignInDetailsFromTokens(tokens) {
    return tokens?.signInDetails;
}


//# sourceMappingURL=getCurrentUser.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/resendSignUpCode.mjs":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/resendSignUpCode.mjs ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   resendSignUpCode: () => (/* binding */ resendSignUpCode)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createResendConfirmationCodeClient_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createResendConfirmationCodeClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createResendConfirmationCodeClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Resend the confirmation code while signing up
 *
 * @param input -  The ResendSignUpCodeInput object
 * @returns ResendSignUpCodeOutput
 * @throws service: {@link ResendConfirmationException } - Cognito service errors thrown when resending the code.
 * @throws validation: {@link AuthValidationErrorCode } - Validation errors thrown either username are not defined.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function resendSignUpCode(input) {
    const { username } = input;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_0__.assertValidationError)(!!username, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthValidationErrorCode.EmptySignUpUsername);
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_3__.assertTokenProviderConfig)(authConfig);
    const { userPoolClientId, userPoolId, userPoolEndpoint } = authConfig;
    const clientMetadata = input.options?.clientMetadata;
    const UserContextData = (0,_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_4__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const resendConfirmationCode = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createResendConfirmationCodeClient_mjs__WEBPACK_IMPORTED_MODULE_5__.createResendConfirmationCodeClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const { CodeDeliveryDetails } = await resendConfirmationCode({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_7__.getRegionFromUserPoolId)(authConfig.userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_8__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_9__.AuthAction.ResendSignUpCode),
    }, {
        Username: username,
        ClientMetadata: clientMetadata,
        ClientId: authConfig.userPoolClientId,
        UserContextData,
    });
    const { DeliveryMedium, AttributeName, Destination } = {
        ...CodeDeliveryDetails,
    };
    return {
        destination: Destination,
        deliveryMedium: DeliveryMedium,
        attributeName: AttributeName
            ? AttributeName
            : undefined,
    };
}


//# sourceMappingURL=resendSignUpCode.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/resetPassword.mjs":
/*!******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/resetPassword.mjs ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   resetPassword: () => (/* binding */ resetPassword)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createForgotPasswordClient_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createForgotPasswordClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createForgotPasswordClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Resets a user's password.
 *
 * @param input -  The ResetPasswordInput object.
 * @returns ResetPasswordOutput
 * @throws -{@link ForgotPasswordException }
 * Thrown due to an invalid confirmation code or password.
 * @throws -{@link AuthValidationErrorCode }
 * Thrown due to an empty username.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 **/
async function resetPassword(input) {
    const { username } = input;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_0__.assertValidationError)(!!username, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthValidationErrorCode.EmptyResetPasswordUsername);
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_3__.assertTokenProviderConfig)(authConfig);
    const { userPoolClientId, userPoolId, userPoolEndpoint } = authConfig;
    const clientMetadata = input.options?.clientMetadata;
    const UserContextData = (0,_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_4__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const forgotPassword = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createForgotPasswordClient_mjs__WEBPACK_IMPORTED_MODULE_5__.createForgotPasswordClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_6__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const res = await forgotPassword({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_7__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_8__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_9__.AuthAction.ResetPassword),
    }, {
        Username: username,
        ClientMetadata: clientMetadata,
        ClientId: userPoolClientId,
        UserContextData,
    });
    const codeDeliveryDetails = res.CodeDeliveryDetails;
    return {
        isPasswordReset: false,
        nextStep: {
            resetPasswordStep: 'CONFIRM_RESET_PASSWORD_WITH_CODE',
            codeDeliveryDetails: {
                deliveryMedium: codeDeliveryDetails?.DeliveryMedium,
                destination: codeDeliveryDetails?.Destination,
                attributeName: codeDeliveryDetails?.AttributeName,
            },
        },
    };
}


//# sourceMappingURL=resetPassword.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/sendUserAttributeVerificationCode.mjs":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/sendUserAttributeVerificationCode.mjs ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sendUserAttributeVerificationCode: () => (/* binding */ sendUserAttributeVerificationCode)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/apis/fetchAuthSession.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _utils_types_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/types.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/types.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createGetUserAttributeVerificationCodeClient_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createGetUserAttributeVerificationCodeClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createGetUserAttributeVerificationCodeClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Resends user's confirmation code when updating attributes while authenticated.
 *
 * @param input - The SendUserAttributeVerificationCodeInput object
 * @returns SendUserAttributeVerificationCodeOutput
 * @throws - {@link GetUserAttributeVerificationException}
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
const sendUserAttributeVerificationCode = async (input) => {
    const { userAttributeKey, options } = input;
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    const clientMetadata = options?.clientMetadata;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const { userPoolEndpoint, userPoolId } = authConfig;
    const { tokens } = await (0,_aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__.fetchAuthSession)({ forceRefresh: false });
    (0,_utils_types_mjs__WEBPACK_IMPORTED_MODULE_3__.assertAuthTokens)(tokens);
    const getUserAttributeVerificationCode = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createGetUserAttributeVerificationCodeClient_mjs__WEBPACK_IMPORTED_MODULE_4__.createGetUserAttributeVerificationCodeClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_5__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const { CodeDeliveryDetails } = await getUserAttributeVerificationCode({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_6__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_7__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_8__.AuthAction.SendUserAttributeVerificationCode),
    }, {
        AccessToken: tokens.accessToken.toString(),
        ClientMetadata: clientMetadata,
        AttributeName: userAttributeKey,
    });
    const { DeliveryMedium, AttributeName, Destination } = {
        ...CodeDeliveryDetails,
    };
    return {
        destination: Destination,
        deliveryMedium: DeliveryMedium,
        attributeName: AttributeName,
    };
};


//# sourceMappingURL=sendUserAttributeVerificationCode.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signIn.mjs":
/*!***********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signIn.mjs ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   signIn: () => (/* binding */ signIn)
/* harmony export */ });
/* harmony import */ var _utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/signInHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signInHelpers.mjs");
/* harmony import */ var _signInWithCustomAuth_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./signInWithCustomAuth.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithCustomAuth.mjs");
/* harmony import */ var _signInWithCustomSRPAuth_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./signInWithCustomSRPAuth.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithCustomSRPAuth.mjs");
/* harmony import */ var _signInWithSRP_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./signInWithSRP.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithSRP.mjs");
/* harmony import */ var _signInWithUserPassword_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./signInWithUserPassword.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithUserPassword.mjs");
/* harmony import */ var _signInWithUserAuth_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./signInWithUserAuth.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithUserAuth.mjs");
/* harmony import */ var _autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./autoSignIn.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/autoSignIn.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Signs a user in
 *
 * @param input -  The SignInInput object
 * @returns SignInOutput
 * @throws service: {@link InitiateAuthException }, {@link RespondToAuthChallengeException }
 *  - Cognito service errors thrown during the sign-in process.
 * @throws validation: {@link AuthValidationErrorCode  } - Validation errors thrown when either username or password
 *  are not defined.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function signIn(input) {
    // Here we want to reset the store but not reassign the callback.
    // The callback is reset when the underlying promise resolves or rejects.
    // With the advent of session based sign in, this guarantees that the signIn API initiates a new auth flow,
    // regardless of whether it is called for a user currently engaged in an active auto sign in session.
    (0,_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_0__.resetAutoSignIn)(false);
    const authFlowType = input.options?.authFlowType;
    await (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_1__.assertUserNotAuthenticated)();
    switch (authFlowType) {
        case 'USER_SRP_AUTH':
            return (0,_signInWithSRP_mjs__WEBPACK_IMPORTED_MODULE_2__.signInWithSRP)(input);
        case 'USER_PASSWORD_AUTH':
            return (0,_signInWithUserPassword_mjs__WEBPACK_IMPORTED_MODULE_3__.signInWithUserPassword)(input);
        case 'CUSTOM_WITHOUT_SRP':
            return (0,_signInWithCustomAuth_mjs__WEBPACK_IMPORTED_MODULE_4__.signInWithCustomAuth)(input);
        case 'CUSTOM_WITH_SRP':
            return (0,_signInWithCustomSRPAuth_mjs__WEBPACK_IMPORTED_MODULE_5__.signInWithCustomSRPAuth)(input);
        case 'USER_AUTH':
            return (0,_signInWithUserAuth_mjs__WEBPACK_IMPORTED_MODULE_6__.signInWithUserAuth)(input);
        default:
            return (0,_signInWithSRP_mjs__WEBPACK_IMPORTED_MODULE_2__.signInWithSRP)(input);
    }
}


//# sourceMappingURL=signIn.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithCustomAuth.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithCustomAuth.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   signInWithCustomAuth: () => (/* binding */ signInWithCustomAuth)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../errors/utils/assertServiceError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertServiceError.mjs");
/* harmony import */ var _utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/signInHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signInHelpers.mjs");
/* harmony import */ var _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../client/utils/store/signInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs");
/* harmony import */ var _tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../tokenProvider/cacheTokens.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/cacheTokens.mjs");
/* harmony import */ var _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../tokenProvider/tokenProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/tokenProvider.mjs");
/* harmony import */ var _utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/dispatchSignedInHubEvent.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/dispatchSignedInHubEvent.mjs");
/* harmony import */ var _utils_retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/retryOnResourceNotFoundException.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/retryOnResourceNotFoundException.mjs");
/* harmony import */ var _utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/getNewDeviceMetadata.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/getNewDeviceMetadata.mjs");
















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Signs a user in using a custom authentication flow without password
 *
 * @param input -  The SignInWithCustomAuthInput object
 * @returns AuthSignInResult
 * @throws service: {@link InitiateAuthException } - Cognito service errors thrown during the sign-in process.
 * @throws validation: {@link AuthValidationErrorCode  } - Validation errors thrown when either username or password
 *  are not defined.
 * @throws SignInWithCustomAuthOutput - Thrown when the token provider config is invalid.
 */
async function signInWithCustomAuth(input) {
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const { username, password, options } = input;
    const signInDetails = {
        loginId: username,
        authFlowType: 'CUSTOM_WITHOUT_SRP',
    };
    const metadata = options?.clientMetadata;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!username, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptySignInUsername);
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!password, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.CustomAuthSignInPassword);
    try {
        const { ChallengeName: retriedChallengeName, ChallengeParameters: retiredChallengeParameters, AuthenticationResult, Session, } = await (0,_utils_retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_4__.retryOnResourceNotFoundException)(_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_5__.handleCustomAuthFlowWithoutSRP, [username, metadata, authConfig, _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_6__.tokenOrchestrator], username, _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_6__.tokenOrchestrator);
        const activeUsername = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_5__.getActiveSignInUsername)(username);
        // sets up local state used during the sign-in process
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_7__.setActiveSignInState)({
            signInSession: Session,
            username: activeUsername,
            challengeName: retriedChallengeName,
            signInDetails,
        });
        if (AuthenticationResult) {
            await (0,_tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_8__.cacheCognitoTokens)({
                username: activeUsername,
                ...AuthenticationResult,
                NewDeviceMetadata: await (0,_utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_9__.getNewDeviceMetadata)({
                    userPoolId: authConfig.userPoolId,
                    userPoolEndpoint: authConfig.userPoolEndpoint,
                    newDeviceMetadata: AuthenticationResult.NewDeviceMetadata,
                    accessToken: AuthenticationResult.AccessToken,
                }),
                signInDetails,
            });
            (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_7__.resetActiveSignInState)();
            await (0,_utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_10__.dispatchSignedInHubEvent)();
            return {
                isSignedIn: true,
                nextStep: { signInStep: 'DONE' },
            };
        }
        return (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_5__.getSignInResult)({
            challengeName: retriedChallengeName,
            challengeParameters: retiredChallengeParameters,
        });
    }
    catch (error) {
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_7__.resetActiveSignInState)();
        (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_11__.assertServiceError)(error);
        const result = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_5__.getSignInResultFromError)(error.name);
        if (result)
            return result;
        throw error;
    }
}


//# sourceMappingURL=signInWithCustomAuth.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithCustomSRPAuth.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithCustomSRPAuth.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   signInWithCustomSRPAuth: () => (/* binding */ signInWithCustomSRPAuth)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../errors/utils/assertServiceError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertServiceError.mjs");
/* harmony import */ var _utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/signInHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signInHelpers.mjs");
/* harmony import */ var _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../client/utils/store/signInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs");
/* harmony import */ var _tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../tokenProvider/cacheTokens.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/cacheTokens.mjs");
/* harmony import */ var _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../tokenProvider/tokenProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/tokenProvider.mjs");
/* harmony import */ var _utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/dispatchSignedInHubEvent.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/dispatchSignedInHubEvent.mjs");
/* harmony import */ var _utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/getNewDeviceMetadata.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/getNewDeviceMetadata.mjs");















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Signs a user in using a custom authentication flow with SRP
 *
 * @param input -  The SignInWithCustomSRPAuthInput object
 * @returns SignInWithCustomSRPAuthOutput
 * @throws service: {@link InitiateAuthException }, {@link RespondToAuthChallengeException } - Cognito
 * service errors thrown during the sign-in process.
 * @throws validation: {@link AuthValidationErrorCode  } - Validation errors thrown when either username or password
 *  are not defined.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function signInWithCustomSRPAuth(input) {
    const { username, password, options } = input;
    const signInDetails = {
        loginId: username,
        authFlowType: 'CUSTOM_WITH_SRP',
    };
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const metadata = options?.clientMetadata;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!username, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptySignInUsername);
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!password, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptySignInPassword);
    try {
        const { ChallengeName: handledChallengeName, ChallengeParameters: handledChallengeParameters, AuthenticationResult, Session, } = await (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__.handleCustomSRPAuthFlow)(username, password, metadata, authConfig, _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_5__.tokenOrchestrator);
        const activeUsername = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__.getActiveSignInUsername)(username);
        // sets up local state used during the sign-in process
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_6__.setActiveSignInState)({
            signInSession: Session,
            username: activeUsername,
            challengeName: handledChallengeName,
            signInDetails,
        });
        if (AuthenticationResult) {
            await (0,_tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_7__.cacheCognitoTokens)({
                username: activeUsername,
                ...AuthenticationResult,
                NewDeviceMetadata: await (0,_utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_8__.getNewDeviceMetadata)({
                    userPoolId: authConfig.userPoolId,
                    userPoolEndpoint: authConfig.userPoolEndpoint,
                    newDeviceMetadata: AuthenticationResult.NewDeviceMetadata,
                    accessToken: AuthenticationResult.AccessToken,
                }),
                signInDetails,
            });
            (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_6__.resetActiveSignInState)();
            await (0,_utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_9__.dispatchSignedInHubEvent)();
            return {
                isSignedIn: true,
                nextStep: { signInStep: 'DONE' },
            };
        }
        return (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__.getSignInResult)({
            challengeName: handledChallengeName,
            challengeParameters: handledChallengeParameters,
        });
    }
    catch (error) {
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_6__.resetActiveSignInState)();
        (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_10__.assertServiceError)(error);
        const result = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__.getSignInResultFromError)(error.name);
        if (result)
            return result;
        throw error;
    }
}


//# sourceMappingURL=signInWithCustomSRPAuth.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithRedirect.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithRedirect.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   signInWithRedirect: () => (/* binding */ signInWithRedirect)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/urlSafeEncode.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/isBrowser.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _utils_oauth_enableOAuthListener_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/oauth/enableOAuthListener.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/enableOAuthListener.mjs");
/* harmony import */ var _types_models_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../types/models.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/types/models.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _utils_openAuthSession_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../utils/openAuthSession.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/openAuthSession.mjs");
/* harmony import */ var _utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/signInHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signInHelpers.mjs");
/* harmony import */ var _utils_oauth_generateCodeVerifier_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/oauth/generateCodeVerifier.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/generateCodeVerifier.mjs");
/* harmony import */ var _utils_oauth_generateState_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/oauth/generateState.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/generateState.mjs");
/* harmony import */ var _utils_oauth_oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/oauth/oAuthStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/oAuthStore.mjs");
/* harmony import */ var _utils_oauth_getRedirectUrl_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/oauth/getRedirectUrl.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/getRedirectUrl.mjs");
/* harmony import */ var _utils_oauth_handleFailure_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../utils/oauth/handleFailure.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/handleFailure.mjs");
/* harmony import */ var _utils_oauth_completeOAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../utils/oauth/completeOAuthFlow.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/completeOAuthFlow.mjs");
/* harmony import */ var _utils_oauth_createOAuthError_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/oauth/createOAuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/createOAuthError.mjs");
/* harmony import */ var _utils_oauth_cancelOAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../utils/oauth/cancelOAuthFlow.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/cancelOAuthFlow.mjs");




















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Signs in a user with OAuth. Redirects the application to an Identity Provider.
 *
 * @param input - The SignInWithRedirectInput object, if empty it will redirect to Cognito HostedUI
 *
 * @throws AuthTokenConfigException - Thrown when the user pool config is invalid.
 * @throws OAuthNotConfigureException - Thrown when the oauth config is invalid.
 */
async function signInWithRedirect(input) {
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__.assertTokenProviderConfig)(authConfig);
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__.assertOAuthConfig)(authConfig);
    _utils_oauth_oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_3__.oAuthStore.setAuthConfig(authConfig);
    if (!input?.options?.prompt) {
        await (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__.assertUserNotAuthenticated)();
    }
    let provider = 'COGNITO'; // Default
    if (typeof input?.provider === 'string') {
        provider = _types_models_mjs__WEBPACK_IMPORTED_MODULE_5__.cognitoHostedUIIdentityProviderMap[input.provider];
    }
    else if (input?.provider?.custom) {
        provider = input.provider.custom;
    }
    return oauthSignIn({
        oauthConfig: authConfig.loginWith.oauth,
        clientId: authConfig.userPoolClientId,
        provider,
        customState: input?.customState,
        preferPrivateSession: input?.options?.preferPrivateSession,
        options: {
            loginHint: input?.options?.loginHint,
            lang: input?.options?.lang,
            nonce: input?.options?.nonce,
            prompt: input?.options?.prompt,
        },
        authSessionOpener: input?.options?.authSessionOpener,
    });
}
const oauthSignIn = async ({ oauthConfig, provider, clientId, customState, preferPrivateSession, options, authSessionOpener, }) => {
    const { domain, redirectSignIn, responseType, scopes } = oauthConfig;
    const { loginHint, lang, nonce, prompt } = options ?? {};
    const randomState = (0,_utils_oauth_generateState_mjs__WEBPACK_IMPORTED_MODULE_6__.generateState)();
    const openAuthSession$1 = authSessionOpener || _utils_openAuthSession_mjs__WEBPACK_IMPORTED_MODULE_7__.openAuthSession;
    /* encodeURIComponent is not URL safe, use urlSafeEncode instead. Cognito
    single-encodes/decodes url on first sign in and double-encodes/decodes url
    when user already signed in. Using encodeURIComponent, Base32, Base64 add
    characters % or = which on further encoding becomes unsafe. '=' create issue
    for parsing query params.
    Refer: https://github.com/aws-amplify/amplify-js/issues/5218 */
    const state = customState
        ? `${randomState}-${(0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_8__.urlSafeEncode)(customState)}`
        : randomState;
    const { value, method, toCodeChallenge } = (0,_utils_oauth_generateCodeVerifier_mjs__WEBPACK_IMPORTED_MODULE_9__.generateCodeVerifier)(128);
    const redirectUri = (0,_utils_oauth_getRedirectUrl_mjs__WEBPACK_IMPORTED_MODULE_10__.getRedirectUrl)(oauthConfig.redirectSignIn);
    if ((0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_11__.isBrowser)())
        _utils_oauth_oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_3__.oAuthStore.storeOAuthInFlight(true);
    _utils_oauth_oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_3__.oAuthStore.storeOAuthState(state);
    _utils_oauth_oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_3__.oAuthStore.storePKCE(value);
    const params = new URLSearchParams([
        ['redirect_uri', redirectUri],
        ['response_type', responseType],
        ['client_id', clientId],
        ['identity_provider', provider],
        ['scope', scopes.join(' ')],
    ]);
    loginHint && params.append('login_hint', loginHint);
    lang && params.append('lang', lang);
    nonce && params.append('nonce', nonce);
    prompt && params.append('prompt', prompt.toLowerCase());
    params.append('state', state);
    if (responseType === 'code') {
        params.append('code_challenge', toCodeChallenge());
        params.append('code_challenge_method', method);
    }
    const oAuthUrl = new URL('/oauth2/authorize', `https://${domain}/`);
    oAuthUrl.search = params.toString();
    // this will only take effect in the following scenarios:
    // 1. the user cancels the OAuth flow on web via back button, and
    // 2. when bfcache is enabled
    (0,_utils_oauth_cancelOAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_12__.listenForOAuthFlowCancellation)(_utils_oauth_oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_3__.oAuthStore);
    // the following is effective only in react-native as openAuthSession resolves only in react-native
    const { type, error, url } = (await openAuthSession$1(oAuthUrl.href, redirectSignIn, preferPrivateSession)) ?? {};
    try {
        if (type === 'error') {
            throw (0,_utils_oauth_createOAuthError_mjs__WEBPACK_IMPORTED_MODULE_13__.createOAuthError)(String(error));
        }
        if (type === 'success' && url) {
            await (0,_utils_oauth_completeOAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_14__.completeOAuthFlow)({
                currentUrl: url,
                clientId,
                domain,
                redirectUri,
                responseType,
                userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_15__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_16__.AuthAction.SignInWithRedirect),
                preferPrivateSession,
            });
        }
    }
    catch (err) {
        await (0,_utils_oauth_handleFailure_mjs__WEBPACK_IMPORTED_MODULE_17__.handleFailure)(err);
        // rethrow the error so it can be caught by `await signInWithRedirect()` in react-native
        throw err;
    }
};


//# sourceMappingURL=signInWithRedirect.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithSRP.mjs":
/*!******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithSRP.mjs ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   signInWithSRP: () => (/* binding */ signInWithSRP)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../errors/utils/assertServiceError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertServiceError.mjs");
/* harmony import */ var _utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/signInHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signInHelpers.mjs");
/* harmony import */ var _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../client/utils/store/signInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs");
/* harmony import */ var _tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../tokenProvider/cacheTokens.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/cacheTokens.mjs");
/* harmony import */ var _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../tokenProvider/tokenProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/tokenProvider.mjs");
/* harmony import */ var _utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/dispatchSignedInHubEvent.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/dispatchSignedInHubEvent.mjs");
/* harmony import */ var _utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/getNewDeviceMetadata.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/getNewDeviceMetadata.mjs");
/* harmony import */ var _autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./autoSignIn.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/autoSignIn.mjs");
















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Signs a user in
 *
 * @param input - The SignInWithSRPInput object
 * @returns SignInWithSRPOutput
 * @throws service: {@link InitiateAuthException }, {@link RespondToAuthChallengeException } - Cognito service errors
 * thrown during the sign-in process.
 * @throws validation: {@link AuthValidationErrorCode  } - Validation errors thrown when either username or password
 *  are not defined.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function signInWithSRP(input) {
    const { username, password } = input;
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    const signInDetails = {
        loginId: username,
        authFlowType: 'USER_SRP_AUTH',
    };
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const clientMetaData = input.options?.clientMetadata;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!username, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptySignInUsername);
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!password, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptySignInPassword);
    try {
        const { ChallengeName: handledChallengeName, ChallengeParameters: handledChallengeParameters, AuthenticationResult, Session, } = await (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__.handleUserSRPAuthFlow)(username, password, clientMetaData, authConfig, _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_5__.tokenOrchestrator);
        const activeUsername = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__.getActiveSignInUsername)(username);
        // sets up local state used during the sign-in process
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_6__.setActiveSignInState)({
            signInSession: Session,
            username: activeUsername,
            challengeName: handledChallengeName,
            signInDetails,
        });
        if (AuthenticationResult) {
            await (0,_tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_7__.cacheCognitoTokens)({
                username: activeUsername,
                ...AuthenticationResult,
                NewDeviceMetadata: await (0,_utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_8__.getNewDeviceMetadata)({
                    userPoolId: authConfig.userPoolId,
                    userPoolEndpoint: authConfig.userPoolEndpoint,
                    newDeviceMetadata: AuthenticationResult.NewDeviceMetadata,
                    accessToken: AuthenticationResult.AccessToken,
                }),
                signInDetails,
            });
            (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_6__.resetActiveSignInState)();
            await (0,_utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_9__.dispatchSignedInHubEvent)();
            (0,_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_10__.resetAutoSignIn)();
            return {
                isSignedIn: true,
                nextStep: { signInStep: 'DONE' },
            };
        }
        return (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__.getSignInResult)({
            challengeName: handledChallengeName,
            challengeParameters: handledChallengeParameters,
        });
    }
    catch (error) {
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_6__.resetActiveSignInState)();
        (0,_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_10__.resetAutoSignIn)();
        (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_11__.assertServiceError)(error);
        const result = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_4__.getSignInResultFromError)(error.name);
        if (result)
            return result;
        throw error;
    }
}


//# sourceMappingURL=signInWithSRP.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithUserAuth.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithUserAuth.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   signInWithUserAuth: () => (/* binding */ signInWithUserAuth)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../errors/utils/assertServiceError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertServiceError.mjs");
/* harmony import */ var _utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/signInHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signInHelpers.mjs");
/* harmony import */ var _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../client/utils/store/autoSignInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/autoSignInStore.mjs");
/* harmony import */ var _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../client/utils/store/signInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs");
/* harmony import */ var _tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../tokenProvider/cacheTokens.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/cacheTokens.mjs");
/* harmony import */ var _utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../utils/dispatchSignedInHubEvent.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/dispatchSignedInHubEvent.mjs");
/* harmony import */ var _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../tokenProvider/tokenProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/tokenProvider.mjs");
/* harmony import */ var _client_flows_userAuth_handleUserAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../client/flows/userAuth/handleUserAuthFlow.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleUserAuthFlow.mjs");
/* harmony import */ var _utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/getNewDeviceMetadata.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/getNewDeviceMetadata.mjs");
/* harmony import */ var _autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./autoSignIn.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/autoSignIn.mjs");


















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Signs a user in through a registered email or phone number without a password by by receiving and entering an OTP.
 *
 * @param input - The SignInWithUserAuthInput object
 * @returns SignInWithUserAuthOutput
 * @throws service: {@link InitiateAuthException }, {@link RespondToAuthChallengeException } - Cognito service errors
 * thrown during the sign-in process.
 * @throws validation: {@link AuthValidationErrorCode  } - Validation errors thrown when either username or password -- needs to change
 *  are not defined.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function signInWithUserAuth(input) {
    const { username, password, options } = input;
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    const signInDetails = {
        loginId: username,
        authFlowType: 'USER_AUTH',
    };
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const clientMetaData = options?.clientMetadata;
    const preferredChallenge = options?.preferredChallenge;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!username, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptySignInUsername);
    try {
        const handleUserAuthFlowInput = {
            username,
            config: authConfig,
            tokenOrchestrator: _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_4__.tokenOrchestrator,
            clientMetadata: clientMetaData,
            preferredChallenge,
            password,
        };
        const autoSignInStoreState = _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_5__.autoSignInStore.getState();
        if (autoSignInStoreState.active &&
            autoSignInStoreState.username === username) {
            handleUserAuthFlowInput.session = autoSignInStoreState.session;
        }
        const response = await (0,_client_flows_userAuth_handleUserAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_6__.handleUserAuthFlow)(handleUserAuthFlowInput);
        const activeUsername = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_7__.getActiveSignInUsername)(username);
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_8__.setActiveSignInState)({
            signInSession: response.Session,
            username: activeUsername,
            challengeName: response.ChallengeName,
            signInDetails,
        });
        if (response.AuthenticationResult) {
            await (0,_tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_9__.cacheCognitoTokens)({
                username: activeUsername,
                ...response.AuthenticationResult,
                NewDeviceMetadata: await (0,_utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_10__.getNewDeviceMetadata)({
                    userPoolId: authConfig.userPoolId,
                    userPoolEndpoint: authConfig.userPoolEndpoint,
                    newDeviceMetadata: response.AuthenticationResult.NewDeviceMetadata,
                    accessToken: response.AuthenticationResult.AccessToken,
                }),
                signInDetails,
            });
            (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_8__.resetActiveSignInState)();
            await (0,_utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_11__.dispatchSignedInHubEvent)();
            (0,_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_12__.resetAutoSignIn)();
            return {
                isSignedIn: true,
                nextStep: { signInStep: 'DONE' },
            };
        }
        return (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_7__.getSignInResult)({
            challengeName: response.ChallengeName,
            challengeParameters: response.ChallengeParameters,
            availableChallenges: 'AvailableChallenges' in response
                ? response.AvailableChallenges
                : undefined,
        });
    }
    catch (error) {
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_8__.resetActiveSignInState)();
        (0,_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_12__.resetAutoSignIn)();
        (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_13__.assertServiceError)(error);
        const result = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_7__.getSignInResultFromError)(error.name);
        if (result)
            return result;
        throw error;
    }
}


//# sourceMappingURL=signInWithUserAuth.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithUserPassword.mjs":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithUserPassword.mjs ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   signInWithUserPassword: () => (/* binding */ signInWithUserPassword)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../errors/utils/assertServiceError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertServiceError.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/signInHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signInHelpers.mjs");
/* harmony import */ var _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../client/utils/store/signInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs");
/* harmony import */ var _tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../tokenProvider/cacheTokens.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/cacheTokens.mjs");
/* harmony import */ var _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../tokenProvider/tokenProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/tokenProvider.mjs");
/* harmony import */ var _utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/dispatchSignedInHubEvent.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/dispatchSignedInHubEvent.mjs");
/* harmony import */ var _utils_retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/retryOnResourceNotFoundException.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/retryOnResourceNotFoundException.mjs");
/* harmony import */ var _utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/getNewDeviceMetadata.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/getNewDeviceMetadata.mjs");
/* harmony import */ var _autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./autoSignIn.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/autoSignIn.mjs");

















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Signs a user in using USER_PASSWORD_AUTH AuthFlowType
 *
 * @param input - The SignInWithUserPasswordInput object
 * @returns SignInWithUserPasswordOutput
 * @throws service: {@link InitiateAuthException } - Cognito service error thrown during the sign-in process.
 * @throws validation: {@link AuthValidationErrorCode  } - Validation errors thrown when either username or password
 *  are not defined.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function signInWithUserPassword(input) {
    const { username, password, options } = input;
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    const signInDetails = {
        loginId: username,
        authFlowType: 'USER_PASSWORD_AUTH',
    };
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const metadata = options?.clientMetadata;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!username, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptySignInUsername);
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!password, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptySignInPassword);
    try {
        const { ChallengeName: retiredChallengeName, ChallengeParameters: retriedChallengeParameters, AuthenticationResult, Session, } = await (0,_utils_retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_4__.retryOnResourceNotFoundException)(_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_5__.handleUserPasswordAuthFlow, [username, password, metadata, authConfig, _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_6__.tokenOrchestrator], username, _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_6__.tokenOrchestrator);
        const activeUsername = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_5__.getActiveSignInUsername)(username);
        // sets up local state used during the sign-in process
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_7__.setActiveSignInState)({
            signInSession: Session,
            username: activeUsername,
            challengeName: retiredChallengeName,
            signInDetails,
        });
        if (AuthenticationResult) {
            await (0,_tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_8__.cacheCognitoTokens)({
                ...AuthenticationResult,
                username: activeUsername,
                NewDeviceMetadata: await (0,_utils_getNewDeviceMetadata_mjs__WEBPACK_IMPORTED_MODULE_9__.getNewDeviceMetadata)({
                    userPoolId: authConfig.userPoolId,
                    userPoolEndpoint: authConfig.userPoolEndpoint,
                    newDeviceMetadata: AuthenticationResult.NewDeviceMetadata,
                    accessToken: AuthenticationResult.AccessToken,
                }),
                signInDetails,
            });
            (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_7__.resetActiveSignInState)();
            await (0,_utils_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_10__.dispatchSignedInHubEvent)();
            (0,_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_11__.resetAutoSignIn)();
            return {
                isSignedIn: true,
                nextStep: { signInStep: 'DONE' },
            };
        }
        return (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_5__.getSignInResult)({
            challengeName: retiredChallengeName,
            challengeParameters: retriedChallengeParameters,
        });
    }
    catch (error) {
        (0,_client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_7__.resetActiveSignInState)();
        (0,_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_11__.resetAutoSignIn)();
        (0,_errors_utils_assertServiceError_mjs__WEBPACK_IMPORTED_MODULE_12__.assertServiceError)(error);
        const result = (0,_utils_signInHelpers_mjs__WEBPACK_IMPORTED_MODULE_5__.getSignInResultFromError)(error.name);
        if (result)
            return result;
        throw error;
    }
}


//# sourceMappingURL=signInWithUserPassword.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signUp.mjs":
/*!***********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signUp.mjs ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   signUp: () => (/* binding */ signUp)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_apiHelpers_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/apiHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/apiHelpers.mjs");
/* harmony import */ var _utils_signUpHelpers_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/signUpHelpers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signUpHelpers.mjs");
/* harmony import */ var _utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createSignUpClient_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createSignUpClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createSignUpClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../client/utils/store/autoSignInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/autoSignInStore.mjs");
/* harmony import */ var _autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./autoSignIn.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/autoSignIn.mjs");



















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Creates a user
 *
 * @param input - The SignUpInput object
 * @returns SignUpOutput
 * @throws service: {@link SignUpException } - Cognito service errors thrown during the sign-up process.
 * @throws validation: {@link AuthValidationErrorCode } - Validation errors thrown either username or password
 *  are not defined.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function signUp(input) {
    const { username, password, options } = input;
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    const signUpVerificationMethod = authConfig?.signUpVerificationMethod ?? 'code';
    const { clientMetadata, validationData, autoSignIn } = input.options ?? {};
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!username, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptySignUpUsername);
    const signInServiceOptions = typeof autoSignIn !== 'boolean' ? autoSignIn : undefined;
    const signInInput = {
        username,
        options: signInServiceOptions,
    };
    // if the authFlowType is 'CUSTOM_WITHOUT_SRP' then we don't include the password
    if (signInServiceOptions?.authFlowType !== 'CUSTOM_WITHOUT_SRP') {
        signInInput.password = password;
    }
    const { userPoolId, userPoolClientId, userPoolEndpoint } = authConfig;
    const signUpClient = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createSignUpClient_mjs__WEBPACK_IMPORTED_MODULE_4__.createSignUpClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_5__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const signUpClientInput = {
        Username: username,
        Password: undefined,
        UserAttributes: options?.userAttributes && (0,_utils_apiHelpers_mjs__WEBPACK_IMPORTED_MODULE_6__.toAttributeType)(options?.userAttributes),
        ClientMetadata: clientMetadata,
        ValidationData: validationData && (0,_utils_apiHelpers_mjs__WEBPACK_IMPORTED_MODULE_6__.toAttributeType)(validationData),
        ClientId: userPoolClientId,
        UserContextData: (0,_utils_userContextData_mjs__WEBPACK_IMPORTED_MODULE_7__.getUserContextData)({
            username,
            userPoolId,
            userPoolClientId,
        }),
    };
    if (password) {
        signUpClientInput.Password = password;
    }
    const { UserSub: userId, CodeDeliveryDetails: cdd, UserConfirmed: userConfirmed, Session: session, } = await signUpClient({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_8__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_9__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_10__.AuthAction.SignUp),
    }, signUpClientInput);
    if (signInServiceOptions || autoSignIn === true) {
        _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_11__.autoSignInStore.dispatch({ type: 'START' });
        _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_11__.autoSignInStore.dispatch({ type: 'SET_USERNAME', value: username });
        _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_11__.autoSignInStore.dispatch({ type: 'SET_SESSION', value: session });
    }
    const codeDeliveryDetails = {
        destination: cdd?.Destination,
        deliveryMedium: cdd?.DeliveryMedium,
        attributeName: cdd?.AttributeName,
    };
    const isSignUpComplete = !!userConfirmed;
    const isAutoSignInStarted = _client_utils_store_autoSignInStore_mjs__WEBPACK_IMPORTED_MODULE_11__.autoSignInStore.getState().active;
    // Sign Up Complete
    // No Confirm Sign In Step Required
    if (isSignUpComplete) {
        if (isAutoSignInStarted) {
            (0,_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_12__.setAutoSignIn)((0,_utils_signUpHelpers_mjs__WEBPACK_IMPORTED_MODULE_13__.autoSignInUserConfirmed)(signInInput));
            return {
                isSignUpComplete: true,
                nextStep: {
                    signUpStep: 'COMPLETE_AUTO_SIGN_IN',
                },
                userId,
            };
        }
        return {
            isSignUpComplete: true,
            nextStep: {
                signUpStep: 'DONE',
            },
            userId,
        };
    }
    // Sign Up Not Complete
    // Confirm Sign Up Step Required
    if (isAutoSignInStarted) {
        // Confirmation Via Link Occurs In Separate Context
        // AutoSignIn Fn Will Initiate Polling Once Executed
        if (signUpVerificationMethod === 'link') {
            (0,_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_12__.setAutoSignIn)((0,_utils_signUpHelpers_mjs__WEBPACK_IMPORTED_MODULE_13__.autoSignInWhenUserIsConfirmedWithLink)(signInInput));
            return {
                isSignUpComplete: false,
                nextStep: {
                    signUpStep: 'COMPLETE_AUTO_SIGN_IN',
                    codeDeliveryDetails,
                },
                userId,
            };
        }
        // Confirmation Via Code Occurs In Same Context
        // AutoSignIn Next Step Will Be Returned From Confirm Sign Up
        (0,_utils_signUpHelpers_mjs__WEBPACK_IMPORTED_MODULE_13__.handleCodeAutoSignIn)(signInInput);
    }
    return {
        isSignUpComplete: false,
        nextStep: {
            signUpStep: 'CONFIRM_SIGN_UP',
            codeDeliveryDetails,
        },
        userId,
    };
}


//# sourceMappingURL=signUp.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/updatePassword.mjs":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/updatePassword.mjs ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   updatePassword: () => (/* binding */ updatePassword)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/apis/fetchAuthSession.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _utils_types_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/types.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/types.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createChangePasswordClient_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createChangePasswordClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createChangePasswordClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Updates user's password while authenticated.
 *
 * @param input - The UpdatePasswordInput object.
 * @throws - {@link ChangePasswordException} - Cognito service errors thrown when updating a password.
 * @throws - {@link AuthValidationErrorCode} - Validation errors thrown when oldPassword or newPassword are empty.
 * @throws AuthTokenConfigException - Thrown when the token provider config is invalid.
 */
async function updatePassword(input) {
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.assertTokenProviderConfig)(authConfig);
    const { userPoolEndpoint, userPoolId } = authConfig;
    const { oldPassword, newPassword } = input;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!oldPassword, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptyUpdatePassword);
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_2__.assertValidationError)(!!newPassword, _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthValidationErrorCode.EmptyUpdatePassword);
    const { tokens } = await (0,_aws_amplify_core__WEBPACK_IMPORTED_MODULE_4__.fetchAuthSession)({ forceRefresh: false });
    (0,_utils_types_mjs__WEBPACK_IMPORTED_MODULE_5__.assertAuthTokens)(tokens);
    const changePassword = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createChangePasswordClient_mjs__WEBPACK_IMPORTED_MODULE_6__.createChangePasswordClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_7__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    await changePassword({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_8__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_9__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_10__.AuthAction.UpdatePassword),
    }, {
        AccessToken: tokens.accessToken.toString(),
        PreviousPassword: oldPassword,
        ProposedPassword: newPassword,
    });
}


//# sourceMappingURL=updatePassword.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/cacheTokens.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/cacheTokens.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cacheCognitoTokens: () => (/* binding */ cacheCognitoTokens)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/errors/AmplifyError.mjs");
/* harmony import */ var _tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tokenProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/tokenProvider.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
async function cacheCognitoTokens(AuthenticationResult) {
    if (AuthenticationResult.AccessToken) {
        const accessToken = (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.decodeJWT)(AuthenticationResult.AccessToken);
        const accessTokenIssuedAtInMillis = (accessToken.payload.iat || 0) * 1000;
        const currentTime = new Date().getTime();
        const clockDrift = accessTokenIssuedAtInMillis > 0
            ? accessTokenIssuedAtInMillis - currentTime
            : 0;
        let idToken;
        let refreshToken;
        let deviceMetadata;
        if (AuthenticationResult.RefreshToken) {
            refreshToken = AuthenticationResult.RefreshToken;
        }
        if (AuthenticationResult.IdToken) {
            idToken = (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.decodeJWT)(AuthenticationResult.IdToken);
        }
        if (AuthenticationResult?.NewDeviceMetadata) {
            deviceMetadata = AuthenticationResult.NewDeviceMetadata;
        }
        const tokens = {
            accessToken,
            idToken,
            refreshToken,
            clockDrift,
            deviceMetadata,
            username: AuthenticationResult.username,
        };
        if (AuthenticationResult?.signInDetails) {
            tokens.signInDetails = AuthenticationResult.signInDetails;
        }
        await _tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_1__.tokenOrchestrator.setTokens({
            tokens,
        });
    }
    else {
        // This would be a service error
        throw new _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__.AmplifyError({
            message: 'Invalid tokens',
            name: 'InvalidTokens',
            recoverySuggestion: 'Check Cognito UserPool settings',
        });
    }
}


//# sourceMappingURL=cacheTokens.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/types/errors.mjs":
/*!************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/types/errors.mjs ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AssociateSoftwareTokenException: () => (/* binding */ AssociateSoftwareTokenException),
/* harmony export */   ChangePasswordException: () => (/* binding */ ChangePasswordException),
/* harmony export */   ConfirmDeviceException: () => (/* binding */ ConfirmDeviceException),
/* harmony export */   ConfirmForgotPasswordException: () => (/* binding */ ConfirmForgotPasswordException),
/* harmony export */   ConfirmSignUpException: () => (/* binding */ ConfirmSignUpException),
/* harmony export */   DeleteUserAttributesException: () => (/* binding */ DeleteUserAttributesException),
/* harmony export */   DeleteUserException: () => (/* binding */ DeleteUserException),
/* harmony export */   ForgetDeviceException: () => (/* binding */ ForgetDeviceException),
/* harmony export */   ForgotPasswordException: () => (/* binding */ ForgotPasswordException),
/* harmony export */   GetCredentialsForIdentityException: () => (/* binding */ GetCredentialsForIdentityException),
/* harmony export */   GetIdException: () => (/* binding */ GetIdException),
/* harmony export */   GetUserAttributeVerificationException: () => (/* binding */ GetUserAttributeVerificationException),
/* harmony export */   GetUserException: () => (/* binding */ GetUserException),
/* harmony export */   GlobalSignOutException: () => (/* binding */ GlobalSignOutException),
/* harmony export */   InitiateAuthException: () => (/* binding */ InitiateAuthException),
/* harmony export */   ListDevicesException: () => (/* binding */ ListDevicesException),
/* harmony export */   ResendConfirmationException: () => (/* binding */ ResendConfirmationException),
/* harmony export */   RespondToAuthChallengeException: () => (/* binding */ RespondToAuthChallengeException),
/* harmony export */   SETUP_TOTP_EXCEPTION: () => (/* binding */ SETUP_TOTP_EXCEPTION),
/* harmony export */   SetUserMFAPreferenceException: () => (/* binding */ SetUserMFAPreferenceException),
/* harmony export */   SignUpException: () => (/* binding */ SignUpException),
/* harmony export */   UpdateDeviceStatusException: () => (/* binding */ UpdateDeviceStatusException),
/* harmony export */   UpdateUserAttributesException: () => (/* binding */ UpdateUserAttributesException),
/* harmony export */   VerifySoftwareTokenException: () => (/* binding */ VerifySoftwareTokenException),
/* harmony export */   VerifyUserAttributeException: () => (/* binding */ VerifyUserAttributeException)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
var AssociateSoftwareTokenException;
(function (AssociateSoftwareTokenException) {
    AssociateSoftwareTokenException["ConcurrentModificationException"] = "ConcurrentModificationException";
    AssociateSoftwareTokenException["ForbiddenException"] = "ForbiddenException";
    AssociateSoftwareTokenException["InternalErrorException"] = "InternalErrorException";
    AssociateSoftwareTokenException["InvalidParameterException"] = "InvalidParameterException";
    AssociateSoftwareTokenException["NotAuthorizedException"] = "NotAuthorizedException";
    AssociateSoftwareTokenException["ResourceNotFoundException"] = "ResourceNotFoundException";
    AssociateSoftwareTokenException["SoftwareTokenMFANotFoundException"] = "SoftwareTokenMFANotFoundException";
})(AssociateSoftwareTokenException || (AssociateSoftwareTokenException = {}));
var ChangePasswordException;
(function (ChangePasswordException) {
    ChangePasswordException["ForbiddenException"] = "ForbiddenException";
    ChangePasswordException["InternalErrorException"] = "InternalErrorException";
    ChangePasswordException["InvalidParameterException"] = "InvalidParameterException";
    ChangePasswordException["InvalidPasswordException"] = "InvalidPasswordException";
    ChangePasswordException["LimitExceededException"] = "LimitExceededException";
    ChangePasswordException["NotAuthorizedException"] = "NotAuthorizedException";
    ChangePasswordException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    ChangePasswordException["ResourceNotFoundException"] = "ResourceNotFoundException";
    ChangePasswordException["TooManyRequestsException"] = "TooManyRequestsException";
    ChangePasswordException["UserNotConfirmedException"] = "UserNotConfirmedException";
    ChangePasswordException["UserNotFoundException"] = "UserNotFoundException";
})(ChangePasswordException || (ChangePasswordException = {}));
var ConfirmDeviceException;
(function (ConfirmDeviceException) {
    ConfirmDeviceException["ForbiddenException"] = "ForbiddenException";
    ConfirmDeviceException["InternalErrorException"] = "InternalErrorException";
    ConfirmDeviceException["InvalidLambdaResponseException"] = "InvalidLambdaResponseException";
    ConfirmDeviceException["InvalidParameterException"] = "InvalidParameterException";
    ConfirmDeviceException["InvalidPasswordException"] = "InvalidPasswordException";
    ConfirmDeviceException["InvalidUserPoolConfigurationException"] = "InvalidUserPoolConfigurationException";
    ConfirmDeviceException["NotAuthorizedException"] = "NotAuthorizedException";
    ConfirmDeviceException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    ConfirmDeviceException["ResourceNotFoundException"] = "ResourceNotFoundException";
    ConfirmDeviceException["TooManyRequestsException"] = "TooManyRequestsException";
    ConfirmDeviceException["UsernameExistsException"] = "UsernameExistsException";
    ConfirmDeviceException["UserNotConfirmedException"] = "UserNotConfirmedException";
    ConfirmDeviceException["UserNotFoundException"] = "UserNotFoundException";
})(ConfirmDeviceException || (ConfirmDeviceException = {}));
var ConfirmForgotPasswordException;
(function (ConfirmForgotPasswordException) {
    ConfirmForgotPasswordException["CodeMismatchException"] = "CodeMismatchException";
    ConfirmForgotPasswordException["ExpiredCodeException"] = "ExpiredCodeException";
    ConfirmForgotPasswordException["ForbiddenException"] = "ForbiddenException";
    ConfirmForgotPasswordException["InternalErrorException"] = "InternalErrorException";
    ConfirmForgotPasswordException["InvalidLambdaResponseException"] = "InvalidLambdaResponseException";
    ConfirmForgotPasswordException["InvalidParameterException"] = "InvalidParameterException";
    ConfirmForgotPasswordException["InvalidPasswordException"] = "InvalidPasswordException";
    ConfirmForgotPasswordException["LimitExceededException"] = "LimitExceededException";
    ConfirmForgotPasswordException["NotAuthorizedException"] = "NotAuthorizedException";
    ConfirmForgotPasswordException["ResourceNotFoundException"] = "ResourceNotFoundException";
    ConfirmForgotPasswordException["TooManyFailedAttemptsException"] = "TooManyFailedAttemptsException";
    ConfirmForgotPasswordException["TooManyRequestsException"] = "TooManyRequestsException";
    ConfirmForgotPasswordException["UnexpectedLambdaException"] = "UnexpectedLambdaException";
    ConfirmForgotPasswordException["UserLambdaValidationException"] = "UserLambdaValidationException";
    ConfirmForgotPasswordException["UserNotConfirmedException"] = "UserNotConfirmedException";
    ConfirmForgotPasswordException["UserNotFoundException"] = "UserNotFoundException";
})(ConfirmForgotPasswordException || (ConfirmForgotPasswordException = {}));
var ConfirmSignUpException;
(function (ConfirmSignUpException) {
    ConfirmSignUpException["AliasExistsException"] = "AliasExistsException";
    ConfirmSignUpException["CodeMismatchException"] = "CodeMismatchException";
    ConfirmSignUpException["ExpiredCodeException"] = "ExpiredCodeException";
    ConfirmSignUpException["ForbiddenException"] = "ForbiddenException";
    ConfirmSignUpException["InternalErrorException"] = "InternalErrorException";
    ConfirmSignUpException["InvalidLambdaResponseException"] = "InvalidLambdaResponseException";
    ConfirmSignUpException["InvalidParameterException"] = "InvalidParameterException";
    ConfirmSignUpException["LimitExceededException"] = "LimitExceededException";
    ConfirmSignUpException["NotAuthorizedException"] = "NotAuthorizedException";
    ConfirmSignUpException["ResourceNotFoundException"] = "ResourceNotFoundException";
    ConfirmSignUpException["TooManyFailedAttemptsException"] = "TooManyFailedAttemptsException";
    ConfirmSignUpException["TooManyRequestsException"] = "TooManyRequestsException";
    ConfirmSignUpException["UnexpectedLambdaException"] = "UnexpectedLambdaException";
    ConfirmSignUpException["UserLambdaValidationException"] = "UserLambdaValidationException";
    ConfirmSignUpException["UserNotFoundException"] = "UserNotFoundException";
})(ConfirmSignUpException || (ConfirmSignUpException = {}));
var DeleteUserAttributesException;
(function (DeleteUserAttributesException) {
    DeleteUserAttributesException["ForbiddenException"] = "ForbiddenException";
    DeleteUserAttributesException["InternalErrorException"] = "InternalErrorException";
    DeleteUserAttributesException["InvalidParameterException"] = "InvalidParameterException";
    DeleteUserAttributesException["NotAuthorizedException"] = "NotAuthorizedException";
    DeleteUserAttributesException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    DeleteUserAttributesException["ResourceNotFoundException"] = "ResourceNotFoundException";
    DeleteUserAttributesException["TooManyRequestsException"] = "TooManyRequestsException";
    DeleteUserAttributesException["UserNotConfirmedException"] = "UserNotConfirmedException";
    DeleteUserAttributesException["UserNotFoundException"] = "UserNotFoundException";
})(DeleteUserAttributesException || (DeleteUserAttributesException = {}));
var DeleteUserException;
(function (DeleteUserException) {
    DeleteUserException["ForbiddenException"] = "ForbiddenException";
    DeleteUserException["InternalErrorException"] = "InternalErrorException";
    DeleteUserException["InvalidParameterException"] = "InvalidParameterException";
    DeleteUserException["NotAuthorizedException"] = "NotAuthorizedException";
    DeleteUserException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    DeleteUserException["ResourceNotFoundException"] = "ResourceNotFoundException";
    DeleteUserException["TooManyRequestsException"] = "TooManyRequestsException";
    DeleteUserException["UserNotConfirmedException"] = "UserNotConfirmedException";
    DeleteUserException["UserNotFoundException"] = "UserNotFoundException";
})(DeleteUserException || (DeleteUserException = {}));
var ForgetDeviceException;
(function (ForgetDeviceException) {
    ForgetDeviceException["ForbiddenException"] = "ForbiddenException";
    ForgetDeviceException["InternalErrorException"] = "InternalErrorException";
    ForgetDeviceException["InvalidParameterException"] = "InvalidParameterException";
    ForgetDeviceException["InvalidUserPoolConfigurationException"] = "InvalidUserPoolConfigurationException";
    ForgetDeviceException["NotAuthorizedException"] = "NotAuthorizedException";
    ForgetDeviceException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    ForgetDeviceException["ResourceNotFoundException"] = "ResourceNotFoundException";
    ForgetDeviceException["TooManyRequestsException"] = "TooManyRequestsException";
    ForgetDeviceException["UserNotConfirmedException"] = "UserNotConfirmedException";
    ForgetDeviceException["UserNotFoundException"] = "UserNotFoundException";
})(ForgetDeviceException || (ForgetDeviceException = {}));
var ForgotPasswordException;
(function (ForgotPasswordException) {
    ForgotPasswordException["CodeDeliveryFailureException"] = "CodeDeliveryFailureException";
    ForgotPasswordException["ForbiddenException"] = "ForbiddenException";
    ForgotPasswordException["InternalErrorException"] = "InternalErrorException";
    ForgotPasswordException["InvalidEmailRoleAccessPolicyException"] = "InvalidEmailRoleAccessPolicyException";
    ForgotPasswordException["InvalidLambdaResponseException"] = "InvalidLambdaResponseException";
    ForgotPasswordException["InvalidParameterException"] = "InvalidParameterException";
    ForgotPasswordException["InvalidSmsRoleAccessPolicyException"] = "InvalidSmsRoleAccessPolicyException";
    ForgotPasswordException["InvalidSmsRoleTrustRelationshipException"] = "InvalidSmsRoleTrustRelationshipException";
    ForgotPasswordException["LimitExceededException"] = "LimitExceededException";
    ForgotPasswordException["NotAuthorizedException"] = "NotAuthorizedException";
    ForgotPasswordException["ResourceNotFoundException"] = "ResourceNotFoundException";
    ForgotPasswordException["TooManyRequestsException"] = "TooManyRequestsException";
    ForgotPasswordException["UnexpectedLambdaException"] = "UnexpectedLambdaException";
    ForgotPasswordException["UserLambdaValidationException"] = "UserLambdaValidationException";
    ForgotPasswordException["UserNotFoundException"] = "UserNotFoundException";
})(ForgotPasswordException || (ForgotPasswordException = {}));
var GetUserException;
(function (GetUserException) {
    GetUserException["ForbiddenException"] = "ForbiddenException";
    GetUserException["InternalErrorException"] = "InternalErrorException";
    GetUserException["InvalidParameterException"] = "InvalidParameterException";
    GetUserException["NotAuthorizedException"] = "NotAuthorizedException";
    GetUserException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    GetUserException["ResourceNotFoundException"] = "ResourceNotFoundException";
    GetUserException["TooManyRequestsException"] = "TooManyRequestsException";
    GetUserException["UserNotConfirmedException"] = "UserNotConfirmedException";
    GetUserException["UserNotFoundException"] = "UserNotFoundException";
})(GetUserException || (GetUserException = {}));
var GetIdException;
(function (GetIdException) {
    GetIdException["ExternalServiceException"] = "ExternalServiceException";
    GetIdException["InternalErrorException"] = "InternalErrorException";
    GetIdException["InvalidParameterException"] = "InvalidParameterException";
    GetIdException["LimitExceededException"] = "LimitExceededException";
    GetIdException["NotAuthorizedException"] = "NotAuthorizedException";
    GetIdException["ResourceConflictException"] = "ResourceConflictException";
    GetIdException["ResourceNotFoundException"] = "ResourceNotFoundException";
    GetIdException["TooManyRequestsException"] = "TooManyRequestsException";
})(GetIdException || (GetIdException = {}));
var GetCredentialsForIdentityException;
(function (GetCredentialsForIdentityException) {
    GetCredentialsForIdentityException["ExternalServiceException"] = "ExternalServiceException";
    GetCredentialsForIdentityException["InternalErrorException"] = "InternalErrorException";
    GetCredentialsForIdentityException["InvalidIdentityPoolConfigurationException"] = "InvalidIdentityPoolConfigurationException";
    GetCredentialsForIdentityException["InvalidParameterException"] = "InvalidParameterException";
    GetCredentialsForIdentityException["NotAuthorizedException"] = "NotAuthorizedException";
    GetCredentialsForIdentityException["ResourceConflictException"] = "ResourceConflictException";
    GetCredentialsForIdentityException["ResourceNotFoundException"] = "ResourceNotFoundException";
    GetCredentialsForIdentityException["TooManyRequestsException"] = "TooManyRequestsException";
})(GetCredentialsForIdentityException || (GetCredentialsForIdentityException = {}));
var GetUserAttributeVerificationException;
(function (GetUserAttributeVerificationException) {
    GetUserAttributeVerificationException["CodeDeliveryFailureException"] = "CodeDeliveryFailureException";
    GetUserAttributeVerificationException["ForbiddenException"] = "ForbiddenException";
    GetUserAttributeVerificationException["InternalErrorException"] = "InternalErrorException";
    GetUserAttributeVerificationException["InvalidEmailRoleAccessPolicyException"] = "InvalidEmailRoleAccessPolicyException";
    GetUserAttributeVerificationException["InvalidLambdaResponseException"] = "InvalidLambdaResponseException";
    GetUserAttributeVerificationException["InvalidParameterException"] = "InvalidParameterException";
    GetUserAttributeVerificationException["InvalidSmsRoleAccessPolicyException"] = "InvalidSmsRoleAccessPolicyException";
    GetUserAttributeVerificationException["InvalidSmsRoleTrustRelationshipException"] = "InvalidSmsRoleTrustRelationshipException";
    GetUserAttributeVerificationException["LimitExceededException"] = "LimitExceededException";
    GetUserAttributeVerificationException["NotAuthorizedException"] = "NotAuthorizedException";
    GetUserAttributeVerificationException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    GetUserAttributeVerificationException["ResourceNotFoundException"] = "ResourceNotFoundException";
    GetUserAttributeVerificationException["TooManyRequestsException"] = "TooManyRequestsException";
    GetUserAttributeVerificationException["UnexpectedLambdaException"] = "UnexpectedLambdaException";
    GetUserAttributeVerificationException["UserLambdaValidationException"] = "UserLambdaValidationException";
    GetUserAttributeVerificationException["UserNotConfirmedException"] = "UserNotConfirmedException";
    GetUserAttributeVerificationException["UserNotFoundException"] = "UserNotFoundException";
})(GetUserAttributeVerificationException || (GetUserAttributeVerificationException = {}));
var GlobalSignOutException;
(function (GlobalSignOutException) {
    GlobalSignOutException["ForbiddenException"] = "ForbiddenException";
    GlobalSignOutException["InternalErrorException"] = "InternalErrorException";
    GlobalSignOutException["InvalidParameterException"] = "InvalidParameterException";
    GlobalSignOutException["NotAuthorizedException"] = "NotAuthorizedException";
    GlobalSignOutException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    GlobalSignOutException["ResourceNotFoundException"] = "ResourceNotFoundException";
    GlobalSignOutException["TooManyRequestsException"] = "TooManyRequestsException";
    GlobalSignOutException["UserNotConfirmedException"] = "UserNotConfirmedException";
})(GlobalSignOutException || (GlobalSignOutException = {}));
var InitiateAuthException;
(function (InitiateAuthException) {
    InitiateAuthException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    InitiateAuthException["ForbiddenException"] = "ForbiddenException";
    InitiateAuthException["InternalErrorException"] = "InternalErrorException";
    InitiateAuthException["InvalidLambdaResponseException"] = "InvalidLambdaResponseException";
    InitiateAuthException["InvalidParameterException"] = "InvalidParameterException";
    InitiateAuthException["InvalidSmsRoleAccessPolicyException"] = "InvalidSmsRoleAccessPolicyException";
    InitiateAuthException["InvalidSmsRoleTrustRelationshipException"] = "InvalidSmsRoleTrustRelationshipException";
    InitiateAuthException["InvalidUserPoolConfigurationException"] = "InvalidUserPoolConfigurationException";
    InitiateAuthException["NotAuthorizedException"] = "NotAuthorizedException";
    InitiateAuthException["ResourceNotFoundException"] = "ResourceNotFoundException";
    InitiateAuthException["TooManyRequestsException"] = "TooManyRequestsException";
    InitiateAuthException["UnexpectedLambdaException"] = "UnexpectedLambdaException";
    InitiateAuthException["UserLambdaValidationException"] = "UserLambdaValidationException";
    InitiateAuthException["UserNotConfirmedException"] = "UserNotConfirmedException";
    InitiateAuthException["UserNotFoundException"] = "UserNotFoundException";
})(InitiateAuthException || (InitiateAuthException = {}));
var ResendConfirmationException;
(function (ResendConfirmationException) {
    ResendConfirmationException["CodeDeliveryFailureException"] = "CodeDeliveryFailureException";
    ResendConfirmationException["ForbiddenException"] = "ForbiddenException";
    ResendConfirmationException["InternalErrorException"] = "InternalErrorException";
    ResendConfirmationException["InvalidEmailRoleAccessPolicyException"] = "InvalidEmailRoleAccessPolicyException";
    ResendConfirmationException["InvalidLambdaResponseException"] = "InvalidLambdaResponseException";
    ResendConfirmationException["InvalidParameterException"] = "InvalidParameterException";
    ResendConfirmationException["InvalidSmsRoleAccessPolicyException"] = "InvalidSmsRoleAccessPolicyException";
    ResendConfirmationException["InvalidSmsRoleTrustRelationshipException"] = "InvalidSmsRoleTrustRelationshipException";
    ResendConfirmationException["LimitExceededException"] = "LimitExceededException";
    ResendConfirmationException["NotAuthorizedException"] = "NotAuthorizedException";
    ResendConfirmationException["ResourceNotFoundException"] = "ResourceNotFoundException";
    ResendConfirmationException["TooManyRequestsException"] = "TooManyRequestsException";
    ResendConfirmationException["UnexpectedLambdaException"] = "UnexpectedLambdaException";
    ResendConfirmationException["UserLambdaValidationException"] = "UserLambdaValidationException";
    ResendConfirmationException["UserNotFoundException"] = "UserNotFoundException";
})(ResendConfirmationException || (ResendConfirmationException = {}));
var RespondToAuthChallengeException;
(function (RespondToAuthChallengeException) {
    RespondToAuthChallengeException["AliasExistsException"] = "AliasExistsException";
    RespondToAuthChallengeException["CodeMismatchException"] = "CodeMismatchException";
    RespondToAuthChallengeException["ExpiredCodeException"] = "ExpiredCodeException";
    RespondToAuthChallengeException["ForbiddenException"] = "ForbiddenException";
    RespondToAuthChallengeException["InternalErrorException"] = "InternalErrorException";
    RespondToAuthChallengeException["InvalidLambdaResponseException"] = "InvalidLambdaResponseException";
    RespondToAuthChallengeException["InvalidParameterException"] = "InvalidParameterException";
    RespondToAuthChallengeException["InvalidPasswordException"] = "InvalidPasswordException";
    RespondToAuthChallengeException["InvalidSmsRoleAccessPolicyException"] = "InvalidSmsRoleAccessPolicyException";
    RespondToAuthChallengeException["InvalidSmsRoleTrustRelationshipException"] = "InvalidSmsRoleTrustRelationshipException";
    RespondToAuthChallengeException["InvalidUserPoolConfigurationException"] = "InvalidUserPoolConfigurationException";
    RespondToAuthChallengeException["MFAMethodNotFoundException"] = "MFAMethodNotFoundException";
    RespondToAuthChallengeException["NotAuthorizedException"] = "NotAuthorizedException";
    RespondToAuthChallengeException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    RespondToAuthChallengeException["ResourceNotFoundException"] = "ResourceNotFoundException";
    RespondToAuthChallengeException["SoftwareTokenMFANotFoundException"] = "SoftwareTokenMFANotFoundException";
    RespondToAuthChallengeException["TooManyRequestsException"] = "TooManyRequestsException";
    RespondToAuthChallengeException["UnexpectedLambdaException"] = "UnexpectedLambdaException";
    RespondToAuthChallengeException["UserLambdaValidationException"] = "UserLambdaValidationException";
    RespondToAuthChallengeException["UserNotConfirmedException"] = "UserNotConfirmedException";
    RespondToAuthChallengeException["UserNotFoundException"] = "UserNotFoundException";
})(RespondToAuthChallengeException || (RespondToAuthChallengeException = {}));
var SetUserMFAPreferenceException;
(function (SetUserMFAPreferenceException) {
    SetUserMFAPreferenceException["ForbiddenException"] = "ForbiddenException";
    SetUserMFAPreferenceException["InternalErrorException"] = "InternalErrorException";
    SetUserMFAPreferenceException["InvalidParameterException"] = "InvalidParameterException";
    SetUserMFAPreferenceException["NotAuthorizedException"] = "NotAuthorizedException";
    SetUserMFAPreferenceException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    SetUserMFAPreferenceException["ResourceNotFoundException"] = "ResourceNotFoundException";
    SetUserMFAPreferenceException["UserNotConfirmedException"] = "UserNotConfirmedException";
    SetUserMFAPreferenceException["UserNotFoundException"] = "UserNotFoundException";
})(SetUserMFAPreferenceException || (SetUserMFAPreferenceException = {}));
var SignUpException;
(function (SignUpException) {
    SignUpException["CodeDeliveryFailureException"] = "CodeDeliveryFailureException";
    SignUpException["InternalErrorException"] = "InternalErrorException";
    SignUpException["InvalidEmailRoleAccessPolicyException"] = "InvalidEmailRoleAccessPolicyException";
    SignUpException["InvalidLambdaResponseException"] = "InvalidLambdaResponseException";
    SignUpException["InvalidParameterException"] = "InvalidParameterException";
    SignUpException["InvalidPasswordException"] = "InvalidPasswordException";
    SignUpException["InvalidSmsRoleAccessPolicyException"] = "InvalidSmsRoleAccessPolicyException";
    SignUpException["InvalidSmsRoleTrustRelationshipException"] = "InvalidSmsRoleTrustRelationshipException";
    SignUpException["NotAuthorizedException"] = "NotAuthorizedException";
    SignUpException["ResourceNotFoundException"] = "ResourceNotFoundException";
    SignUpException["TooManyRequestsException"] = "TooManyRequestsException";
    SignUpException["UnexpectedLambdaException"] = "UnexpectedLambdaException";
    SignUpException["UserLambdaValidationException"] = "UserLambdaValidationException";
    SignUpException["UsernameExistsException"] = "UsernameExistsException";
})(SignUpException || (SignUpException = {}));
var UpdateUserAttributesException;
(function (UpdateUserAttributesException) {
    UpdateUserAttributesException["AliasExistsException"] = "AliasExistsException";
    UpdateUserAttributesException["CodeDeliveryFailureException"] = "CodeDeliveryFailureException";
    UpdateUserAttributesException["CodeMismatchException"] = "CodeMismatchException";
    UpdateUserAttributesException["ExpiredCodeException"] = "ExpiredCodeException";
    UpdateUserAttributesException["ForbiddenException"] = "ForbiddenException";
    UpdateUserAttributesException["InternalErrorException"] = "InternalErrorException";
    UpdateUserAttributesException["InvalidEmailRoleAccessPolicyException"] = "InvalidEmailRoleAccessPolicyException";
    UpdateUserAttributesException["InvalidLambdaResponseException"] = "InvalidLambdaResponseException";
    UpdateUserAttributesException["InvalidParameterException"] = "InvalidParameterException";
    UpdateUserAttributesException["InvalidSmsRoleAccessPolicyException"] = "InvalidSmsRoleAccessPolicyException";
    UpdateUserAttributesException["InvalidSmsRoleTrustRelationshipException"] = "InvalidSmsRoleTrustRelationshipException";
    UpdateUserAttributesException["NotAuthorizedException"] = "NotAuthorizedException";
    UpdateUserAttributesException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    UpdateUserAttributesException["ResourceNotFoundException"] = "ResourceNotFoundException";
    UpdateUserAttributesException["TooManyRequestsException"] = "TooManyRequestsException";
    UpdateUserAttributesException["UnexpectedLambdaException"] = "UnexpectedLambdaException";
    UpdateUserAttributesException["UserLambdaValidationException"] = "UserLambdaValidationException";
    UpdateUserAttributesException["UserNotConfirmedException"] = "UserNotConfirmedException";
    UpdateUserAttributesException["UserNotFoundException"] = "UserNotFoundException";
})(UpdateUserAttributesException || (UpdateUserAttributesException = {}));
var VerifySoftwareTokenException;
(function (VerifySoftwareTokenException) {
    VerifySoftwareTokenException["CodeMismatchException"] = "CodeMismatchException";
    VerifySoftwareTokenException["EnableSoftwareTokenMFAException"] = "EnableSoftwareTokenMFAException";
    VerifySoftwareTokenException["ForbiddenException"] = "ForbiddenException";
    VerifySoftwareTokenException["InternalErrorException"] = "InternalErrorException";
    VerifySoftwareTokenException["InvalidParameterException"] = "InvalidParameterException";
    VerifySoftwareTokenException["InvalidUserPoolConfigurationException"] = "InvalidUserPoolConfigurationException";
    VerifySoftwareTokenException["NotAuthorizedException"] = "NotAuthorizedException";
    VerifySoftwareTokenException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    VerifySoftwareTokenException["ResourceNotFoundException"] = "ResourceNotFoundException";
    VerifySoftwareTokenException["SoftwareTokenMFANotFoundException"] = "SoftwareTokenMFANotFoundException";
    VerifySoftwareTokenException["TooManyRequestsException"] = "TooManyRequestsException";
    VerifySoftwareTokenException["UserNotConfirmedException"] = "UserNotConfirmedException";
    VerifySoftwareTokenException["UserNotFoundException"] = "UserNotFoundException";
})(VerifySoftwareTokenException || (VerifySoftwareTokenException = {}));
var VerifyUserAttributeException;
(function (VerifyUserAttributeException) {
    VerifyUserAttributeException["AliasExistsException"] = "AliasExistsException";
    VerifyUserAttributeException["CodeMismatchException"] = "CodeMismatchException";
    VerifyUserAttributeException["ExpiredCodeException"] = "ExpiredCodeException";
    VerifyUserAttributeException["ForbiddenException"] = "ForbiddenException";
    VerifyUserAttributeException["InternalErrorException"] = "InternalErrorException";
    VerifyUserAttributeException["InvalidParameterException"] = "InvalidParameterException";
    VerifyUserAttributeException["LimitExceededException"] = "LimitExceededException";
    VerifyUserAttributeException["NotAuthorizedException"] = "NotAuthorizedException";
    VerifyUserAttributeException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    VerifyUserAttributeException["ResourceNotFoundException"] = "ResourceNotFoundException";
    VerifyUserAttributeException["TooManyRequestsException"] = "TooManyRequestsException";
    VerifyUserAttributeException["UserNotConfirmedException"] = "UserNotConfirmedException";
    VerifyUserAttributeException["UserNotFoundException"] = "UserNotFoundException";
})(VerifyUserAttributeException || (VerifyUserAttributeException = {}));
var UpdateDeviceStatusException;
(function (UpdateDeviceStatusException) {
    UpdateDeviceStatusException["ForbiddenException"] = "ForbiddenException";
    UpdateDeviceStatusException["InternalErrorException"] = "InternalErrorException";
    UpdateDeviceStatusException["InvalidParameterException"] = "InvalidParameterException";
    UpdateDeviceStatusException["InvalidUserPoolConfigurationException"] = "InvalidUserPoolConfigurationException";
    UpdateDeviceStatusException["NotAuthorizedException"] = "NotAuthorizedException";
    UpdateDeviceStatusException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    UpdateDeviceStatusException["ResourceNotFoundException"] = "ResourceNotFoundException";
    UpdateDeviceStatusException["TooManyRequestsException"] = "TooManyRequestsException";
    UpdateDeviceStatusException["UserNotConfirmedException"] = "UserNotConfirmedException";
    UpdateDeviceStatusException["UserNotFoundException"] = "UserNotFoundException";
})(UpdateDeviceStatusException || (UpdateDeviceStatusException = {}));
var ListDevicesException;
(function (ListDevicesException) {
    ListDevicesException["ForbiddenException"] = "ForbiddenException";
    ListDevicesException["InternalErrorException"] = "InternalErrorException";
    ListDevicesException["InvalidParameterException"] = "InvalidParameterException";
    ListDevicesException["InvalidUserPoolConfigurationException"] = "InvalidUserPoolConfigurationException";
    ListDevicesException["NotAuthorizedException"] = "NotAuthorizedException";
    ListDevicesException["PasswordResetRequiredException"] = "PasswordResetRequiredException";
    ListDevicesException["ResourceNotFoundException"] = "ResourceNotFoundException";
    ListDevicesException["TooManyRequestsException"] = "TooManyRequestsException";
    ListDevicesException["UserNotConfirmedException"] = "UserNotConfirmedException";
    ListDevicesException["UserNotFoundException"] = "UserNotFoundException";
})(ListDevicesException || (ListDevicesException = {}));
const SETUP_TOTP_EXCEPTION = 'SetUpTOTPException';


//# sourceMappingURL=errors.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/types/models.mjs":
/*!************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/types/models.mjs ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cognitoHostedUIIdentityProviderMap: () => (/* binding */ cognitoHostedUIIdentityProviderMap)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const cognitoHostedUIIdentityProviderMap = {
    Google: 'Google',
    Facebook: 'Facebook',
    Amazon: 'LoginWithAmazon',
    Apple: 'SignInWithApple',
};


//# sourceMappingURL=models.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/apiHelpers.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/apiHelpers.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   toAttributeType: () => (/* binding */ toAttributeType),
/* harmony export */   toAuthUserAttribute: () => (/* binding */ toAuthUserAttribute)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Transforms a user attributes object into an array of AttributeType objects.
 * @param attributes user attributes to be mapped to AttributeType objects.
 * @returns an array of AttributeType objects.
 */
function toAttributeType(attributes) {
    return Object.entries(attributes).map(([key, value]) => ({
        Name: key,
        Value: value,
    }));
}
/**
 * Transforms an array of AttributeType objects into a user attributes object.
 *
 * @param attributes - an array of AttributeType objects.
 * @returns AuthUserAttributes object.
 */
function toAuthUserAttribute(attributes) {
    const userAttributes = {};
    attributes?.forEach(attribute => {
        if (attribute.Name)
            userAttributes[attribute.Name] = attribute.Value;
    });
    return userAttributes;
}


//# sourceMappingURL=apiHelpers.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/dispatchSignedInHubEvent.mjs":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/dispatchSignedInHubEvent.mjs ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ERROR_MESSAGE: () => (/* binding */ ERROR_MESSAGE),
/* harmony export */   dispatchSignedInHubEvent: () => (/* binding */ dispatchSignedInHubEvent)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Hub/index.mjs");
/* harmony import */ var _apis_getCurrentUser_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../apis/getCurrentUser.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/getCurrentUser.mjs");
/* harmony import */ var _errors_constants_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/constants.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");






// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const ERROR_MESSAGE = 'Unable to get user session following successful sign-in.';
const dispatchSignedInHubEvent = async () => {
    try {
        _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.Hub.dispatch('auth', {
            event: 'signedIn',
            data: await (0,_apis_getCurrentUser_mjs__WEBPACK_IMPORTED_MODULE_1__.getCurrentUser)(),
        }, 'Auth', _aws_amplify_core__WEBPACK_IMPORTED_MODULE_0__.AMPLIFY_SYMBOL);
    }
    catch (error) {
        if (error.name === _errors_constants_mjs__WEBPACK_IMPORTED_MODULE_2__.USER_UNAUTHENTICATED_EXCEPTION) {
            throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthError({
                name: _errors_constants_mjs__WEBPACK_IMPORTED_MODULE_2__.UNEXPECTED_SIGN_IN_INTERRUPTION_EXCEPTION,
                message: ERROR_MESSAGE,
                recoverySuggestion: 'This most likely is due to auth tokens not being persisted. If you are using cookie store, please ensure cookies can be correctly set from your server.',
            });
        }
        throw error;
    }
};


//# sourceMappingURL=dispatchSignedInHubEvent.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/getNewDeviceMetadata.mjs":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/getNewDeviceMetadata.mjs ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getNewDeviceMetadata: () => (/* binding */ getNewDeviceMetadata)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/base64Encoder.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/deviceName/getDeviceName.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createConfirmDeviceClient_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmDeviceClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createConfirmDeviceClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _srp_getAuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./srp/getAuthenticationHelper.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getAuthenticationHelper.mjs");
/* harmony import */ var _srp_getBytesFromHex_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./srp/getBytesFromHex.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getBytesFromHex.mjs");
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * This function is used to kick off the device management flow.
 *
 * If an error is thrown while generating a hash device or calling the `ConfirmDevice`
 * client, then this API will ignore the error and return undefined. Otherwise the authentication
 * flow will not complete and the user won't be able to be signed in.
 *
 * @returns DeviceMetadata | undefined
 */
async function getNewDeviceMetadata({ userPoolId, userPoolEndpoint, newDeviceMetadata, accessToken, }) {
    if (!newDeviceMetadata)
        return undefined;
    const userPoolName = userPoolId.split('_')[1] || '';
    const authenticationHelper = await (0,_srp_getAuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_1__.getAuthenticationHelper)(userPoolName);
    const deviceKey = newDeviceMetadata?.DeviceKey;
    const deviceGroupKey = newDeviceMetadata?.DeviceGroupKey;
    try {
        await authenticationHelper.generateHashDevice(deviceGroupKey ?? '', deviceKey ?? '');
    }
    catch (errGenHash) {
        // TODO: log error here
        return undefined;
    }
    const deviceSecretVerifierConfig = {
        Salt: _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__.base64Encoder.convert((0,_srp_getBytesFromHex_mjs__WEBPACK_IMPORTED_MODULE_3__.getBytesFromHex)(authenticationHelper.getSaltToHashDevices())),
        PasswordVerifier: _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__.base64Encoder.convert((0,_srp_getBytesFromHex_mjs__WEBPACK_IMPORTED_MODULE_3__.getBytesFromHex)(authenticationHelper.getVerifierDevices())),
    };
    const randomPassword = authenticationHelper.getRandomPassword();
    try {
        const confirmDevice = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createConfirmDeviceClient_mjs__WEBPACK_IMPORTED_MODULE_4__.createConfirmDeviceClient)({
            endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_5__.createCognitoUserPoolEndpointResolver)({
                endpointOverride: userPoolEndpoint,
            }),
        });
        await confirmDevice({ region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_6__.getRegionFromUserPoolId)(userPoolId) }, {
            AccessToken: accessToken,
            DeviceName: await (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_7__.getDeviceName)(),
            DeviceKey: newDeviceMetadata?.DeviceKey,
            DeviceSecretVerifierConfig: deviceSecretVerifierConfig,
        });
        return {
            deviceKey,
            deviceGroupKey,
            randomPassword,
        };
    }
    catch (error) {
        // TODO: log error here
        return undefined;
    }
}


//# sourceMappingURL=getNewDeviceMetadata.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/handleDeviceSRPAuth.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/handleDeviceSRPAuth.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleDeviceSRPAuth: () => (/* binding */ handleDeviceSRPAuth)
/* harmony export */ });
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _types_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./types.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/types.mjs");
/* harmony import */ var _srp_getAuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./srp/getAuthenticationHelper.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getAuthenticationHelper.mjs");
/* harmony import */ var _srp_getNowString_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./srp/getNowString.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getNowString.mjs");
/* harmony import */ var _srp_getSignatureString_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./srp/getSignatureString.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getSignatureString.mjs");
/* harmony import */ var _srp_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./srp/BigInteger/BigInteger.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/BigInteger/BigInteger.mjs");
/* harmony import */ var _userContextData_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");




















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
async function handleDeviceSRPAuth({ username, config, clientMetadata, session, tokenOrchestrator, }) {
    const { userPoolId, userPoolEndpoint } = config;
    const clientId = config.userPoolClientId;
    const deviceMetadata = await tokenOrchestrator?.getDeviceMetadata(username);
    (0,_types_mjs__WEBPACK_IMPORTED_MODULE_0__.assertDeviceMetadata)(deviceMetadata);
    const authenticationHelper = await (0,_srp_getAuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_1__.getAuthenticationHelper)(deviceMetadata.deviceGroupKey);
    const challengeResponses = {
        USERNAME: username,
        SRP_A: authenticationHelper.A.toString(16),
        DEVICE_KEY: deviceMetadata.deviceKey,
    };
    const jsonReqResponseChallenge = {
        ChallengeName: 'DEVICE_SRP_AUTH',
        ClientId: clientId,
        ChallengeResponses: challengeResponses,
        ClientMetadata: clientMetadata,
        Session: session,
    };
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_2__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const { ChallengeParameters: respondedChallengeParameters, Session } = await respondToAuthChallenge({ region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId) }, jsonReqResponseChallenge);
    return handleDevicePasswordVerifier(username, respondedChallengeParameters, clientMetadata, Session, authenticationHelper, config, tokenOrchestrator);
}
async function handleDevicePasswordVerifier(username, challengeParameters, clientMetadata, session, authenticationHelper, { userPoolId, userPoolClientId, userPoolEndpoint }, tokenOrchestrator) {
    const deviceMetadata = await tokenOrchestrator?.getDeviceMetadata(username);
    (0,_types_mjs__WEBPACK_IMPORTED_MODULE_0__.assertDeviceMetadata)(deviceMetadata);
    const serverBValue = new _srp_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_5__["default"](challengeParameters?.SRP_B, 16);
    const salt = new _srp_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_5__["default"](challengeParameters?.SALT, 16);
    const { deviceKey } = deviceMetadata;
    const { deviceGroupKey } = deviceMetadata;
    const hkdf = await authenticationHelper.getPasswordAuthenticationKey({
        username: deviceMetadata.deviceKey,
        password: deviceMetadata.randomPassword,
        serverBValue,
        salt,
    });
    const dateNow = (0,_srp_getNowString_mjs__WEBPACK_IMPORTED_MODULE_6__.getNowString)();
    const challengeResponses = {
        USERNAME: challengeParameters?.USERNAME ?? username,
        PASSWORD_CLAIM_SECRET_BLOCK: challengeParameters?.SECRET_BLOCK,
        TIMESTAMP: dateNow,
        PASSWORD_CLAIM_SIGNATURE: (0,_srp_getSignatureString_mjs__WEBPACK_IMPORTED_MODULE_7__.getSignatureString)({
            username: deviceKey,
            userPoolName: deviceGroupKey,
            challengeParameters,
            dateNow,
            hkdf,
        }),
        DEVICE_KEY: deviceKey,
    };
    const UserContextData = (0,_userContextData_mjs__WEBPACK_IMPORTED_MODULE_8__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const jsonReqResponseChallenge = {
        ChallengeName: 'DEVICE_PASSWORD_VERIFIER',
        ClientId: userPoolClientId,
        ChallengeResponses: challengeResponses,
        Session: session,
        ClientMetadata: clientMetadata,
        UserContextData,
    };
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_2__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    return respondToAuthChallenge({ region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId) }, jsonReqResponseChallenge);
}


//# sourceMappingURL=handleDeviceSRPAuth.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/handlePasswordVerifierChallenge.mjs":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/handlePasswordVerifierChallenge.mjs ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handlePasswordVerifierChallenge: () => (/* binding */ handlePasswordVerifierChallenge)
/* harmony export */ });
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _srp_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./srp/BigInteger/BigInteger.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/BigInteger/BigInteger.mjs");
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _srp_getNowString_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./srp/getNowString.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getNowString.mjs");
/* harmony import */ var _srp_getSignatureString_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./srp/getSignatureString.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getSignatureString.mjs");
/* harmony import */ var _userContextData_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _handleDeviceSRPAuth_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./handleDeviceSRPAuth.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/handleDeviceSRPAuth.mjs");





















// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
async function handlePasswordVerifierChallenge(password, challengeParameters, clientMetadata, session, authenticationHelper, config, tokenOrchestrator) {
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    const userPoolName = userPoolId?.split('_')[1] || '';
    const serverBValue = new _srp_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__["default"](challengeParameters?.SRP_B, 16);
    const salt = new _srp_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__["default"](challengeParameters?.SALT, 16);
    const username = challengeParameters?.USER_ID_FOR_SRP;
    if (!username)
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_2__.AuthError({
            name: 'EmptyUserIdForSRPException',
            message: 'USER_ID_FOR_SRP was not found in challengeParameters',
        });
    const hkdf = await authenticationHelper.getPasswordAuthenticationKey({
        username,
        password,
        serverBValue,
        salt,
    });
    const dateNow = (0,_srp_getNowString_mjs__WEBPACK_IMPORTED_MODULE_3__.getNowString)();
    const challengeResponses = {
        USERNAME: username,
        PASSWORD_CLAIM_SECRET_BLOCK: challengeParameters?.SECRET_BLOCK,
        TIMESTAMP: dateNow,
        PASSWORD_CLAIM_SIGNATURE: (0,_srp_getSignatureString_mjs__WEBPACK_IMPORTED_MODULE_4__.getSignatureString)({
            username,
            userPoolName,
            challengeParameters,
            dateNow,
            hkdf,
        }),
    };
    const deviceMetadata = await tokenOrchestrator.getDeviceMetadata(username);
    if (deviceMetadata && deviceMetadata.deviceKey) {
        challengeResponses.DEVICE_KEY = deviceMetadata.deviceKey;
    }
    const UserContextData = (0,_userContextData_mjs__WEBPACK_IMPORTED_MODULE_5__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const jsonReqResponseChallenge = {
        ChallengeName: 'PASSWORD_VERIFIER',
        ChallengeResponses: challengeResponses,
        ClientMetadata: clientMetadata,
        Session: session,
        ClientId: userPoolClientId,
        UserContextData,
    };
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_6__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_7__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const response = await respondToAuthChallenge({ region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_8__.getRegionFromUserPoolId)(userPoolId) }, jsonReqResponseChallenge);
    if (response.ChallengeName === 'DEVICE_SRP_AUTH')
        return (0,_handleDeviceSRPAuth_mjs__WEBPACK_IMPORTED_MODULE_9__.handleDeviceSRPAuth)({
            username,
            config,
            clientMetadata,
            session: response.Session,
            tokenOrchestrator,
        });
    return response;
}


//# sourceMappingURL=handlePasswordVerifierChallenge.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/attemptCompleteOAuthFlow.mjs":
/*!************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/attemptCompleteOAuthFlow.mjs ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   attemptCompleteOAuthFlow: () => (/* binding */ attemptCompleteOAuthFlow)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./oAuthStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/oAuthStore.mjs");
/* harmony import */ var _completeOAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./completeOAuthFlow.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/completeOAuthFlow.mjs");
/* harmony import */ var _getRedirectUrl_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getRedirectUrl.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/getRedirectUrl.mjs");
/* harmony import */ var _handleFailure_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./handleFailure.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/handleFailure.mjs");







// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const attemptCompleteOAuthFlow = async (authConfig) => {
    try {
        (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.assertTokenProviderConfig)(authConfig);
        (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.assertOAuthConfig)(authConfig);
        _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_1__.oAuthStore.setAuthConfig(authConfig);
    }
    catch (_) {
        // no-op
        // This should not happen as Amplify singleton checks the oauth config key
        // unless the oauth config object doesn't contain required properties
        return;
    }
    // No inflight OAuth
    if (!(await _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_1__.oAuthStore.loadOAuthInFlight())) {
        return;
    }
    try {
        const currentUrl = window.location.href;
        const { loginWith, userPoolClientId } = authConfig;
        const { domain, redirectSignIn, responseType } = loginWith.oauth;
        const redirectUri = (0,_getRedirectUrl_mjs__WEBPACK_IMPORTED_MODULE_2__.getRedirectUrl)(redirectSignIn);
        await (0,_completeOAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_3__.completeOAuthFlow)({
            currentUrl,
            clientId: userPoolClientId,
            domain,
            redirectUri,
            responseType,
            userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_4__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_5__.AuthAction.SignInWithRedirect),
        });
    }
    catch (err) {
        await (0,_handleFailure_mjs__WEBPACK_IMPORTED_MODULE_6__.handleFailure)(err);
    }
};


//# sourceMappingURL=attemptCompleteOAuthFlow.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/cancelOAuthFlow.mjs":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/cancelOAuthFlow.mjs ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   listenForOAuthFlowCancellation: () => (/* binding */ listenForOAuthFlowCancellation)
/* harmony export */ });
/* harmony import */ var _createOAuthError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createOAuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/createOAuthError.mjs");
/* harmony import */ var _handleFailure_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./handleFailure.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/handleFailure.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const listenForOAuthFlowCancellation = (store) => {
    async function handleCancelOAuthFlow(event) {
        const isBfcache = event.persisted;
        if (isBfcache && (await store.loadOAuthInFlight())) {
            const error = (0,_createOAuthError_mjs__WEBPACK_IMPORTED_MODULE_0__.createOAuthError)('User cancelled OAuth flow.');
            await (0,_handleFailure_mjs__WEBPACK_IMPORTED_MODULE_1__.handleFailure)(error);
        }
        window.removeEventListener('pageshow', handleCancelOAuthFlow);
    }
    window.addEventListener('pageshow', handleCancelOAuthFlow);
};


//# sourceMappingURL=cancelOAuthFlow.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/completeOAuthFlow.mjs":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/completeOAuthFlow.mjs ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   completeOAuthFlow: () => (/* binding */ completeOAuthFlow)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/amplifyUrl/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/constants.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/urlSafeDecode.mjs");
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/Hub/index.mjs");
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../tokenProvider/cacheTokens.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/cacheTokens.mjs");
/* harmony import */ var _dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../dispatchSignedInHubEvent.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/dispatchSignedInHubEvent.mjs");
/* harmony import */ var _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./oAuthStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/oAuthStore.mjs");
/* harmony import */ var _inflightPromise_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./inflightPromise.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/inflightPromise.mjs");
/* harmony import */ var _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../tokenProvider/tokenProvider.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/tokenProvider/tokenProvider.mjs");
/* harmony import */ var _createOAuthError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createOAuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/createOAuthError.mjs");
/* harmony import */ var _validateState_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./validateState.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/validateState.mjs");












// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const completeOAuthFlow = async ({ currentUrl, userAgentValue, clientId, redirectUri, responseType, domain, preferPrivateSession, }) => {
    const urlParams = new _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.AmplifyUrl(currentUrl);
    const error = urlParams.searchParams.get('error');
    const errorMessage = urlParams.searchParams.get('error_description');
    if (error) {
        throw (0,_createOAuthError_mjs__WEBPACK_IMPORTED_MODULE_1__.createOAuthError)(errorMessage ?? error);
    }
    if (responseType === 'code') {
        return handleCodeFlow({
            currentUrl,
            userAgentValue,
            clientId,
            redirectUri,
            domain,
            preferPrivateSession,
        });
    }
    return handleImplicitFlow({
        currentUrl,
        redirectUri,
        preferPrivateSession,
    });
};
const handleCodeFlow = async ({ currentUrl, userAgentValue, clientId, redirectUri, domain, preferPrivateSession, }) => {
    /* Convert URL into an object with parameters as keys
{ redirect_uri: 'http://localhost:3000/', response_type: 'code', ...} */
    const url = new _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.AmplifyUrl(currentUrl);
    const code = url.searchParams.get('code');
    const state = url.searchParams.get('state');
    // if `code` or `state` is not presented in the redirect url, most likely
    // that the end user cancelled the inflight oauth flow by:
    // 1. clicking the back button of browser
    // 2. closing the provider hosted UI page and coming back to the app
    if (!code || !state) {
        throw (0,_createOAuthError_mjs__WEBPACK_IMPORTED_MODULE_1__.createOAuthError)('User cancelled OAuth flow.');
    }
    // may throw error is being caught in attemptCompleteOAuthFlow.ts
    const validatedState = await (0,_validateState_mjs__WEBPACK_IMPORTED_MODULE_2__.validateState)(state);
    const oAuthTokenEndpoint = 'https://' + domain + '/oauth2/token';
    // TODO(v6): check hub events
    // dispatchAuthEvent(
    // 	'codeFlow',
    // 	{},
    // 	`Retrieving tokens from ${oAuthTokenEndpoint}`
    // );
    const codeVerifier = await _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_3__.oAuthStore.loadPKCE();
    const oAuthTokenBody = {
        grant_type: 'authorization_code',
        code,
        client_id: clientId,
        redirect_uri: redirectUri,
        ...(codeVerifier ? { code_verifier: codeVerifier } : {}),
    };
    const body = Object.entries(oAuthTokenBody)
        .map(([k, v]) => `${encodeURIComponent(k)}=${encodeURIComponent(v)}`)
        .join('&');
    const { access_token, refresh_token: refreshToken, id_token, error, error_message: errorMessage, token_type, expires_in, } = await (await fetch(oAuthTokenEndpoint, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
            [_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_4__.USER_AGENT_HEADER]: userAgentValue,
        },
        body,
    })).json();
    if (error) {
        // error is being caught in attemptCompleteOAuthFlow.ts
        throw (0,_createOAuthError_mjs__WEBPACK_IMPORTED_MODULE_1__.createOAuthError)(errorMessage ?? error);
    }
    const username = (access_token && (0,_aws_amplify_core__WEBPACK_IMPORTED_MODULE_5__.decodeJWT)(access_token).payload.username) ?? 'username';
    await (0,_tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_6__.cacheCognitoTokens)({
        username,
        AccessToken: access_token,
        IdToken: id_token,
        RefreshToken: refreshToken});
    return completeFlow({
        redirectUri,
        state: validatedState,
        preferPrivateSession,
    });
};
const handleImplicitFlow = async ({ currentUrl, redirectUri, preferPrivateSession, }) => {
    // hash is `null` if `#` doesn't exist on URL
    const url = new _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.AmplifyUrl(currentUrl);
    const { id_token, access_token, state, token_type, expires_in, error_description, error, } = (url.hash ?? '#')
        .substring(1) // Remove # from returned code
        .split('&')
        .map(pairings => pairings.split('='))
        .reduce((accum, [k, v]) => ({ ...accum, [k]: v }), {
        id_token: undefined,
        access_token: undefined,
        state: undefined,
        token_type: undefined,
        expires_in: undefined,
        error_description: undefined,
        error: undefined,
    });
    if (error) {
        throw (0,_createOAuthError_mjs__WEBPACK_IMPORTED_MODULE_1__.createOAuthError)(error_description ?? error);
    }
    if (!access_token) {
        // error is being caught in attemptCompleteOAuthFlow.ts
        throw (0,_createOAuthError_mjs__WEBPACK_IMPORTED_MODULE_1__.createOAuthError)('No access token returned from OAuth flow.');
    }
    const validatedState = await (0,_validateState_mjs__WEBPACK_IMPORTED_MODULE_2__.validateState)(state);
    const username = (access_token && (0,_aws_amplify_core__WEBPACK_IMPORTED_MODULE_5__.decodeJWT)(access_token).payload.username) ?? 'username';
    await (0,_tokenProvider_cacheTokens_mjs__WEBPACK_IMPORTED_MODULE_6__.cacheCognitoTokens)({
        username,
        AccessToken: access_token,
        IdToken: id_token});
    return completeFlow({
        redirectUri,
        state: validatedState,
        preferPrivateSession,
    });
};
const completeFlow = async ({ redirectUri, state, preferPrivateSession, }) => {
    await _tokenProvider_tokenProvider_mjs__WEBPACK_IMPORTED_MODULE_7__.tokenOrchestrator.setOAuthMetadata({
        oauthSignIn: true,
    });
    await _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_3__.oAuthStore.clearOAuthData();
    await _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_3__.oAuthStore.storeOAuthSignIn(true, preferPrivateSession);
    // this should be called before any call that involves `fetchAuthSession`
    // e.g. `getCurrentUser()` below, so it allows every inflight async calls to
    //  `fetchAuthSession` can be resolved
    (0,_inflightPromise_mjs__WEBPACK_IMPORTED_MODULE_8__.resolveAndClearInflightPromises)();
    // clear history before sending out final Hub events
    clearHistory(redirectUri);
    if (isCustomState(state)) {
        _aws_amplify_core__WEBPACK_IMPORTED_MODULE_9__.Hub.dispatch('auth', {
            event: 'customOAuthState',
            data: (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_10__.urlSafeDecode)(getCustomState(state)),
        }, 'Auth', _aws_amplify_core__WEBPACK_IMPORTED_MODULE_9__.AMPLIFY_SYMBOL);
    }
    _aws_amplify_core__WEBPACK_IMPORTED_MODULE_9__.Hub.dispatch('auth', { event: 'signInWithRedirect' }, 'Auth', _aws_amplify_core__WEBPACK_IMPORTED_MODULE_9__.AMPLIFY_SYMBOL);
    await (0,_dispatchSignedInHubEvent_mjs__WEBPACK_IMPORTED_MODULE_11__.dispatchSignedInHubEvent)();
};
const isCustomState = (state) => {
    return /-/.test(state);
};
const getCustomState = (state) => {
    return state.split('-').splice(1).join('-');
};
const clearHistory = (redirectUri) => {
    if (typeof window !== 'undefined' && typeof window.history !== 'undefined') {
        window.history.replaceState(window.history.state, '', redirectUri);
    }
};


//# sourceMappingURL=completeOAuthFlow.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/createOAuthError.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/createOAuthError.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createOAuthError: () => (/* binding */ createOAuthError)
/* harmony export */ });
/* harmony import */ var _Errors_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../Errors.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/Errors.mjs");
/* harmony import */ var _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../common/AuthErrorStrings.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/common/AuthErrorStrings.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");




// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const createOAuthError = (message, recoverySuggestion) => new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthError({
    message: message ?? 'An error has occurred during the oauth process.',
    name: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthErrorCodes.OAuthSignInError,
    recoverySuggestion: recoverySuggestion ?? _Errors_mjs__WEBPACK_IMPORTED_MODULE_2__.authErrorMessages.oauthSignInError.log,
});


//# sourceMappingURL=createOAuthError.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/enableOAuthListener.mjs":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/enableOAuthListener.mjs ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/isBrowser.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/constants.mjs");
/* harmony import */ var _attemptCompleteOAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./attemptCompleteOAuthFlow.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/attemptCompleteOAuthFlow.mjs");




// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
// attach the side effect for handling the completion of an inflight oauth flow
// this side effect works only on Web
(0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.isBrowser)() &&
    (() => {
        // add the listener to the singleton for triggering
        _aws_amplify_core__WEBPACK_IMPORTED_MODULE_1__.Amplify[_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__.ADD_OAUTH_LISTENER](_attemptCompleteOAuthFlow_mjs__WEBPACK_IMPORTED_MODULE_3__.attemptCompleteOAuthFlow);
    })();
//# sourceMappingURL=enableOAuthListener.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/generateCodeVerifier.mjs":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/generateCodeVerifier.mjs ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   generateCodeVerifier: () => (/* binding */ generateCodeVerifier)
/* harmony export */ });
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/globalHelpers/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/base64Encoder.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const CODE_VERIFIER_CHARSET = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
/**
 *
 * @param length Desired length of the code verifier.
 *
 * **NOTE:** According to the [RFC 7636](https://datatracker.ietf.org/doc/html/rfc7636#section-4.1)
 * A code verifier must be with a length >= 43 and <= 128.
 *
 * @returns An object that contains the generated `codeVerifier` and a method
 * `toCodeChallenge` to generate the code challenge from the `codeVerifier`
 * following the spec of [RFC 7636](https://datatracker.ietf.org/doc/html/rfc7636#section-4.2).
 */
const generateCodeVerifier = (length) => {
    const randomBytes = new Uint8Array(length);
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_1__.getCrypto)().getRandomValues(randomBytes);
    let value = '';
    let codeChallenge;
    for (const byte of randomBytes) {
        value += CODE_VERIFIER_CHARSET.charAt(byte % CODE_VERIFIER_CHARSET.length);
    }
    return {
        value,
        method: 'S256',
        toCodeChallenge() {
            if (codeChallenge) {
                return codeChallenge;
            }
            codeChallenge = generateCodeChallenge(value);
            return codeChallenge;
        },
    };
};
function generateCodeChallenge(codeVerifier) {
    const awsCryptoHash = new _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__.Sha256();
    awsCryptoHash.update(codeVerifier);
    const codeChallenge = removePaddingChar(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__.base64Encoder.convert(awsCryptoHash.digestSync(), { urlSafe: true }));
    return codeChallenge;
}
function removePaddingChar(base64Encoded) {
    return base64Encoded.replace(/=/g, '');
}


//# sourceMappingURL=generateCodeVerifier.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/generateState.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/generateState.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   generateState: () => (/* binding */ generateState)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/generateRandomString.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const generateState = () => {
    return (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.generateRandomString)(32);
};


//# sourceMappingURL=generateState.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/handleFailure.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/handleFailure.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   handleFailure: () => (/* binding */ handleFailure)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Hub/index.mjs");
/* harmony import */ var _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./oAuthStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/oAuthStore.mjs");
/* harmony import */ var _inflightPromise_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./inflightPromise.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/inflightPromise.mjs");





// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const handleFailure = async (error) => {
    (0,_inflightPromise_mjs__WEBPACK_IMPORTED_MODULE_0__.resolveAndClearInflightPromises)();
    await _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_1__.oAuthStore.clearOAuthInflightData();
    _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__.Hub.dispatch('auth', { event: 'signInWithRedirect_failure', data: { error } }, 'Auth', _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__.AMPLIFY_SYMBOL);
};


//# sourceMappingURL=handleFailure.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/validateState.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/validateState.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   flowCancelledMessage: () => (/* binding */ flowCancelledMessage),
/* harmony export */   validateState: () => (/* binding */ validateState),
/* harmony export */   validationFailedMessage: () => (/* binding */ validationFailedMessage),
/* harmony export */   validationRecoverySuggestion: () => (/* binding */ validationRecoverySuggestion)
/* harmony export */ });
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _types_Auth_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../types/Auth.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/types/Auth.mjs");
/* harmony import */ var _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./oAuthStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/oauth/oAuthStore.mjs");




// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const flowCancelledMessage = '`signInWithRedirect` has been canceled.';
const validationFailedMessage = 'An error occurred while validating the state.';
const validationRecoverySuggestion = 'Try to initiate an OAuth flow from Amplify';
const validateState = async (state) => {
    const savedState = await _oAuthStore_mjs__WEBPACK_IMPORTED_MODULE_0__.oAuthStore.loadOAuthState();
    // This is because savedState only exists if the flow was initiated by Amplify
    const validatedState = state === savedState ? savedState : undefined;
    if (!validatedState) {
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthError({
            name: _types_Auth_mjs__WEBPACK_IMPORTED_MODULE_2__.AuthErrorTypes.OAuthSignInError,
            message: state === null ? flowCancelledMessage : validationFailedMessage,
            recoverySuggestion: state === null ? undefined : validationRecoverySuggestion,
        });
    }
    return validatedState;
};


//# sourceMappingURL=validateState.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/retryOnResourceNotFoundException.mjs":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/retryOnResourceNotFoundException.mjs ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   retryOnResourceNotFoundException: () => (/* binding */ retryOnResourceNotFoundException)
/* harmony export */ });
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * It will retry the function if the error is a `ResourceNotFoundException` and
 * will clean the device keys stored in the storage mechanism.
 *
 */
async function retryOnResourceNotFoundException(func, args, username, tokenOrchestrator) {
    try {
        return await func(...args);
    }
    catch (error) {
        if (error instanceof _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_0__.AuthError &&
            error.name === 'ResourceNotFoundException' &&
            error.message.includes('Device does not exist.')) {
            await tokenOrchestrator.clearDeviceMetadata(username);
            return func(...args);
        }
        throw error;
    }
}


//# sourceMappingURL=retryOnResourceNotFoundException.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/setActiveSignInUsername.mjs":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/setActiveSignInUsername.mjs ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   setActiveSignInUsername: () => (/* binding */ setActiveSignInUsername)
/* harmony export */ });
/* harmony import */ var _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../client/utils/store/signInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function setActiveSignInUsername(username) {
    const { dispatch } = _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_0__.signInStore;
    dispatch({ type: 'SET_USERNAME', value: username });
}


//# sourceMappingURL=setActiveSignInUsername.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signInHelpers.mjs":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signInHelpers.mjs ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   assertUserNotAuthenticated: () => (/* binding */ assertUserNotAuthenticated),
/* harmony export */   createAttributes: () => (/* binding */ createAttributes),
/* harmony export */   getActiveSignInUsername: () => (/* binding */ getActiveSignInUsername),
/* harmony export */   getAllowedMfaSetupTypes: () => (/* binding */ getAllowedMfaSetupTypes),
/* harmony export */   getMFAType: () => (/* binding */ getMFAType),
/* harmony export */   getMFATypes: () => (/* binding */ getMFATypes),
/* harmony export */   getSignInResult: () => (/* binding */ getSignInResult),
/* harmony export */   getSignInResultFromError: () => (/* binding */ getSignInResultFromError),
/* harmony export */   getTOTPSetupDetails: () => (/* binding */ getTOTPSetupDetails),
/* harmony export */   handleChallengeName: () => (/* binding */ handleChallengeName),
/* harmony export */   handleCompleteNewPasswordChallenge: () => (/* binding */ handleCompleteNewPasswordChallenge),
/* harmony export */   handleCustomAuthFlowWithoutSRP: () => (/* binding */ handleCustomAuthFlowWithoutSRP),
/* harmony export */   handleCustomChallenge: () => (/* binding */ handleCustomChallenge),
/* harmony export */   handleCustomSRPAuthFlow: () => (/* binding */ handleCustomSRPAuthFlow),
/* harmony export */   handleMFAChallenge: () => (/* binding */ handleMFAChallenge),
/* harmony export */   handleMFASetupChallenge: () => (/* binding */ handleMFASetupChallenge),
/* harmony export */   handleSelectMFATypeChallenge: () => (/* binding */ handleSelectMFATypeChallenge),
/* harmony export */   handleUserPasswordAuthFlow: () => (/* binding */ handleUserPasswordAuthFlow),
/* harmony export */   handleUserSRPAuthFlow: () => (/* binding */ handleUserSRPAuthFlow),
/* harmony export */   mapMfaType: () => (/* binding */ mapMfaType),
/* harmony export */   parseAttributes: () => (/* binding */ parseAttributes),
/* harmony export */   parseMFATypes: () => (/* binding */ parseMFATypes)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Amplify.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Platform/types.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/singleton/Auth/utils/index.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/amplifyUrl/index.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _types_errors_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../types/errors.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/types/errors.mjs");
/* harmony import */ var _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../common/AuthErrorStrings.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/common/AuthErrorStrings.mjs");
/* harmony import */ var _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../errors/types/validation.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/types/validation.mjs");
/* harmony import */ var _errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../errors/utils/assertValidationError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/utils/assertValidationError.mjs");
/* harmony import */ var _errors_constants_mjs__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../../errors/constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/constants.mjs");
/* harmony import */ var _apis_getCurrentUser_mjs__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../apis/getCurrentUser.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/getCurrentUser.mjs");
/* harmony import */ var _utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../utils/getAuthUserAgentValue.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/utils/getAuthUserAgentValue.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createInitiateAuthClient_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createInitiateAuthClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createInitiateAuthClient.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createRespondToAuthChallengeClient.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createVerifySoftwareTokenClient_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createVerifySoftwareTokenClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createVerifySoftwareTokenClient.mjs");
/* harmony import */ var _foundation_factories_serviceClients_cognitoIdentityProvider_createAssociateSoftwareTokenClient_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../../foundation/factories/serviceClients/cognitoIdentityProvider/createAssociateSoftwareTokenClient.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/factories/serviceClients/cognitoIdentityProvider/createAssociateSoftwareTokenClient.mjs");
/* harmony import */ var _factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../factories/createCognitoUserPoolEndpointResolver.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/factories/createCognitoUserPoolEndpointResolver.mjs");
/* harmony import */ var _foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../foundation/parsers/regionParsers.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/foundation/parsers/regionParsers.mjs");
/* harmony import */ var _client_flows_userAuth_handleWebAuthnSignInResult_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../../client/flows/userAuth/handleWebAuthnSignInResult.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleWebAuthnSignInResult.mjs");
/* harmony import */ var _client_flows_shared_handlePasswordSRP_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../../client/flows/shared/handlePasswordSRP.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/shared/handlePasswordSRP.mjs");
/* harmony import */ var _client_flows_userAuth_handleSelectChallenge_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../../client/flows/userAuth/handleSelectChallenge.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleSelectChallenge.mjs");
/* harmony import */ var _client_flows_userAuth_handleSelectChallengeWithPassword_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../../client/flows/userAuth/handleSelectChallengeWithPassword.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleSelectChallengeWithPassword.mjs");
/* harmony import */ var _client_flows_userAuth_handleSelectChallengeWithPasswordSRP_mjs__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../../client/flows/userAuth/handleSelectChallengeWithPasswordSRP.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/flows/userAuth/handleSelectChallengeWithPasswordSRP.mjs");
/* harmony import */ var _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../client/utils/store/signInStore.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/client/utils/store/signInStore.mjs");
/* harmony import */ var _srp_getAuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./srp/getAuthenticationHelper.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getAuthenticationHelper.mjs");
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _userContextData_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./userContextData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs");
/* harmony import */ var _handlePasswordVerifierChallenge_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./handlePasswordVerifierChallenge.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/handlePasswordVerifierChallenge.mjs");
/* harmony import */ var _handleDeviceSRPAuth_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./handleDeviceSRPAuth.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/handleDeviceSRPAuth.mjs");
/* harmony import */ var _retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./retryOnResourceNotFoundException.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/retryOnResourceNotFoundException.mjs");
/* harmony import */ var _setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./setActiveSignInUsername.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/setActiveSignInUsername.mjs");




































// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const USER_ATTRIBUTES = 'userAttributes.';
function isWebAuthnResultAuthSignInOutput(result) {
    return 'isSignedIn' in result && 'nextStep' in result;
}
async function handleCustomChallenge({ challengeResponse, clientMetadata, session, username, config, tokenOrchestrator, }) {
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    const challengeResponses = {
        USERNAME: username,
        ANSWER: challengeResponse,
    };
    const deviceMetadata = await tokenOrchestrator?.getDeviceMetadata(username);
    if (deviceMetadata && deviceMetadata.deviceKey) {
        challengeResponses.DEVICE_KEY = deviceMetadata.deviceKey;
    }
    const UserContextData = (0,_userContextData_mjs__WEBPACK_IMPORTED_MODULE_1__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const jsonReq = {
        ChallengeName: 'CUSTOM_CHALLENGE',
        ChallengeResponses: challengeResponses,
        Session: session,
        ClientMetadata: clientMetadata,
        ClientId: userPoolClientId,
        UserContextData,
    };
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_2__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const response = await respondToAuthChallenge({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__.AuthAction.ConfirmSignIn),
    }, jsonReq);
    if (response.ChallengeName === 'DEVICE_SRP_AUTH') {
        return (0,_handleDeviceSRPAuth_mjs__WEBPACK_IMPORTED_MODULE_7__.handleDeviceSRPAuth)({
            username,
            config,
            clientMetadata,
            session: response.Session,
            tokenOrchestrator,
        });
    }
    return response;
}
async function handleMFASetupChallenge({ challengeResponse, username, clientMetadata, session, deviceName, config, }) {
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    if (challengeResponse === 'EMAIL') {
        return {
            ChallengeName: 'MFA_SETUP',
            Session: session,
            ChallengeParameters: {
                MFAS_CAN_SETUP: '["EMAIL_OTP"]',
            },
            $metadata: {},
        };
    }
    if (challengeResponse === 'TOTP') {
        return {
            ChallengeName: 'MFA_SETUP',
            Session: session,
            ChallengeParameters: {
                MFAS_CAN_SETUP: '["SOFTWARE_TOKEN_MFA"]',
            },
            $metadata: {},
        };
    }
    const challengeResponses = {
        USERNAME: username,
    };
    const isTOTPCode = /^\d+$/.test(challengeResponse);
    if (isTOTPCode) {
        const verifySoftwareToken = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createVerifySoftwareTokenClient_mjs__WEBPACK_IMPORTED_MODULE_8__.createVerifySoftwareTokenClient)({
            endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
                endpointOverride: userPoolEndpoint,
            }),
        });
        const { Session } = await verifySoftwareToken({
            region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId),
            userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__.AuthAction.ConfirmSignIn),
        }, {
            UserCode: challengeResponse,
            Session: session,
            FriendlyDeviceName: deviceName,
        });
        _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_9__.signInStore.dispatch({
            type: 'SET_SIGN_IN_SESSION',
            value: Session,
        });
        const jsonReq = {
            ChallengeName: 'MFA_SETUP',
            ChallengeResponses: challengeResponses,
            Session,
            ClientMetadata: clientMetadata,
            ClientId: userPoolClientId,
        };
        const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_2__.createRespondToAuthChallengeClient)({
            endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
                endpointOverride: userPoolEndpoint,
            }),
        });
        return respondToAuthChallenge({
            region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId),
            userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__.AuthAction.ConfirmSignIn),
        }, jsonReq);
    }
    const isEmail = challengeResponse.includes('@');
    if (isEmail) {
        challengeResponses.EMAIL = challengeResponse;
        const jsonReq = {
            ChallengeName: 'MFA_SETUP',
            ChallengeResponses: challengeResponses,
            Session: session,
            ClientMetadata: clientMetadata,
            ClientId: userPoolClientId,
        };
        const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_2__.createRespondToAuthChallengeClient)({
            endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
                endpointOverride: userPoolEndpoint,
            }),
        });
        return respondToAuthChallenge({
            region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId),
            userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__.AuthAction.ConfirmSignIn),
        }, jsonReq);
    }
    throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_10__.AuthError({
        name: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_11__.AuthErrorCodes.SignInException,
        message: `Cannot proceed with MFA setup using challengeResponse: ${challengeResponse}`,
        recoverySuggestion: 'Try passing "EMAIL", "TOTP", a valid email, or OTP code as the challengeResponse.',
    });
}
async function handleSelectMFATypeChallenge({ challengeResponse, username, clientMetadata, session, config, }) {
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    (0,_errors_utils_assertValidationError_mjs__WEBPACK_IMPORTED_MODULE_12__.assertValidationError)(challengeResponse === 'TOTP' ||
        challengeResponse === 'SMS' ||
        challengeResponse === 'EMAIL', _errors_types_validation_mjs__WEBPACK_IMPORTED_MODULE_13__.AuthValidationErrorCode.IncorrectMFAMethod);
    const challengeResponses = {
        USERNAME: username,
        ANSWER: mapMfaType(challengeResponse),
    };
    const UserContextData = (0,_userContextData_mjs__WEBPACK_IMPORTED_MODULE_1__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const jsonReq = {
        ChallengeName: 'SELECT_MFA_TYPE',
        ChallengeResponses: challengeResponses,
        Session: session,
        ClientMetadata: clientMetadata,
        ClientId: userPoolClientId,
        UserContextData,
    };
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_2__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    return respondToAuthChallenge({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__.AuthAction.ConfirmSignIn),
    }, jsonReq);
}
async function handleCompleteNewPasswordChallenge({ challengeResponse, clientMetadata, session, username, requiredAttributes, config, }) {
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    const challengeResponses = {
        ...createAttributes(requiredAttributes),
        NEW_PASSWORD: challengeResponse,
        USERNAME: username,
    };
    const UserContextData = (0,_userContextData_mjs__WEBPACK_IMPORTED_MODULE_1__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const jsonReq = {
        ChallengeName: 'NEW_PASSWORD_REQUIRED',
        ChallengeResponses: challengeResponses,
        ClientMetadata: clientMetadata,
        Session: session,
        ClientId: userPoolClientId,
        UserContextData,
    };
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_2__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    return respondToAuthChallenge({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__.AuthAction.ConfirmSignIn),
    }, jsonReq);
}
async function handleUserPasswordAuthFlow(username, password, clientMetadata, config, tokenOrchestrator) {
    const { userPoolClientId, userPoolId, userPoolEndpoint } = config;
    const authParameters = {
        USERNAME: username,
        PASSWORD: password,
    };
    const deviceMetadata = await tokenOrchestrator.getDeviceMetadata(username);
    if (deviceMetadata && deviceMetadata.deviceKey) {
        authParameters.DEVICE_KEY = deviceMetadata.deviceKey;
    }
    const UserContextData = (0,_userContextData_mjs__WEBPACK_IMPORTED_MODULE_1__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const jsonReq = {
        AuthFlow: 'USER_PASSWORD_AUTH',
        AuthParameters: authParameters,
        ClientMetadata: clientMetadata,
        ClientId: userPoolClientId,
        UserContextData,
    };
    const initiateAuth = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createInitiateAuthClient_mjs__WEBPACK_IMPORTED_MODULE_14__.createInitiateAuthClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const response = await initiateAuth({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__.AuthAction.SignIn),
    }, jsonReq);
    const activeUsername = response.ChallengeParameters?.USERNAME ??
        response.ChallengeParameters?.USER_ID_FOR_SRP ??
        username;
    (0,_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_15__.setActiveSignInUsername)(activeUsername);
    if (response.ChallengeName === 'DEVICE_SRP_AUTH')
        return (0,_handleDeviceSRPAuth_mjs__WEBPACK_IMPORTED_MODULE_7__.handleDeviceSRPAuth)({
            username: activeUsername,
            config,
            clientMetadata,
            session: response.Session,
            tokenOrchestrator,
        });
    return response;
}
async function handleUserSRPAuthFlow(username, password, clientMetadata, config, tokenOrchestrator) {
    return (0,_client_flows_shared_handlePasswordSRP_mjs__WEBPACK_IMPORTED_MODULE_16__.handlePasswordSRP)({
        username,
        password,
        clientMetadata,
        config,
        tokenOrchestrator,
        authFlow: 'USER_SRP_AUTH',
    });
}
async function handleCustomAuthFlowWithoutSRP(username, clientMetadata, config, tokenOrchestrator) {
    const { userPoolClientId, userPoolId, userPoolEndpoint } = config;
    const authParameters = {
        USERNAME: username,
    };
    const deviceMetadata = await tokenOrchestrator.getDeviceMetadata(username);
    if (deviceMetadata && deviceMetadata.deviceKey) {
        authParameters.DEVICE_KEY = deviceMetadata.deviceKey;
    }
    const UserContextData = (0,_userContextData_mjs__WEBPACK_IMPORTED_MODULE_1__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const jsonReq = {
        AuthFlow: 'CUSTOM_AUTH',
        AuthParameters: authParameters,
        ClientMetadata: clientMetadata,
        ClientId: userPoolClientId,
        UserContextData,
    };
    const initiateAuth = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createInitiateAuthClient_mjs__WEBPACK_IMPORTED_MODULE_14__.createInitiateAuthClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const response = await initiateAuth({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__.AuthAction.SignIn),
    }, jsonReq);
    const activeUsername = response.ChallengeParameters?.USERNAME ?? username;
    (0,_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_15__.setActiveSignInUsername)(activeUsername);
    if (response.ChallengeName === 'DEVICE_SRP_AUTH')
        return (0,_handleDeviceSRPAuth_mjs__WEBPACK_IMPORTED_MODULE_7__.handleDeviceSRPAuth)({
            username: activeUsername,
            config,
            clientMetadata,
            session: response.Session,
            tokenOrchestrator,
        });
    return response;
}
async function handleCustomSRPAuthFlow(username, password, clientMetadata, config, tokenOrchestrator) {
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_17__.assertTokenProviderConfig)(config);
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    const userPoolName = userPoolId?.split('_')[1] || '';
    const authenticationHelper = await (0,_srp_getAuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_18__.getAuthenticationHelper)(userPoolName);
    const authParameters = {
        USERNAME: username,
        SRP_A: authenticationHelper.A.toString(16),
        CHALLENGE_NAME: 'SRP_A',
    };
    const UserContextData = (0,_userContextData_mjs__WEBPACK_IMPORTED_MODULE_1__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const jsonReq = {
        AuthFlow: 'CUSTOM_AUTH',
        AuthParameters: authParameters,
        ClientMetadata: clientMetadata,
        ClientId: userPoolClientId,
        UserContextData,
    };
    const initiateAuth = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createInitiateAuthClient_mjs__WEBPACK_IMPORTED_MODULE_14__.createInitiateAuthClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    const { ChallengeParameters: challengeParameters, Session: session } = await initiateAuth({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__.AuthAction.SignIn),
    }, jsonReq);
    const activeUsername = challengeParameters?.USERNAME ?? username;
    (0,_setActiveSignInUsername_mjs__WEBPACK_IMPORTED_MODULE_15__.setActiveSignInUsername)(activeUsername);
    return (0,_retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_19__.retryOnResourceNotFoundException)(_handlePasswordVerifierChallenge_mjs__WEBPACK_IMPORTED_MODULE_20__.handlePasswordVerifierChallenge, [
        password,
        challengeParameters,
        clientMetadata,
        session,
        authenticationHelper,
        config,
        tokenOrchestrator,
    ], activeUsername, tokenOrchestrator);
}
async function getSignInResult(params) {
    const { challengeName, challengeParameters, availableChallenges } = params;
    const authConfig = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_21__.Amplify.getConfig().Auth?.Cognito;
    (0,_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_17__.assertTokenProviderConfig)(authConfig);
    switch (challengeName) {
        case 'CUSTOM_CHALLENGE':
            return {
                isSignedIn: false,
                nextStep: {
                    signInStep: 'CONFIRM_SIGN_IN_WITH_CUSTOM_CHALLENGE',
                    additionalInfo: challengeParameters,
                },
            };
        case 'MFA_SETUP': {
            const { signInSession, username } = _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_9__.signInStore.getState();
            const mfaSetupTypes = getMFATypes(parseMFATypes(challengeParameters.MFAS_CAN_SETUP)) || [];
            const allowedMfaSetupTypes = getAllowedMfaSetupTypes(mfaSetupTypes);
            const isTotpMfaSetupAvailable = allowedMfaSetupTypes.includes('TOTP');
            const isEmailMfaSetupAvailable = allowedMfaSetupTypes.includes('EMAIL');
            if (isTotpMfaSetupAvailable && isEmailMfaSetupAvailable) {
                return {
                    isSignedIn: false,
                    nextStep: {
                        signInStep: 'CONTINUE_SIGN_IN_WITH_MFA_SETUP_SELECTION',
                        allowedMFATypes: allowedMfaSetupTypes,
                    },
                };
            }
            if (isEmailMfaSetupAvailable) {
                return {
                    isSignedIn: false,
                    nextStep: {
                        signInStep: 'CONTINUE_SIGN_IN_WITH_EMAIL_SETUP',
                    },
                };
            }
            if (isTotpMfaSetupAvailable) {
                const associateSoftwareToken = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createAssociateSoftwareTokenClient_mjs__WEBPACK_IMPORTED_MODULE_22__.createAssociateSoftwareTokenClient)({
                    endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
                        endpointOverride: authConfig.userPoolEndpoint,
                    }),
                });
                const { Session, SecretCode: secretCode } = await associateSoftwareToken({ region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(authConfig.userPoolId) }, {
                    Session: signInSession,
                });
                _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_9__.signInStore.dispatch({
                    type: 'SET_SIGN_IN_SESSION',
                    value: Session,
                });
                return {
                    isSignedIn: false,
                    nextStep: {
                        signInStep: 'CONTINUE_SIGN_IN_WITH_TOTP_SETUP',
                        totpSetupDetails: getTOTPSetupDetails(secretCode, username),
                    },
                };
            }
            throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_10__.AuthError({
                name: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_11__.AuthErrorCodes.SignInException,
                message: `Cannot initiate MFA setup from available types: ${mfaSetupTypes}`,
            });
        }
        case 'NEW_PASSWORD_REQUIRED':
            return {
                isSignedIn: false,
                nextStep: {
                    signInStep: 'CONFIRM_SIGN_IN_WITH_NEW_PASSWORD_REQUIRED',
                    missingAttributes: parseAttributes(challengeParameters.requiredAttributes),
                },
            };
        case 'SELECT_MFA_TYPE':
            return {
                isSignedIn: false,
                nextStep: {
                    signInStep: 'CONTINUE_SIGN_IN_WITH_MFA_SELECTION',
                    allowedMFATypes: getMFATypes(parseMFATypes(challengeParameters.MFAS_CAN_CHOOSE)),
                },
            };
        case 'SMS_OTP':
        case 'SMS_MFA':
            return {
                isSignedIn: false,
                nextStep: {
                    signInStep: 'CONFIRM_SIGN_IN_WITH_SMS_CODE',
                    codeDeliveryDetails: {
                        deliveryMedium: challengeParameters.CODE_DELIVERY_DELIVERY_MEDIUM,
                        destination: challengeParameters.CODE_DELIVERY_DESTINATION,
                    },
                },
            };
        case 'SOFTWARE_TOKEN_MFA':
            return {
                isSignedIn: false,
                nextStep: {
                    signInStep: 'CONFIRM_SIGN_IN_WITH_TOTP_CODE',
                },
            };
        case 'EMAIL_OTP':
            return {
                isSignedIn: false,
                nextStep: {
                    signInStep: 'CONFIRM_SIGN_IN_WITH_EMAIL_CODE',
                    codeDeliveryDetails: {
                        deliveryMedium: challengeParameters.CODE_DELIVERY_DELIVERY_MEDIUM,
                        destination: challengeParameters.CODE_DELIVERY_DESTINATION,
                    },
                },
            };
        case 'WEB_AUTHN': {
            const result = await (0,_client_flows_userAuth_handleWebAuthnSignInResult_mjs__WEBPACK_IMPORTED_MODULE_23__.handleWebAuthnSignInResult)(challengeParameters);
            if (isWebAuthnResultAuthSignInOutput(result)) {
                return result;
            }
            return getSignInResult(result);
        }
        case 'PASSWORD':
        case 'PASSWORD_SRP':
            return {
                isSignedIn: false,
                nextStep: {
                    signInStep: 'CONFIRM_SIGN_IN_WITH_PASSWORD',
                },
            };
        case 'SELECT_CHALLENGE':
            return {
                isSignedIn: false,
                nextStep: {
                    signInStep: 'CONTINUE_SIGN_IN_WITH_FIRST_FACTOR_SELECTION',
                    availableChallenges,
                },
            };
    }
    // TODO: remove this error message for production apps
    throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_10__.AuthError({
        name: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_11__.AuthErrorCodes.SignInException,
        message: 'An error occurred during the sign in process. ' +
            `${challengeName} challengeName returned by the underlying service was not addressed.`,
    });
}
function getTOTPSetupDetails(secretCode, username) {
    return {
        sharedSecret: secretCode,
        getSetupUri: (appName, accountName) => {
            const totpUri = `otpauth://totp/${appName}:${accountName ?? username}?secret=${secretCode}&issuer=${appName}`;
            return new _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_24__.AmplifyUrl(totpUri);
        },
    };
}
function getSignInResultFromError(errorName) {
    if (errorName === _types_errors_mjs__WEBPACK_IMPORTED_MODULE_25__.InitiateAuthException.PasswordResetRequiredException) {
        return {
            isSignedIn: false,
            nextStep: { signInStep: 'RESET_PASSWORD' },
        };
    }
    else if (errorName === _types_errors_mjs__WEBPACK_IMPORTED_MODULE_25__.InitiateAuthException.UserNotConfirmedException) {
        return {
            isSignedIn: false,
            nextStep: { signInStep: 'CONFIRM_SIGN_UP' },
        };
    }
}
function parseAttributes(attributes) {
    if (!attributes)
        return [];
    const parsedAttributes = JSON.parse(attributes).map(att => att.includes(USER_ATTRIBUTES) ? att.replace(USER_ATTRIBUTES, '') : att);
    return parsedAttributes;
}
function createAttributes(attributes) {
    if (!attributes)
        return {};
    const newAttributes = {};
    Object.entries(attributes).forEach(([key, value]) => {
        if (value)
            newAttributes[`${USER_ATTRIBUTES}${key}`] = value;
    });
    return newAttributes;
}
async function handleChallengeName(username, challengeName, session, challengeResponse, config, tokenOrchestrator, clientMetadata, options) {
    const userAttributes = options?.userAttributes;
    const deviceName = options?.friendlyDeviceName;
    switch (challengeName) {
        case 'WEB_AUTHN':
        case 'SELECT_CHALLENGE':
            if (challengeResponse === 'PASSWORD_SRP' ||
                challengeResponse === 'PASSWORD') {
                return {
                    ChallengeName: challengeResponse,
                    Session: session,
                    $metadata: {},
                };
            }
            return (0,_client_flows_userAuth_handleSelectChallenge_mjs__WEBPACK_IMPORTED_MODULE_26__.initiateSelectedChallenge)({
                username,
                session,
                selectedChallenge: challengeResponse,
                config,
                clientMetadata,
            });
        case 'SELECT_MFA_TYPE':
            return handleSelectMFATypeChallenge({
                challengeResponse,
                clientMetadata,
                session,
                username,
                config,
            });
        case 'MFA_SETUP':
            return handleMFASetupChallenge({
                challengeResponse,
                clientMetadata,
                session,
                username,
                deviceName,
                config,
            });
        case 'NEW_PASSWORD_REQUIRED':
            return handleCompleteNewPasswordChallenge({
                challengeResponse,
                clientMetadata,
                session,
                username,
                requiredAttributes: userAttributes,
                config,
            });
        case 'CUSTOM_CHALLENGE':
            return (0,_retryOnResourceNotFoundException_mjs__WEBPACK_IMPORTED_MODULE_19__.retryOnResourceNotFoundException)(handleCustomChallenge, [
                {
                    challengeResponse,
                    clientMetadata,
                    session,
                    username,
                    config,
                    tokenOrchestrator,
                },
            ], username, tokenOrchestrator);
        case 'SMS_MFA':
        case 'SOFTWARE_TOKEN_MFA':
        case 'SMS_OTP':
        case 'EMAIL_OTP':
            return handleMFAChallenge({
                challengeName,
                challengeResponse,
                clientMetadata,
                session,
                username,
                config,
            });
        case 'PASSWORD':
            return (0,_client_flows_userAuth_handleSelectChallengeWithPassword_mjs__WEBPACK_IMPORTED_MODULE_27__.handleSelectChallengeWithPassword)(username, challengeResponse, clientMetadata, config, session);
        case 'PASSWORD_SRP':
            return (0,_client_flows_userAuth_handleSelectChallengeWithPasswordSRP_mjs__WEBPACK_IMPORTED_MODULE_28__.handleSelectChallengeWithPasswordSRP)(username, challengeResponse, // This is the actual password
            clientMetadata, config, session, tokenOrchestrator);
    }
    // TODO: remove this error message for production apps
    throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_10__.AuthError({
        name: _common_AuthErrorStrings_mjs__WEBPACK_IMPORTED_MODULE_11__.AuthErrorCodes.SignInException,
        message: `An error occurred during the sign in process.
		${challengeName} challengeName returned by the underlying service was not addressed.`,
    });
}
function mapMfaType(mfa) {
    let mfaType = 'SMS_MFA';
    if (mfa === 'TOTP')
        mfaType = 'SOFTWARE_TOKEN_MFA';
    if (mfa === 'EMAIL')
        mfaType = 'EMAIL_OTP';
    return mfaType;
}
function getMFAType(type) {
    if (type === 'SMS_MFA')
        return 'SMS';
    if (type === 'SOFTWARE_TOKEN_MFA')
        return 'TOTP';
    if (type === 'EMAIL_OTP')
        return 'EMAIL';
    // TODO: log warning for unknown MFA type
}
function getMFATypes(types) {
    if (!types)
        return undefined;
    return types.map(getMFAType).filter(Boolean);
}
function parseMFATypes(mfa) {
    if (!mfa)
        return [];
    return JSON.parse(mfa);
}
function getAllowedMfaSetupTypes(availableMfaSetupTypes) {
    return availableMfaSetupTypes.filter(authMfaType => authMfaType === 'EMAIL' || authMfaType === 'TOTP');
}
async function assertUserNotAuthenticated() {
    let authUser;
    try {
        authUser = await (0,_apis_getCurrentUser_mjs__WEBPACK_IMPORTED_MODULE_29__.getCurrentUser)();
    }
    catch (error) { }
    if (authUser && authUser.userId && authUser.username) {
        throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_10__.AuthError({
            name: _errors_constants_mjs__WEBPACK_IMPORTED_MODULE_30__.USER_ALREADY_AUTHENTICATED_EXCEPTION,
            message: 'There is already a signed in user.',
            recoverySuggestion: 'Call signOut before calling signIn again.',
        });
    }
}
function getActiveSignInUsername(username) {
    const state = _client_utils_store_signInStore_mjs__WEBPACK_IMPORTED_MODULE_9__.signInStore.getState();
    return state.username ?? username;
}
async function handleMFAChallenge({ challengeName, challengeResponse, clientMetadata, session, username, config, }) {
    const { userPoolId, userPoolClientId, userPoolEndpoint } = config;
    const challengeResponses = {
        USERNAME: username,
    };
    if (challengeName === 'EMAIL_OTP') {
        challengeResponses.EMAIL_OTP_CODE = challengeResponse;
    }
    if (challengeName === 'SMS_MFA') {
        challengeResponses.SMS_MFA_CODE = challengeResponse;
    }
    if (challengeName === 'SMS_OTP') {
        challengeResponses.SMS_OTP_CODE = challengeResponse;
    }
    if (challengeName === 'SOFTWARE_TOKEN_MFA') {
        challengeResponses.SOFTWARE_TOKEN_MFA_CODE = challengeResponse;
    }
    const userContextData = (0,_userContextData_mjs__WEBPACK_IMPORTED_MODULE_1__.getUserContextData)({
        username,
        userPoolId,
        userPoolClientId,
    });
    const jsonReq = {
        ChallengeName: challengeName,
        ChallengeResponses: challengeResponses,
        Session: session,
        ClientMetadata: clientMetadata,
        ClientId: userPoolClientId,
        UserContextData: userContextData,
    };
    const respondToAuthChallenge = (0,_foundation_factories_serviceClients_cognitoIdentityProvider_createRespondToAuthChallengeClient_mjs__WEBPACK_IMPORTED_MODULE_2__.createRespondToAuthChallengeClient)({
        endpointResolver: (0,_factories_createCognitoUserPoolEndpointResolver_mjs__WEBPACK_IMPORTED_MODULE_3__.createCognitoUserPoolEndpointResolver)({
            endpointOverride: userPoolEndpoint,
        }),
    });
    return respondToAuthChallenge({
        region: (0,_foundation_parsers_regionParsers_mjs__WEBPACK_IMPORTED_MODULE_4__.getRegionFromUserPoolId)(userPoolId),
        userAgentValue: (0,_utils_getAuthUserAgentValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getAuthUserAgentValue)(_aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_6__.AuthAction.ConfirmSignIn),
    }, jsonReq);
}


//# sourceMappingURL=signInHelpers.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signUpHelpers.mjs":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/signUpHelpers.mjs ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   autoSignInUserConfirmed: () => (/* binding */ autoSignInUserConfirmed),
/* harmony export */   autoSignInWhenUserIsConfirmedWithLink: () => (/* binding */ autoSignInWhenUserIsConfirmedWithLink),
/* harmony export */   handleCodeAutoSignIn: () => (/* binding */ handleCodeAutoSignIn)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/Hub/index.mjs");
/* harmony import */ var _apis_signIn_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../apis/signIn.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signIn.mjs");
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _apis_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../apis/autoSignIn.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/autoSignIn.mjs");
/* harmony import */ var _errors_constants_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../errors/constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/constants.mjs");
/* harmony import */ var _apis_signInWithUserAuth_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../apis/signInWithUserAuth.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/signInWithUserAuth.mjs");







// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const MAX_AUTOSIGNIN_POLLING_MS = 3 * 60 * 1000;
function handleCodeAutoSignIn(signInInput) {
    const stopHubListener = _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.HubInternal.listen('auth-internal', async ({ payload }) => {
        switch (payload.event) {
            case 'confirmSignUp': {
                const response = payload.data;
                if (response?.isSignUpComplete) {
                    _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.HubInternal.dispatch('auth-internal', {
                        event: 'autoSignIn',
                    });
                    (0,_apis_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_1__.setAutoSignIn)(autoSignInWithCode(signInInput));
                    stopHubListener();
                }
            }
        }
    });
    // This will stop the listener if confirmSignUp is not resolved.
    const timeOutId = setTimeout(() => {
        stopHubListener();
        clearTimeout(timeOutId);
        (0,_apis_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_1__.resetAutoSignIn)();
    }, MAX_AUTOSIGNIN_POLLING_MS);
}
function debounce(fun, delay) {
    let timer;
    return (args) => {
        if (!timer) {
            fun(...args);
        }
        clearTimeout(timer);
        timer = setTimeout(() => {
            timer = undefined;
        }, delay);
    };
}
function handleAutoSignInWithLink(signInInput, resolve, reject) {
    const start = Date.now();
    const autoSignInPollingIntervalId = setInterval(async () => {
        const elapsedTime = Date.now() - start;
        const maxTime = MAX_AUTOSIGNIN_POLLING_MS;
        if (elapsedTime > maxTime) {
            clearInterval(autoSignInPollingIntervalId);
            reject(new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_2__.AuthError({
                name: _errors_constants_mjs__WEBPACK_IMPORTED_MODULE_3__.AUTO_SIGN_IN_EXCEPTION,
                message: 'The account was not confirmed on time.',
                recoverySuggestion: 'Try to verify your account by clicking the link sent your email or phone and then login manually.',
            }));
            (0,_apis_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_1__.resetAutoSignIn)();
        }
        else {
            try {
                const signInOutput = await (0,_apis_signIn_mjs__WEBPACK_IMPORTED_MODULE_4__.signIn)(signInInput);
                if (signInOutput.nextStep.signInStep !== 'CONFIRM_SIGN_UP') {
                    resolve(signInOutput);
                    clearInterval(autoSignInPollingIntervalId);
                    (0,_apis_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_1__.resetAutoSignIn)();
                }
            }
            catch (error) {
                clearInterval(autoSignInPollingIntervalId);
                reject(error);
                (0,_apis_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_1__.resetAutoSignIn)();
            }
        }
    }, 5000);
}
const debouncedAutoSignInWithLink = debounce(handleAutoSignInWithLink, 300);
const debouncedAutoSignWithCodeOrUserConfirmed = debounce(handleAutoSignInWithCodeOrUserConfirmed, 300);
function autoSignInWhenUserIsConfirmedWithLink(signInInput) {
    return async () => {
        return new Promise((resolve, reject) => {
            debouncedAutoSignInWithLink([signInInput, resolve, reject]);
        });
    };
}
async function handleAutoSignInWithCodeOrUserConfirmed(signInInput, resolve, reject) {
    try {
        const output = signInInput?.options?.authFlowType === 'USER_AUTH'
            ? await (0,_apis_signInWithUserAuth_mjs__WEBPACK_IMPORTED_MODULE_5__.signInWithUserAuth)(signInInput)
            : await (0,_apis_signIn_mjs__WEBPACK_IMPORTED_MODULE_4__.signIn)(signInInput);
        resolve(output);
        (0,_apis_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_1__.resetAutoSignIn)();
    }
    catch (error) {
        reject(error);
        (0,_apis_autoSignIn_mjs__WEBPACK_IMPORTED_MODULE_1__.resetAutoSignIn)();
    }
}
function autoSignInWithCode(signInInput) {
    return async () => {
        return new Promise((resolve, reject) => {
            debouncedAutoSignWithCodeOrUserConfirmed([signInInput, resolve, reject]);
        });
    };
}
const autoSignInUserConfirmed = autoSignInWithCode;


//# sourceMappingURL=signUpHelpers.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/AuthenticationHelper/AuthenticationHelper.mjs":
/*!***************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/AuthenticationHelper/AuthenticationHelper.mjs ***!
  \***************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AuthenticationHelper)
/* harmony export */ });
/* harmony import */ var _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../../errors/AuthError.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/errors/AuthError.mjs");
/* harmony import */ var _textEncoder_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../textEncoder/index.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/textEncoder/index.mjs");
/* harmony import */ var _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../BigInteger/BigInteger.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/BigInteger/BigInteger.mjs");
/* harmony import */ var _calculate_calculateS_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../calculate/calculateS.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/calculate/calculateS.mjs");
/* harmony import */ var _calculate_calculateU_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../calculate/calculateU.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/calculate/calculateU.mjs");
/* harmony import */ var _getBytesFromHex_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../getBytesFromHex.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getBytesFromHex.mjs");
/* harmony import */ var _getHashFromData_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../getHashFromData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHashFromData.mjs");
/* harmony import */ var _getHashFromHex_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../getHashFromHex.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHashFromHex.mjs");
/* harmony import */ var _getHexFromBytes_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../getHexFromBytes.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHexFromBytes.mjs");
/* harmony import */ var _getHkdfKey_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../getHkdfKey.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHkdfKey.mjs");
/* harmony import */ var _getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../getPaddedHex.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getPaddedHex.mjs");
/* harmony import */ var _getRandomBytes_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../getRandomBytes.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getRandomBytes.mjs");
/* harmony import */ var _getRandomString_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../getRandomString.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getRandomString.mjs");














// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/** @class */
class AuthenticationHelper {
    constructor({ userPoolName, a, g, A, N, }) {
        this.encoder = _textEncoder_index_mjs__WEBPACK_IMPORTED_MODULE_0__.textEncoder;
        this.userPoolName = userPoolName;
        this.a = a;
        this.g = g;
        this.A = A;
        this.N = N;
        this.k = new _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]((0,_getHashFromHex_mjs__WEBPACK_IMPORTED_MODULE_2__.getHashFromHex)(`${(0,_getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_3__.getPaddedHex)(N)}${(0,_getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_3__.getPaddedHex)(g)}`), 16);
    }
    /**
     * @returns {string} Generated random value included in password hash.
     */
    getRandomPassword() {
        if (!this.randomPassword) {
            throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_4__.AuthError({
                name: 'EmptyBigIntegerRandomPassword',
                message: 'random password is empty',
            });
        }
        return this.randomPassword;
    }
    /**
     * @returns {string} Generated random value included in devices hash.
     */
    getSaltToHashDevices() {
        if (!this.saltToHashDevices) {
            throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_4__.AuthError({
                name: 'EmptyBigIntegersaltToHashDevices',
                message: 'saltToHashDevices is empty',
            });
        }
        return this.saltToHashDevices;
    }
    /**
     * @returns {string} Value used to verify devices.
     */
    getVerifierDevices() {
        if (!this.verifierDevices) {
            throw new _errors_AuthError_mjs__WEBPACK_IMPORTED_MODULE_4__.AuthError({
                name: 'EmptyBigIntegerVerifierDevices',
                message: 'verifyDevices is empty',
            });
        }
        return this.verifierDevices;
    }
    /**
     * Generate salts and compute verifier.
     *
     * @param {string} deviceGroupKey Devices to generate verifier for.
     * @param {string} username User to generate verifier for.
     *
     * @returns {Promise<void>}
     */
    async generateHashDevice(deviceGroupKey, username) {
        this.randomPassword = (0,_getRandomString_mjs__WEBPACK_IMPORTED_MODULE_5__.getRandomString)();
        const combinedString = `${deviceGroupKey}${username}:${this.randomPassword}`;
        const hashedString = (0,_getHashFromData_mjs__WEBPACK_IMPORTED_MODULE_6__.getHashFromData)(combinedString);
        const hexRandom = (0,_getHexFromBytes_mjs__WEBPACK_IMPORTED_MODULE_7__.getHexFromBytes)((0,_getRandomBytes_mjs__WEBPACK_IMPORTED_MODULE_8__.getRandomBytes)(16));
        // The random hex will be unambiguously represented as a postive integer
        this.saltToHashDevices = (0,_getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_3__.getPaddedHex)(new _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__["default"](hexRandom, 16));
        return new Promise((resolve, reject) => {
            this.g.modPow(new _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]((0,_getHashFromHex_mjs__WEBPACK_IMPORTED_MODULE_2__.getHashFromHex)(this.saltToHashDevices + hashedString), 16), this.N, (err, result) => {
                if (err) {
                    reject(err);
                    return;
                }
                this.verifierDevices = (0,_getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_3__.getPaddedHex)(result);
                resolve();
            });
        });
    }
    /**
     * Calculates the final HKDF key based on computed S value, computed U value and the key
     *
     * @param {String} username Username.
     * @param {String} password Password.
     * @param {AuthBigInteger} B Server B value.
     * @param {AuthBigInteger} salt Generated salt.
     */
    async getPasswordAuthenticationKey({ username, password, serverBValue, salt, }) {
        if (serverBValue.mod(this.N).equals(_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].ZERO)) {
            throw new Error('B cannot be zero.');
        }
        const U = (0,_calculate_calculateU_mjs__WEBPACK_IMPORTED_MODULE_9__.calculateU)({
            A: this.A,
            B: serverBValue,
        });
        const usernamePassword = `${this.userPoolName}${username}:${password}`;
        const usernamePasswordHash = (0,_getHashFromData_mjs__WEBPACK_IMPORTED_MODULE_6__.getHashFromData)(usernamePassword);
        const x = new _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]((0,_getHashFromHex_mjs__WEBPACK_IMPORTED_MODULE_2__.getHashFromHex)((0,_getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_3__.getPaddedHex)(salt) + usernamePasswordHash), 16);
        const S = await (0,_calculate_calculateS_mjs__WEBPACK_IMPORTED_MODULE_10__.calculateS)({
            a: this.a,
            g: this.g,
            k: this.k,
            x,
            B: serverBValue,
            N: this.N,
            U,
        });
        const context = this.encoder.convert('Caldera Derived Key');
        const spacer = this.encoder.convert(String.fromCharCode(1));
        const info = new Uint8Array(context.byteLength + spacer.byteLength);
        info.set(context, 0);
        info.set(spacer, context.byteLength);
        const hkdfKey = (0,_getHkdfKey_mjs__WEBPACK_IMPORTED_MODULE_11__.getHkdfKey)((0,_getBytesFromHex_mjs__WEBPACK_IMPORTED_MODULE_12__.getBytesFromHex)((0,_getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_3__.getPaddedHex)(S)), (0,_getBytesFromHex_mjs__WEBPACK_IMPORTED_MODULE_12__.getBytesFromHex)((0,_getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_3__.getPaddedHex)(U)), info);
        return hkdfKey;
    }
}


//# sourceMappingURL=AuthenticationHelper.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/BigInteger/BigInteger.mjs":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/BigInteger/BigInteger.mjs ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BigInteger)
/* harmony export */ });
/* eslint-disable */
// @ts-nocheck -> BigInteger is already a vended utility
// A small implementation of BigInteger based on http://www-cs-students.stanford.edu/~tjw/jsbn/
//
// All public methods have been removed except the following:
//   new BigInteger(a, b) (only radix 2, 4, 8, 16 and 32 supported)
//   toString (only radix 2, 4, 8, 16 and 32 supported)
//   negate
//   abs
//   compareTo
//   bitLength
//   mod
//   equals
//   add
//   subtract
//   multiply
//   divide
//   modPow
/*
 * Copyright (c) 2003-2005  Tom Wu
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
 *
 * IN NO EVENT SHALL TOM WU BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF
 * THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT
 * OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * In addition, the following condition applies:
 *
 * All redistributions must retain an intact copy of this copyright notice
 * and disclaimer.
 */
// (public) Constructor
function BigInteger(a, b) {
    if (a != null)
        this.fromString(a, b);
}
// return new, unset BigInteger
function nbi() {
    return new BigInteger(null, null);
}
// Bits per digit
let dbits;
// JavaScript engine analysis
const canary = 0xdeadbeefcafe;
const j_lm = (canary & 0xffffff) === 0xefcafe;
// am: Compute w_j += (x*this_i), propagate carries,
// c is initial carry, returns final carry.
// c < 3*dvalue, x < 2*dvalue, this_i < dvalue
// We need to select the fastest one that works in this environment.
// am1: use a single mult and divide to get the high bits,
// max digit bits should be 26 because
// max internal value = 2*dvalue^2-2*dvalue (< 2^53)
function am1(i, x, w, j, c, n) {
    while (--n >= 0) {
        const v = x * this[i++] + w[j] + c;
        c = Math.floor(v / 0x4000000);
        w[j++] = v & 0x3ffffff;
    }
    return c;
}
// am2 avoids a big mult-and-extract completely.
// Max digit bits should be <= 30 because we do bitwise ops
// on values up to 2*hdvalue^2-hdvalue-1 (< 2^31)
function am2(i, x, w, j, c, n) {
    const xl = x & 0x7fff;
    const xh = x >> 15;
    while (--n >= 0) {
        let l = this[i] & 0x7fff;
        const h = this[i++] >> 15;
        const m = xh * l + h * xl;
        l = xl * l + ((m & 0x7fff) << 15) + w[j] + (c & 0x3fffffff);
        c = (l >>> 30) + (m >>> 15) + xh * h + (c >>> 30);
        w[j++] = l & 0x3fffffff;
    }
    return c;
}
// Alternately, set max digit bits to 28 since some
// browsers slow down when dealing with 32-bit numbers.
function am3(i, x, w, j, c, n) {
    const xl = x & 0x3fff;
    const xh = x >> 14;
    while (--n >= 0) {
        let l = this[i] & 0x3fff;
        const h = this[i++] >> 14;
        const m = xh * l + h * xl;
        l = xl * l + ((m & 0x3fff) << 14) + w[j] + c;
        c = (l >> 28) + (m >> 14) + xh * h;
        w[j++] = l & 0xfffffff;
    }
    return c;
}
const inBrowser = typeof navigator !== 'undefined';
if (inBrowser && j_lm && navigator.appName === 'Microsoft Internet Explorer') {
    BigInteger.prototype.am = am2;
    dbits = 30;
}
else if (inBrowser && j_lm && navigator.appName !== 'Netscape') {
    BigInteger.prototype.am = am1;
    dbits = 26;
}
else {
    // Mozilla/Netscape seems to prefer am3
    BigInteger.prototype.am = am3;
    dbits = 28;
}
BigInteger.prototype.DB = dbits;
BigInteger.prototype.DM = (1 << dbits) - 1;
BigInteger.prototype.DV = 1 << dbits;
const BI_FP = 52;
BigInteger.prototype.FV = Math.pow(2, BI_FP);
BigInteger.prototype.F1 = BI_FP - dbits;
BigInteger.prototype.F2 = 2 * dbits - BI_FP;
// Digit conversions
const BI_RM = '0123456789abcdefghijklmnopqrstuvwxyz';
const BI_RC = [];
let rr, vv;
rr = '0'.charCodeAt(0);
for (vv = 0; vv <= 9; ++vv)
    BI_RC[rr++] = vv;
rr = 'a'.charCodeAt(0);
for (vv = 10; vv < 36; ++vv)
    BI_RC[rr++] = vv;
rr = 'A'.charCodeAt(0);
for (vv = 10; vv < 36; ++vv)
    BI_RC[rr++] = vv;
function int2char(n) {
    return BI_RM.charAt(n);
}
function intAt(s, i) {
    const c = BI_RC[s.charCodeAt(i)];
    return c == null ? -1 : c;
}
// (protected) copy this to r
function bnpCopyTo(r) {
    for (let i = this.t - 1; i >= 0; --i)
        r[i] = this[i];
    r.t = this.t;
    r.s = this.s;
}
// (protected) set from integer value x, -DV <= x < DV
function bnpFromInt(x) {
    this.t = 1;
    this.s = x < 0 ? -1 : 0;
    if (x > 0)
        this[0] = x;
    else if (x < -1)
        this[0] = x + this.DV;
    else
        this.t = 0;
}
// return bigint initialized to value
function nbv(i) {
    const r = nbi();
    r.fromInt(i);
    return r;
}
// (protected) set from string and radix
function bnpFromString(s, b) {
    let k;
    if (b === 16)
        k = 4;
    else if (b === 8)
        k = 3;
    else if (b === 2)
        k = 1;
    else if (b === 32)
        k = 5;
    else if (b === 4)
        k = 2;
    else
        throw new Error('Only radix 2, 4, 8, 16, 32 are supported');
    this.t = 0;
    this.s = 0;
    let i = s.length;
    let mi = false;
    let sh = 0;
    while (--i >= 0) {
        const x = intAt(s, i);
        if (x < 0) {
            if (s.charAt(i) === '-')
                mi = true;
            continue;
        }
        mi = false;
        if (sh === 0)
            this[this.t++] = x;
        else if (sh + k > this.DB) {
            this[this.t - 1] |= (x & ((1 << (this.DB - sh)) - 1)) << sh;
            this[this.t++] = x >> (this.DB - sh);
        }
        else
            this[this.t - 1] |= x << sh;
        sh += k;
        if (sh >= this.DB)
            sh -= this.DB;
    }
    this.clamp();
    if (mi)
        BigInteger.ZERO.subTo(this, this);
}
// (protected) clamp off excess high words
function bnpClamp() {
    const c = this.s & this.DM;
    while (this.t > 0 && this[this.t - 1] == c)
        --this.t;
}
// (public) return string representation in given radix
function bnToString(b) {
    if (this.s < 0)
        return '-' + this.negate().toString(b);
    let k;
    if (b == 16)
        k = 4;
    else if (b === 8)
        k = 3;
    else if (b === 2)
        k = 1;
    else if (b === 32)
        k = 5;
    else if (b === 4)
        k = 2;
    else
        throw new Error('Only radix 2, 4, 8, 16, 32 are supported');
    const km = (1 << k) - 1;
    let d;
    let m = false;
    let r = '';
    let i = this.t;
    let p = this.DB - ((i * this.DB) % k);
    if (i-- > 0) {
        if (p < this.DB && (d = this[i] >> p) > 0) {
            m = true;
            r = int2char(d);
        }
        while (i >= 0) {
            if (p < k) {
                d = (this[i] & ((1 << p) - 1)) << (k - p);
                d |= this[--i] >> (p += this.DB - k);
            }
            else {
                d = (this[i] >> (p -= k)) & km;
                if (p <= 0) {
                    p += this.DB;
                    --i;
                }
            }
            if (d > 0)
                m = true;
            if (m)
                r += int2char(d);
        }
    }
    return m ? r : '0';
}
// (public) -this
function bnNegate() {
    const r = nbi();
    BigInteger.ZERO.subTo(this, r);
    return r;
}
// (public) |this|
function bnAbs() {
    return this.s < 0 ? this.negate() : this;
}
// (public) return + if this > a, - if this < a, 0 if equal
function bnCompareTo(a) {
    let r = this.s - a.s;
    if (r != 0)
        return r;
    let i = this.t;
    r = i - a.t;
    if (r != 0)
        return this.s < 0 ? -r : r;
    while (--i >= 0)
        if ((r = this[i] - a[i]) != 0)
            return r;
    return 0;
}
// returns bit length of the integer x
function nbits(x) {
    let r = 1;
    let t;
    if ((t = x >>> 16) !== 0) {
        x = t;
        r += 16;
    }
    if ((t = x >> 8) !== 0) {
        x = t;
        r += 8;
    }
    if ((t = x >> 4) !== 0) {
        x = t;
        r += 4;
    }
    if ((t = x >> 2) !== 0) {
        x = t;
        r += 2;
    }
    if ((t = x >> 1) !== 0) {
        x = t;
        r += 1;
    }
    return r;
}
// (public) return the number of bits in "this"
function bnBitLength() {
    if (this.t <= 0)
        return 0;
    return this.DB * (this.t - 1) + nbits(this[this.t - 1] ^ (this.s & this.DM));
}
// (protected) r = this << n*DB
function bnpDLShiftTo(n, r) {
    let i;
    for (i = this.t - 1; i >= 0; --i)
        r[i + n] = this[i];
    for (i = n - 1; i >= 0; --i)
        r[i] = 0;
    r.t = this.t + n;
    r.s = this.s;
}
// (protected) r = this >> n*DB
function bnpDRShiftTo(n, r) {
    for (let i = n; i < this.t; ++i)
        r[i - n] = this[i];
    r.t = Math.max(this.t - n, 0);
    r.s = this.s;
}
// (protected) r = this << n
function bnpLShiftTo(n, r) {
    const bs = n % this.DB;
    const cbs = this.DB - bs;
    const bm = (1 << cbs) - 1;
    const ds = Math.floor(n / this.DB);
    let c = (this.s << bs) & this.DM;
    let i;
    for (i = this.t - 1; i >= 0; --i) {
        r[i + ds + 1] = (this[i] >> cbs) | c;
        c = (this[i] & bm) << bs;
    }
    for (i = ds - 1; i >= 0; --i)
        r[i] = 0;
    r[ds] = c;
    r.t = this.t + ds + 1;
    r.s = this.s;
    r.clamp();
}
// (protected) r = this >> n
function bnpRShiftTo(n, r) {
    r.s = this.s;
    const ds = Math.floor(n / this.DB);
    if (ds >= this.t) {
        r.t = 0;
        return;
    }
    const bs = n % this.DB;
    const cbs = this.DB - bs;
    const bm = (1 << bs) - 1;
    r[0] = this[ds] >> bs;
    for (let i = ds + 1; i < this.t; ++i) {
        r[i - ds - 1] |= (this[i] & bm) << cbs;
        r[i - ds] = this[i] >> bs;
    }
    if (bs > 0)
        r[this.t - ds - 1] |= (this.s & bm) << cbs;
    r.t = this.t - ds;
    r.clamp();
}
// (protected) r = this - a
function bnpSubTo(a, r) {
    let i = 0;
    let c = 0;
    const m = Math.min(a.t, this.t);
    while (i < m) {
        c += this[i] - a[i];
        r[i++] = c & this.DM;
        c >>= this.DB;
    }
    if (a.t < this.t) {
        c -= a.s;
        while (i < this.t) {
            c += this[i];
            r[i++] = c & this.DM;
            c >>= this.DB;
        }
        c += this.s;
    }
    else {
        c += this.s;
        while (i < a.t) {
            c -= a[i];
            r[i++] = c & this.DM;
            c >>= this.DB;
        }
        c -= a.s;
    }
    r.s = c < 0 ? -1 : 0;
    if (c < -1)
        r[i++] = this.DV + c;
    else if (c > 0)
        r[i++] = c;
    r.t = i;
    r.clamp();
}
// (protected) r = this * a, r != this,a (HAC 14.12)
// "this" should be the larger one if appropriate.
function bnpMultiplyTo(a, r) {
    const x = this.abs();
    const y = a.abs();
    let i = x.t;
    r.t = i + y.t;
    while (--i >= 0)
        r[i] = 0;
    for (i = 0; i < y.t; ++i)
        r[i + x.t] = x.am(0, y[i], r, i, 0, x.t);
    r.s = 0;
    r.clamp();
    if (this.s !== a.s)
        BigInteger.ZERO.subTo(r, r);
}
// (protected) r = this^2, r != this (HAC 14.16)
function bnpSquareTo(r) {
    const x = this.abs();
    let i = (r.t = 2 * x.t);
    while (--i >= 0)
        r[i] = 0;
    for (i = 0; i < x.t - 1; ++i) {
        const c = x.am(i, x[i], r, 2 * i, 0, 1);
        if ((r[i + x.t] += x.am(i + 1, 2 * x[i], r, 2 * i + 1, c, x.t - i - 1)) >=
            x.DV) {
            r[i + x.t] -= x.DV;
            r[i + x.t + 1] = 1;
        }
    }
    if (r.t > 0)
        r[r.t - 1] += x.am(i, x[i], r, 2 * i, 0, 1);
    r.s = 0;
    r.clamp();
}
// (protected) divide this by m, quotient and remainder to q, r (HAC 14.20)
// r != q, this != m.  q or r may be null.
function bnpDivRemTo(m, q, r) {
    const pm = m.abs();
    if (pm.t <= 0)
        return;
    const pt = this.abs();
    if (pt.t < pm.t) {
        if (q != null)
            q.fromInt(0);
        if (r != null)
            this.copyTo(r);
        return;
    }
    if (r === null)
        r = nbi();
    const y = nbi();
    const ts = this.s;
    const ms = m.s;
    const nsh = this.DB - nbits(pm[pm.t - 1]);
    // normalize modulus
    if (nsh > 0) {
        pm.lShiftTo(nsh, y);
        pt.lShiftTo(nsh, r);
    }
    else {
        pm.copyTo(y);
        pt.copyTo(r);
    }
    const ys = y.t;
    const y0 = y[ys - 1];
    if (y0 === 0)
        return;
    const yt = y0 * (1 << this.F1) + (ys > 1 ? y[ys - 2] >> this.F2 : 0);
    const d1 = this.FV / yt;
    const d2 = (1 << this.F1) / yt;
    const e = 1 << this.F2;
    let i = r.t;
    let j = i - ys;
    const t = q === null ? nbi() : q;
    y.dlShiftTo(j, t);
    if (r.compareTo(t) >= 0) {
        r[r.t++] = 1;
        r.subTo(t, r);
    }
    BigInteger.ONE.dlShiftTo(ys, t);
    t.subTo(y, y);
    // "negative" y so we can replace sub with am later
    while (y.t < ys)
        y[y.t++] = 0;
    while (--j >= 0) {
        // Estimate quotient digit
        let qd = r[--i] === y0 ? this.DM : Math.floor(r[i] * d1 + (r[i - 1] + e) * d2);
        if ((r[i] += y.am(0, qd, r, j, 0, ys)) < qd) {
            // Try it out
            y.dlShiftTo(j, t);
            r.subTo(t, r);
            while (r[i] < --qd)
                r.subTo(t, r);
        }
    }
    if (q !== null) {
        r.drShiftTo(ys, q);
        if (ts !== ms)
            BigInteger.ZERO.subTo(q, q);
    }
    r.t = ys;
    r.clamp();
    if (nsh > 0)
        r.rShiftTo(nsh, r);
    // Denormalize remainder
    if (ts < 0)
        BigInteger.ZERO.subTo(r, r);
}
// (public) this mod a
function bnMod(a) {
    const r = nbi();
    this.abs().divRemTo(a, null, r);
    if (this.s < 0 && r.compareTo(BigInteger.ZERO) > 0)
        a.subTo(r, r);
    return r;
}
// (protected) return "-1/this % 2^DB"; useful for Mont. reduction
// justification:
//         xy == 1 (mod m)
//         xy =  1+km
//   xy(2-xy) = (1+km)(1-km)
// x[y(2-xy)] = 1-k^2m^2
// x[y(2-xy)] == 1 (mod m^2)
// if y is 1/x mod m, then y(2-xy) is 1/x mod m^2
// should reduce x and y(2-xy) by m^2 at each step to keep size bounded.
// JS multiply "overflows" differently from C/C++, so care is needed here.
function bnpInvDigit() {
    if (this.t < 1)
        return 0;
    const x = this[0];
    if ((x & 1) === 0)
        return 0;
    let y = x & 3;
    // y == 1/x mod 2^2
    y = (y * (2 - (x & 0xf) * y)) & 0xf;
    // y == 1/x mod 2^4
    y = (y * (2 - (x & 0xff) * y)) & 0xff;
    // y == 1/x mod 2^8
    y = (y * (2 - (((x & 0xffff) * y) & 0xffff))) & 0xffff;
    // y == 1/x mod 2^16
    // last step - calculate inverse mod DV directly;
    // assumes 16 < DB <= 32 and assumes ability to handle 48-bit ints
    y = (y * (2 - ((x * y) % this.DV))) % this.DV;
    // y == 1/x mod 2^dbits
    // we really want the negative inverse, and -DV < y < DV
    return y > 0 ? this.DV - y : -y;
}
function bnEquals(a) {
    return this.compareTo(a) === 0;
}
// (protected) r = this + a
function bnpAddTo(a, r) {
    let i = 0;
    let c = 0;
    const m = Math.min(a.t, this.t);
    while (i < m) {
        c += this[i] + a[i];
        r[i++] = c & this.DM;
        c >>= this.DB;
    }
    if (a.t < this.t) {
        c += a.s;
        while (i < this.t) {
            c += this[i];
            r[i++] = c & this.DM;
            c >>= this.DB;
        }
        c += this.s;
    }
    else {
        c += this.s;
        while (i < a.t) {
            c += a[i];
            r[i++] = c & this.DM;
            c >>= this.DB;
        }
        c += a.s;
    }
    r.s = c < 0 ? -1 : 0;
    if (c > 0)
        r[i++] = c;
    else if (c < -1)
        r[i++] = this.DV + c;
    r.t = i;
    r.clamp();
}
// (public) this + a
function bnAdd(a) {
    const r = nbi();
    this.addTo(a, r);
    return r;
}
// (public) this - a
function bnSubtract(a) {
    const r = nbi();
    this.subTo(a, r);
    return r;
}
// (public) this * a
function bnMultiply(a) {
    const r = nbi();
    this.multiplyTo(a, r);
    return r;
}
// (public) this / a
function bnDivide(a) {
    const r = nbi();
    this.divRemTo(a, r, null);
    return r;
}
// Montgomery reduction
function Montgomery(m) {
    this.m = m;
    this.mp = m.invDigit();
    this.mpl = this.mp & 0x7fff;
    this.mph = this.mp >> 15;
    this.um = (1 << (m.DB - 15)) - 1;
    this.mt2 = 2 * m.t;
}
// xR mod m
function montConvert(x) {
    const r = nbi();
    x.abs().dlShiftTo(this.m.t, r);
    r.divRemTo(this.m, null, r);
    if (x.s < 0 && r.compareTo(BigInteger.ZERO) > 0)
        this.m.subTo(r, r);
    return r;
}
// x/R mod m
function montRevert(x) {
    const r = nbi();
    x.copyTo(r);
    this.reduce(r);
    return r;
}
// x = x/R mod m (HAC 14.32)
function montReduce(x) {
    while (x.t <= this.mt2)
        // pad x so am has enough room later
        x[x.t++] = 0;
    for (let i = 0; i < this.m.t; ++i) {
        // faster way of calculating u0 = x[i]*mp mod DV
        let j = x[i] & 0x7fff;
        const u0 = (j * this.mpl +
            (((j * this.mph + (x[i] >> 15) * this.mpl) & this.um) << 15)) &
            x.DM;
        // use am to combine the multiply-shift-add into one call
        j = i + this.m.t;
        x[j] += this.m.am(0, u0, x, i, 0, this.m.t);
        // propagate carry
        while (x[j] >= x.DV) {
            x[j] -= x.DV;
            x[++j]++;
        }
    }
    x.clamp();
    x.drShiftTo(this.m.t, x);
    if (x.compareTo(this.m) >= 0)
        x.subTo(this.m, x);
}
// r = "x^2/R mod m"; x != r
function montSqrTo(x, r) {
    x.squareTo(r);
    this.reduce(r);
}
// r = "xy/R mod m"; x,y != r
function montMulTo(x, y, r) {
    x.multiplyTo(y, r);
    this.reduce(r);
}
Montgomery.prototype.convert = montConvert;
Montgomery.prototype.revert = montRevert;
Montgomery.prototype.reduce = montReduce;
Montgomery.prototype.mulTo = montMulTo;
Montgomery.prototype.sqrTo = montSqrTo;
// (public) this^e % m (HAC 14.85)
function bnModPow(e, m, callback) {
    let i = e.bitLength();
    let k;
    let r = nbv(1);
    const z = new Montgomery(m);
    if (i <= 0)
        return r;
    else if (i < 18)
        k = 1;
    else if (i < 48)
        k = 3;
    else if (i < 144)
        k = 4;
    else if (i < 768)
        k = 5;
    else
        k = 6;
    // precomputation
    const g = [];
    let n = 3;
    const k1 = k - 1;
    const km = (1 << k) - 1;
    g[1] = z.convert(this);
    if (k > 1) {
        const g2 = nbi();
        z.sqrTo(g[1], g2);
        while (n <= km) {
            g[n] = nbi();
            z.mulTo(g2, g[n - 2], g[n]);
            n += 2;
        }
    }
    let j = e.t - 1;
    let w;
    let is1 = true;
    let r2 = nbi();
    let t;
    i = nbits(e[j]) - 1;
    while (j >= 0) {
        if (i >= k1)
            w = (e[j] >> (i - k1)) & km;
        else {
            w = (e[j] & ((1 << (i + 1)) - 1)) << (k1 - i);
            if (j > 0)
                w |= e[j - 1] >> (this.DB + i - k1);
        }
        n = k;
        while ((w & 1) === 0) {
            w >>= 1;
            --n;
        }
        if ((i -= n) < 0) {
            i += this.DB;
            --j;
        }
        if (is1) {
            // ret == 1, don't bother squaring or multiplying it
            g[w].copyTo(r);
            is1 = false;
        }
        else {
            while (n > 1) {
                z.sqrTo(r, r2);
                z.sqrTo(r2, r);
                n -= 2;
            }
            if (n > 0)
                z.sqrTo(r, r2);
            else {
                t = r;
                r = r2;
                r2 = t;
            }
            z.mulTo(r2, g[w], r);
        }
        while (j >= 0 && (e[j] & (1 << i)) === 0) {
            z.sqrTo(r, r2);
            t = r;
            r = r2;
            r2 = t;
            if (--i < 0) {
                i = this.DB - 1;
                --j;
            }
        }
    }
    const result = z.revert(r);
    callback(null, result);
    return result;
}
// protected
BigInteger.prototype.copyTo = bnpCopyTo;
BigInteger.prototype.fromInt = bnpFromInt;
BigInteger.prototype.fromString = bnpFromString;
BigInteger.prototype.clamp = bnpClamp;
BigInteger.prototype.dlShiftTo = bnpDLShiftTo;
BigInteger.prototype.drShiftTo = bnpDRShiftTo;
BigInteger.prototype.lShiftTo = bnpLShiftTo;
BigInteger.prototype.rShiftTo = bnpRShiftTo;
BigInteger.prototype.subTo = bnpSubTo;
BigInteger.prototype.multiplyTo = bnpMultiplyTo;
BigInteger.prototype.squareTo = bnpSquareTo;
BigInteger.prototype.divRemTo = bnpDivRemTo;
BigInteger.prototype.invDigit = bnpInvDigit;
BigInteger.prototype.addTo = bnpAddTo;
// public
BigInteger.prototype.toString = bnToString;
BigInteger.prototype.negate = bnNegate;
BigInteger.prototype.abs = bnAbs;
BigInteger.prototype.compareTo = bnCompareTo;
BigInteger.prototype.bitLength = bnBitLength;
BigInteger.prototype.mod = bnMod;
BigInteger.prototype.equals = bnEquals;
BigInteger.prototype.add = bnAdd;
BigInteger.prototype.subtract = bnSubtract;
BigInteger.prototype.multiply = bnMultiply;
BigInteger.prototype.divide = bnDivide;
BigInteger.prototype.modPow = bnModPow;
// "constants"
BigInteger.ZERO = nbv(0);
BigInteger.ONE = nbv(1);


//# sourceMappingURL=BigInteger.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/calculate/calculateA.mjs":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/calculate/calculateA.mjs ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateA: () => (/* binding */ calculateA)
/* harmony export */ });
/* harmony import */ var _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../BigInteger/BigInteger.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/BigInteger/BigInteger.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * @internal
 */
const calculateA = async ({ a, g, N, }) => {
    return new Promise((resolve, reject) => {
        g.modPow(a, N, (err, A) => {
            if (err) {
                reject(err);
                return;
            }
            if (A.mod(N).equals(_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_0__["default"].ZERO)) {
                reject(new Error('Illegal parameter. A mod N cannot be 0.'));
                return;
            }
            resolve(A);
        });
    });
};


//# sourceMappingURL=calculateA.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/calculate/calculateS.mjs":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/calculate/calculateS.mjs ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateS: () => (/* binding */ calculateS)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * @internal
 */
const calculateS = async ({ a, g, k, x, B, N, U, }) => {
    return new Promise((resolve, reject) => {
        g.modPow(x, N, (outerErr, outerResult) => {
            if (outerErr) {
                reject(outerErr);
                return;
            }
            B.subtract(k.multiply(outerResult)).modPow(a.add(U.multiply(x)), N, (innerErr, innerResult) => {
                if (innerErr) {
                    reject(innerErr);
                    return;
                }
                resolve(innerResult.mod(N));
            });
        });
    });
};


//# sourceMappingURL=calculateS.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/calculate/calculateU.mjs":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/calculate/calculateU.mjs ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateU: () => (/* binding */ calculateU)
/* harmony export */ });
/* harmony import */ var _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../BigInteger/BigInteger.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/BigInteger/BigInteger.mjs");
/* harmony import */ var _getHashFromHex_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../getHashFromHex.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHashFromHex.mjs");
/* harmony import */ var _getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../getPaddedHex.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getPaddedHex.mjs");




// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * @internal
 */
const calculateU = ({ A, B, }) => {
    const U = new _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]((0,_getHashFromHex_mjs__WEBPACK_IMPORTED_MODULE_1__.getHashFromHex)((0,_getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_2__.getPaddedHex)(A) + (0,_getPaddedHex_mjs__WEBPACK_IMPORTED_MODULE_2__.getPaddedHex)(B)), 16);
    if (U.equals(_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_0__["default"].ZERO)) {
        throw new Error('U cannot be zero.');
    }
    return U;
};


//# sourceMappingURL=calculateU.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/constants.mjs":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/constants.mjs ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HEX_TO_SHORT: () => (/* binding */ HEX_TO_SHORT),
/* harmony export */   INIT_N: () => (/* binding */ INIT_N),
/* harmony export */   SHORT_TO_HEX: () => (/* binding */ SHORT_TO_HEX)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const INIT_N = 'FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD1' +
    '29024E088A67CC74020BBEA63B139B22514A08798E3404DD' +
    'EF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245' +
    'E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7ED' +
    'EE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3D' +
    'C2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F' +
    '83655D23DCA3AD961C62F356208552BB9ED529077096966D' +
    '670C354E4ABC9804F1746C08CA18217C32905E462E36CE3B' +
    'E39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9' +
    'DE2BCBF6955817183995497CEA956AE515D2261898FA0510' +
    '15728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64' +
    'ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7' +
    'ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6B' +
    'F12FFA06D98A0864D87602733EC86A64521F2B18177B200C' +
    'BBE117577A615D6C770988C0BAD946E208E24FA074E5AB31' +
    '43DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF';
const SHORT_TO_HEX = {};
const HEX_TO_SHORT = {};
for (let i = 0; i < 256; i++) {
    let encodedByte = i.toString(16).toLowerCase();
    if (encodedByte.length === 1) {
        encodedByte = `0${encodedByte}`;
    }
    SHORT_TO_HEX[i] = encodedByte;
    HEX_TO_SHORT[encodedByte] = i;
}


//# sourceMappingURL=constants.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getAuthenticationHelper.mjs":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getAuthenticationHelper.mjs ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getAuthenticationHelper: () => (/* binding */ getAuthenticationHelper)
/* harmony export */ });
/* harmony import */ var _AuthenticationHelper_AuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AuthenticationHelper/AuthenticationHelper.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/AuthenticationHelper/AuthenticationHelper.mjs");
/* harmony import */ var _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BigInteger/BigInteger.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/BigInteger/BigInteger.mjs");
/* harmony import */ var _calculate_calculateA_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./calculate/calculateA.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/calculate/calculateA.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/constants.mjs");
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _getHexFromBytes_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getHexFromBytes.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHexFromBytes.mjs");
/* harmony import */ var _getRandomBytes_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./getRandomBytes.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getRandomBytes.mjs");








// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Returns a new {@link AuthenticationHelper} instance with randomly generated BigInteger seed
 *
 * @param userPoolName Cognito user pool name.
 * @returns An {@link AuthenticationHelper} instance.
 *
 * @internal
 */
const getAuthenticationHelper = async (userPoolName) => {
    const N = new _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__["default"](_constants_mjs__WEBPACK_IMPORTED_MODULE_2__.INIT_N, 16);
    const g = new _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__["default"]('2', 16);
    const a = generateRandomBigInteger();
    const A = await (0,_calculate_calculateA_mjs__WEBPACK_IMPORTED_MODULE_3__.calculateA)({ a, g, N });
    return new _AuthenticationHelper_AuthenticationHelper_mjs__WEBPACK_IMPORTED_MODULE_4__["default"]({ userPoolName, a, g, A, N });
};
/**
 * Generates a random BigInteger.
 *
 * @returns {BigInteger} a random value.
 */
const generateRandomBigInteger = () => {
    // This will be interpreted as a postive 128-bit integer
    const hexRandom = (0,_getHexFromBytes_mjs__WEBPACK_IMPORTED_MODULE_5__.getHexFromBytes)((0,_getRandomBytes_mjs__WEBPACK_IMPORTED_MODULE_6__.getRandomBytes)(128));
    // There is no need to do randomBigInt.mod(this.N - 1) as N (3072-bit) is > 128 bytes (1024-bit)
    return new _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_1__["default"](hexRandom, 16);
};


//# sourceMappingURL=getAuthenticationHelper.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getBytesFromHex.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getBytesFromHex.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getBytesFromHex: () => (/* binding */ getBytesFromHex)
/* harmony export */ });
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/constants.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Converts a hexadecimal encoded string to a Uint8Array of bytes.
 *
 * @param encoded The hexadecimal encoded string
 */
const getBytesFromHex = (encoded) => {
    if (encoded.length % 2 !== 0) {
        throw new Error('Hex encoded strings must have an even number length');
    }
    const out = new Uint8Array(encoded.length / 2);
    for (let i = 0; i < encoded.length; i += 2) {
        const encodedByte = encoded.slice(i, i + 2).toLowerCase();
        if (encodedByte in _constants_mjs__WEBPACK_IMPORTED_MODULE_0__.HEX_TO_SHORT) {
            out[i / 2] = _constants_mjs__WEBPACK_IMPORTED_MODULE_0__.HEX_TO_SHORT[encodedByte];
        }
        else {
            throw new Error(`Cannot decode unrecognized sequence ${encodedByte} as hexadecimal`);
        }
    }
    return out;
};


//# sourceMappingURL=getBytesFromHex.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHashFromData.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHashFromData.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getHashFromData: () => (/* binding */ getHashFromData)
/* harmony export */ });
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _getHexFromBytes_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getHexFromBytes.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHexFromBytes.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Calculate a hash from a `SourceData`
 * @param {SourceData} data Value to hash.
 * @returns {string} Hex-encoded hash.
 * @private
 */
const getHashFromData = (data) => {
    const sha256 = new _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__.Sha256();
    sha256.update(data);
    const hashedData = sha256.digestSync();
    const hashHexFromUint8 = (0,_getHexFromBytes_mjs__WEBPACK_IMPORTED_MODULE_1__.getHexFromBytes)(hashedData);
    return new Array(64 - hashHexFromUint8.length).join('0') + hashHexFromUint8;
};


//# sourceMappingURL=getHashFromData.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHashFromHex.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHashFromHex.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getHashFromHex: () => (/* binding */ getHashFromHex)
/* harmony export */ });
/* harmony import */ var _getBytesFromHex_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getBytesFromHex.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getBytesFromHex.mjs");
/* harmony import */ var _getHashFromData_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getHashFromData.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHashFromData.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Calculate a hash from a hex string
 * @param {string} hexStr Value to hash.
 * @returns {string} Hex-encoded hash.
 * @private
 */
const getHashFromHex = (hexStr) => (0,_getHashFromData_mjs__WEBPACK_IMPORTED_MODULE_0__.getHashFromData)((0,_getBytesFromHex_mjs__WEBPACK_IMPORTED_MODULE_1__.getBytesFromHex)(hexStr));


//# sourceMappingURL=getHashFromHex.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHexFromBytes.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHexFromBytes.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getHexFromBytes: () => (/* binding */ getHexFromBytes)
/* harmony export */ });
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/constants.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Converts a Uint8Array of binary data to a hexadecimal encoded string.
 *
 * @param bytes The binary data to encode
 */
const getHexFromBytes = (bytes) => {
    let out = '';
    for (let i = 0; i < bytes.byteLength; i++) {
        out += _constants_mjs__WEBPACK_IMPORTED_MODULE_0__.SHORT_TO_HEX[bytes[i]];
    }
    return out;
};


//# sourceMappingURL=getHexFromBytes.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHkdfKey.mjs":
/*!********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getHkdfKey.mjs ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getHkdfKey: () => (/* binding */ getHkdfKey)
/* harmony export */ });
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Standard HKDF algorithm.
 *
 * @param {Uint8Array} ikm Input key material.
 * @param {Uint8Array} salt Salt value.
 * @param {Uint8Array} info Context and application specific info.
 *
 * @returns {Uint8Array} Strong key material.
 *
 * @internal
 */
const getHkdfKey = (ikm, salt, info) => {
    const awsCryptoHash = new _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__.Sha256(salt);
    awsCryptoHash.update(ikm);
    const resultFromAWSCryptoPrk = awsCryptoHash.digestSync();
    const awsCryptoHashHmac = new _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__.Sha256(resultFromAWSCryptoPrk);
    awsCryptoHashHmac.update(info);
    const resultFromAWSCryptoHmac = awsCryptoHashHmac.digestSync();
    const hashHexFromAWSCrypto = resultFromAWSCryptoHmac;
    return hashHexFromAWSCrypto.slice(0, 16);
};


//# sourceMappingURL=getHkdfKey.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getNowString.mjs":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getNowString.mjs ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getNowString: () => (/* binding */ getNowString)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const MONTH_NAMES = [
    'Jan',
    'Feb',
    'Mar',
    'Apr',
    'May',
    'Jun',
    'Jul',
    'Aug',
    'Sep',
    'Oct',
    'Nov',
    'Dec',
];
const WEEK_NAMES = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
const getNowString = () => {
    const now = new Date();
    const weekDay = WEEK_NAMES[now.getUTCDay()];
    const month = MONTH_NAMES[now.getUTCMonth()];
    const day = now.getUTCDate();
    let hours = now.getUTCHours();
    if (hours < 10) {
        hours = `0${hours}`;
    }
    let minutes = now.getUTCMinutes();
    if (minutes < 10) {
        minutes = `0${minutes}`;
    }
    let seconds = now.getUTCSeconds();
    if (seconds < 10) {
        seconds = `0${seconds}`;
    }
    const year = now.getUTCFullYear();
    // ddd MMM D HH:mm:ss UTC YYYY
    const dateNow = `${weekDay} ${month} ${day} ${hours}:${minutes}:${seconds} UTC ${year}`;
    return dateNow;
};


//# sourceMappingURL=getNowString.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getPaddedHex.mjs":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getPaddedHex.mjs ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getPaddedHex: () => (/* binding */ getPaddedHex)
/* harmony export */ });
/* harmony import */ var _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BigInteger/BigInteger.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/BigInteger/BigInteger.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Tests if a hex string has it most significant bit set (case-insensitive regex)
 */
const HEX_MSB_REGEX = /^[89a-f]/i;
/**
 * Returns an unambiguous, even-length hex string of the two's complement encoding of an integer.
 *
 * It is compatible with the hex encoding of Java's BigInteger's toByteArray(), wich returns a
 * byte array containing the two's-complement representation of a BigInteger. The array contains
 * the minimum number of bytes required to represent the BigInteger, including at least one sign bit.
 *
 * Examples showing how ambiguity is avoided by left padding with:
 * 	"00" (for positive values where the most-significant-bit is set)
 *  "FF" (for negative values where the most-significant-bit is set)
 *
 * padHex(bigInteger.fromInt(-236))  === "FF14"
 * padHex(bigInteger.fromInt(20))    === "14"
 *
 * padHex(bigInteger.fromInt(-200))  === "FF38"
 * padHex(bigInteger.fromInt(56))    === "38"
 *
 * padHex(bigInteger.fromInt(-20))   === "EC"
 * padHex(bigInteger.fromInt(236))   === "00EC"
 *
 * padHex(bigInteger.fromInt(-56))   === "C8"
 * padHex(bigInteger.fromInt(200))   === "00C8"
 *
 * @param {AuthBigInteger} bigInt Number to encode.
 * @returns {String} even-length hex string of the two's complement encoding.
 */
const getPaddedHex = (bigInt) => {
    if (!(bigInt instanceof _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_0__["default"])) {
        throw new Error('Not a BigInteger');
    }
    const isNegative = bigInt.compareTo(_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_0__["default"].ZERO) < 0;
    /* Get a hex string for abs(bigInt) */
    let hexStr = bigInt.abs().toString(16);
    /* Pad hex to even length if needed */
    hexStr = hexStr.length % 2 !== 0 ? `0${hexStr}` : hexStr;
    /* Prepend "00" if the most significant bit is set */
    hexStr = HEX_MSB_REGEX.test(hexStr) ? `00${hexStr}` : hexStr;
    if (isNegative) {
        /* Flip the bits of the representation */
        const invertedNibbles = hexStr
            .split('')
            .map((x) => {
            const invertedNibble = ~parseInt(x, 16) & 0xf;
            return '0123456789ABCDEF'.charAt(invertedNibble);
        })
            .join('');
        /* After flipping the bits, add one to get the 2's complement representation */
        const flippedBitsBI = new _BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_0__["default"](invertedNibbles, 16).add(_BigInteger_BigInteger_mjs__WEBPACK_IMPORTED_MODULE_0__["default"].ONE);
        hexStr = flippedBitsBI.toString(16);
        /*
        For hex strings starting with 'FF8', 'FF' can be dropped, e.g. 0xFFFF80=0xFF80=0x80=-128

        Any sequence of '1' bits on the left can always be substituted with a single '1' bit
        without changing the represented value.

        This only happens in the case when the input is 80...00
        */
        if (hexStr.toUpperCase().startsWith('FF8')) {
            hexStr = hexStr.substring(2);
        }
    }
    return hexStr;
};


//# sourceMappingURL=getPaddedHex.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getRandomBytes.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getRandomBytes.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getRandomBytes: () => (/* binding */ getRandomBytes)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/WordArray.mjs");
/* harmony import */ var _getBytesFromHex_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getBytesFromHex.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getBytesFromHex.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Returns a Uint8Array with a sequence of random nBytes
 *
 * @param {number} nBytes
 * @returns {Uint8Array} fixed-length sequence of random bytes
 */
const getRandomBytes = (nBytes) => {
    const str = new _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.WordArray().random(nBytes).toString();
    return (0,_getBytesFromHex_mjs__WEBPACK_IMPORTED_MODULE_1__.getBytesFromHex)(str);
};


//# sourceMappingURL=getRandomBytes.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getRandomString.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getRandomString.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getRandomString: () => (/* binding */ getRandomString)
/* harmony export */ });
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/base64Encoder.mjs");
/* harmony import */ var _getRandomBytes_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getRandomBytes.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getRandomBytes.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Helper function to generate a random string
 * @returns {string} a random value.
 *
 * @internal
 */
const getRandomString = () => _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_0__.base64Encoder.convert((0,_getRandomBytes_mjs__WEBPACK_IMPORTED_MODULE_1__.getRandomBytes)(40));


//# sourceMappingURL=getRandomString.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getSignatureString.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/srp/getSignatureString.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getSignatureString: () => (/* binding */ getSignatureString)
/* harmony export */ });
/* harmony import */ var _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-crypto/sha256-js */ "./node_modules/@aws-crypto/sha256-js/build/module/index.js");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/base64Encoder.mjs");
/* harmony import */ var _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/core/internals/utils */ "./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/base64Decoder.mjs");
/* harmony import */ var _textEncoder_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../textEncoder/index.mjs */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/textEncoder/index.mjs");




// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const getSignatureString = ({ userPoolName, username, challengeParameters, dateNow, hkdf, }) => {
    const bufUPIDaToB = _textEncoder_index_mjs__WEBPACK_IMPORTED_MODULE_1__.textEncoder.convert(userPoolName);
    const bufUNaToB = _textEncoder_index_mjs__WEBPACK_IMPORTED_MODULE_1__.textEncoder.convert(username);
    const bufSBaToB = urlB64ToUint8Array(challengeParameters.SECRET_BLOCK);
    const bufDNaToB = _textEncoder_index_mjs__WEBPACK_IMPORTED_MODULE_1__.textEncoder.convert(dateNow);
    const bufConcat = new Uint8Array(bufUPIDaToB.byteLength +
        bufUNaToB.byteLength +
        bufSBaToB.byteLength +
        bufDNaToB.byteLength);
    bufConcat.set(bufUPIDaToB, 0);
    bufConcat.set(bufUNaToB, bufUPIDaToB.byteLength);
    bufConcat.set(bufSBaToB, bufUPIDaToB.byteLength + bufUNaToB.byteLength);
    bufConcat.set(bufDNaToB, bufUPIDaToB.byteLength + bufUNaToB.byteLength + bufSBaToB.byteLength);
    const awsCryptoHash = new _aws_crypto_sha256_js__WEBPACK_IMPORTED_MODULE_0__.Sha256(hkdf);
    awsCryptoHash.update(bufConcat);
    const resultFromAWSCrypto = awsCryptoHash.digestSync();
    const signatureString = _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_2__.base64Encoder.convert(resultFromAWSCrypto);
    return signatureString;
};
const urlB64ToUint8Array = (base64String) => {
    const padding = '='.repeat((4 - (base64String.length % 4)) % 4);
    const base64 = (base64String + padding).replace(/-/g, '+').replace(/_/g, '/');
    const rawData = _aws_amplify_core_internals_utils__WEBPACK_IMPORTED_MODULE_3__.base64Decoder.convert(base64);
    const outputArray = new Uint8Array(rawData.length);
    for (let i = 0; i < rawData.length; ++i) {
        outputArray[i] = rawData.charCodeAt(i);
    }
    return outputArray;
};


//# sourceMappingURL=getSignatureString.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/textEncoder/index.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/textEncoder/index.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   textEncoder: () => (/* binding */ textEncoder)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const textEncoder = {
    convert(input) {
        return new TextEncoder().encode(input);
    },
};


//# sourceMappingURL=index.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/utils/userContextData.mjs ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getUserContextData: () => (/* binding */ getUserContextData)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function getUserContextData({ username, userPoolId, userPoolClientId, }) {
    if (typeof window === 'undefined') {
        return undefined;
    }
    const amazonCognitoAdvancedSecurityData = window
        .AmazonCognitoAdvancedSecurityData;
    if (typeof amazonCognitoAdvancedSecurityData === 'undefined') {
        return undefined;
    }
    const advancedSecurityData = amazonCognitoAdvancedSecurityData.getData(username, userPoolId, userPoolClientId);
    if (advancedSecurityData) {
        const userContextData = {
            EncodedData: advancedSecurityData,
        };
        return userContextData;
    }
    return {};
}


//# sourceMappingURL=userContextData.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/auth/dist/esm/types/Auth.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/@aws-amplify/auth/dist/esm/types/Auth.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthErrorTypes: () => (/* binding */ AuthErrorTypes)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
var AuthErrorTypes;
(function (AuthErrorTypes) {
    AuthErrorTypes["NoConfig"] = "noConfig";
    AuthErrorTypes["MissingAuthConfig"] = "missingAuthConfig";
    AuthErrorTypes["EmptyUsername"] = "emptyUsername";
    AuthErrorTypes["InvalidUsername"] = "invalidUsername";
    AuthErrorTypes["EmptyPassword"] = "emptyPassword";
    AuthErrorTypes["EmptyCode"] = "emptyCode";
    AuthErrorTypes["SignUpError"] = "signUpError";
    AuthErrorTypes["NoMFA"] = "noMFA";
    AuthErrorTypes["InvalidMFA"] = "invalidMFA";
    AuthErrorTypes["EmptyChallengeResponse"] = "emptyChallengeResponse";
    AuthErrorTypes["NoUserSession"] = "noUserSession";
    AuthErrorTypes["Default"] = "default";
    AuthErrorTypes["DeviceConfig"] = "deviceConfig";
    AuthErrorTypes["NetworkError"] = "networkError";
    AuthErrorTypes["AutoSignInError"] = "autoSignInError";
    AuthErrorTypes["OAuthSignInError"] = "oauthSignInError";
})(AuthErrorTypes || (AuthErrorTypes = {}));


//# sourceMappingURL=Auth.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/I18n/I18n.mjs":
/*!***************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/I18n/I18n.mjs ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I18n: () => (/* binding */ I18n$1)
/* harmony export */ });
/* harmony import */ var _Logger_ConsoleLogger_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Logger/ConsoleLogger.mjs */ "./node_modules/@aws-amplify/core/dist/esm/Logger/ConsoleLogger.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const logger = new _Logger_ConsoleLogger_mjs__WEBPACK_IMPORTED_MODULE_0__.ConsoleLogger('I18n');
/**
 * Language translation utility.
 */
let I18n$1 = class I18n {
    constructor() {
        /**
         * @private
         */
        this._options = null;
        /**
         * @private
         */
        this._lang = null;
        /**
         * @private
         */
        this._dict = {};
    }
    /**
     * Sets the default language from the configuration when required.
     */
    setDefaultLanguage() {
        // Default to window language if not set in instance
        if (!this._lang &&
            typeof window !== 'undefined' &&
            window &&
            window.navigator) {
            this._lang = window.navigator.language;
        }
        logger.debug(this._lang);
    }
    /**
     * @method
     * Explicitly setting language
     * @param {String} lang
     */
    setLanguage(lang) {
        this._lang = lang;
    }
    /**
     * @method
     * Get value
     * @param {String} key
     * @param {String} defVal - Default value
     */
    get(key, defVal = undefined) {
        this.setDefaultLanguage();
        if (!this._lang) {
            return typeof defVal !== 'undefined' ? defVal : key;
        }
        const lang = this._lang;
        let val = this.getByLanguage(key, lang);
        if (val) {
            return val;
        }
        if (lang.indexOf('-') > 0) {
            val = this.getByLanguage(key, lang.split('-')[0]);
        }
        if (val) {
            return val;
        }
        return typeof defVal !== 'undefined' ? defVal : key;
    }
    /**
     * @method
     * Get value according to specified language
     * @param {String} key
     * @param {String} language - Specified langurage to be used
     * @param {String} defVal - Default value
     */
    getByLanguage(key, language, defVal = null) {
        if (!language) {
            return defVal;
        }
        const langDict = this._dict[language];
        if (!langDict) {
            return defVal;
        }
        return langDict[key];
    }
    /**
     * @method
     * Add vocabularies for one language
     * @param {String} language - Language of the dictionary
     * @param {Object} vocabularies - Object that has key-value as dictionary entry
     */
    putVocabulariesForLanguage(language, vocabularies) {
        let langDict = this._dict[language];
        if (!langDict) {
            langDict = this._dict[language] = {};
        }
        this._dict[language] = { ...langDict, ...vocabularies };
    }
    /**
     * @method
     * Add vocabularies for one language
     * @param {Object} vocabularies - Object that has language as key,
     *                                vocabularies of each language as value
     */
    putVocabularies(vocabularies) {
        Object.keys(vocabularies).forEach(key => {
            this.putVocabulariesForLanguage(key, vocabularies[key]);
        });
    }
};


//# sourceMappingURL=I18n.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/I18n/errorHelpers.mjs":
/*!***********************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/I18n/errorHelpers.mjs ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I18nErrorCode: () => (/* binding */ I18nErrorCode),
/* harmony export */   assert: () => (/* binding */ assert)
/* harmony export */ });
/* harmony import */ var _errors_createAssertionFunction_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../errors/createAssertionFunction.mjs */ "./node_modules/@aws-amplify/core/dist/esm/errors/createAssertionFunction.mjs");




// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
var I18nErrorCode;
(function (I18nErrorCode) {
    I18nErrorCode["NotConfigured"] = "NotConfigured";
})(I18nErrorCode || (I18nErrorCode = {}));
const i18nErrorMap = {
    [I18nErrorCode.NotConfigured]: {
        message: 'i18n is not configured.',
    },
};
const assert = (0,_errors_createAssertionFunction_mjs__WEBPACK_IMPORTED_MODULE_0__.createAssertionFunction)(i18nErrorMap);


//# sourceMappingURL=errorHelpers.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/I18n/index.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/I18n/index.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   I18n: () => (/* binding */ I18n)
/* harmony export */ });
/* harmony import */ var _Logger_ConsoleLogger_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Logger/ConsoleLogger.mjs */ "./node_modules/@aws-amplify/core/dist/esm/Logger/ConsoleLogger.mjs");
/* harmony import */ var _I18n_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./I18n.mjs */ "./node_modules/@aws-amplify/core/dist/esm/I18n/I18n.mjs");
/* harmony import */ var _errorHelpers_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./errorHelpers.mjs */ "./node_modules/@aws-amplify/core/dist/esm/I18n/errorHelpers.mjs");




// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const logger = new _Logger_ConsoleLogger_mjs__WEBPACK_IMPORTED_MODULE_0__.ConsoleLogger('I18n');
let _config = { language: null };
let _i18n = null;
/**
 * Export I18n APIs
 */
class I18n {
    /**
     * @static
     * @method
     * Configure I18n part
     * @param {Object} config - Configuration of the I18n
     */
    static configure(config) {
        logger.debug('configure I18n');
        if (!config) {
            return _config;
        }
        _config = Object.assign({}, _config, config.I18n || config);
        I18n.createInstance();
        return _config;
    }
    static getModuleName() {
        return 'I18n';
    }
    /**
     * @static
     * @method
     * Create an instance of I18n for the library
     */
    static createInstance() {
        logger.debug('create I18n instance');
        if (_i18n) {
            return;
        }
        _i18n = new _I18n_mjs__WEBPACK_IMPORTED_MODULE_1__.I18n();
    }
    /**
     * @static @method
     * Explicitly setting language
     * @param {String} lang
     */
    static setLanguage(lang) {
        I18n.checkConfig();
        (0,_errorHelpers_mjs__WEBPACK_IMPORTED_MODULE_2__.assert)(!!_i18n, _errorHelpers_mjs__WEBPACK_IMPORTED_MODULE_2__.I18nErrorCode.NotConfigured);
        _i18n.setLanguage(lang);
    }
    /**
     * @static @method
     * Get value
     * @param {String} key
     * @param {String} defVal - Default value
     */
    static get(key, defVal) {
        if (!I18n.checkConfig()) {
            return typeof defVal === 'undefined' ? key : defVal;
        }
        (0,_errorHelpers_mjs__WEBPACK_IMPORTED_MODULE_2__.assert)(!!_i18n, _errorHelpers_mjs__WEBPACK_IMPORTED_MODULE_2__.I18nErrorCode.NotConfigured);
        return _i18n.get(key, defVal);
    }
    /**
     * @static
     * @method
     * Add vocabularies for one language
     * @param {String} language - Language of the dictionary
     * @param {Object} vocabularies - Object that has key-value as dictionary entry
     */
    static putVocabulariesForLanguage(language, vocabularies) {
        I18n.checkConfig();
        (0,_errorHelpers_mjs__WEBPACK_IMPORTED_MODULE_2__.assert)(!!_i18n, _errorHelpers_mjs__WEBPACK_IMPORTED_MODULE_2__.I18nErrorCode.NotConfigured);
        _i18n.putVocabulariesForLanguage(language, vocabularies);
    }
    /**
     * @static
     * @method
     * Add vocabularies for one language
     * @param {Object} vocabularies - Object that has language as key,
     *                                vocabularies of each language as value
     */
    static putVocabularies(vocabularies) {
        I18n.checkConfig();
        (0,_errorHelpers_mjs__WEBPACK_IMPORTED_MODULE_2__.assert)(!!_i18n, _errorHelpers_mjs__WEBPACK_IMPORTED_MODULE_2__.I18nErrorCode.NotConfigured);
        _i18n.putVocabularies(vocabularies);
    }
    static checkConfig() {
        if (!_i18n) {
            I18n.createInstance();
        }
        return true;
    }
}
// Create an instance of I18n in the static class
I18n.createInstance();


//# sourceMappingURL=index.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/utils/WordArray.mjs":
/*!*********************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/utils/WordArray.mjs ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   WordArray: () => (/* binding */ WordArray)
/* harmony export */ });
/* harmony import */ var _cryptoSecureRandomInt_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cryptoSecureRandomInt.mjs */ "./node_modules/@aws-amplify/core/dist/esm/utils/cryptoSecureRandomInt.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Hex encoding strategy.
 * Converts a word array to a hex string.
 * @param {WordArray} wordArray The word array.
 * @return {string} The hex string.
 * @static
 */
function hexStringify(wordArray) {
    // Shortcuts
    const { words } = wordArray;
    const { sigBytes } = wordArray;
    // Convert
    const hexChars = [];
    for (let i = 0; i < sigBytes; i++) {
        const bite = (words[i >>> 2] >>> (24 - (i % 4) * 8)) & 0xff;
        hexChars.push((bite >>> 4).toString(16));
        hexChars.push((bite & 0x0f).toString(16));
    }
    return hexChars.join('');
}
class WordArray {
    constructor(words, sigBytes) {
        this.words = [];
        let Words = words;
        Words = this.words = Words || [];
        if (sigBytes !== undefined) {
            this.sigBytes = sigBytes;
        }
        else {
            this.sigBytes = Words.length * 4;
        }
    }
    random(nBytes) {
        const words = [];
        for (let i = 0; i < nBytes; i += 4) {
            words.push((0,_cryptoSecureRandomInt_mjs__WEBPACK_IMPORTED_MODULE_0__.cryptoSecureRandomInt)());
        }
        return new WordArray(words, nBytes);
    }
    toString() {
        return hexStringify(this);
    }
}


//# sourceMappingURL=WordArray.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/base64Encoder.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/base64Encoder.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   base64Encoder: () => (/* binding */ base64Encoder)
/* harmony export */ });
/* harmony import */ var _globalHelpers_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../globalHelpers/index.mjs */ "./node_modules/@aws-amplify/core/dist/esm/utils/globalHelpers/index.mjs");
/* harmony import */ var _bytesToString_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bytesToString.mjs */ "./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/bytesToString.mjs");



// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const base64Encoder = {
    /**
     * Convert input to base64-encoded string
     * @param input - string to convert to base64
     * @param options - encoding options that can optionally produce a base64url string
     * @returns base64-encoded string
     */
    convert(input, options = {
        urlSafe: false,
        skipPadding: false,
    }) {
        const inputStr = typeof input === 'string' ? input : (0,_bytesToString_mjs__WEBPACK_IMPORTED_MODULE_0__.bytesToString)(input);
        let encodedStr = (0,_globalHelpers_index_mjs__WEBPACK_IMPORTED_MODULE_1__.getBtoa)()(inputStr);
        // urlSafe char replacement and skipPadding options conform to the base64url spec
        // https://datatracker.ietf.org/doc/html/rfc4648#section-5
        if (options.urlSafe) {
            encodedStr = encodedStr.replace(/\+/g, '-').replace(/\//g, '_');
        }
        if (options.skipPadding) {
            encodedStr = encodedStr.replace(/=/g, '');
        }
        return encodedStr;
    },
};


//# sourceMappingURL=base64Encoder.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/bytesToString.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/utils/convert/base64/bytesToString.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   bytesToString: () => (/* binding */ bytesToString)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function bytesToString(input) {
    return Array.from(input, byte => String.fromCodePoint(byte)).join('');
}


//# sourceMappingURL=bytesToString.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/utils/cryptoSecureRandomInt.mjs":
/*!*********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/utils/cryptoSecureRandomInt.mjs ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   cryptoSecureRandomInt: () => (/* binding */ cryptoSecureRandomInt)
/* harmony export */ });
/* harmony import */ var _globalHelpers_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./globalHelpers/index.mjs */ "./node_modules/@aws-amplify/core/dist/esm/utils/globalHelpers/index.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/*
 * Cryptographically secure pseudorandom number generator
 * As Math.random() is cryptographically not safe to use
 */
function cryptoSecureRandomInt() {
    const crypto = (0,_globalHelpers_index_mjs__WEBPACK_IMPORTED_MODULE_0__.getCrypto)();
    const randomResult = crypto.getRandomValues(new Uint32Array(1))[0];
    return randomResult;
}


//# sourceMappingURL=cryptoSecureRandomInt.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/utils/deviceName/getDeviceName.mjs":
/*!************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/utils/deviceName/getDeviceName.mjs ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getDeviceName: () => (/* binding */ getDeviceName)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
/**
 * Retrieves the device name using the User-Agent Client Hints API if available,
 * falling back to the traditional userAgent string if not.
 *
 * @returns {Promise<string>} A promise that resolves with a string representing the device name.
 *
 * Example Output:
 * navigator.userAgentData:
 *   'macOS 14.2.1 arm macOS Not A(Brand/99.0.0.0;Google Chrome/121.0.6167.160;Chromium/121.0.6167.160'
 * navigator.userAgent:
 *   'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:109.0) Gecko/20100101 Firefox/115.0'
 */
const getDeviceName = async () => {
    const { userAgentData } = navigator;
    if (!userAgentData)
        return navigator.userAgent;
    const { platform = '', platformVersion = '', model = '', architecture = '', fullVersionList = [], } = await userAgentData.getHighEntropyValues([
        'platform',
        'platformVersion',
        'architecture',
        'model',
        'fullVersionList',
    ]);
    const versionList = fullVersionList
        .map((v) => `${v.brand}/${v.version}`)
        .join(';');
    const deviceName = [
        platform,
        platformVersion,
        architecture,
        model,
        platform,
        versionList,
    ]
        .filter(value => value)
        .join(' ');
    return deviceName || navigator.userAgent;
};


//# sourceMappingURL=getDeviceName.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/utils/generateRandomString.mjs":
/*!********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/utils/generateRandomString.mjs ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   generateRandomString: () => (/* binding */ generateRandomString)
/* harmony export */ });
/* harmony import */ var _globalHelpers_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./globalHelpers/index.mjs */ "./node_modules/@aws-amplify/core/dist/esm/utils/globalHelpers/index.mjs");


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const generateRandomString = (length) => {
    const STATE_CHARSET = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    const result = [];
    const randomNums = new Uint8Array(length);
    (0,_globalHelpers_index_mjs__WEBPACK_IMPORTED_MODULE_0__.getCrypto)().getRandomValues(randomNums);
    for (const num of randomNums) {
        result.push(STATE_CHARSET[num % STATE_CHARSET.length]);
    }
    return result.join('');
};


//# sourceMappingURL=generateRandomString.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/utils/urlSafeDecode.mjs":
/*!*************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/utils/urlSafeDecode.mjs ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   urlSafeDecode: () => (/* binding */ urlSafeDecode)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function urlSafeDecode(hex) {
    const matchArr = hex.match(/.{2}/g) || [];
    return matchArr.map(char => String.fromCharCode(parseInt(char, 16))).join('');
}


//# sourceMappingURL=urlSafeDecode.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/core/dist/esm/utils/urlSafeEncode.mjs":
/*!*************************************************************************!*\
  !*** ./node_modules/@aws-amplify/core/dist/esm/utils/urlSafeEncode.mjs ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   urlSafeEncode: () => (/* binding */ urlSafeEncode)
/* harmony export */ });
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
function urlSafeEncode(str) {
    return str
        .split('')
        .map(char => char.charCodeAt(0).toString(16).padStart(2, '0'))
        .join('');
}


//# sourceMappingURL=urlSafeEncode.mjs.map


/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/context/AuthenticatorContext.mjs":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/context/AuthenticatorContext.mjs ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AuthenticatorContext: () => (/* binding */ AuthenticatorContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/**
 * AuthenticatorContext serves static reference to the auth machine service.
 *
 * https://xstate.js.org/docs/recipes/react.html#context-provider
 */
const AuthenticatorContext = react__WEBPACK_IMPORTED_MODULE_0___default().createContext(null);




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/context/AuthenticatorProvider.mjs":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/context/AuthenticatorProvider.mjs ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AuthenticatorProvider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _xstate_react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @xstate/react */ "./node_modules/@xstate/react/es/useInterpret.js");
/* harmony import */ var aws_amplify_auth__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! aws-amplify/auth */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/getCurrentUser.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/defaultAuthHubHandler.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/machines/authenticator/index.mjs");
/* harmony import */ var _AuthenticatorContext_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AuthenticatorContext.mjs */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/context/AuthenticatorContext.mjs");






const createHubHandler = (options) => (data, service) => {
    (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.defaultAuthHubHandler)(data, service, options);
};
function AuthenticatorProvider({ children, }) {
    // `authStatus` is exposed by `useAuthenticator` but should not be derived directly from the
    // state machine as the machine only updates on `Authenticator` initiated events, which
    // leads to scenarios where the state machine `authStatus` gets "stuck". For exmample,
    // if a user was to sign in using `Auth.signIn` directly rather than using `Authenticator`
    const [authStatus, setAuthStatus] = react__WEBPACK_IMPORTED_MODULE_0___default().useState('configuring');
    // only run on first render
    react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
        (0,aws_amplify_auth__WEBPACK_IMPORTED_MODULE_2__.getCurrentUser)()
            .then(() => {
            setAuthStatus('authenticated');
        })
            .catch(() => {
            setAuthStatus('unauthenticated');
        });
    }, []);
    /**
     * Based on use cases, developer might already have added another Provider
     * outside Authenticator. In that case, we sync the two providers by just
     * passing the parent value.
     *
     * TODO(BREAKING): enforce only one provider in App tree
     */
    const parentProviderVal = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(_AuthenticatorContext_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthenticatorContext);
    const service = (0,_xstate_react__WEBPACK_IMPORTED_MODULE_4__.useInterpret)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.createAuthenticatorMachine);
    const value = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => (!parentProviderVal ? { authStatus, service } : parentProviderVal), [authStatus, parentProviderVal, service]);
    const { service: activeService } = value;
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const onSignIn = () => {
            setAuthStatus('authenticated');
        };
        const onSignOut = () => {
            setAuthStatus('unauthenticated');
        };
        const unsubscribe = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.listenToAuthHub)(activeService, createHubHandler({ onSignIn, onSignOut }));
        return unsubscribe;
    }, [activeService]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_AuthenticatorContext_mjs__WEBPACK_IMPORTED_MODULE_3__.AuthenticatorContext.Provider, { value: value }, children));
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/constants.mjs":
/*!********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/constants.mjs ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   COMPONENT_ROUTE_KEYS: () => (/* binding */ COMPONENT_ROUTE_KEYS),
/* harmony export */   COMPONENT_ROUTE_NAMES: () => (/* binding */ COMPONENT_ROUTE_NAMES)
/* harmony export */ });
const COMPONENT_ROUTE_KEYS = [
    'confirmResetPassword',
    'confirmSignIn',
    'confirmSignUp',
    'confirmVerifyUser',
    'forceNewPassword',
    'forgotPassword',
    'selectMfaType',
    'setupEmail',
    'setupTotp',
    'signIn',
    'signUp',
    'verifyUser',
];
const COMPONENT_ROUTE_NAMES = [
    'ConfirmResetPassword',
    'ConfirmSignIn',
    'ConfirmSignUp',
    'ConfirmVerifyUser',
    'ForceNewPassword',
    'ForgotPassword',
    'SelectMfaType',
    'SetupEmail',
    'SetupTotp',
    'SignIn',
    'SignUp',
    'VerifyUser',
];




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/constants.mjs":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/constants.mjs ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   USE_AUTHENTICATOR_ERROR: () => (/* binding */ USE_AUTHENTICATOR_ERROR)
/* harmony export */ });
const USE_AUTHENTICATOR_ERROR = '`useAuthenticator` must be used inside an `Authenticator.Provider`.';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useAuthenticator)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _xstate_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @xstate/react */ "./node_modules/@xstate/react/es/useSelector.js");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/facade.mjs");
/* harmony import */ var _context_AuthenticatorContext_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../context/AuthenticatorContext.mjs */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/context/AuthenticatorContext.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/constants.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/utils.mjs");








/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/connected-components/authenticator/headless#useauthenticator-hook)
 */
function useAuthenticator(selector) {
    const context = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(_context_AuthenticatorContext_mjs__WEBPACK_IMPORTED_MODULE_1__.AuthenticatorContext);
    if (!context) {
        throw new Error(_constants_mjs__WEBPACK_IMPORTED_MODULE_2__.USE_AUTHENTICATOR_ERROR);
    }
    const { service } = context;
    const { send } = service;
    const xstateSelector = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((state) => ({ ...(0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.getServiceFacade)({ send, state }) }), [send]);
    const comparator = selector ? (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_4__.getComparator)(selector) : _utils_mjs__WEBPACK_IMPORTED_MODULE_4__.defaultComparator;
    // the purpose of `context.authStatus`is to intentionally override `facade.authStatus`. `facade.authStatus` does
    // not update on external sign in events (for example when a user is not using the `Authenticator`).
    const { authStatus } = context;
    const facade = (0,_xstate_react__WEBPACK_IMPORTED_MODULE_5__.useSelector)(service, xstateSelector, comparator);
    const { route, totpSecretCode, user, ...rest } = facade;
    // do not memoize output. `service.getSnapshot` reference remains stable preventing
    // `fields` from updating with current form state on value changes
    const serviceSnapshot = service.getSnapshot();
    // legacy `QRFields` values only used for SetupTotp page to retrieve issuer information, will be removed in future
    const QRFields = route === 'setupTotp' ? (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_4__.getQRFields)(serviceSnapshot) : null;
    // legacy `formFields` values required until form state is removed from state machine
    const fields = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_4__.getMachineFields)(route, serviceSnapshot);
    return {
        ...rest,
        authStatus,
        route,
        totpSecretCode,
        user,
        /** @deprecated For internal use only */
        fields,
        QRFields,
    };
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/utils.mjs":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/utils.mjs ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   areSelectorDepsEqual: () => (/* binding */ areSelectorDepsEqual),
/* harmony export */   defaultComparator: () => (/* binding */ defaultComparator),
/* harmony export */   getComparator: () => (/* binding */ getComparator),
/* harmony export */   getMachineFields: () => (/* binding */ getMachineFields),
/* harmony export */   getQRFields: () => (/* binding */ getQRFields)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/actor.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/formFields/formFields.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils.mjs */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/utils.mjs");



const defaultComparator = () => false;
/**
 * Does an ordering and shallow comparison of each array value,
 * plus a value equality check for empty objects and arrays.
 */
function areSelectorDepsEqual(currentDeps, nextDeps) {
    if (currentDeps.length !== nextDeps.length) {
        return false;
    }
    return currentDeps.every((currentDep, index) => {
        const nextDep = nextDeps[index];
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_0__.areEmptyArrays)(currentDep, nextDep) ||
            (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_0__.areEmptyObjects)(currentDep, nextDep)) {
            return true;
        }
        return currentDep === nextDep;
    });
}
const getComparator = (selector) => (currentFacade, nextFacade) => {
    const currentSelectorDeps = selector(currentFacade);
    const nextSelectorDeps = selector(nextFacade);
    // Shallow compare the array values
    return areSelectorDepsEqual(currentSelectorDeps, nextSelectorDeps);
};
const getQRFields = (state) => ({
    ...(0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.getActorContext)(state)?.formFields?.setupTotp?.QR,
});
const flattenFormFields = (fields) => fields.flatMap(([name, options]) => ({ name, ...options }));
const convertContactMethodsToFields = (unverifiedUserAttributes = {}) => {
    return (unverifiedUserAttributes &&
        Object.entries(unverifiedUserAttributes).map(([name, value]) => {
            const valueIsString = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_0__.isString)(value);
            if (!valueIsString || !name) {
                return {};
            }
            return { name, label: value, type: 'radio', value };
        }));
};
const convertAllowedMfaTypesToFields = (allowedMfaTypes = []) => {
    return allowedMfaTypes.map((mfaType) => ({
        name: 'mfa_type',
        label: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.authenticatorTextUtil.getMfaTypeLabelByValue(mfaType),
        type: 'radio',
        value: mfaType,
    }));
};
/**
 * Retrieves default and custom (RWA only, to be updated) form field values from state machine
 * for subcomponent routes that render fields
 */
const getMachineFields = (route, state) => {
    if ((0,_utils_mjs__WEBPACK_IMPORTED_MODULE_3__.isComponentRouteKey)(route)) {
        if (route === 'verifyUser') {
            return convertContactMethodsToFields((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.getActorContext)(state).unverifiedUserAttributes);
        }
        if (route === 'selectMfaType') {
            return convertAllowedMfaTypesToFields((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.getActorContext)(state).allowedMfaTypes);
        }
        return flattenFormFields((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.getSortedFormFields)(route, state));
    }
    return [];
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticatorInitMachine/useAuthenticatorInitMachine.mjs":
/*!******************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticatorInitMachine/useAuthenticatorInitMachine.mjs ***!
  \******************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useAuthenticatorInitMachine),
/* harmony export */   routeSelector: () => (/* binding */ routeSelector)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _useAuthenticator_useAuthenticator_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../useAuthenticator/useAuthenticator.mjs */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");



// only select `route` from machine context
const routeSelector = ({ route }) => [route];
function useAuthenticatorInitMachine(data) {
    const { route, initializeMachine } = (0,_useAuthenticator_useAuthenticator_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])(routeSelector);
    const hasInitialized = react__WEBPACK_IMPORTED_MODULE_0___default().useRef(false);
    react__WEBPACK_IMPORTED_MODULE_0___default().useEffect(() => {
        if (!hasInitialized.current && route === 'setup') {
            initializeMachine(data);
            hasInitialized.current = true;
        }
    }, [initializeMachine, route, data]);
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/utils.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/utils.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isComponentRouteKey: () => (/* binding */ isComponentRouteKey),
/* harmony export */   resolveAuthenticatorComponents: () => (/* binding */ resolveAuthenticatorComponents)
/* harmony export */ });
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants.mjs */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/constants.mjs");


const isComponentRouteKey = (route) => _constants_mjs__WEBPACK_IMPORTED_MODULE_0__.COMPONENT_ROUTE_KEYS.some((componentRoute) => componentRoute === route);
function resolveAuthenticatorComponents(defaults, overrides) {
    if (!overrides) {
        return defaults;
    }
    return _constants_mjs__WEBPACK_IMPORTED_MODULE_0__.COMPONENT_ROUTE_NAMES.reduce((components, route) => {
        const Default = defaults[route];
        const Override = overrides[route];
        if (typeof Override !== 'function') {
            return { ...components, [route]: Default };
        }
        const { Footer, FormFields, Header } = Default;
        // cast to allow assigning of component slots
        const Component = Override;
        Component.Footer = Footer;
        Component.FormFields = FormFields;
        Component.Header = Header;
        return { ...components, [route]: Component };
    }, {});
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useDeprecationWarning.mjs":
/*!******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useDeprecationWarning.mjs ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useDeprecationWarning)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


/**
 * Logs a deprecation warning message.
 *
 * @important Please use the React/React Native specific platform implementations.
 * This version of the hook is a base implementation that the others extend from due
 * to env differences between running in RN or the browser
 */
const useDeprecationWarning = ({ shouldWarn, message, }) => {
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        if (shouldWarn) {
            // eslint-disable-next-line no-console
            console.warn(message);
        }
    }, [shouldWarn, message]);
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useDropZone.mjs":
/*!********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useDropZone.mjs ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useDropZone)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _utils_filterAllowedFiles_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/filterAllowedFiles.mjs */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/utils/filterAllowedFiles.mjs");
/* harmony import */ var _utils_processDroppedItems_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/processDroppedItems.mjs */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/utils/processDroppedItems.mjs");





function useDropZone({ onDropComplete, onDragEnter: _onDragEnter, onDragLeave: _onDragLeave, onDragOver: _onDragOver, onDragStart: _onDragStart, onDrop: _onDrop, acceptedFileTypes = [], }) {
    const [dragState, setDragState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('inactive');
    const onDragStart = (event) => {
        event.dataTransfer.clearData();
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.isFunction)(_onDragStart)) {
            _onDragStart(event);
        }
    };
    const onDragEnter = (event) => {
        event.preventDefault();
        event.stopPropagation();
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.isFunction)(_onDragEnter)) {
            _onDragEnter(event);
        }
    };
    const onDragLeave = (event) => {
        event.preventDefault();
        event.stopPropagation();
        setDragState('inactive');
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.isFunction)(_onDragLeave)) {
            _onDragLeave(event);
        }
    };
    const onDragOver = (event) => {
        event.preventDefault();
        event.stopPropagation();
        event.dataTransfer.dropEffect = 'copy';
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.isFunction)(_onDragOver)) {
            _onDragOver(event);
        }
        const files = Array.from(event.dataTransfer.items).map(({ kind, type }) => ({
            kind,
            type,
        }));
        const { rejectedFiles } = (0,_utils_filterAllowedFiles_mjs__WEBPACK_IMPORTED_MODULE_2__.filterAllowedFiles)(files, acceptedFileTypes);
        setDragState(rejectedFiles.length > 0 ? 'reject' : 'accept');
    };
    const onDrop = (event) => {
        event.preventDefault();
        event.stopPropagation();
        setDragState('inactive');
        const { files, items } = event.dataTransfer;
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.isFunction)(_onDrop)) {
            _onDrop(event);
        }
        const completeDrop = (files) => {
            const { acceptedFiles, rejectedFiles } = (0,_utils_filterAllowedFiles_mjs__WEBPACK_IMPORTED_MODULE_2__.filterAllowedFiles)(files, acceptedFileTypes);
            if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.isFunction)(onDropComplete)) {
                onDropComplete({ acceptedFiles, rejectedFiles });
            }
        };
        if (!items) {
            completeDrop(Array.from(files));
        }
        else {
            (0,_utils_processDroppedItems_mjs__WEBPACK_IMPORTED_MODULE_3__.processDroppedItems)(Array.from(items)).then(completeDrop);
        }
    };
    return {
        onDragStart,
        onDragEnter,
        onDragLeave,
        onDragOver,
        onDrop,
        dragState,
    };
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useSetUserAgent.mjs":
/*!************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useSetUserAgent.mjs ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useSetUserAgent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/setUserAgent/setUserAgent.mjs");



function useSetUserAgent({ componentName, packageName, version, }) {
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const clearUserAgent = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.setUserAgent)({
            componentName,
            packageName,
            version,
        });
        return clearUserAgent;
    }, [componentName, packageName, version]);
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/utils/filterAllowedFiles.mjs":
/*!***************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/utils/filterAllowedFiles.mjs ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   filterAllowedFiles: () => (/* binding */ filterAllowedFiles)
/* harmony export */ });
function filterAllowedFiles(files, acceptedFileTypes) {
    // Allow any files if acceptedFileTypes is undefined, empty array, or contains '*'
    if (!acceptedFileTypes ||
        acceptedFileTypes.length === 0 ||
        acceptedFileTypes.includes('*')) {
        return { acceptedFiles: files, rejectedFiles: [] };
    }
    const acceptedFiles = [];
    const rejectedFiles = [];
    function filterFile(file) {
        const { type = '', name = '' } = file;
        const mimeType = type.toLowerCase();
        const baseMimeType = mimeType.split('/')[0];
        return acceptedFileTypes.some((type) => {
            const validType = type.trim().toLowerCase();
            // if the accepted file type is a file extension
            // it will start with '.', check against the file name
            if (validType.charAt(0) === '.') {
                return name.toLowerCase().endsWith(validType);
            }
            // This is something like a image/* mime type
            if (validType.endsWith('/*')) {
                return baseMimeType === validType.split('/')[0];
            }
            return mimeType === validType;
        });
    }
    files.forEach((file) => {
        (filterFile(file) ? acceptedFiles : rejectedFiles).push(file);
    });
    return { acceptedFiles, rejectedFiles };
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react-core/dist/esm/utils/processDroppedItems.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react-core/dist/esm/utils/processDroppedItems.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   processDroppedItems: () => (/* binding */ processDroppedItems)
/* harmony export */ });
// Helper function to convert FileSystemFileEntry to File
const getFileFromEntry = (fileEntry) => {
    return new Promise((resolve) => {
        fileEntry.file(resolve);
    });
};
// Helper function to read all entries in a directory
const readAllDirectoryEntries = async (dirReader) => {
    const entries = [];
    let readBatch = [];
    do {
        readBatch = await new Promise((resolve, reject) => {
            try {
                dirReader.readEntries(resolve, reject);
            }
            catch (error) {
                reject(error);
            }
        });
        entries.push(...readBatch);
    } while (readBatch.length > 0);
    return entries;
};
// Helper function to process files and folder contents
async function processDroppedItems(dataTransferItems) {
    const files = [];
    const processFileSystemEntry = async (entry) => {
        if (entry.isFile) {
            const file = await getFileFromEntry(entry);
            // drag and dropped files do not have a webkitRelativePath property,
            // but they do have a fullPath property which has the same information
            // https://github.com/ant-design/ant-design/issues/16426
            if (entry.fullPath && !file.webkitRelativePath) {
                Object.defineProperties(file, {
                    webkitRelativePath: {
                        writable: true,
                    },
                });
                // intentionally overwriting webkitRelativePath
                // @ts-expect-error
                file.webkitRelativePath = entry.fullPath.replace(/^\//, '');
                Object.defineProperties(file, {
                    webkitRelativePath: {
                        writable: false,
                    },
                });
            }
            files.push(file);
        }
        else if (entry.isDirectory) {
            const dirReader = entry.createReader();
            const dirEntries = await readAllDirectoryEntries(dirReader);
            await Promise.all(dirEntries.map(processFileSystemEntry));
        }
    };
    // Filter out and process files from the data transfer items
    await Promise.all(dataTransferItems
        .reduce((acc, item) => {
        const entry = item.webkitGetAsEntry();
        return item.kind === 'file' && entry ? [...acc, entry] : acc;
    }, [])
        .map(processFileSystemEntry));
    return files;
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/AccountSettings.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/AccountSettings.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AccountSettings)
/* harmony export */ });
/* harmony import */ var _ChangePassword_ChangePassword_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ChangePassword/ChangePassword.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/ChangePassword/ChangePassword.mjs");
/* harmony import */ var _DeleteUser_DeleteUser_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DeleteUser/DeleteUser.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/DeleteUser/DeleteUser.mjs");



var AccountSettings = { ChangePassword: _ChangePassword_ChangePassword_mjs__WEBPACK_IMPORTED_MODULE_0__["default"], DeleteUser: _DeleteUser_DeleteUser_mjs__WEBPACK_IMPORTED_MODULE_1__["default"] };




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/ChangePassword/ChangePassword.mjs":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/ChangePassword/ChangePassword.mjs ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ChangePassword)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_isEqual_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isEqual.js */ "./node_modules/lodash/isEqual.js");
/* harmony import */ var lodash_isEqual_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isEqual_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useSetUserAgent.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/utils.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/accountSettings/validator.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/accountSettings/utils.mjs");
/* harmony import */ var _hooks_useAuth_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../hooks/useAuth.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useAuth.mjs");
/* harmony import */ var _primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../primitives/View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../constants.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/constants.mjs");
/* harmony import */ var _defaults_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./defaults.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/ChangePassword/defaults.mjs");
/* harmony import */ var _utils_displayText_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/displayText.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/utils/displayText.mjs");
/* harmony import */ var _version_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../version.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/version.mjs");














































































const logger = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.getLogger)('AccountSettings');
const getIsDisabled = (formValues, validationError) => {
    const { currentPassword, newPassword, confirmPassword } = formValues;
    const hasEmptyField = !currentPassword || !newPassword || !confirmPassword;
    if (hasEmptyField) {
        return true;
    }
    const arePasswordsInvalid = validationError.newPassword?.length > 0 ||
        validationError.confirmPassword?.length > 0;
    return arePasswordsInvalid;
};
function ChangePassword({ components, displayText: overrideDisplayText, onError, onSuccess, validators, }) {
    const [errorMessage, setErrorMessage] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(null);
    const [formValues, setFormValues] = react__WEBPACK_IMPORTED_MODULE_0___default().useState({});
    const [validationError, setValidationError] = react__WEBPACK_IMPORTED_MODULE_0___default().useState({});
    const blurredFields = react__WEBPACK_IMPORTED_MODULE_0___default().useRef([]);
    const { user, isLoading } = (0,_hooks_useAuth_mjs__WEBPACK_IMPORTED_MODULE_3__.useAuth)();
    const isDisabled = getIsDisabled(formValues, validationError);
    const passwordValidators = react__WEBPACK_IMPORTED_MODULE_0___default().useMemo(() => {
        return validators ?? (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.getDefaultPasswordValidators)();
    }, [validators]);
    (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_5__["default"])({
        componentName: 'ChangePassword',
        packageName: 'react',
        version: _version_mjs__WEBPACK_IMPORTED_MODULE_6__.VERSION,
    });
    /*
     * Note that formValues and other states are passed in as props so that
     * it does not depend on whether or not those states have been updated yet
     */
    const validateNewPassword = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(({ formValues, eventType }) => {
        const { newPassword } = formValues;
        const hasBlurred = blurredFields.current.includes('newPassword');
        return (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.runFieldValidators)({
            value: newPassword,
            validators: passwordValidators,
            eventType,
            hasBlurred,
        });
    }, [passwordValidators]);
    const validateConfirmPassword = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(({ formValues, eventType }) => {
        const { newPassword, confirmPassword } = formValues;
        const hasBlurred = blurredFields.current.includes('confirmPassword');
        const confirmPasswordValidators = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.getDefaultConfirmPasswordValidators)(newPassword);
        return (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.runFieldValidators)({
            value: confirmPassword,
            validators: confirmPasswordValidators,
            eventType,
            hasBlurred,
        });
    }, []);
    const runValidation = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback((param) => {
        const passwordErrors = validateNewPassword(param);
        const confirmPasswordErrors = validateConfirmPassword(param);
        const newValidationError = {
            newPassword: passwordErrors,
            confirmPassword: confirmPasswordErrors,
        };
        // only re-render if errors have changed
        if (!lodash_isEqual_js__WEBPACK_IMPORTED_MODULE_1___default()(validationError, newValidationError)) {
            setValidationError(newValidationError);
        }
    }, [validateConfirmPassword, validateNewPassword, validationError]);
    /* Translations */
    const displayText = {
        ..._utils_displayText_mjs__WEBPACK_IMPORTED_MODULE_7__.defaultChangePasswordDisplayText,
        ...overrideDisplayText,
    };
    const { confirmPasswordFieldLabel, currentPasswordFieldLabel, newPasswordFieldLabel, updatePasswordButtonText, } = displayText;
    /* Subcomponents */
    const { CurrentPasswordField, NewPasswordField, ConfirmPasswordField, SubmitButton, ErrorMessage, } = react__WEBPACK_IMPORTED_MODULE_0___default().useMemo(() => ({ ..._defaults_mjs__WEBPACK_IMPORTED_MODULE_8__["default"], ...(components ?? {}) }), [components]);
    /* Event Handlers */
    const handleChange = (event) => {
        event.preventDefault();
        const { name, value } = event.target;
        const newFormValues = { ...formValues, [name]: value };
        runValidation({ formValues: newFormValues, eventType: 'change' });
        setFormValues(newFormValues);
    };
    const handleBlur = (event) => {
        event.preventDefault();
        const { name } = event.target;
        // only update state and run validation if this is the first time blurring the field
        if (!blurredFields.current.includes(name)) {
            const newBlurredFields = [...blurredFields.current, name];
            blurredFields.current = newBlurredFields;
            runValidation({ formValues, eventType: 'blur' });
        }
    };
    const handleSubmit = (event) => {
        event.preventDefault();
        if (!user) {
            return;
        }
        const { currentPassword, newPassword } = formValues;
        if (errorMessage) {
            setErrorMessage(null);
        }
        (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_9__.changePassword)({ currentPassword, newPassword })
            .then(() => {
            // notify success to the parent
            onSuccess?.();
        })
            .catch((e) => {
            const error = e;
            if (error.message)
                setErrorMessage(error.message);
            onError?.(error); // notify error to the parent
        });
    };
    // Return null if Auth.getgetCurrentUser is still in progress
    if (isLoading) {
        return null;
    }
    // Return null if user isn't authenticated in the first place
    if (!user) {
        logger.warn('<ChangePassword /> requires user to be authenticated.');
        return null;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_10__.View, { as: "form", className: _constants_mjs__WEBPACK_IMPORTED_MODULE_11__.ComponentClassName.ChangePassword, onSubmit: handleSubmit },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_12__.Flex, { direction: "column" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(CurrentPasswordField, { autoComplete: "current-password", isRequired: true, label: currentPasswordFieldLabel, name: "currentPassword", onBlur: handleBlur, onChange: handleChange }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(NewPasswordField, { autoComplete: "new-password", fieldValidationErrors: validationError?.newPassword, isRequired: true, label: newPasswordFieldLabel, name: "newPassword", onBlur: handleBlur, onChange: handleChange }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ConfirmPasswordField, { autoComplete: "new-password", fieldValidationErrors: validationError?.confirmPassword, isRequired: true, label: confirmPasswordFieldLabel, name: "confirmPassword", onBlur: handleBlur, onChange: handleChange }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(SubmitButton, { isDisabled: isDisabled, type: "submit" }, updatePasswordButtonText),
            errorMessage ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ErrorMessage, null, errorMessage) : null)));
}
ChangePassword.CurrentPasswordField = _defaults_mjs__WEBPACK_IMPORTED_MODULE_8__["default"].CurrentPasswordField;
ChangePassword.NewPasswordField = _defaults_mjs__WEBPACK_IMPORTED_MODULE_8__["default"].NewPasswordField;
ChangePassword.ConfirmPasswordField = _defaults_mjs__WEBPACK_IMPORTED_MODULE_8__["default"].ConfirmPasswordField;
ChangePassword.SubmitButton = _defaults_mjs__WEBPACK_IMPORTED_MODULE_8__["default"].SubmitButton;
ChangePassword.ErrorMessage = _defaults_mjs__WEBPACK_IMPORTED_MODULE_8__["default"].ErrorMessage;




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/ChangePassword/defaults.mjs":
/*!************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/ChangePassword/defaults.mjs ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DEFAULTS)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../primitives/Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _primitives_PasswordField_PasswordField_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../primitives/PasswordField/PasswordField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/PasswordField/PasswordField.mjs");
/* harmony import */ var _shared_ValidationErrors_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../shared/ValidationErrors.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/shared/ValidationErrors.mjs");
/* harmony import */ var _shared_Defaults_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../shared/Defaults.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/shared/Defaults.mjs");

































































const DefaultPasswordField = ({ fieldValidationErrors, label, ...rest }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_PasswordField_PasswordField_mjs__WEBPACK_IMPORTED_MODULE_1__.PasswordField, { ...rest, label: label }),
        fieldValidationErrors ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_ValidationErrors_mjs__WEBPACK_IMPORTED_MODULE_2__.ValidationErrors, { errors: fieldValidationErrors })) : null));
};
const DEFAULTS = {
    CurrentPasswordField: DefaultPasswordField,
    NewPasswordField: DefaultPasswordField,
    ConfirmPasswordField: DefaultPasswordField,
    SubmitButton: _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_3__.Button,
    ErrorMessage: _shared_Defaults_mjs__WEBPACK_IMPORTED_MODULE_4__.DefaultErrorMessage,
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/DeleteUser/DeleteUser.mjs":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/DeleteUser/DeleteUser.mjs ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DeleteUser)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useSetUserAgent.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/utils.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/accountSettings/utils.mjs");
/* harmony import */ var _hooks_useAuth_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../hooks/useAuth.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useAuth.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _constants_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../constants.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/constants.mjs");
/* harmony import */ var _defaults_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./defaults.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/DeleteUser/defaults.mjs");
/* harmony import */ var _utils_displayText_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/displayText.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/utils/displayText.mjs");
/* harmony import */ var _version_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../version.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/version.mjs");













































































const logger = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.getLogger)('AccountSettings');
function DeleteUser({ components, displayText: overrideDisplayText, handleDelete, onError, onSuccess, }) {
    const [state, setState] = react__WEBPACK_IMPORTED_MODULE_0___default().useState('IDLE');
    const [errorMessage, setErrorMessage] = react__WEBPACK_IMPORTED_MODULE_0___default().useState(null);
    (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])({
        componentName: 'DeleteUser',
        packageName: 'react',
        version: _version_mjs__WEBPACK_IMPORTED_MODULE_3__.VERSION,
    });
    // translations
    const displayText = {
        ..._utils_displayText_mjs__WEBPACK_IMPORTED_MODULE_4__.defaultDeleteUserDisplayText,
        ...overrideDisplayText,
    };
    const { deleteAccountButtonText } = displayText;
    const { user, isLoading } = (0,_hooks_useAuth_mjs__WEBPACK_IMPORTED_MODULE_5__.useAuth)();
    // subcomponents
    const { ErrorMessage, DeleteButton, WarningView } = react__WEBPACK_IMPORTED_MODULE_0___default().useMemo(() => ({ ..._defaults_mjs__WEBPACK_IMPORTED_MODULE_6__["default"], ...(components ?? {}) }), [components]);
    const startConfirmation = (event) => {
        event.preventDefault();
        setState('CONFIRMATION');
    };
    const runDeleteUser = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(async () => {
        if (!user) {
            return;
        }
        setState('DELETING');
        if (errorMessage) {
            setErrorMessage(null);
        }
        try {
            if (handleDelete) {
                /*
                 * run custom delete handler, if provided. We pass `user` so that
                 * developer can do whichever cleanup with the user object they wish.
                 */
                await handleDelete(user);
            }
            else {
                // else, run default deleteUser function.
                await (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.deleteUser)();
            }
            setState('DONE');
            onSuccess?.();
        }
        catch (e) {
            const error = e;
            setState('ERROR');
            setErrorMessage(error.message);
            onError?.(error);
        }
    }, [errorMessage, handleDelete, onError, onSuccess, user]);
    // called when end user cancels account deletion confirmation
    const handleCancel = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(() => {
        setState('IDLE');
    }, []);
    const handleConfirmDelete = react__WEBPACK_IMPORTED_MODULE_0___default().useCallback(() => {
        runDeleteUser();
    }, [runDeleteUser]);
    // Return null if Auth.getgetCurrentUser is still in progress
    if (isLoading) {
        return null;
    }
    // Return null if user isn't authenticated
    if (!user) {
        logger.warn('<DeleteUser /> requires user to be authenticated.');
        return null;
    }
    // Return null if delete user was successful
    if (state === 'DONE') {
        return null;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_8__.Flex, { className: _constants_mjs__WEBPACK_IMPORTED_MODULE_9__.ComponentClassName.DeleteUser, direction: "column" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(DeleteButton, { isDisabled: state === 'CONFIRMATION' || state === 'DELETING', onClick: startConfirmation }, deleteAccountButtonText),
        state === 'CONFIRMATION' || state === 'DELETING' ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(WarningView, { displayText: displayText, isDisabled: state === 'DELETING', onCancel: handleCancel, onConfirm: handleConfirmDelete })) : null,
        errorMessage ? react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ErrorMessage, null, errorMessage) : null));
}
DeleteUser.ErrorMessage = _defaults_mjs__WEBPACK_IMPORTED_MODULE_6__["default"].ErrorMessage;
DeleteUser.DeleteButton = _defaults_mjs__WEBPACK_IMPORTED_MODULE_6__["default"].DeleteButton;
DeleteUser.WarningView = _defaults_mjs__WEBPACK_IMPORTED_MODULE_6__["default"].WarningView;




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/DeleteUser/defaults.mjs":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/DeleteUser/defaults.mjs ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DEFAULTS)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../primitives/Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _primitives_Card_Card_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../primitives/Card/Card.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Card/Card.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../primitives/Text/Text.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Text/Text.mjs");
/* harmony import */ var _shared_Defaults_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../shared/Defaults.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/shared/Defaults.mjs");
/* harmony import */ var _utils_displayText_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/displayText.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/utils/displayText.mjs");

































































const DefaultWarningView = ({ displayText: overrideDisplayText, isDisabled, onCancel, onConfirm, }) => {
    // translations
    const displayText = {
        ..._utils_displayText_mjs__WEBPACK_IMPORTED_MODULE_1__.defaultDeleteUserDisplayText,
        ...overrideDisplayText,
    };
    const { cancelButtonText, confirmDeleteButtonText, warningText } = displayText;
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Card_Card_mjs__WEBPACK_IMPORTED_MODULE_2__.Card, null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__.Flex, { direction: "column" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_4__.Text, { color: "font.error" }, warningText),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__.Flex, null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_5__.Button, { variation: "link", onClick: onCancel, isDisabled: isDisabled }, cancelButtonText),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_5__.Button, { variation: "destructive", onClick: onConfirm, isDisabled: isDisabled }, confirmDeleteButtonText)))));
};
const DefaultDeleteButton = (props) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_5__.Button, { ...props, variation: "warning" }));
const DEFAULTS = {
    ErrorMessage: _shared_Defaults_mjs__WEBPACK_IMPORTED_MODULE_6__.DefaultErrorMessage,
    DeleteButton: DefaultDeleteButton,
    WarningView: DefaultWarningView,
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/constants.mjs":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/constants.mjs ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ComponentClassName: () => (/* binding */ ComponentClassName)
/* harmony export */ });
var ComponentClassName;
(function (ComponentClassName) {
    ComponentClassName["ChangePassword"] = "amplify-accountsettings-changepassword";
    ComponentClassName["DeleteUser"] = "amplify-accountsettings-deleteuser";
})(ComponentClassName || (ComponentClassName = {}));




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/shared/Defaults.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/shared/Defaults.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DefaultErrorMessage: () => (/* binding */ DefaultErrorMessage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primitives_Alert_Alert_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../primitives/Alert/Alert.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Alert/Alert.mjs");































































const DefaultErrorMessage = (props) => {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Alert_Alert_mjs__WEBPACK_IMPORTED_MODULE_1__.Alert, { variation: "error", ...props });
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/utils/displayText.mjs":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/utils/displayText.mjs ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   defaultChangePasswordDisplayText: () => (/* binding */ defaultChangePasswordDisplayText),
/* harmony export */   defaultDeleteUserDisplayText: () => (/* binding */ defaultDeleteUserDisplayText)
/* harmony export */ });
const defaultChangePasswordDisplayText = {
    confirmPasswordFieldLabel: 'Confirm Password',
    currentPasswordFieldLabel: 'Current Password',
    newPasswordFieldLabel: 'New Password',
    updatePasswordButtonText: 'Update password',
};
const defaultDeleteUserDisplayText = {
    cancelButtonText: 'Cancel',
    confirmDeleteButtonText: 'Delete',
    deleteAccountButtonText: 'Delete Account',
    warningText: 'Deleting your account is not reversible. You will lose access to your account and all data associated with it.',
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/Authenticator.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/Authenticator.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Authenticator: () => (/* binding */ Authenticator),
/* harmony export */   AuthenticatorInternal: () => (/* binding */ AuthenticatorInternal)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticatorInitMachine/useAuthenticatorInitMachine.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useSetUserAgent.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/context/AuthenticatorProvider.mjs");
/* harmony import */ var _version_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../version.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/version.mjs");
/* harmony import */ var _hooks_useDeprecationWarning_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../hooks/useDeprecationWarning.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useDeprecationWarning.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _Router_Router_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Router/Router.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/Router/Router.mjs");
/* harmony import */ var _SetupTotp_SetupTotp_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./SetupTotp/SetupTotp.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SetupTotp/SetupTotp.mjs");
/* harmony import */ var _SignIn_SignIn_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./SignIn/SignIn.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SignIn/SignIn.mjs");
/* harmony import */ var _SignUp_SignUp_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./SignUp/SignUp.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SignUp/SignUp.mjs");
/* harmony import */ var _ForceNewPassword_ForceNewPassword_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./ForceNewPassword/ForceNewPassword.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForceNewPassword/ForceNewPassword.mjs");
/* harmony import */ var _ForgotPassword_ForgotPassword_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ForgotPassword/ForgotPassword.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForgotPassword/ForgotPassword.mjs");
/* harmony import */ var _hooks_useCustomComponents_defaultComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./hooks/useCustomComponents/defaultComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/defaultComponents.mjs");
/* harmony import */ var _SelectMfaType_SelectMfaType_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./SelectMfaType/SelectMfaType.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SelectMfaType/SelectMfaType.mjs");
/* harmony import */ var _SetupEmail_SetupEmail_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./SetupEmail/SetupEmail.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SetupEmail/SetupEmail.mjs");


















// `AuthenticatorInternal` exists to give access to the context returned via `useAuthenticator`,
// which allows the `Authenticator` to just return `children` if a user is authenticated.
// Once the `Provider` is removed from the `Authenticator` component and exported as
// `AuthenticatorProvider`, this component should be renamed to `Authenticator`.
function AuthenticatorInternal({ children, className, components: customComponents, formFields, hideSignUp, initialState, loginMechanisms, passwordSettings, signUpAttributes, services, socialProviders, variation, }) {
    (0,_hooks_useDeprecationWarning_mjs__WEBPACK_IMPORTED_MODULE_1__.useDeprecationWarning)({
        message: 'The `passwordSettings` prop has been deprecated and will be removed in a future major version of Amplify UI.',
        // shouldWarn: !!passwordSettings,
        /**
         * @migration turn off until getConfig returns zero config
         */
        shouldWarn: false,
    });
    const { route, signOut, user } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])(({ route, signOut, user }) => [route, signOut, user]);
    (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_3__["default"])({
        initialState,
        loginMechanisms,
        passwordSettings,
        services,
        signUpAttributes,
        socialProviders,
        formFields,
    });
    const value = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({ components: { ..._hooks_useCustomComponents_defaultComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.defaultComponents, ...customComponents } }), [customComponents]);
    const isAuthenticatedRoute = route === 'authenticated' || route === 'signOut';
    if (isAuthenticatedRoute) {
        // `Authenticator` might not have user defined `children` for non SPA use cases.
        if (!children) {
            // @ts-ignore
            return null;
        }
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.isFunction)(children)
            ? children({ signOut, user }) // children is a render prop
            : children));
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_6__.CustomComponentsContext.Provider, { value: value },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Router_Router_mjs__WEBPACK_IMPORTED_MODULE_7__.Router, { className: className, hideSignUp: hideSignUp, variation: variation })));
}
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/connected-components/authenticator)
 */
function Authenticator(props) {
    (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_8__["default"])({
        componentName: 'Authenticator',
        packageName: 'react',
        version: _version_mjs__WEBPACK_IMPORTED_MODULE_9__.VERSION,
    });
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_10__["default"], null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(AuthenticatorInternal, { ...props })));
}
Authenticator.Provider = _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_10__["default"];
Authenticator.ForgotPassword = _ForgotPassword_ForgotPassword_mjs__WEBPACK_IMPORTED_MODULE_11__.ForgotPassword;
Authenticator.SetupTotp = _SetupTotp_SetupTotp_mjs__WEBPACK_IMPORTED_MODULE_12__.SetupTotp;
Authenticator.SignIn = _SignIn_SignIn_mjs__WEBPACK_IMPORTED_MODULE_13__.SignIn;
Authenticator.SignUp = _SignUp_SignUp_mjs__WEBPACK_IMPORTED_MODULE_14__.SignUp;
Authenticator.ForceNewPassword = _ForceNewPassword_ForceNewPassword_mjs__WEBPACK_IMPORTED_MODULE_15__.ForceNewPassword;
Authenticator.SelectMfaType = _SelectMfaType_SelectMfaType_mjs__WEBPACK_IMPORTED_MODULE_16__.SelectMfaType;
Authenticator.SetupEmail = _SetupEmail_SetupEmail_mjs__WEBPACK_IMPORTED_MODULE_17__.SetupEmail;




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ConfirmSignIn/ConfirmSignIn.mjs":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ConfirmSignIn/ConfirmSignIn.mjs ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfirmSignIn: () => (/* binding */ ConfirmSignIn)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../shared/FormFields.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs");
/* harmony import */ var _shared_ConfirmSignInFooter_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../shared/ConfirmSignInFooter.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/ConfirmSignInFooter.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");












const { getChallengeText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const ConfirmSignIn = ({ className, variation, }) => {
    const { isPending } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [context.isPending]);
    const { handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    ConfirmSignIn: { Header = ConfirmSignIn.Header, Footer = ConfirmSignIn.Footer, }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.useCustomComponents)();
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__.RouteContainer, { className: className, variation: variation },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-confirmsignin": "", method: "post", onChange: handleChange, onSubmit: handleSubmit },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { direction: "column" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_7__.FormFields, null),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__.RemoteErrorMessage, null)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_ConfirmSignInFooter_mjs__WEBPACK_IMPORTED_MODULE_9__.ConfirmSignInFooter, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Footer, null)))));
};
function Header() {
    const { challengeName } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])(({ challengeName }) => [
        challengeName,
    ]);
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__.Heading, { level: 3 }, getChallengeText(challengeName));
}
ConfirmSignIn.Header = Header;
ConfirmSignIn.Footer = function Footer() {
    // @ts-ignore
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ConfirmSignUp/ConfirmSignUp.mjs":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ConfirmSignUp/ConfirmSignUp.mjs ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfirmSignUp: () => (/* binding */ ConfirmSignUp)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../primitives/Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _primitives_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../primitives/Text/Text.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Text/Text.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../shared/FormFields.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");













const { getDeliveryMessageText, getDeliveryMethodText, getConfirmingText, getConfirmText, getResendCodeText, } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
function ConfirmSignUp({ className, variation, }) {
    const { isPending, resendCode, codeDeliveryDetails } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [
        context.isPending,
        context.resendCode,
        context.codeDeliveryDetails,
    ]);
    const { handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    ConfirmSignUp: { Header = ConfirmSignUp.Header, Footer = ConfirmSignUp.Footer, }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.useCustomComponents)();
    return (
    // TODO Automatically add these namespaces again from `useAmplify`
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__.RouteContainer, { className: className, variation: variation },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-confirmsignup": "", method: "post", onChange: handleChange, onSubmit: handleSubmit },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { direction: "column" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_7__.Text, { className: "amplify-authenticator__subtitle" }, getDeliveryMessageText(codeDeliveryDetails)),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_8__.FormFields, null),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_9__.RemoteErrorMessage, null),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_10__.Button, { variation: "primary", isDisabled: isPending, type: "submit", loadingText: getConfirmingText(), isLoading: isPending }, getConfirmText()),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_10__.Button, { onClick: resendCode, type: "button" }, getResendCodeText())),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Footer, null)))));
}
const DefaultHeader = () => {
    const { codeDeliveryDetails } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [
        context.codeDeliveryDetails,
    ]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_11__.Heading, { level: 4 }, getDeliveryMethodText(codeDeliveryDetails)));
};
ConfirmSignUp.Header = DefaultHeader;
ConfirmSignUp.Footer = function Footer() {
    // @ts-ignore
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/FederatedSignIn/FederatedSignIn.mjs":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/FederatedSignIn/FederatedSignIn.mjs ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FederatedSignIn: () => (/* binding */ FederatedSignIn)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/authenticator/user.mjs");
/* harmony import */ var _primitives_Divider_Divider_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/Divider/Divider.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Divider/Divider.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _FederatedSignInButtons_FederatedSignInButton_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./FederatedSignInButtons/FederatedSignInButton.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/FederatedSignIn/FederatedSignInButtons/FederatedSignInButton.mjs");







const { getSignInWithFederationText, getOrText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
function FederatedSignIn() {
    const { route, socialProviders } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])(({ route, socialProviders }) => [route, socialProviders]);
    if (socialProviders.length === 0) {
        // @ts-ignore
        return null;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__.Flex, { direction: "column", padding: `0 0 1rem 0`, className: "federated-sign-in-container" },
        socialProviders.map((provider) => {
            switch (provider) {
                case 'amazon':
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FederatedSignInButtons_FederatedSignInButton_mjs__WEBPACK_IMPORTED_MODULE_4__.FederatedSignInButton, { icon: "amazon", key: provider, provider: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.FederatedIdentityProviders.Amazon, text: getSignInWithFederationText(route, provider) }));
                case 'apple':
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FederatedSignInButtons_FederatedSignInButton_mjs__WEBPACK_IMPORTED_MODULE_4__.FederatedSignInButton, { icon: "apple", key: provider, provider: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.FederatedIdentityProviders.Apple, text: getSignInWithFederationText(route, provider) }));
                case 'facebook':
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FederatedSignInButtons_FederatedSignInButton_mjs__WEBPACK_IMPORTED_MODULE_4__.FederatedSignInButton, { icon: "facebook", key: provider, provider: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.FederatedIdentityProviders.Facebook, text: getSignInWithFederationText(route, provider) }));
                case 'google':
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FederatedSignInButtons_FederatedSignInButton_mjs__WEBPACK_IMPORTED_MODULE_4__.FederatedSignInButton, { icon: "google", key: provider, provider: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.FederatedIdentityProviders.Google, text: getSignInWithFederationText(route, provider) }));
                default:
                    // eslint-disable-next-line no-console
                    console.error(`Authenticator does not support ${provider}. Please open an issue: https://github.com/aws-amplify/amplify-ui/issues/choose`);
            }
        }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Divider_Divider_mjs__WEBPACK_IMPORTED_MODULE_6__.Divider, { size: "small", label: getOrText() })));
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/FederatedSignIn/FederatedSignInButtons/FederatedSignInButton.mjs":
/*!***********************************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/FederatedSignIn/FederatedSignInButtons/FederatedSignInButton.mjs ***!
  \***********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FederatedSignInButton: () => (/* binding */ FederatedSignInButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../primitives/Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _primitives_Icon_Icon_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../primitives/Icon/Icon.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/Icon.mjs");
/* harmony import */ var _primitives_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../primitives/Text/Text.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Text/Text.mjs");









const AppleIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { "aria-label": "Apple icon", className: "amplify-icon federated-sign-in-icon", fill: "#000", preserveAspectRatio: "xMidYMid", stroke: "#000", strokeWidth: "0", viewBox: "0 0 1024 1024", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M747.4 535.7c-.4-68.2 30.5-119.6 92.9-157.5-34.9-50-87.7-77.5-157.3-82.8-65.9-5.2-138 38.4-164.4 38.4-27.9 0-91.7-36.6-141.9-36.6C273.1 298.8 163 379.8 163 544.6c0 48.7 8.9 99 26.7 150.8 23.8 68.2 109.6 235.3 199.1 232.6 46.8-1.1 79.9-33.2 140.8-33.2 59.1 0 89.7 33.2 141.9 33.2 90.3-1.3 167.9-153.2 190.5-221.6-121.1-57.1-114.6-167.2-114.6-170.7zm-105.1-305c50.7-60.2 46.1-115 44.6-134.7-44.8 2.6-96.6 30.5-126.1 64.8-32.5 36.8-51.6 82.3-47.5 133.6 48.4 3.7 92.6-21.2 129-63.7z" })));
};
const GoogleIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { "aria-label": "Google icon", className: "amplify-icon federated-sign-in-icon", viewBox: "0 0 256 262", xmlns: "http://www.w3.org/2000/svg", preserveAspectRatio: "xMidYMid" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M255.878 133.451c0-10.734-.871-18.567-2.756-26.69H130.55v48.448h71.947c-1.45 12.04-9.283 30.172-26.69 42.356l-.244 1.622 38.755 30.023 2.685.268c24.659-22.774 38.875-56.282 38.875-96.027", fill: "#4285F4" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M130.55 261.1c35.248 0 64.839-11.605 86.453-31.622l-41.196-31.913c-11.024 7.688-25.82 13.055-45.257 13.055-34.523 0-63.824-22.773-74.269-54.25l-1.531.13-40.298 31.187-.527 1.465C35.393 231.798 79.49 261.1 130.55 261.1", fill: "#34A853" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M56.281 156.37c-2.756-8.123-4.351-16.827-4.351-25.82 0-8.994 1.595-17.697 4.206-25.82l-.073-1.73L15.26 71.312l-1.335.635C5.077 89.644 0 109.517 0 130.55s5.077 40.905 13.925 58.602l42.356-32.782", fill: "#FBBC05" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M130.55 50.479c24.514 0 41.05 10.589 50.479 19.438l36.844-35.974C195.245 12.91 165.798 0 130.55 0 79.49 0 35.393 29.301 13.925 71.947l42.211 32.783c10.59-31.477 39.891-54.251 74.414-54.251", fill: "#EB4335" })));
};
const FacebookIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Icon_Icon_mjs__WEBPACK_IMPORTED_MODULE_1__.Icon, { className: "federated-sign-in-icon", ariaLabel: "Facebook icon", viewBox: { minX: 0, minY: 0, width: 279, height: 538 }, pathData: "M82.3409742,538 L82.3409742,292.936652 L0,292.936652 L0,196.990154 L82.2410458,196.990154 L82.2410458,126.4295 C82.2410458,44.575144 132.205229,0 205.252865,0 C240.227794,0 270.306232,2.59855099 279,3.79788222 L279,89.2502322 L228.536175,89.2502322 C188.964542,89.2502322 181.270057,108.139699 181.270057,135.824262 L181.270057,196.89021 L276.202006,196.89021 L263.810888,292.836708 L181.16913,292.836708 L181.16913,538 L82.3409742,538 Z", fill: "#1877F2" }));
};
const AmazonIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { "aria-label": "Amazon icon", className: "amplify-icon federated-sign-in-icon", viewBox: "0 0 243 264", xmlns: "http://www.w3.org/2000/svg", preserveAspectRatio: "xMidYMid" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M230.826 208.039C227.468 203.683 208.551 205.982 200.056 206.998C197.471 207.321 197.076 205.042 199.407 203.405C214.475 192.665 239.201 195.766 242.082 199.364C244.966 202.982 241.337 228.071 227.173 240.049C225.001 241.888 222.93 240.904 223.898 238.468C227.077 230.431 234.205 212.419 230.826 208.039ZM123.769 264C71.0234 264 39.0764 241.955 14.7853 217.542C9.97339 212.706 3.71799 206.296 0.311513 200.691C-1.09773 198.372 2.59096 195.022 5.04421 196.844C35.239 219.268 79.1012 239.538 122.53 239.538C151.82 239.538 188.046 227.47 217.669 214.868C222.147 212.966 222.147 219.18 221.512 221.061C221.183 222.032 206.515 236.221 186.247 247.047C167.304 257.166 143.397 264 123.769 264Z", fill: "#F2541B" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { fillRule: "evenodd", clipRule: "evenodd", d: "M142.943 111.185C142.943 124.756 143.268 136.054 136.406 148.123C130.856 157.913 122.027 163.95 112.222 163.95C98.8288 163.95 90.9806 153.772 90.9806 138.693C90.9806 109.036 117.677 103.647 142.943 103.647V111.185ZM178.166 196.081C175.858 198.15 171.635 198.22 169.914 196.894C157.974 187.684 149.89 173.688 149.89 173.688C130.706 193.156 117.127 199 92.2879 199C62.8772 199 40 180.905 40 144.729C40 116.461 55.3552 97.2408 77.2563 87.823C96.2094 79.5256 122.684 78.0173 142.943 75.7517C142.943 75.7517 144.633 53.933 138.699 45.9806C134.098 39.8163 126.272 36.9329 119.089 36.9329C106.127 36.8829 93.61 43.9051 91.1262 57.4188C90.4136 61.2829 87.5533 64.5261 84.54 64.206L51.0823 60.5922C48.5156 60.2951 45.0381 57.6639 45.8636 53.3081C53.644 12.3684 90.7373 0 123.989 0C140.983 0 163.21 4.51651 176.608 17.3349C193.597 33.1648 191.969 54.2755 191.969 77.2722V131.51C191.969 147.835 198.768 154.987 205.151 163.775C207.376 166.953 207.886 170.714 205.04 173.032C197.902 178.999 178.166 196.081 178.166 196.081Z", fill: "#F2541B" })));
};
const FederatedSignInButton = (props) => {
    const { icon, provider, text } = props;
    const { toFederatedSignIn } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])();
    const handleClick = (event) => {
        event.preventDefault();
        toFederatedSignIn({ provider });
    };
    let iconComponent;
    if (icon === 'facebook') {
        iconComponent = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FacebookIcon, null);
    }
    else if (icon === 'google') {
        iconComponent = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(GoogleIcon, null);
    }
    else if (icon === 'amazon') {
        iconComponent = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(AmazonIcon, null);
    }
    else if (icon === 'apple') {
        iconComponent = react__WEBPACK_IMPORTED_MODULE_0___default().createElement(AppleIcon, null);
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_3__.Button, { onClick: handleClick, className: "federated-sign-in-button", gap: "1rem" },
        iconComponent,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_4__.Text, { as: "span" }, text)));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForceNewPassword/ForceNewPassword.mjs":
/*!********************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForceNewPassword/ForceNewPassword.mjs ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ForceNewPassword: () => (/* binding */ ForceNewPassword)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../primitives/Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../shared/FormFields.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");












const { getChangePasswordText, getChangingText, getBackToSignInText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const ForceNewPassword = ({ className, variation, }) => {
    const { isPending, toSignIn } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [
        context.isPending,
        context.toSignIn,
    ]);
    const { handleBlur, handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    ForceNewPassword: { FormFields = ForceNewPassword.FormFields, Header = ForceNewPassword.Header, Footer = ForceNewPassword.Footer, }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.useCustomComponents)();
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__.RouteContainer, { className: className, variation: variation },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-forcenewpassword": "", method: "post", onChange: handleChange, onSubmit: handleSubmit, onBlur: handleBlur },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FormFields, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_7__.RemoteErrorMessage, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_8__.Button, { isDisabled: isPending, type: "submit", variation: "primary", isLoading: isPending, loadingText: getChangingText() }, getChangePasswordText()),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_8__.Button, { onClick: toSignIn, type: "button", variation: "link", size: "small" }, getBackToSignInText()),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Footer, null)))));
};
ForceNewPassword.FormFields = function FormFields$1() {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_9__.FormFields, null);
};
ForceNewPassword.Header = function Header() {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__.Heading, { level: 4 }, getChangePasswordText());
};
ForceNewPassword.Footer = function Footer() {
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForgotPassword/ConfirmResetPassword.mjs":
/*!**********************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForgotPassword/ConfirmResetPassword.mjs ***!
  \**********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfirmResetPassword: () => (/* binding */ ConfirmResetPassword)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _shared_TwoButtonSubmitFooter_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../shared/TwoButtonSubmitFooter.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/TwoButtonSubmitFooter.mjs");
/* harmony import */ var _shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../shared/FormFields.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");












const { getResendCodeText, getResetYourPasswordText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const ConfirmResetPassword = ({ className, variation, }) => {
    const { isPending } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [context.isPending]);
    const { handleBlur, handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    ConfirmResetPassword: { Header = ConfirmResetPassword.Header, Footer = ConfirmResetPassword.Footer, }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.useCustomComponents)();
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__.RouteContainer, { className: className, variation: variation },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-confirmresetpassword": "", method: "post", onSubmit: handleSubmit, onChange: handleChange, onBlur: handleBlur },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { direction: "column" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_7__.FormFields, null)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__.RemoteErrorMessage, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_TwoButtonSubmitFooter_mjs__WEBPACK_IMPORTED_MODULE_9__.TwoButtonSubmitFooter, { cancelButtonSendType: "RESEND", cancelButtonText: getResendCodeText() }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Footer, null)))));
};
ConfirmResetPassword.Header = function Header() {
    const headerText = getResetYourPasswordText();
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__.Heading, { level: 3 }, headerText);
};
ConfirmResetPassword.Footer = function Footer() {
    // @ts-ignore
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForgotPassword/ForgotPassword.mjs":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForgotPassword/ForgotPassword.mjs ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ForgotPassword: () => (/* binding */ ForgotPassword)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _shared_TwoButtonSubmitFooter_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../shared/TwoButtonSubmitFooter.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/TwoButtonSubmitFooter.mjs");
/* harmony import */ var _shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../shared/FormFields.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");












const { getBackToSignInText, getSendingText, getSendCodeText, getResetYourPasswordText, } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const ForgotPassword = ({ className, variation, }) => {
    const { isPending } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [context.isPending]);
    const { handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    ForgotPassword: { Header = ForgotPassword.Header, Footer = ForgotPassword.Footer, }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.useCustomComponents)();
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__.RouteContainer, { className: className, variation: variation },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-forgotpassword": "", method: "post", onChange: handleChange, onSubmit: handleSubmit },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { direction: "column" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_7__.FormFields, null)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__.RemoteErrorMessage, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_TwoButtonSubmitFooter_mjs__WEBPACK_IMPORTED_MODULE_9__.TwoButtonSubmitFooter, { cancelButtonText: getBackToSignInText(), cancelButtonSendType: "SIGN_IN", submitButtonText: isPending ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                        getSendingText(),
                        "\u2026")) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, getSendCodeText())) }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Footer, null)))));
};
ForgotPassword.Header = function Header() {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__.Heading, { level: 3 }, getResetYourPasswordText());
};
ForgotPassword.Footer = function Footer() {
    // @ts-ignore
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs":
/*!****************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RouteContainer: () => (/* binding */ RouteContainer)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../primitives/View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");





function RouteContainer({ children, className, variation = 'default', }) {
    const { route } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__["default"])(({ route }) => [route]);
    const { 
    // @ts-ignore
    components: { Header, Footer }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_2__.useCustomComponents)();
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { className: className, "data-amplify-authenticator": "", "data-variation": variation },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { "data-amplify-container": "" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, null),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { "data-amplify-router": "", "data-amplify-router-content": undefined  }, children),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Footer, null))));
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/Router/Router.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/Router/Router.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Router: () => (/* binding */ Router)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _ConfirmSignUp_ConfirmSignUp_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ConfirmSignUp/ConfirmSignUp.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ConfirmSignUp/ConfirmSignUp.mjs");
/* harmony import */ var _ForceNewPassword_ForceNewPassword_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../ForceNewPassword/ForceNewPassword.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForceNewPassword/ForceNewPassword.mjs");
/* harmony import */ var _SetupTotp_SetupTotp_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../SetupTotp/SetupTotp.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SetupTotp/SetupTotp.mjs");
/* harmony import */ var _shared_SignInSignUpTabs_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../shared/SignInSignUpTabs.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/SignInSignUpTabs.mjs");
/* harmony import */ var _VerifyUser_ConfirmVerifyUser_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../VerifyUser/ConfirmVerifyUser.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/VerifyUser/ConfirmVerifyUser.mjs");
/* harmony import */ var _VerifyUser_VerifyUser_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../VerifyUser/VerifyUser.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/VerifyUser/VerifyUser.mjs");
/* harmony import */ var _ConfirmSignIn_ConfirmSignIn_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ConfirmSignIn/ConfirmSignIn.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ConfirmSignIn/ConfirmSignIn.mjs");
/* harmony import */ var _ForgotPassword_ConfirmResetPassword_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../ForgotPassword/ConfirmResetPassword.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForgotPassword/ConfirmResetPassword.mjs");
/* harmony import */ var _ForgotPassword_ForgotPassword_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../ForgotPassword/ForgotPassword.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForgotPassword/ForgotPassword.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/utils.mjs");
/* harmony import */ var _SelectMfaType_SelectMfaType_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../SelectMfaType/SelectMfaType.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SelectMfaType/SelectMfaType.mjs");
/* harmony import */ var _SetupEmail_SetupEmail_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../SetupEmail/SetupEmail.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SetupEmail/SetupEmail.mjs");




















function RenderNothing() {
    // @ts-ignore
    return null;
}
const getRouteComponent = (route) => {
    switch (route) {
        case 'authenticated':
        case 'idle':
        case 'setup':
        case 'transition':
            return RenderNothing;
        case 'confirmSignUp':
            return _ConfirmSignUp_ConfirmSignUp_mjs__WEBPACK_IMPORTED_MODULE_1__.ConfirmSignUp;
        case 'confirmSignIn':
            return _ConfirmSignIn_ConfirmSignIn_mjs__WEBPACK_IMPORTED_MODULE_2__.ConfirmSignIn;
        case 'selectMfaType':
            return _SelectMfaType_SelectMfaType_mjs__WEBPACK_IMPORTED_MODULE_3__.SelectMfaType;
        case 'setupEmail':
            return _SetupEmail_SetupEmail_mjs__WEBPACK_IMPORTED_MODULE_4__.SetupEmail;
        case 'setupTotp':
            return _SetupTotp_SetupTotp_mjs__WEBPACK_IMPORTED_MODULE_5__.SetupTotp;
        case 'signIn':
        case 'signUp':
            return _shared_SignInSignUpTabs_mjs__WEBPACK_IMPORTED_MODULE_6__.SignInSignUpTabs;
        case 'forceNewPassword':
            return _ForceNewPassword_ForceNewPassword_mjs__WEBPACK_IMPORTED_MODULE_7__.ForceNewPassword;
        case 'forgotPassword':
            return _ForgotPassword_ForgotPassword_mjs__WEBPACK_IMPORTED_MODULE_8__.ForgotPassword;
        case 'confirmResetPassword':
            return _ForgotPassword_ConfirmResetPassword_mjs__WEBPACK_IMPORTED_MODULE_9__.ConfirmResetPassword;
        case 'verifyUser':
            return _VerifyUser_VerifyUser_mjs__WEBPACK_IMPORTED_MODULE_10__.VerifyUser;
        case 'confirmVerifyUser':
            return _VerifyUser_ConfirmVerifyUser_mjs__WEBPACK_IMPORTED_MODULE_11__.ConfirmVerifyUser;
        default:
            // eslint-disable-next-line no-console
            console.warn(`Unhandled Authenticator route - please open an issue: ${route}`);
            return RenderNothing;
    }
};
function Router({ className, hideSignUp, variation, }) {
    const { route } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_12__["default"])(({ route }) => [route]);
    const RouterChildren = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => getRouteComponent(route), [route]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(RouterChildren, { className: className, 
        // @ts-ignore
        hideSignUp: (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_13__.isSignInOrSignUpRoute)(route) ? hideSignUp : undefined, variation: variation }));
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SelectMfaType/SelectMfaType.mjs":
/*!**************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SelectMfaType/SelectMfaType.mjs ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SelectMfaType: () => (/* binding */ SelectMfaType)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _primitives_RadioGroupField_RadioGroupField_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../primitives/RadioGroupField/RadioGroupField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/RadioGroupField/RadioGroupField.mjs");
/* harmony import */ var _primitives_Radio_Radio_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../primitives/Radio/Radio.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Radio/Radio.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_ConfirmSignInFooter_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../shared/ConfirmSignInFooter.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/ConfirmSignInFooter.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");













const { getMfaTypeLabelByValue, getSelectMfaTypeByChallengeName, getSelectMfaTypeText, } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const SelectMfaType = ({ className, variation, }) => {
    const { isPending, allowedMfaTypes = [] } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => {
        return [context.isPending, context.allowedMfaTypes];
    });
    const { handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    SelectMfaType: { Header = SelectMfaType.Header, Footer = SelectMfaType.Footer, }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.useCustomComponents)();
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__.RouteContainer, { className: className, variation: variation },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-select-mfa-type": "", method: "post", onChange: handleChange, onSubmit: handleSubmit },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(Header, null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { direction: "column" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_RadioGroupField_RadioGroupField_mjs__WEBPACK_IMPORTED_MODULE_7__.RadioGroupField, { name: "mfa_type", legend: getSelectMfaTypeText(), legendHidden: true, isDisabled: isPending, isRequired: true }, allowedMfaTypes.map((value, index) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_Radio_Radio_mjs__WEBPACK_IMPORTED_MODULE_8__.Radio, { name: "mfa_type", key: value, value: value, defaultChecked: index === 0 }, getMfaTypeLabelByValue(value))))),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_9__.RemoteErrorMessage, null)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_shared_ConfirmSignInFooter_mjs__WEBPACK_IMPORTED_MODULE_10__.ConfirmSignInFooter, null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(Footer, null)))));
};
SelectMfaType.Header = function Header() {
    const { challengeName } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => {
        return [context.challengeName];
    });
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_11__.Heading, { level: 3 }, getSelectMfaTypeByChallengeName(challengeName)));
};
SelectMfaType.Footer = function Footer() {
    // @ts-ignore
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SetupEmail/SetupEmail.mjs":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SetupEmail/SetupEmail.mjs ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SetupEmail: () => (/* binding */ SetupEmail)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_ConfirmSignInFooter_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../shared/ConfirmSignInFooter.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/ConfirmSignInFooter.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../shared/FormFields.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");












const { getSetupEmailText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const SetupEmail = ({ className, variation, }) => {
    const { isPending } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [context.isPending]);
    const { handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    SetupEmail: { Header = SetupEmail.Header, Footer = SetupEmail.Footer }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.useCustomComponents)();
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__.RouteContainer, { className: className, variation: variation },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-setup-email": "", method: "post", onChange: handleChange, onSubmit: handleSubmit },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(Header, null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { direction: "column" },
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_7__.FormFields, null),
                    react__WEBPACK_IMPORTED_MODULE_0__.createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__.RemoteErrorMessage, null)),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(_shared_ConfirmSignInFooter_mjs__WEBPACK_IMPORTED_MODULE_9__.ConfirmSignInFooter, null),
                react__WEBPACK_IMPORTED_MODULE_0__.createElement(Footer, null)))));
};
SetupEmail.Header = function Header() {
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__.Heading, { level: 3 }, getSetupEmailText());
};
SetupEmail.Footer = function Footer() {
    // @ts-ignore
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SetupTotp/SetupTotp.mjs":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SetupTotp/SetupTotp.mjs ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SetupTotp: () => (/* binding */ SetupTotp)
/* harmony export */ });
/* harmony import */ var qrcode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! qrcode */ "./node_modules/qrcode/lib/browser.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var aws_amplify_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! aws-amplify/utils */ "./node_modules/@aws-amplify/core/dist/esm/Logger/ConsoleLogger.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/utils.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_ConfirmSignInFooter_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../shared/ConfirmSignInFooter.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/ConfirmSignInFooter.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../shared/FormFields.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");














const logger = new aws_amplify_utils__WEBPACK_IMPORTED_MODULE_2__.ConsoleLogger('SetupTotp-logger');
const { getSetupTotpText, getCopiedText, getLoadingText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.authenticatorTextUtil;
const SetupTotp = ({ className, variation, }) => {
    const { totpSecretCode, isPending, username, QRFields } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_4__["default"])((context) => [context.isPending, context.totpSecretCode, context.username]);
    const { handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_5__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    SetupTotp: { Header = SetupTotp.Header, Footer = SetupTotp.Footer }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_6__.useCustomComponents)();
    const [isLoading, setIsLoading] = react__WEBPACK_IMPORTED_MODULE_1__.useState(true);
    const [qrCode, setQrCode] = react__WEBPACK_IMPORTED_MODULE_1__.useState();
    const [copyTextLabel, setCopyTextLabel] = react__WEBPACK_IMPORTED_MODULE_1__.useState('COPY');
    const { totpIssuer = 'AWSCognito', totpUsername = username } = QRFields ?? {};
    const generateQRCode = react__WEBPACK_IMPORTED_MODULE_1__.useCallback(async () => {
        try {
            const totpCode = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.getTotpCodeURL)(totpIssuer, totpUsername, totpSecretCode);
            const qrCodeImageSource = await qrcode__WEBPACK_IMPORTED_MODULE_0__.toDataURL(totpCode);
            setQrCode(qrCodeImageSource);
        }
        catch (error) {
            logger.error(error);
        }
        finally {
            setIsLoading(false);
        }
    }, [totpIssuer, totpUsername, totpSecretCode]);
    react__WEBPACK_IMPORTED_MODULE_1__.useEffect(() => {
        if (!qrCode) {
            generateQRCode();
        }
    }, [generateQRCode, qrCode]);
    const copyText = () => {
        navigator.clipboard.writeText(totpSecretCode);
        setCopyTextLabel(getCopiedText());
    };
    return (react__WEBPACK_IMPORTED_MODULE_1__.createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_8__.RouteContainer, { className: className, variation: variation },
        react__WEBPACK_IMPORTED_MODULE_1__.createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-setup-totp": "", method: "post", onChange: handleChange, onSubmit: handleSubmit },
            react__WEBPACK_IMPORTED_MODULE_1__.createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_9__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(Header, null),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_9__.Flex, { direction: "column" },
                    isLoading ? (react__WEBPACK_IMPORTED_MODULE_1__.createElement("p", null,
                        getLoadingText(),
                        "\u2026")) : (react__WEBPACK_IMPORTED_MODULE_1__.createElement("img", { "data-amplify-qrcode": true, src: qrCode, alt: "qr code", width: "228", height: "228" })),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_9__.Flex, { "data-amplify-copy": true },
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", null, totpSecretCode),
                        react__WEBPACK_IMPORTED_MODULE_1__.createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_9__.Flex, { "data-amplify-copy-svg": true, onClick: copyText },
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement("div", { "data-amplify-copy-tooltip": true }, copyTextLabel),
                            react__WEBPACK_IMPORTED_MODULE_1__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", xmlns: "http://www.w3.org/2000/svg" },
                                react__WEBPACK_IMPORTED_MODULE_1__.createElement("path", { d: "M16 1H4C2.9 1 2 1.9 2 3V17H4V3H16V1ZM15 5H8C6.9 5 6.01 5.9 6.01 7L6 21C6 22.1 6.89 23 7.99 23H19C20.1 23 21 22.1 21 21V11L15 5ZM8 21V7H14V12H19V21H8Z" })))),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_10__.FormFields, null),
                    react__WEBPACK_IMPORTED_MODULE_1__.createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_11__.RemoteErrorMessage, null)),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(_shared_ConfirmSignInFooter_mjs__WEBPACK_IMPORTED_MODULE_12__.ConfirmSignInFooter, null),
                react__WEBPACK_IMPORTED_MODULE_1__.createElement(Footer, null)))));
};
SetupTotp.Header = function Header() {
    return react__WEBPACK_IMPORTED_MODULE_1__.createElement(_primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_13__.Heading, { level: 3 }, getSetupTotpText());
};
SetupTotp.Footer = function Footer() {
    // @ts-ignore
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SignIn/SignIn.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SignIn/SignIn.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SignIn: () => (/* binding */ SignIn)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../primitives/Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../primitives/View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _primitives_VisuallyHidden_VisuallyHidden_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../primitives/VisuallyHidden/VisuallyHidden.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/VisuallyHidden/VisuallyHidden.mjs");
/* harmony import */ var _FederatedSignIn_FederatedSignIn_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../FederatedSignIn/FederatedSignIn.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/FederatedSignIn/FederatedSignIn.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../shared/FormFields.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs");













const { getSignInText, getSigningInText, getForgotPasswordText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
function SignIn() {
    const { isPending } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [context.isPending]);
    const { handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    SignIn: { Header = SignIn.Header, Footer = SignIn.Footer }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.useCustomComponents)();
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__.View, null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, null),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-signin": "", method: "post", onSubmit: handleSubmit, onChange: handleChange },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FederatedSignIn_FederatedSignIn_mjs__WEBPACK_IMPORTED_MODULE_6__.FederatedSignIn, null),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_7__.Flex, { direction: "column" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_7__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_VisuallyHidden_VisuallyHidden_mjs__WEBPACK_IMPORTED_MODULE_8__.VisuallyHidden, null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("legend", null, getSignInText())),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_9__.FormFields, null)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_10__.RemoteErrorMessage, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_11__.Button, { isDisabled: isPending, type: "submit", variation: "primary", isLoading: isPending, loadingText: getSigningInText() }, getSignInText()),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Footer, null)))));
}
const DefaultFooter = () => {
    const { toForgotPassword } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [
        context.toForgotPassword,
    ]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__.View, { "data-amplify-footer": "" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_11__.Button, { onClick: toForgotPassword, size: "small", variation: "link" }, getForgotPasswordText())));
};
SignIn.Footer = DefaultFooter;
SignIn.Header = function Header() {
    // @ts-ignore
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SignUp/SignUp.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SignUp/SignUp.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SignUp: () => (/* binding */ SignUp)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../primitives/Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../primitives/View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _FederatedSignIn_FederatedSignIn_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../FederatedSignIn/FederatedSignIn.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/FederatedSignIn/FederatedSignIn.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../shared/FormFields.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs");












const { getCreateAccountText, getCreatingAccountText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
function SignUp() {
    const { hasValidationErrors, isPending } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [
        context.hasValidationErrors,
        context.isPending,
    ]);
    const { handleChange, handleBlur, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    SignUp: { Header = SignUp.Header, FormFields = SignUp.FormFields, Footer = SignUp.Footer, }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.useCustomComponents)();
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__.View, null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, null),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-signup": "", method: "post", onChange: handleChange, onSubmit: handleSubmit, onBlur: handleBlur },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FederatedSignIn_FederatedSignIn_mjs__WEBPACK_IMPORTED_MODULE_6__.FederatedSignIn, null),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_7__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_7__.Flex, { direction: "column" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(FormFields, null),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__.RemoteErrorMessage, null)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_9__.Button, { isDisabled: hasValidationErrors || isPending, isFullWidth: true, type: "submit", variation: "primary", isLoading: isPending, loadingText: getCreatingAccountText() }, getCreateAccountText()),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Footer, null)))));
}
SignUp.Header = function Header() {
    // @ts-ignore
    return null;
};
SignUp.FormFields = function FormFields$1() {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_10__.FormFields, null);
};
SignUp.Footer = function Footer() {
    // @ts-ignore
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/VerifyUser/ConfirmVerifyUser.mjs":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/VerifyUser/ConfirmVerifyUser.mjs ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfirmVerifyUser: () => (/* binding */ ConfirmVerifyUser)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _shared_TwoButtonSubmitFooter_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../shared/TwoButtonSubmitFooter.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/TwoButtonSubmitFooter.mjs");
/* harmony import */ var _shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../shared/FormFields.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");












const { getAccountRecoveryInfoText, getSkipText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const ConfirmVerifyUser = ({ className, variation, }) => {
    const { isPending } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [context.isPending]);
    const { handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_3__.useFormHandlers)();
    const { components: { 
    // @ts-ignore
    ConfirmVerifyUser: { Header = ConfirmVerifyUser.Header, Footer = ConfirmVerifyUser.Footer, }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_4__.useCustomComponents)();
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_5__.RouteContainer, { className: className, variation: variation },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-confirmverifyuser": "", method: "post", onChange: handleChange, onSubmit: handleSubmit },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { direction: "column" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_FormFields_mjs__WEBPACK_IMPORTED_MODULE_7__.FormFields, null)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_8__.RemoteErrorMessage, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_TwoButtonSubmitFooter_mjs__WEBPACK_IMPORTED_MODULE_9__.TwoButtonSubmitFooter, { cancelButtonText: getSkipText(), cancelButtonSendType: "SKIP" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Footer, null)))));
};
ConfirmVerifyUser.Header = function Header() {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_10__.Heading, { level: 3 }, getAccountRecoveryInfoText());
};
ConfirmVerifyUser.Footer = function Footer() {
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/VerifyUser/VerifyUser.mjs":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/VerifyUser/VerifyUser.mjs ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   VerifyUser: () => (/* binding */ VerifyUser)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/constants.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/i18n/translations.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/utils.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _primitives_Radio_Radio_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../primitives/Radio/Radio.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Radio/Radio.mjs");
/* harmony import */ var _primitives_RadioGroupField_RadioGroupField_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../primitives/RadioGroupField/RadioGroupField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/RadioGroupField/RadioGroupField.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../hooks/useCustomComponents/useCustomComponents.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs");
/* harmony import */ var _hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../hooks/useFormHandlers/useFormHandlers.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs");
/* harmony import */ var _shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../shared/RemoteErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs");
/* harmony import */ var _shared_TwoButtonSubmitFooter_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../shared/TwoButtonSubmitFooter.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/TwoButtonSubmitFooter.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");













const { getSkipText, getVerifyText, getVerifyContactText, getAccountRecoveryInfoText, } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const generateRadioGroup = (attributes) => {
    return Object.entries(attributes).map(([key, value], index) => {
        const verificationType = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.defaultFormFieldOptions[key].label;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Radio_Radio_mjs__WEBPACK_IMPORTED_MODULE_3__.Radio, { name: "unverifiedAttr", value: key, key: key, defaultChecked: index === 0 },
            (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.translate)(verificationType),
            ":",
            ' ',
            (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.censorContactMethod)(verificationType, value)));
    });
};
const VerifyUser = ({ className, variation, }) => {
    const { components: { 
    // @ts-ignore
    VerifyUser: { Header = VerifyUser.Header, Footer = VerifyUser.Footer }, }, } = (0,_hooks_useCustomComponents_useCustomComponents_mjs__WEBPACK_IMPORTED_MODULE_6__.useCustomComponents)();
    const { isPending, unverifiedUserAttributes } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_7__["default"])(({ isPending, unverifiedUserAttributes }) => [
        isPending,
        unverifiedUserAttributes,
    ]);
    const { handleChange, handleSubmit } = (0,_hooks_useFormHandlers_useFormHandlers_mjs__WEBPACK_IMPORTED_MODULE_8__.useFormHandlers)();
    const footerSubmitText = isPending ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, "Verifying\u2026")) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, getVerifyText()));
    const verificationRadioGroup = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_RadioGroupField_RadioGroupField_mjs__WEBPACK_IMPORTED_MODULE_9__.RadioGroupField, { legend: getVerifyContactText(), name: "verify_context", isDisabled: isPending, legendHidden: true }, generateRadioGroup(unverifiedUserAttributes)));
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_10__.RouteContainer, { className: className, variation: variation },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { "data-amplify-form": "", "data-amplify-authenticator-verifyuser": "", method: "post", onChange: handleChange, onSubmit: handleSubmit },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_11__.Flex, { as: "fieldset", direction: "column", isDisabled: isPending },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Header, null),
                verificationRadioGroup,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_RemoteErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_12__.RemoteErrorMessage, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_shared_TwoButtonSubmitFooter_mjs__WEBPACK_IMPORTED_MODULE_13__.TwoButtonSubmitFooter, { cancelButtonText: getSkipText(), cancelButtonSendType: "SKIP", submitButtonText: footerSubmitText }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Footer, null)))));
};
VerifyUser.Header = function Header() {
    return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_14__.Heading, { level: 3 }, getAccountRecoveryInfoText());
};
VerifyUser.Footer = function Footer() {
    // @ts-ignore
    return null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/defaultComponents.mjs":
/*!******************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/defaultComponents.mjs ***!
  \******************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   defaultComponents: () => (/* binding */ defaultComponents)
/* harmony export */ });
/* harmony import */ var _SignIn_SignIn_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../SignIn/SignIn.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SignIn/SignIn.mjs");
/* harmony import */ var _SignUp_SignUp_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../SignUp/SignUp.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SignUp/SignUp.mjs");
/* harmony import */ var _ConfirmSignUp_ConfirmSignUp_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../ConfirmSignUp/ConfirmSignUp.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ConfirmSignUp/ConfirmSignUp.mjs");
/* harmony import */ var _ForceNewPassword_ForceNewPassword_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../ForceNewPassword/ForceNewPassword.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForceNewPassword/ForceNewPassword.mjs");
/* harmony import */ var _SetupTotp_SetupTotp_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../SetupTotp/SetupTotp.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SetupTotp/SetupTotp.mjs");
/* harmony import */ var _ConfirmSignIn_ConfirmSignIn_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../ConfirmSignIn/ConfirmSignIn.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ConfirmSignIn/ConfirmSignIn.mjs");
/* harmony import */ var _VerifyUser_ConfirmVerifyUser_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../VerifyUser/ConfirmVerifyUser.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/VerifyUser/ConfirmVerifyUser.mjs");
/* harmony import */ var _VerifyUser_VerifyUser_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../VerifyUser/VerifyUser.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/VerifyUser/VerifyUser.mjs");
/* harmony import */ var _ForgotPassword_ConfirmResetPassword_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../ForgotPassword/ConfirmResetPassword.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForgotPassword/ConfirmResetPassword.mjs");
/* harmony import */ var _ForgotPassword_ForgotPassword_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../ForgotPassword/ForgotPassword.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/ForgotPassword/ForgotPassword.mjs");
/* harmony import */ var _SelectMfaType_SelectMfaType_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../SelectMfaType/SelectMfaType.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SelectMfaType/SelectMfaType.mjs");
/* harmony import */ var _SetupEmail_SetupEmail_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../SetupEmail/SetupEmail.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SetupEmail/SetupEmail.mjs");













const defaultComponents = {
    // @ts-ignore
    Header: () => null,
    SignIn: {
        Header: _SignIn_SignIn_mjs__WEBPACK_IMPORTED_MODULE_0__.SignIn.Header,
        Footer: _SignIn_SignIn_mjs__WEBPACK_IMPORTED_MODULE_0__.SignIn.Footer,
    },
    SignUp: {
        Header: _SignUp_SignUp_mjs__WEBPACK_IMPORTED_MODULE_1__.SignUp.Header,
        FormFields: _SignUp_SignUp_mjs__WEBPACK_IMPORTED_MODULE_1__.SignUp.FormFields,
        Footer: _SignUp_SignUp_mjs__WEBPACK_IMPORTED_MODULE_1__.SignUp.Footer,
    },
    ConfirmSignUp: {
        Header: _ConfirmSignUp_ConfirmSignUp_mjs__WEBPACK_IMPORTED_MODULE_2__.ConfirmSignUp.Header,
        Footer: _ConfirmSignUp_ConfirmSignUp_mjs__WEBPACK_IMPORTED_MODULE_2__.ConfirmSignUp.Footer,
    },
    SelectMfaType: {
        Header: _SelectMfaType_SelectMfaType_mjs__WEBPACK_IMPORTED_MODULE_3__.SelectMfaType.Header,
        Footer: _SelectMfaType_SelectMfaType_mjs__WEBPACK_IMPORTED_MODULE_3__.SelectMfaType.Footer,
    },
    SetupEmail: {
        Header: _SetupEmail_SetupEmail_mjs__WEBPACK_IMPORTED_MODULE_4__.SetupEmail.Header,
        Footer: _SetupEmail_SetupEmail_mjs__WEBPACK_IMPORTED_MODULE_4__.SetupEmail.Footer,
    },
    SetupTotp: {
        Header: _SetupTotp_SetupTotp_mjs__WEBPACK_IMPORTED_MODULE_5__.SetupTotp.Header,
        Footer: _SetupTotp_SetupTotp_mjs__WEBPACK_IMPORTED_MODULE_5__.SetupTotp.Footer,
    },
    ConfirmResetPassword: {
        Header: _ForgotPassword_ConfirmResetPassword_mjs__WEBPACK_IMPORTED_MODULE_6__.ConfirmResetPassword.Header,
        Footer: _ForgotPassword_ConfirmResetPassword_mjs__WEBPACK_IMPORTED_MODULE_6__.ConfirmResetPassword.Footer,
    },
    ConfirmSignIn: {
        Header: _ConfirmSignIn_ConfirmSignIn_mjs__WEBPACK_IMPORTED_MODULE_7__.ConfirmSignIn.Header,
        Footer: _ConfirmSignIn_ConfirmSignIn_mjs__WEBPACK_IMPORTED_MODULE_7__.ConfirmSignIn.Footer,
    },
    VerifyUser: {
        Header: _VerifyUser_VerifyUser_mjs__WEBPACK_IMPORTED_MODULE_8__.VerifyUser.Header,
        Footer: _VerifyUser_VerifyUser_mjs__WEBPACK_IMPORTED_MODULE_8__.VerifyUser.Footer,
    },
    ConfirmVerifyUser: {
        Header: _VerifyUser_ConfirmVerifyUser_mjs__WEBPACK_IMPORTED_MODULE_9__.ConfirmVerifyUser.Header,
        // @ts-ignore
        Footer: _VerifyUser_ConfirmVerifyUser_mjs__WEBPACK_IMPORTED_MODULE_9__.ConfirmVerifyUser.Footer,
    },
    ForceNewPassword: {
        Header: _ForceNewPassword_ForceNewPassword_mjs__WEBPACK_IMPORTED_MODULE_10__.ForceNewPassword.Header,
        Footer: _ForceNewPassword_ForceNewPassword_mjs__WEBPACK_IMPORTED_MODULE_10__.ForceNewPassword.Footer,
        FormFields: _ForceNewPassword_ForceNewPassword_mjs__WEBPACK_IMPORTED_MODULE_10__.ForceNewPassword.FormFields,
    },
    ForgotPassword: {
        Header: _ForgotPassword_ForgotPassword_mjs__WEBPACK_IMPORTED_MODULE_11__.ForgotPassword.Header,
        Footer: _ForgotPassword_ForgotPassword_mjs__WEBPACK_IMPORTED_MODULE_11__.ForgotPassword.Footer,
    },
    // @ts-ignore
    Footer: () => null,
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs":
/*!********************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useCustomComponents/useCustomComponents.mjs ***!
  \********************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CustomComponentsContext: () => (/* binding */ CustomComponentsContext),
/* harmony export */   useCustomComponents: () => (/* binding */ useCustomComponents)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const CustomComponentsContext = 
// @ts-ignore
react__WEBPACK_IMPORTED_MODULE_0__.createContext(null);
const useCustomComponents = () => {
    const context = react__WEBPACK_IMPORTED_MODULE_0__.useContext(CustomComponentsContext);
    if (!context) {
        throw new Error('`useCustomComponents` cannot be used outside of a `CustomComponentsContext.Provider`');
    }
    return context;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs":
/*!************************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/hooks/useFormHandlers/useFormHandlers.mjs ***!
  \************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useFormHandlers: () => (/* binding */ useFormHandlers)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _helpers_utils_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../helpers/utils.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/helpers/utils.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");




function useFormHandlers() {
    const { submitForm, updateBlur, updateForm } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__["default"])((context) => [
        context.submitForm,
        context.updateBlur,
        context.updateForm,
    ]);
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(({ target: { name } }) => {
        updateBlur({ name });
    }, [updateBlur]);
    // @TODO: align multiple input type handling with react docs example for 3.0 release
    // example: https://reactjs.org/docs/forms.html#handling-multiple-inputs
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)(({ target: { checked, name, type, value }, }) => {
        const isUncheckedCheckbox = type === 'checkbox' && !checked;
        updateForm({
            name,
            value: isUncheckedCheckbox ? undefined : value,
        });
    }, [updateForm]);
    const handleSubmit = (0,react__WEBPACK_IMPORTED_MODULE_0__.useCallback)((event) => {
        event.preventDefault();
        submitForm((0,_helpers_utils_mjs__WEBPACK_IMPORTED_MODULE_2__.getFormDataFromEvent)(event));
    }, [submitForm]);
    return { handleBlur, handleChange, handleSubmit };
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/ConfirmSignInFooter.mjs":
/*!*************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/ConfirmSignInFooter.mjs ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConfirmSignInFooter: () => (/* binding */ ConfirmSignInFooter)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../primitives/Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");






const { getConfirmText, getConfirmingText, getBackToSignInText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const ConfirmSignInFooter = () => {
    const { isPending, toSignIn } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [
        context.isPending,
        context.toSignIn,
    ]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__.Flex, { direction: "column" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_4__.Button, { isDisabled: isPending, type: "submit", variation: "primary", isLoading: isPending, loadingText: getConfirmingText() }, getConfirmText()),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_4__.Button, { onClick: toSignIn, type: "button", variation: "link", size: "small" }, getBackToSignInText())));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormField.mjs":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormField.mjs ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormField: () => (/* binding */ FormField)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/form.mjs");
/* harmony import */ var _primitives_PasswordField_PasswordField_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/PasswordField/PasswordField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/PasswordField/PasswordField.mjs");
/* harmony import */ var _primitives_PhoneNumberField_PhoneNumberField_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../primitives/PhoneNumberField/PhoneNumberField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/PhoneNumberField/PhoneNumberField.mjs");
/* harmony import */ var _primitives_TextField_TextField_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../primitives/TextField/TextField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/TextField/TextField.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _primitives_utils_useStableId_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../primitives/utils/useStableId.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/useStableId.mjs");
/* harmony import */ var _shared_ValidationErrors_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../shared/ValidationErrors.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/shared/ValidationErrors.mjs");









function FormField({ autocomplete: autoComplete, dialCode, name, type, ...props }) {
    const { validationErrors } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__["default"])(({ validationErrors }) => [
        validationErrors,
    ]);
    const errors = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.getErrors)(validationErrors[name]), [name, validationErrors]);
    const hasError = errors?.length > 0;
    const errorId = (0,_primitives_utils_useStableId_mjs__WEBPACK_IMPORTED_MODULE_3__.useStableId)();
    const ariaDescribedBy = hasError ? errorId : undefined;
    if (type === 'tel') {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_PhoneNumberField_PhoneNumberField_mjs__WEBPACK_IMPORTED_MODULE_4__.PhoneNumberField, { ...props, name: name, defaultDialCode: dialCode, dialCodeName: "country_code", autoComplete: autoComplete, hasError: hasError, "aria-describedby": ariaDescribedBy }),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_shared_ValidationErrors_mjs__WEBPACK_IMPORTED_MODULE_5__.ValidationErrors, { dataAttr: "data-amplify-sign-up-errors", errors: errors, id: errorId })));
    }
    else if (type === 'password') {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_PasswordField_PasswordField_mjs__WEBPACK_IMPORTED_MODULE_6__.PasswordField, { ...props, name: name, autoCapitalize: "off", autoComplete: autoComplete, hasError: hasError, "aria-describedby": ariaDescribedBy }),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_shared_ValidationErrors_mjs__WEBPACK_IMPORTED_MODULE_5__.ValidationErrors, { dataAttr: "data-amplify-sign-up-errors", errors: errors, id: errorId })));
    }
    else {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_primitives_TextField_TextField_mjs__WEBPACK_IMPORTED_MODULE_7__.TextField, { ...props, name: name, autoCapitalize: "off", autoComplete: autoComplete, hasError: hasError, type: type, "aria-describedby": ariaDescribedBy }),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_shared_ValidationErrors_mjs__WEBPACK_IMPORTED_MODULE_5__.ValidationErrors, { dataAttr: "data-amplify-sign-up-errors", errors: errors, id: errorId })));
    }
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormFields.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FormFields: () => (/* binding */ FormFields)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _FormField_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FormField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/FormField.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");




function FormFields() {
    const { fields } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__["default"])(({ route }) => [route]);
    const formFields = react__WEBPACK_IMPORTED_MODULE_0__.useRef(fields.map((field, index) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FormField_mjs__WEBPACK_IMPORTED_MODULE_2__.FormField
    // use index for key, field order is static
    , { 
        // use index for key, field order is static
        key: index, ...field })))).current;
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, formFields);
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs":
/*!************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/RemoteErrorMessage.mjs ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   RemoteErrorMessage: () => (/* binding */ RemoteErrorMessage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/i18n/translations.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _primitives_Alert_Alert_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../primitives/Alert/Alert.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Alert/Alert.mjs");





const RemoteErrorMessage = () => {
    const { error } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__["default"])((context) => [context.error]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, error ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Alert_Alert_mjs__WEBPACK_IMPORTED_MODULE_2__.Alert, { variation: "error", isDismissible: true }, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.translate)(error))) : null));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/SignInSignUpTabs.mjs":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/SignInSignUpTabs.mjs ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SignInSignUpTabs: () => (/* binding */ SignInSignUpTabs)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _primitives_Tabs_Tabs_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../primitives/Tabs/Tabs.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Tabs/Tabs.mjs");
/* harmony import */ var _primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../primitives/View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _SignIn_SignIn_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../SignIn/SignIn.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SignIn/SignIn.mjs");
/* harmony import */ var _SignUp_SignUp_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../SignUp/SignUp.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/SignUp/SignUp.mjs");
/* harmony import */ var _RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../RouteContainer/RouteContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/RouteContainer/RouteContainer.mjs");









const { getSignInTabText, getSignUpTabText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const SignInSignUpTabs = ({ className, hideSignUp, variation, }) => {
    const { route, toSignIn, toSignUp } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [
        context.route,
        context.toSignIn,
        context.toSignUp,
    ]);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_RouteContainer_RouteContainer_mjs__WEBPACK_IMPORTED_MODULE_3__.RouteContainer, { className: className, variation: variation }, hideSignUp ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_4__.View, { "data-amplify-router-content": "" }, route === 'signIn' && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SignIn_SignIn_mjs__WEBPACK_IMPORTED_MODULE_5__.SignIn, null))) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Tabs_Tabs_mjs__WEBPACK_IMPORTED_MODULE_6__.Tabs.Container, { value: route, isLazy: true, onValueChange: (newRoute) => {
            if (newRoute !== route) {
                newRoute === 'signIn' ? toSignIn() : toSignUp();
            }
        } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Tabs_Tabs_mjs__WEBPACK_IMPORTED_MODULE_6__.Tabs.List, { spacing: "equal", indicatorPosition: "top" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Tabs_Tabs_mjs__WEBPACK_IMPORTED_MODULE_6__.Tabs.Item, { value: "signIn" }, getSignInTabText()),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Tabs_Tabs_mjs__WEBPACK_IMPORTED_MODULE_6__.Tabs.Item, { value: "signUp" }, getSignUpTabText())),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Tabs_Tabs_mjs__WEBPACK_IMPORTED_MODULE_6__.Tabs.Panel, { value: "signIn", "data-amplify-router-content": "" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SignIn_SignIn_mjs__WEBPACK_IMPORTED_MODULE_5__.SignIn, null)),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Tabs_Tabs_mjs__WEBPACK_IMPORTED_MODULE_6__.Tabs.Panel, { value: "signUp", "data-amplify-router-content": "" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SignUp_SignUp_mjs__WEBPACK_IMPORTED_MODULE_7__.SignUp, null))))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/TwoButtonSubmitFooter.mjs":
/*!***************************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/shared/TwoButtonSubmitFooter.mjs ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TwoButtonSubmitFooter: () => (/* binding */ TwoButtonSubmitFooter)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/helpers/authenticator/textUtil.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../primitives/Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");






const { getSubmitText, getSubmittingText } = _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.authenticatorTextUtil;
const TwoButtonSubmitFooter = (props) => {
    const { cancelButtonSendType, cancelButtonText, submitButtonText } = props;
    const { isPending, resendCode, skipVerification, toSignIn } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_2__["default"])((context) => [context.isPending]);
    const onClick = () => {
        switch (cancelButtonSendType) {
            case 'SKIP':
                skipVerification();
                break;
            case 'RESEND':
                resendCode();
                break;
            case 'SIGN_IN':
                toSignIn();
                break;
            default:
                return;
        }
    };
    const defaultSubmitText = isPending ? (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        getSubmittingText(),
        "\u2026")) : (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, getSubmitText()));
    const submitText = submitButtonText ?? defaultSubmitText;
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__.Flex, { direction: "column" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_4__.Button, { variation: "primary", isDisabled: isPending, type: "submit" }, submitText),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__.Flex, { direction: "column", alignItems: "center" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_4__.Button, { onClick: onClick, type: "button", variation: "link", size: "small" }, cancelButtonText))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/utils.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/utils.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isSignInOrSignUpRoute: () => (/* binding */ isSignInOrSignUpRoute)
/* harmony export */ });
const isSignInOrSignUpRoute = (route) => route === 'signIn' || route === 'signUp';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/withAuthenticator.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/withAuthenticator.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   withAuthenticator: () => (/* binding */ withAuthenticator)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Authenticator_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Authenticator.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/Authenticator.mjs");



/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/connected-components/authenticator)
 */
function withAuthenticator(Component, options = {}) {
    const { variation = 'modal' } = options;
    return function WrappedWithAuthenticator(props) {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Authenticator_mjs__WEBPACK_IMPORTED_MODULE_1__.Authenticator, { variation: variation, ...options }, (withAuthenticatorProps) => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(Component, { ...props, ...withAuthenticatorProps }))));
    };
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/Style.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/Style.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Style: () => (/* binding */ Style)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const Style = ({ cssText, ...rest }) => {
    /*
      Only inject theme CSS variables if given a theme.
      The CSS file users import already has the default theme variables in it.
      This will allow users to use the provider and theme with CSS variables
      without having to worry about specificity issues because this stylesheet
      will likely come after a user's defined CSS.
  
      Q: Why are we using dangerouslySetInnerHTML?
      A: We need to directly inject the theme's CSS string into the <style> tag without typical HTML escaping.
          For example, JSX would escape characters meaningful in CSS such as ', ", < and >, thus breaking the CSS.
      Q: Why not use a sanitization library such as DOMPurify?
      A: For our use case, we specifically want to purify CSS text, *not* HTML.
          DOMPurify, as well as any other HTML sanitization library, would escape/encode meaningful CSS characters
          and break our CSS in the same way that JSX would.
  
      Q: Are there any security risks in this particular use case?
      A: Anything set inside of a <style> tag is always interpreted as CSS text, *not* HTML.
          Reference: “Restrictions on the content of raw text elements” https://html.spec.whatwg.org/dev/syntax.html#cdata-rcdata-restrictions
          And in our case, we are using dangerouslySetInnerHTML to set CSS text inside of a <style> tag.
              
          Thus, it really comes down to the question: Could a malicious user escape from the context of the <style> tag?
          For example, when inserting HTML into the DOM, could someone prematurely close the </style> tag and add a <script> tag?
            e.g., </style><script>alert('hello')</script>
          The answer depends on whether the code is rendered on the client or server side.
  
          Client side
          - To prevent XSS inside of the <style> tag, we need to make sure it's not closed prematurely.
          - This is prevented by React because React creates a style DOM node (e.g., React.createElement(‘style’, ...)), and directly sets innerHTML as a string.
          - Even if the string contains a closing </style> tag, it will still be interpreted as CSS text by the browser.
          - Therefore, there is not an XSS vulnerability on the client side.
  
          Server side
          - When React code is rendered on the server side (e.g., NextJS), the code is sent to the browser as HTML text.
          - Therefore, it *IS* possible to insert a closing </style> tag and escape the CSS context, which opens an XSS vulnerability.
  
      Q: How are we mitigating the potential attack vector?
      A: To fix this potential attack vector on the server side, we need to filter out any closing </style> tags,
          as this the only way to escape from the context of the browser interpreting the text as CSS.
          We also need to catch cases where there is any kind of whitespace character </style[HERE]>, such as tabs, carriage returns, etc:
          </style
          
          >
          Therefore, by only rendering CSS text which does not include a closing '</style>' tag,
          we ensure that the browser will correctly interpret all the text as CSS.
    */
    if (cssText === undefined || /<\/style/i.test(cssText)) {
        return null;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement("style", { ...rest, 
        // eslint-disable-next-line react/no-danger
        dangerouslySetInnerHTML: { __html: cssText } }));
};
Style.displayName = 'Style';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeContext.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeContext.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThemeContext: () => (/* binding */ ThemeContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/theme/createTheme/createTheme.mjs");



const ThemeContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext({
    theme: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.createTheme)(),
    colorMode: undefined,
});




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeProvider.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeProvider.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThemeProvider: () => (/* binding */ ThemeProvider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _radix_ui_react_direction__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @radix-ui/react-direction */ "./node_modules/@radix-ui/react-direction/dist/index.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/theme/createTheme/createTheme.mjs");
/* harmony import */ var _ThemeContext_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ThemeContext.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeContext.mjs");
/* harmony import */ var _ThemeStyle_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ThemeStyle.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeStyle.mjs");






/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/theming)
 */
function ThemeProvider({ children, colorMode, direction = 'ltr', nonce, theme, }) {
    const value = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({ theme: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.createTheme)(theme), colorMode }), [theme, colorMode]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ThemeContext_mjs__WEBPACK_IMPORTED_MODULE_2__.ThemeContext.Provider, { value: value },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_radix_ui_react_direction__WEBPACK_IMPORTED_MODULE_3__.DirectionProvider, { dir: direction },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("div", { "data-amplify-theme": value.theme.name, "data-amplify-color-mode": colorMode, dir: direction }, children),
            theme ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ThemeStyle_mjs__WEBPACK_IMPORTED_MODULE_4__.ThemeStyle, { theme: value.theme, nonce: nonce }) : null)));
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeStyle.mjs":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeStyle.mjs ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ThemeStyle: () => (/* binding */ ThemeStyle)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Style_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Style.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/Style.mjs");



const ThemeStyle = ({ theme, ...rest }) => {
    if (!theme)
        return null;
    const { name, cssText } = theme;
    return react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Style_mjs__WEBPACK_IMPORTED_MODULE_1__.Style, { ...rest, cssText: cssText, id: `amplify-theme-${name}` });
};
ThemeStyle.displayName = 'ThemeStyle';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/index.mjs":
/*!**************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/index.mjs ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccountSettings: () => (/* reexport safe */ _AccountSettings_AccountSettings_mjs__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   Authenticator: () => (/* reexport safe */ _Authenticator_Authenticator_mjs__WEBPACK_IMPORTED_MODULE_1__.Authenticator),
/* harmony export */   ThemeProvider: () => (/* reexport safe */ _ThemeProvider_ThemeProvider_mjs__WEBPACK_IMPORTED_MODULE_4__.ThemeProvider),
/* harmony export */   useAuthenticator: () => (/* reexport safe */ _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   withAuthenticator: () => (/* reexport safe */ _Authenticator_withAuthenticator_mjs__WEBPACK_IMPORTED_MODULE_2__.withAuthenticator)
/* harmony export */ });
/* harmony import */ var _AccountSettings_AccountSettings_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AccountSettings/AccountSettings.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/AccountSettings.mjs");
/* harmony import */ var _Authenticator_Authenticator_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Authenticator/Authenticator.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/Authenticator.mjs");
/* harmony import */ var _Authenticator_withAuthenticator_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Authenticator/withAuthenticator.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/withAuthenticator.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _ThemeProvider_ThemeProvider_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ThemeProvider/ThemeProvider.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeProvider.mjs");







/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/components/shared/ValidationErrors.mjs":
/*!********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/components/shared/ValidationErrors.mjs ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ValidationErrors: () => (/* binding */ ValidationErrors)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/i18n/translations.mjs");
/* harmony import */ var _primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../primitives/View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _primitives_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../primitives/Text/Text.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Text/Text.mjs");





const ValidationErrors = ({ errors, id, dataAttr, }) => {
    if (!(errors?.length > 0))
        return null;
    const dataAttrProp = dataAttr ? { [dataAttr]: true } : {};
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { ...dataAttrProp, id: id }, errors.map((error) => {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_primitives_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_2__.Text, { key: error, role: "alert", variation: "error" }, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.translate)(error)));
    })));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/helpers/constants.mjs":
/*!***************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/helpers/constants.mjs ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DESCRIPTION_SUFFIX: () => (/* binding */ DESCRIPTION_SUFFIX),
/* harmony export */   ERROR_SUFFIX: () => (/* binding */ ERROR_SUFFIX)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");


(typeof Symbol !== 'undefined' && (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_0__.isFunction)(Symbol.for)
    ? Symbol.for('amplify_default')
    : '@@amplify_default');
const ERROR_SUFFIX = 'error';
const DESCRIPTION_SUFFIX = 'description';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/helpers/utils.mjs":
/*!***********************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/helpers/utils.mjs ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getFormDataFromEvent: () => (/* binding */ getFormDataFromEvent)
/* harmony export */ });
const getFormDataFromEvent = (event) => {
    const formData = new FormData(event.target);
    return Object.fromEntries(formData);
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useAuth.mjs":
/*!***********************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useAuth.mjs ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useAuth: () => (/* binding */ useAuth)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/core */ "./node_modules/@aws-amplify/core/dist/esm/Hub/index.mjs");
/* harmony import */ var aws_amplify_auth__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! aws-amplify/auth */ "./node_modules/@aws-amplify/auth/dist/esm/providers/cognito/apis/getCurrentUser.mjs");




/**
 * Amplify Auth React hook
 * @internal
 */
const useAuth = () => {
    const [result, setResult] = react__WEBPACK_IMPORTED_MODULE_0__.useState({
        error: undefined,
        isLoading: true,
        user: undefined,
    });
    /**
     * Hub events like `tokenRefresh` will not give back the user object.
     * This util will be used to get current user after those events.
     */
    const fetchCurrentUser = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(async () => {
        setResult((prevResult) => ({ ...prevResult, isLoading: true }));
        try {
            const user = await (0,aws_amplify_auth__WEBPACK_IMPORTED_MODULE_1__.getCurrentUser)();
            setResult({ user, isLoading: false });
        }
        catch (e) {
            const error = e;
            setResult({ error, isLoading: false });
        }
    }, []);
    const handleAuth = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(({ payload }) => {
        switch (payload.event) {
            // success events
            case 'signedIn':
            case 'signUp':
            case 'autoSignIn': {
                setResult({ user: payload.data, isLoading: false });
                break;
            }
            case 'signedOut': {
                setResult({ user: undefined, isLoading: false });
                break;
            }
            // failure events
            case 'tokenRefresh_failure':
            case 'signIn_failure': {
                setResult({ error: payload.data, isLoading: false });
                break;
            }
            case 'autoSignIn_failure': {
                // autoSignIn just returns error message. Wrap it to an Error object
                setResult({ error: new Error(payload.message), isLoading: false });
                break;
            }
            // events that need another fetch
            case 'tokenRefresh': {
                fetchCurrentUser();
                break;
            }
        }
    }, [fetchCurrentUser]);
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        const unsubscribe = _aws_amplify_core__WEBPACK_IMPORTED_MODULE_2__.Hub.listen('auth', handleAuth, 'useAuth');
        fetchCurrentUser(); // on init, see if user is already logged in
        return unsubscribe;
    }, [handleAuth, fetchCurrentUser]);
    return {
        ...result,
        /** @deprecated Fetch is handled automatically, do not use this directly */
        fetch: fetchCurrentUser,
    };
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useBreakpointValue.mjs":
/*!**********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useBreakpointValue.mjs ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useBreakpointValue: () => (/* binding */ useBreakpointValue)
/* harmony export */ });
/* harmony import */ var _primitives_shared_responsive_utils_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../primitives/shared/responsive/utils.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/responsive/utils.mjs");
/* harmony import */ var _primitives_shared_responsive_useBreakpoint_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../primitives/shared/responsive/useBreakpoint.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/responsive/useBreakpoint.mjs");
/* harmony import */ var _useTheme_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./useTheme.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useTheme.mjs");
/* harmony import */ var _primitives_shared_getStyleValue_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../primitives/shared/getStyleValue.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/getStyleValue.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/theme/createTheme/utils.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");






/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/theming/responsive#usebreakpointvalue)
 */
const useBreakpointValue = (values, defaultBreakpoint = 'base', propKey) => {
    const { breakpoints: { values: breakpoints }, tokens, } = (0,_useTheme_mjs__WEBPACK_IMPORTED_MODULE_0__.useTheme)();
    const breakpoint = (0,_primitives_shared_responsive_useBreakpoint_mjs__WEBPACK_IMPORTED_MODULE_1__.useBreakpoint)({
        breakpoints,
        defaultBreakpoint,
    });
    const value = (0,_primitives_shared_responsive_utils_mjs__WEBPACK_IMPORTED_MODULE_2__.getValueAtCurrentBreakpoint)({
        breakpoint,
        breakpoints,
        values,
    });
    if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.isDesignToken)(value) || (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.isString)(value)) {
        return (0,_primitives_shared_getStyleValue_mjs__WEBPACK_IMPORTED_MODULE_5__.getStyleValue)({ value, propKey, tokens });
    }
    else {
        return value;
    }
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useComposeRefsCallback.mjs":
/*!**************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useComposeRefsCallback.mjs ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useComposeRefsCallback: () => (/* binding */ useComposeRefsCallback)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");



/**
 *  Creates ref callback to compose together external and internal refs
 */
function useComposeRefsCallback({ externalRef, internalRef, }) {
    return react__WEBPACK_IMPORTED_MODULE_0__.useCallback((node) => {
        // Handle callback ref
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.isFunction)(externalRef)) {
            externalRef(node);
        }
        else if (externalRef) {
            externalRef.current = node;
        }
        internalRef.current = node;
    }, [externalRef, internalRef]);
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useDeprecationWarning.mjs":
/*!*************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useDeprecationWarning.mjs ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useDeprecationWarning: () => (/* binding */ useDeprecationWarning)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useDeprecationWarning.mjs");
/* provided dependency */ var process = __webpack_require__(/*! process/browser */ "./node_modules/process/browser.js");


/**
 * Logs a deprecation warning `message` to the console.
 */
const useDeprecationWarning = ({ message, shouldWarn: _shouldWarn, }) => {
    const shouldWarn = _shouldWarn &&
        // show message on builds without Node `process` polyfill
        // or with process.env.NODE_ENV not production
        (typeof process === 'undefined' ||
            (process && "development" !== 'production'));
    (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_0__["default"])({ message, shouldWarn });
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useTheme.mjs":
/*!************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useTheme.mjs ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getThemeFromContext: () => (/* binding */ getThemeFromContext),
/* harmony export */   useColorMode: () => (/* binding */ useColorMode),
/* harmony export */   useTheme: () => (/* binding */ useTheme)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/theme/createTheme/createTheme.mjs");
/* harmony import */ var _components_ThemeProvider_ThemeContext_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../components/ThemeProvider/ThemeContext.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeContext.mjs");




/**
 * Get current Theme object value from Amplify context.
 * Returns a default theme if context is not available
 */
const getThemeFromContext = (context) => {
    if (typeof context === 'undefined' || typeof context.theme === 'undefined') {
        return (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.createTheme)();
    }
    return context.theme;
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/theming)
 */
const useTheme = () => {
    const context = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_components_ThemeProvider_ThemeContext_mjs__WEBPACK_IMPORTED_MODULE_2__.ThemeContext);
    return getThemeFromContext(context);
};
/**
 * Internal use only
 */
const useColorMode = () => {
    const context = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_components_ThemeProvider_ThemeContext_mjs__WEBPACK_IMPORTED_MODULE_2__.ThemeContext);
    return context.colorMode;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/index.mjs":
/*!***************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/index.mjs ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Accordion: () => (/* reexport safe */ _primitives_Accordion_Accordion_mjs__WEBPACK_IMPORTED_MODULE_27__.Accordion),
/* harmony export */   AccountSettings: () => (/* reexport safe */ _components_AccountSettings_AccountSettings_mjs__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   Alert: () => (/* reexport safe */ _primitives_Alert_Alert_mjs__WEBPACK_IMPORTED_MODULE_14__.Alert),
/* harmony export */   Authenticator: () => (/* reexport safe */ _components_Authenticator_Authenticator_mjs__WEBPACK_IMPORTED_MODULE_9__.Authenticator),
/* harmony export */   Autocomplete: () => (/* reexport safe */ _primitives_Autocomplete_Autocomplete_mjs__WEBPACK_IMPORTED_MODULE_15__.Autocomplete),
/* harmony export */   Avatar: () => (/* reexport safe */ _primitives_Avatar_Avatar_mjs__WEBPACK_IMPORTED_MODULE_16__.Avatar),
/* harmony export */   Badge: () => (/* reexport safe */ _primitives_Badge_Badge_mjs__WEBPACK_IMPORTED_MODULE_17__.Badge),
/* harmony export */   Breadcrumbs: () => (/* reexport safe */ _primitives_Breadcrumbs_Breadcrumbs_mjs__WEBPACK_IMPORTED_MODULE_18__.Breadcrumbs),
/* harmony export */   Button: () => (/* reexport safe */ _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_19__.Button),
/* harmony export */   ButtonGroup: () => (/* reexport safe */ _primitives_ButtonGroup_ButtonGroup_mjs__WEBPACK_IMPORTED_MODULE_20__.ButtonGroup),
/* harmony export */   Card: () => (/* reexport safe */ _primitives_Card_Card_mjs__WEBPACK_IMPORTED_MODULE_21__.Card),
/* harmony export */   Checkbox: () => (/* reexport safe */ _primitives_Checkbox_Checkbox_mjs__WEBPACK_IMPORTED_MODULE_22__.Checkbox),
/* harmony export */   CheckboxField: () => (/* reexport safe */ _primitives_CheckboxField_CheckboxField_mjs__WEBPACK_IMPORTED_MODULE_23__.CheckboxField),
/* harmony export */   Collection: () => (/* reexport safe */ _primitives_Collection_Collection_mjs__WEBPACK_IMPORTED_MODULE_24__.Collection),
/* harmony export */   ComponentPropsToStylePropsMap: () => (/* reexport safe */ _primitives_types_style_mjs__WEBPACK_IMPORTED_MODULE_73__.ComponentPropsToStylePropsMap),
/* harmony export */   ComponentPropsToStylePropsMapKeys: () => (/* reexport safe */ _primitives_types_style_mjs__WEBPACK_IMPORTED_MODULE_73__.ComponentPropsToStylePropsMapKeys),
/* harmony export */   Divider: () => (/* reexport safe */ _primitives_Divider_Divider_mjs__WEBPACK_IMPORTED_MODULE_25__.Divider),
/* harmony export */   DropZone: () => (/* reexport safe */ _primitives_DropZone_DropZone_mjs__WEBPACK_IMPORTED_MODULE_26__.DropZone),
/* harmony export */   FieldGroupIcon: () => (/* reexport safe */ _primitives_FieldGroupIcon_FieldGroupIcon_mjs__WEBPACK_IMPORTED_MODULE_28__.FieldGroupIcon),
/* harmony export */   FieldGroupIconButton: () => (/* reexport safe */ _primitives_FieldGroupIcon_FieldGroupIconButton_mjs__WEBPACK_IMPORTED_MODULE_29__.FieldGroupIconButton),
/* harmony export */   Fieldset: () => (/* reexport safe */ _primitives_Fieldset_Fieldset_mjs__WEBPACK_IMPORTED_MODULE_30__.Fieldset),
/* harmony export */   Flex: () => (/* reexport safe */ _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_31__.Flex),
/* harmony export */   Grid: () => (/* reexport safe */ _primitives_Grid_Grid_mjs__WEBPACK_IMPORTED_MODULE_32__.Grid),
/* harmony export */   Heading: () => (/* reexport safe */ _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_33__.Heading),
/* harmony export */   HighlightMatch: () => (/* reexport safe */ _primitives_HighlightMatch_HighlightMatch_mjs__WEBPACK_IMPORTED_MODULE_34__.HighlightMatch),
/* harmony export */   Icon: () => (/* reexport safe */ _primitives_Icon_Icon_mjs__WEBPACK_IMPORTED_MODULE_35__.Icon),
/* harmony export */   IconsProvider: () => (/* reexport safe */ _primitives_Icon_context_IconsProvider_mjs__WEBPACK_IMPORTED_MODULE_13__.IconsProvider),
/* harmony export */   Image: () => (/* reexport safe */ _primitives_Image_Image_mjs__WEBPACK_IMPORTED_MODULE_36__.Image),
/* harmony export */   Input: () => (/* reexport safe */ _primitives_Input_Input_mjs__WEBPACK_IMPORTED_MODULE_37__.Input),
/* harmony export */   Label: () => (/* reexport safe */ _primitives_Label_Label_mjs__WEBPACK_IMPORTED_MODULE_38__.Label),
/* harmony export */   Link: () => (/* reexport safe */ _primitives_Link_Link_mjs__WEBPACK_IMPORTED_MODULE_39__.Link),
/* harmony export */   Loader: () => (/* reexport safe */ _primitives_Loader_Loader_mjs__WEBPACK_IMPORTED_MODULE_40__.Loader),
/* harmony export */   Menu: () => (/* reexport safe */ _primitives_Menu_Menu_mjs__WEBPACK_IMPORTED_MODULE_41__.Menu),
/* harmony export */   MenuButton: () => (/* reexport safe */ _primitives_Menu_MenuButton_mjs__WEBPACK_IMPORTED_MODULE_42__.MenuButton),
/* harmony export */   MenuItem: () => (/* reexport safe */ _primitives_Menu_MenuItem_mjs__WEBPACK_IMPORTED_MODULE_43__.MenuItem),
/* harmony export */   Message: () => (/* reexport safe */ _primitives_Message_Message_mjs__WEBPACK_IMPORTED_MODULE_44__.Message),
/* harmony export */   Pagination: () => (/* reexport safe */ _primitives_Pagination_Pagination_mjs__WEBPACK_IMPORTED_MODULE_45__.Pagination),
/* harmony export */   PasswordField: () => (/* reexport safe */ _primitives_PasswordField_PasswordField_mjs__WEBPACK_IMPORTED_MODULE_46__.PasswordField),
/* harmony export */   PhoneNumberField: () => (/* reexport safe */ _primitives_PhoneNumberField_PhoneNumberField_mjs__WEBPACK_IMPORTED_MODULE_47__.PhoneNumberField),
/* harmony export */   Placeholder: () => (/* reexport safe */ _primitives_Placeholder_Placeholder_mjs__WEBPACK_IMPORTED_MODULE_48__.Placeholder),
/* harmony export */   Radio: () => (/* reexport safe */ _primitives_Radio_Radio_mjs__WEBPACK_IMPORTED_MODULE_49__.Radio),
/* harmony export */   RadioGroupField: () => (/* reexport safe */ _primitives_RadioGroupField_RadioGroupField_mjs__WEBPACK_IMPORTED_MODULE_50__.RadioGroupField),
/* harmony export */   Rating: () => (/* reexport safe */ _primitives_Rating_Rating_mjs__WEBPACK_IMPORTED_MODULE_51__.Rating),
/* harmony export */   ScrollView: () => (/* reexport safe */ _primitives_ScrollView_ScrollView_mjs__WEBPACK_IMPORTED_MODULE_52__.ScrollView),
/* harmony export */   SearchField: () => (/* reexport safe */ _primitives_SearchField_SearchField_mjs__WEBPACK_IMPORTED_MODULE_53__.SearchField),
/* harmony export */   SelectField: () => (/* reexport safe */ _primitives_SelectField_SelectField_mjs__WEBPACK_IMPORTED_MODULE_54__.SelectField),
/* harmony export */   SliderField: () => (/* reexport safe */ _primitives_SliderField_SliderField_mjs__WEBPACK_IMPORTED_MODULE_55__.SliderField),
/* harmony export */   StepperField: () => (/* reexport safe */ _primitives_StepperField_StepperField_mjs__WEBPACK_IMPORTED_MODULE_56__.StepperField),
/* harmony export */   SwitchField: () => (/* reexport safe */ _primitives_SwitchField_SwitchField_mjs__WEBPACK_IMPORTED_MODULE_57__.SwitchField),
/* harmony export */   Table: () => (/* reexport safe */ _primitives_Table_Table_mjs__WEBPACK_IMPORTED_MODULE_66__.Table),
/* harmony export */   TableBody: () => (/* reexport safe */ _primitives_Table_TableBody_mjs__WEBPACK_IMPORTED_MODULE_67__.TableBody),
/* harmony export */   TableCell: () => (/* reexport safe */ _primitives_Table_TableCell_mjs__WEBPACK_IMPORTED_MODULE_68__.TableCell),
/* harmony export */   TableFoot: () => (/* reexport safe */ _primitives_Table_TableFoot_mjs__WEBPACK_IMPORTED_MODULE_69__.TableFoot),
/* harmony export */   TableHead: () => (/* reexport safe */ _primitives_Table_TableHead_mjs__WEBPACK_IMPORTED_MODULE_70__.TableHead),
/* harmony export */   TableRow: () => (/* reexport safe */ _primitives_Table_TableRow_mjs__WEBPACK_IMPORTED_MODULE_71__.TableRow),
/* harmony export */   Tabs: () => (/* reexport safe */ _primitives_Tabs_Tabs_mjs__WEBPACK_IMPORTED_MODULE_58__.Tabs),
/* harmony export */   Text: () => (/* reexport safe */ _primitives_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_59__.Text),
/* harmony export */   TextAreaField: () => (/* reexport safe */ _primitives_TextAreaField_TextAreaField_mjs__WEBPACK_IMPORTED_MODULE_60__.TextAreaField),
/* harmony export */   TextField: () => (/* reexport safe */ _primitives_TextField_TextField_mjs__WEBPACK_IMPORTED_MODULE_61__.TextField),
/* harmony export */   ThemeProvider: () => (/* reexport safe */ _components_ThemeProvider_ThemeProvider_mjs__WEBPACK_IMPORTED_MODULE_12__.ThemeProvider),
/* harmony export */   ToggleButton: () => (/* reexport safe */ _primitives_ToggleButton_ToggleButton_mjs__WEBPACK_IMPORTED_MODULE_62__.ToggleButton),
/* harmony export */   ToggleButtonGroup: () => (/* reexport safe */ _primitives_ToggleButtonGroup_ToggleButtonGroup_mjs__WEBPACK_IMPORTED_MODULE_63__.ToggleButtonGroup),
/* harmony export */   View: () => (/* reexport safe */ _primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_64__.View),
/* harmony export */   VisuallyHidden: () => (/* reexport safe */ _primitives_VisuallyHidden_VisuallyHidden_mjs__WEBPACK_IMPORTED_MODULE_65__.VisuallyHidden),
/* harmony export */   components: () => (/* reexport module object */ _components_index_mjs__WEBPACK_IMPORTED_MODULE_0__),
/* harmony export */   createTheme: () => (/* reexport safe */ _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.createTheme),
/* harmony export */   defaultDarkModeOverride: () => (/* reexport safe */ _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.defaultDarkModeOverride),
/* harmony export */   defaultTheme: () => (/* reexport safe */ _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__.defaultTheme),
/* harmony export */   primitives: () => (/* reexport module object */ _primitives_index_mjs__WEBPACK_IMPORTED_MODULE_3__),
/* harmony export */   translations: () => (/* reexport safe */ _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.translations),
/* harmony export */   useAuthenticator: () => (/* reexport safe */ _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   useBreakpointValue: () => (/* reexport safe */ _hooks_useBreakpointValue_mjs__WEBPACK_IMPORTED_MODULE_2__.useBreakpointValue),
/* harmony export */   usePagination: () => (/* reexport safe */ _primitives_Pagination_usePagination_mjs__WEBPACK_IMPORTED_MODULE_72__.usePagination),
/* harmony export */   useTheme: () => (/* reexport safe */ _hooks_useTheme_mjs__WEBPACK_IMPORTED_MODULE_1__.useTheme),
/* harmony export */   withAuthenticator: () => (/* reexport safe */ _components_Authenticator_withAuthenticator_mjs__WEBPACK_IMPORTED_MODULE_10__.withAuthenticator)
/* harmony export */ });
/* harmony import */ var _components_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/index.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/index.mjs");
/* harmony import */ var _hooks_useTheme_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hooks/useTheme.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useTheme.mjs");
/* harmony import */ var _hooks_useBreakpointValue_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hooks/useBreakpointValue.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/hooks/useBreakpointValue.mjs");
/* harmony import */ var _primitives_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./primitives/index.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/index.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/theme/createTheme/createTheme.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/theme/defaultDarkModeOverride.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/theme/defaultTheme.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/i18n/translations.mjs");
/* harmony import */ var _components_AccountSettings_AccountSettings_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./components/AccountSettings/AccountSettings.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/AccountSettings/AccountSettings.mjs");
/* harmony import */ var _components_Authenticator_Authenticator_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./components/Authenticator/Authenticator.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/Authenticator.mjs");
/* harmony import */ var _components_Authenticator_withAuthenticator_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./components/Authenticator/withAuthenticator.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/Authenticator/withAuthenticator.mjs");
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/Authenticator/hooks/useAuthenticator/useAuthenticator.mjs");
/* harmony import */ var _components_ThemeProvider_ThemeProvider_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./components/ThemeProvider/ThemeProvider.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/components/ThemeProvider/ThemeProvider.mjs");
/* harmony import */ var _primitives_Icon_context_IconsProvider_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./primitives/Icon/context/IconsProvider.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/IconsProvider.mjs");
/* harmony import */ var _primitives_Alert_Alert_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./primitives/Alert/Alert.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Alert/Alert.mjs");
/* harmony import */ var _primitives_Autocomplete_Autocomplete_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./primitives/Autocomplete/Autocomplete.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/Autocomplete.mjs");
/* harmony import */ var _primitives_Avatar_Avatar_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./primitives/Avatar/Avatar.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Avatar/Avatar.mjs");
/* harmony import */ var _primitives_Badge_Badge_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./primitives/Badge/Badge.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Badge/Badge.mjs");
/* harmony import */ var _primitives_Breadcrumbs_Breadcrumbs_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./primitives/Breadcrumbs/Breadcrumbs.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/Breadcrumbs.mjs");
/* harmony import */ var _primitives_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./primitives/Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _primitives_ButtonGroup_ButtonGroup_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./primitives/ButtonGroup/ButtonGroup.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/ButtonGroup/ButtonGroup.mjs");
/* harmony import */ var _primitives_Card_Card_mjs__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./primitives/Card/Card.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Card/Card.mjs");
/* harmony import */ var _primitives_Checkbox_Checkbox_mjs__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./primitives/Checkbox/Checkbox.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Checkbox/Checkbox.mjs");
/* harmony import */ var _primitives_CheckboxField_CheckboxField_mjs__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./primitives/CheckboxField/CheckboxField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/CheckboxField/CheckboxField.mjs");
/* harmony import */ var _primitives_Collection_Collection_mjs__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./primitives/Collection/Collection.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Collection/Collection.mjs");
/* harmony import */ var _primitives_Divider_Divider_mjs__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./primitives/Divider/Divider.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Divider/Divider.mjs");
/* harmony import */ var _primitives_DropZone_DropZone_mjs__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./primitives/DropZone/DropZone.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZone.mjs");
/* harmony import */ var _primitives_Accordion_Accordion_mjs__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./primitives/Accordion/Accordion.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/Accordion.mjs");
/* harmony import */ var _primitives_FieldGroupIcon_FieldGroupIcon_mjs__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./primitives/FieldGroupIcon/FieldGroupIcon.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/FieldGroupIcon/FieldGroupIcon.mjs");
/* harmony import */ var _primitives_FieldGroupIcon_FieldGroupIconButton_mjs__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./primitives/FieldGroupIcon/FieldGroupIconButton.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/FieldGroupIcon/FieldGroupIconButton.mjs");
/* harmony import */ var _primitives_Fieldset_Fieldset_mjs__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./primitives/Fieldset/Fieldset.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Fieldset/Fieldset.mjs");
/* harmony import */ var _primitives_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./primitives/Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _primitives_Grid_Grid_mjs__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./primitives/Grid/Grid.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Grid/Grid.mjs");
/* harmony import */ var _primitives_Heading_Heading_mjs__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./primitives/Heading/Heading.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs");
/* harmony import */ var _primitives_HighlightMatch_HighlightMatch_mjs__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./primitives/HighlightMatch/HighlightMatch.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/HighlightMatch/HighlightMatch.mjs");
/* harmony import */ var _primitives_Icon_Icon_mjs__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./primitives/Icon/Icon.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/Icon.mjs");
/* harmony import */ var _primitives_Image_Image_mjs__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./primitives/Image/Image.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Image/Image.mjs");
/* harmony import */ var _primitives_Input_Input_mjs__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./primitives/Input/Input.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Input/Input.mjs");
/* harmony import */ var _primitives_Label_Label_mjs__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./primitives/Label/Label.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Label/Label.mjs");
/* harmony import */ var _primitives_Link_Link_mjs__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./primitives/Link/Link.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Link/Link.mjs");
/* harmony import */ var _primitives_Loader_Loader_mjs__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./primitives/Loader/Loader.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Loader/Loader.mjs");
/* harmony import */ var _primitives_Menu_Menu_mjs__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./primitives/Menu/Menu.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Menu/Menu.mjs");
/* harmony import */ var _primitives_Menu_MenuButton_mjs__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./primitives/Menu/MenuButton.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Menu/MenuButton.mjs");
/* harmony import */ var _primitives_Menu_MenuItem_mjs__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./primitives/Menu/MenuItem.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Menu/MenuItem.mjs");
/* harmony import */ var _primitives_Message_Message_mjs__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./primitives/Message/Message.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Message/Message.mjs");
/* harmony import */ var _primitives_Pagination_Pagination_mjs__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./primitives/Pagination/Pagination.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Pagination/Pagination.mjs");
/* harmony import */ var _primitives_PasswordField_PasswordField_mjs__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./primitives/PasswordField/PasswordField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/PasswordField/PasswordField.mjs");
/* harmony import */ var _primitives_PhoneNumberField_PhoneNumberField_mjs__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./primitives/PhoneNumberField/PhoneNumberField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/PhoneNumberField/PhoneNumberField.mjs");
/* harmony import */ var _primitives_Placeholder_Placeholder_mjs__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./primitives/Placeholder/Placeholder.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Placeholder/Placeholder.mjs");
/* harmony import */ var _primitives_Radio_Radio_mjs__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./primitives/Radio/Radio.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Radio/Radio.mjs");
/* harmony import */ var _primitives_RadioGroupField_RadioGroupField_mjs__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./primitives/RadioGroupField/RadioGroupField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/RadioGroupField/RadioGroupField.mjs");
/* harmony import */ var _primitives_Rating_Rating_mjs__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./primitives/Rating/Rating.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Rating/Rating.mjs");
/* harmony import */ var _primitives_ScrollView_ScrollView_mjs__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./primitives/ScrollView/ScrollView.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/ScrollView/ScrollView.mjs");
/* harmony import */ var _primitives_SearchField_SearchField_mjs__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./primitives/SearchField/SearchField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/SearchField/SearchField.mjs");
/* harmony import */ var _primitives_SelectField_SelectField_mjs__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./primitives/SelectField/SelectField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/SelectField/SelectField.mjs");
/* harmony import */ var _primitives_SliderField_SliderField_mjs__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./primitives/SliderField/SliderField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/SliderField/SliderField.mjs");
/* harmony import */ var _primitives_StepperField_StepperField_mjs__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./primitives/StepperField/StepperField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/StepperField/StepperField.mjs");
/* harmony import */ var _primitives_SwitchField_SwitchField_mjs__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./primitives/SwitchField/SwitchField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/SwitchField/SwitchField.mjs");
/* harmony import */ var _primitives_Tabs_Tabs_mjs__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./primitives/Tabs/Tabs.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Tabs/Tabs.mjs");
/* harmony import */ var _primitives_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ./primitives/Text/Text.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Text/Text.mjs");
/* harmony import */ var _primitives_TextAreaField_TextAreaField_mjs__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ./primitives/TextAreaField/TextAreaField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/TextAreaField/TextAreaField.mjs");
/* harmony import */ var _primitives_TextField_TextField_mjs__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ./primitives/TextField/TextField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/TextField/TextField.mjs");
/* harmony import */ var _primitives_ToggleButton_ToggleButton_mjs__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ./primitives/ToggleButton/ToggleButton.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/ToggleButton/ToggleButton.mjs");
/* harmony import */ var _primitives_ToggleButtonGroup_ToggleButtonGroup_mjs__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ./primitives/ToggleButtonGroup/ToggleButtonGroup.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/ToggleButtonGroup/ToggleButtonGroup.mjs");
/* harmony import */ var _primitives_View_View_mjs__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ./primitives/View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _primitives_VisuallyHidden_VisuallyHidden_mjs__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ./primitives/VisuallyHidden/VisuallyHidden.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/VisuallyHidden/VisuallyHidden.mjs");
/* harmony import */ var _primitives_Table_Table_mjs__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ./primitives/Table/Table.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Table/Table.mjs");
/* harmony import */ var _primitives_Table_TableBody_mjs__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ./primitives/Table/TableBody.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Table/TableBody.mjs");
/* harmony import */ var _primitives_Table_TableCell_mjs__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ./primitives/Table/TableCell.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Table/TableCell.mjs");
/* harmony import */ var _primitives_Table_TableFoot_mjs__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ./primitives/Table/TableFoot.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Table/TableFoot.mjs");
/* harmony import */ var _primitives_Table_TableHead_mjs__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ./primitives/Table/TableHead.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Table/TableHead.mjs");
/* harmony import */ var _primitives_Table_TableRow_mjs__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ./primitives/Table/TableRow.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Table/TableRow.mjs");
/* harmony import */ var _primitives_Pagination_usePagination_mjs__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ./primitives/Pagination/usePagination.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Pagination/usePagination.mjs");
/* harmony import */ var _primitives_types_style_mjs__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ./primitives/types/style.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/types/style.mjs");











































































/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/Accordion.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/Accordion.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Accordion: () => (/* binding */ Accordion)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _AccordionItem_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AccordionItem.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionItem.mjs");
/* harmony import */ var _AccordionContent_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./AccordionContent.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContent.mjs");
/* harmony import */ var _AccordionTrigger_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AccordionTrigger.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionTrigger.mjs");
/* harmony import */ var _AccordionIcon_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./AccordionIcon.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionIcon.mjs");
/* harmony import */ var _AccordionContainer_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AccordionContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContainer.mjs");








const AccordionPrimitive = ({ items, ...rest }, ref) => {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AccordionContainer_mjs__WEBPACK_IMPORTED_MODULE_1__.AccordionContainer, { ref: ref, ...rest }, items?.map(({ content, trigger, value }) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AccordionItem_mjs__WEBPACK_IMPORTED_MODULE_2__.AccordionItem, { key: value, value: value },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AccordionTrigger_mjs__WEBPACK_IMPORTED_MODULE_3__.AccordionTrigger, null,
            trigger,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AccordionIcon_mjs__WEBPACK_IMPORTED_MODULE_4__.AccordionIcon, null)),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AccordionContent_mjs__WEBPACK_IMPORTED_MODULE_5__.AccordionContent, null, content))))));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/accordion)
 */
const Accordion = Object.assign((0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__.primitiveWithForwardRef)(AccordionPrimitive), {
    Container: _AccordionContainer_mjs__WEBPACK_IMPORTED_MODULE_1__.AccordionContainer,
    Content: _AccordionContent_mjs__WEBPACK_IMPORTED_MODULE_5__.AccordionContent,
    Icon: _AccordionIcon_mjs__WEBPACK_IMPORTED_MODULE_4__.AccordionIcon,
    Item: _AccordionItem_mjs__WEBPACK_IMPORTED_MODULE_2__.AccordionItem,
    Trigger: _AccordionTrigger_mjs__WEBPACK_IMPORTED_MODULE_3__.AccordionTrigger,
});
Accordion.displayName = 'Accordion';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContainer.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContainer.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccordionContainer: () => (/* binding */ AccordionContainer)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _AccordionContext_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AccordionContext.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContext.mjs");






const AccordionContainerPrimitive = ({ children, className, defaultValue, allowMultiple, preventCollapse, onValueChange, testId, value: controlledValue, ...rest }, ref) => {
    const isControlled = controlledValue !== undefined;
    const [localValue, setLocalValue] = react__WEBPACK_IMPORTED_MODULE_0__.useState(() => isControlled ? controlledValue : defaultValue ?? []);
    const value = isControlled ? controlledValue : localValue;
    const setValue = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((_value) => {
        let newValue;
        // if the value has the incoming value we try to close it by removing it from the array
        if (value.includes(_value)) {
            // only remove it from the array if preventCollapse is false/undefined OR
            // the number of open accordions is more than 1 (so it won't fully collapse anyways)
            newValue =
                !preventCollapse || value.length > 1
                    ? value.filter((v) => v !== _value)
                    : value;
        }
        else {
            // open the item by adding it to the array if allowMultiple is true
            // or make it the whole array
            newValue = allowMultiple ? [...value, _value] : [_value];
        }
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.isFunction)(onValueChange)) {
            onValueChange(newValue);
        }
        if (!isControlled) {
            setLocalValue(newValue);
        }
    }, [onValueChange, value, isControlled, allowMultiple, preventCollapse]);
    const contextValue = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
        return {
            value,
            setValue,
        };
    }, [value, setValue]);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AccordionContext_mjs__WEBPACK_IMPORTED_MODULE_2__.AccordionContext.Provider, { value: contextValue },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { ...rest, className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.ComponentClassName.Accordion, className), "data-testid": testId, ref: ref }, children)));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/accordion)
 */
const AccordionContainer = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__.primitiveWithForwardRef)(AccordionContainerPrimitive);
AccordionContainer.displayName = 'Accordion.Container';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContent.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContent.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccordionContent: () => (/* binding */ AccordionContent)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");





const AccordionContentPrimitive = ({ className, children, ...rest }, ref) => {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { ...rest, className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.AccordionItemContent, className), ref: ref }, children));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/accordion)
 */
const AccordionContent = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__.primitiveWithForwardRef)(AccordionContentPrimitive);
AccordionContent.displayName = 'Accordion.Content';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContext.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContext.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccordionContext: () => (/* binding */ AccordionContext),
/* harmony export */   AccordionItemContext: () => (/* binding */ AccordionItemContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const AccordionContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext(undefined);
const AccordionItemContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext(undefined);




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionIcon.mjs":
/*!********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionIcon.mjs ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccordionIcon: () => (/* binding */ AccordionIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon/context/useIcons.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/useIcons.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _Icon_icons_IconExpandMore_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Icon/icons/IconExpandMore.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconExpandMore.mjs");









const AccordionIconPrimitive = ({ className, as = 'span', ...rest }, ref) => {
    const icons = (0,_Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_1__.useIcons)('accordion');
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_2__.View, { ...rest, ref: ref, as: as, className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.ComponentClassName.AccordionItemIcon, className), "aria-hidden": "true" }, icons?.more ?? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icon_icons_IconExpandMore_mjs__WEBPACK_IMPORTED_MODULE_5__.IconExpandMore, null)));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/accordion)
 */
const AccordionIcon = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__.primitiveWithForwardRef)(AccordionIconPrimitive);
AccordionIcon.displayName = 'Accordion.Icon';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionItem.mjs":
/*!********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionItem.mjs ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccordionItem: () => (/* binding */ AccordionItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _AccordionContext_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AccordionContext.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContext.mjs");






const AccordionItemPrimitive = ({ children, className, value, as = 'details', ...rest }, ref) => {
    const context = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_AccordionContext_mjs__WEBPACK_IMPORTED_MODULE_1__.AccordionContext);
    const open = value ? context?.value?.includes(value) : undefined;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AccordionContext_mjs__WEBPACK_IMPORTED_MODULE_1__.AccordionItemContext.Provider, { value: value },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_2__.View, { ...rest, open: open, ref: ref, as: as, className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.ComponentClassName.AccordionItem, className) }, children)));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/accordion)
 */
const AccordionItem = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__.primitiveWithForwardRef)(AccordionItemPrimitive);
AccordionItem.displayName = 'AccordionItem';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionTrigger.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionTrigger.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AccordionTrigger: () => (/* binding */ AccordionTrigger)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _AccordionContext_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AccordionContext.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Accordion/AccordionContext.mjs");






const AccordionTriggerPrimitive = ({ children, className, ...rest }, ref) => {
    const context = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_AccordionContext_mjs__WEBPACK_IMPORTED_MODULE_1__.AccordionContext);
    const value = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_AccordionContext_mjs__WEBPACK_IMPORTED_MODULE_1__.AccordionItemContext);
    const handleOnClick = (e) => {
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.isFunction)(rest.onClick)) {
            rest.onClick(e);
        }
        if (context?.setValue && value) {
            e.preventDefault();
            context.setValue(value);
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { ...rest, ref: ref, as: "summary", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.ComponentClassName.AccordionItemTrigger, className), onClick: handleOnClick }, children));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/accordion)
 */
const AccordionTrigger = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__.primitiveWithForwardRef)(AccordionTriggerPrimitive);
AccordionTrigger.displayName = 'Accordion.Trigger';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Alert/Alert.mjs":
/*!********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Alert/Alert.mjs ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Alert: () => (/* binding */ Alert)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../shared/constants.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/constants.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _Button_Button_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _AlertIcon_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./AlertIcon.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Alert/AlertIcon.mjs");
/* harmony import */ var _Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Icon/context/useIcons.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/useIcons.mjs");
/* harmony import */ var _Icon_icons_IconClose_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Icon/icons/IconClose.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconClose.mjs");













const AlertPrimitive = ({ buttonRef, children, className, dismissButtonLabel = _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.ComponentText.Alert.dismissButtonLabel, hasIcon = true, heading, isDismissible = false, onDismiss, variation, ...rest }, ref) => {
    const [dismissed, setDismissed] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const icons = (0,_Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_2__.useIcons)('alert');
    const dismissAlert = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
        setDismissed(!dismissed);
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.isFunction)(onDismiss)) {
            onDismiss();
        }
    }, [setDismissed, onDismiss, dismissed]);
    return !dismissed ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_4__.Flex, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__.ComponentClassName.Alert, className, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__.ComponentClassName.Alert, variation)), ref: ref, role: "alert", ...rest },
        hasIcon && react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AlertIcon_mjs__WEBPACK_IMPORTED_MODULE_7__.AlertIcon, { variation: variation, ariaHidden: true }),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_8__.View, { flex: "1" },
            heading && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_8__.View, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__.ComponentClassName.AlertHeading }, heading)),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_8__.View, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__.ComponentClassName.AlertBody }, children)),
        isDismissible && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Button_Button_mjs__WEBPACK_IMPORTED_MODULE_9__.Button, { ariaLabel: dismissButtonLabel, variation: "link", className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__.ComponentClassName.AlertDismiss, onClick: dismissAlert, ref: buttonRef }, icons?.close ?? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icon_icons_IconClose_mjs__WEBPACK_IMPORTED_MODULE_10__.IconClose, { "aria-hidden": "true" }))))) : null;
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/alert)
 */
const Alert = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_11__.primitiveWithForwardRef)(AlertPrimitive);
Alert.displayName = 'Alert';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Alert/AlertIcon.mjs":
/*!************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Alert/AlertIcon.mjs ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AlertIcon: () => (/* binding */ AlertIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon/context/useIcons.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/useIcons.mjs");
/* harmony import */ var _Icon_icons_IconCheckCircle_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Icon/icons/IconCheckCircle.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconCheckCircle.mjs");
/* harmony import */ var _Icon_icons_IconError_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Icon/icons/IconError.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconError.mjs");
/* harmony import */ var _Icon_icons_IconInfo_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Icon/icons/IconInfo.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconInfo.mjs");
/* harmony import */ var _Icon_icons_IconWarning_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Icon/icons/IconWarning.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconWarning.mjs");











/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const AlertIcon = ({ variation, ariaHidden, ariaLabel, role, }) => {
    const icons = (0,_Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_1__.useIcons)('alert');
    let icon;
    switch (variation) {
        case 'info':
            icon = icons?.info ?? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icon_icons_IconInfo_mjs__WEBPACK_IMPORTED_MODULE_2__.IconInfo, { "aria-hidden": ariaHidden, "aria-label": ariaLabel, role: role }));
            break;
        case 'error':
            icon = icons?.error ?? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icon_icons_IconError_mjs__WEBPACK_IMPORTED_MODULE_3__.IconError, { "aria-hidden": ariaHidden, "aria-label": ariaLabel, role: role }));
            break;
        case 'warning':
            icon = icons?.warning ?? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icon_icons_IconWarning_mjs__WEBPACK_IMPORTED_MODULE_4__.IconWarning, { "aria-hidden": ariaHidden, "aria-label": ariaLabel, role: role }));
            break;
        case 'success':
            icon = icons?.success ?? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icon_icons_IconCheckCircle_mjs__WEBPACK_IMPORTED_MODULE_5__.IconCheckCircle, { "aria-hidden": ariaHidden, "aria-label": ariaLabel, role: role }));
            break;
    }
    return icon ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement("span", { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__.ComponentClassName.AlertIcon }, icon)) : null;
};
AlertIcon.displayName = 'AlertIcon';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/Autocomplete.mjs":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/Autocomplete.mjs ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Autocomplete: () => (/* binding */ Autocomplete),
/* harmony export */   AutocompletePrimitive: () => (/* binding */ AutocompletePrimitive)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _AutocompleteOption_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AutocompleteOption.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/AutocompleteOption.mjs");
/* harmony import */ var _AutocompleteMenu_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./AutocompleteMenu.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/AutocompleteMenu.mjs");
/* harmony import */ var _useAutocomplete_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useAutocomplete.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/useAutocomplete.mjs");
/* harmony import */ var _HighlightMatch_HighlightMatch_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../HighlightMatch/HighlightMatch.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/HighlightMatch/HighlightMatch.mjs");
/* harmony import */ var _SearchField_SearchField_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../SearchField/SearchField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/SearchField/SearchField.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");










const AutocompletePrimitive = ({ className, defaultValue, value, isLoading = false, menuSlots = {}, options, optionFilter, onBlur, onChange, onClear, onClick, onSelect, onSubmit, renderOption, testId, ...rest }, ref) => {
    const { activeOptionId, autocompleteId, composedValue, filteredOptions, handleOnBlur, handleOnClear, handleOnClick, handleOnChange, handleOnKeyDown, isControlled, isCustomFiltering, isMenuOpen, listboxId, menuId, optionBaseId, setActiveOption, setIsMenuOpen, setInternalValue, } = (0,_useAutocomplete_mjs__WEBPACK_IMPORTED_MODULE_1__.useAutocomplete)({
        defaultValue,
        value,
        options,
        optionFilter,
        onBlur,
        onChange,
        onClear,
        onClick,
        onSelect,
        onSubmit,
    });
    const comboboxProps = {
        role: 'combobox',
        'aria-activedescendant': activeOptionId,
        'aria-autocomplete': 'list',
        'aria-controls': isMenuOpen ? menuId : undefined,
        'aria-expanded': isMenuOpen,
        'aria-haspopup': 'listbox',
        'aria-owns': isMenuOpen ? menuId : undefined,
    };
    const Options = filteredOptions.map((option, idx) => {
        const { id, label, ...rest } = option;
        const handleOnClick = () => {
            setIsMenuOpen(false);
            setActiveOption(null);
            if (!isControlled) {
                setInternalValue(label);
            }
            if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.isFunction)(onSelect)) {
                onSelect(option);
            }
        };
        // This is required. Mousedown event will fire a blur event by default
        // and so the menu will close before the click event on an option gets a chance to fire
        const handleOnMouseDown = (event) => {
            event.preventDefault();
        };
        const handleOnMouseMove = () => {
            setActiveOption(option);
        };
        const optionId = id ?? `${optionBaseId}-option-${idx}`;
        const isActive = optionId === activeOptionId;
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AutocompleteOption_mjs__WEBPACK_IMPORTED_MODULE_3__.AutocompleteOption, { isActive: isActive, id: optionId, key: optionId, onClick: handleOnClick, onMouseDown: handleOnMouseDown, onMouseMove: handleOnMouseMove, ...rest }, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.isFunction)(renderOption) ? (renderOption(option, composedValue)) : isCustomFiltering ? (label) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_HighlightMatch_HighlightMatch_mjs__WEBPACK_IMPORTED_MODULE_4__.HighlightMatch, { query: composedValue }, label))));
    });
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__.View, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_6__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.Autocomplete, className), id: autocompleteId, testId: testId },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_SearchField_SearchField_mjs__WEBPACK_IMPORTED_MODULE_8__.SearchField, { hasSearchButton: false, hasSearchIcon: true, onBlur: handleOnBlur, onChange: handleOnChange, onClear: handleOnClear, onClick: handleOnClick, onKeyDown: handleOnKeyDown, ref: ref, value: composedValue, ...comboboxProps, ...rest }),
        isMenuOpen ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_AutocompleteMenu_mjs__WEBPACK_IMPORTED_MODULE_9__.AutocompleteMenu, { id: menuId, isLoading: isLoading, listboxId: listboxId, ...menuSlots }, Options)) : null));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/autocomplete)
 */
const Autocomplete = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_10__.primitiveWithForwardRef)(AutocompletePrimitive);
Autocomplete.displayName = 'Autocomplete';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/AutocompleteMenu.mjs":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/AutocompleteMenu.mjs ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AutocompleteMenu: () => (/* binding */ AutocompleteMenu)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _Loader_Loader_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Loader/Loader.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Loader/Loader.mjs");
/* harmony import */ var _ScrollView_ScrollView_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../ScrollView/ScrollView.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/ScrollView/ScrollView.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../shared/constants.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/constants.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");








const MenuHeader = ({ children }) => {
    if (!children) {
        return null;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.AutocompleteMenuHeader }, children));
};
const MenuFooter = ({ children }) => {
    if (!children) {
        return null;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.AutocompleteMenuFooter }, children));
};
const MenuLoading = ({ children }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.AutocompleteMenuLoading }, children ?? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Loader_Loader_mjs__WEBPACK_IMPORTED_MODULE_3__.Loader, null),
        _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_4__.ComponentText.Autocomplete.loadingText))));
};
const MenuEmpty = ({ children }) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.AutocompleteMenuEmpty }, children ?? _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_4__.ComponentText.Autocomplete.emptyText));
const AutocompleteMenuPrimitive = ({ ariaLabel, children, Header = null, Footer = null, LoadingIndicator = null, Empty = null, isLoading, listboxId, ...rest }, ref) => {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ScrollView_ScrollView_mjs__WEBPACK_IMPORTED_MODULE_5__.ScrollView, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.AutocompleteMenu, ref: ref, ...rest }, isLoading ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuLoading, null, LoadingIndicator)) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuHeader, null, Header),
        children.length > 0 ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_ScrollView_ScrollView_mjs__WEBPACK_IMPORTED_MODULE_5__.ScrollView, { as: "ul", ariaLabel: ariaLabel, className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.AutocompleteMenuOptions, id: listboxId, role: "listbox" }, children)) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuEmpty, null, Empty)),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(MenuFooter, null, Footer)))));
};
const AutocompleteMenu = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__.primitiveWithForwardRef)(AutocompleteMenuPrimitive);
AutocompleteMenu.displayName = 'AutocompleteMenu';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/AutocompleteOption.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/AutocompleteOption.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AutocompleteOption: () => (/* binding */ AutocompleteOption)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");





const AutocompleteOptionPrimitive = ({ children, className, isActive, ...rest }, ref) => {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { "aria-selected": isActive, as: "li", role: "option", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.AutocompleteMenuOption, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.AutocompleteMenuOption, 'active', isActive), className), ref: ref, ...rest }, children));
};
const AutocompleteOption = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__.primitiveWithForwardRef)(AutocompleteOptionPrimitive);
AutocompleteOption.displayName = 'AutocompleteOption';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/useAutocomplete.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Autocomplete/useAutocomplete.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useAutocomplete: () => (/* binding */ useAutocomplete)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../shared/constants.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/constants.mjs");
/* harmony import */ var _shared_utils_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../shared/utils.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/utils.mjs");
/* harmony import */ var _utils_useStableId_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/useStableId.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/useStableId.mjs");






const DEFAULT_KEYS = new Set([_shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.ARROW_DOWN, _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.ARROW_UP, _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.ENTER_KEY, _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.ESCAPE_KEY]);
const useAutocomplete = ({ defaultValue = '', value, options, optionFilter, onBlur, onChange, onClear, onClick, onSelect, onSubmit, }) => {
    const isControlled = value !== undefined;
    const [internalValue, setInternalValue] = react__WEBPACK_IMPORTED_MODULE_0__.useState(defaultValue);
    const composedValue = isControlled ? value : internalValue;
    const [isMenuOpen, setIsMenuOpen] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const [activeOption, setActiveOption] = react__WEBPACK_IMPORTED_MODULE_0__.useState(null);
    const isCustomFiltering = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.isFunction)(optionFilter);
    const filteredOptions = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => {
        const defaultFilter = (option) => {
            const { label } = option;
            return label
                ?.toLocaleLowerCase()
                .includes(composedValue?.toLocaleLowerCase());
        };
        const filter = isCustomFiltering
            ? (option) => optionFilter(option, composedValue)
            : defaultFilter;
        return options?.filter(filter) ?? [];
    }, [composedValue, optionFilter, isCustomFiltering, options]);
    const autocompleteId = (0,_utils_useStableId_mjs__WEBPACK_IMPORTED_MODULE_3__.useStableId)();
    const listboxId = (0,_utils_useStableId_mjs__WEBPACK_IMPORTED_MODULE_3__.useStableId)();
    const menuId = (0,_utils_useStableId_mjs__WEBPACK_IMPORTED_MODULE_3__.useStableId)();
    const optionBaseId = (0,_utils_useStableId_mjs__WEBPACK_IMPORTED_MODULE_3__.useStableId)();
    const activeIndex = filteredOptions.findIndex((option) => option === activeOption);
    const activeOptionId = activeOption?.id ??
        (activeIndex !== -1 ? `${optionBaseId}-option-${activeIndex}` : undefined);
    const handleOnBlur = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((event) => {
        setIsMenuOpen(false);
        setActiveOption(null);
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.isFunction)(onBlur)) {
            onBlur(event);
        }
    }, [onBlur]);
    const handleOnChange = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((event) => {
        setActiveOption(null);
        setIsMenuOpen(true);
        if (!isControlled) {
            setInternalValue(event.target.value);
        }
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.isFunction)(onChange)) {
            onChange(event);
        }
    }, [isControlled, onChange]);
    const handleOnClear = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(() => {
        if (!isControlled) {
            setInternalValue('');
        }
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.isFunction)(onClear)) {
            onClear();
        }
    }, [isControlled, onClear]);
    const handleOnClick = react__WEBPACK_IMPORTED_MODULE_0__.useCallback((event) => {
        setIsMenuOpen(true);
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.isFunction)(onClick)) {
            onClick(event);
        }
    }, [onClick]);
    const handleOnKeyDown = (event) => {
        const { key } = event;
        if (!DEFAULT_KEYS.has(key)) {
            return;
        }
        event.preventDefault();
        switch (key) {
            case _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.ESCAPE_KEY: {
                if (isMenuOpen) {
                    setIsMenuOpen(false);
                    setActiveOption(null);
                }
                else {
                    handleOnClear();
                }
                break;
            }
            case _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.ENTER_KEY: {
                if (!activeOption) {
                    if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.isFunction)(onSubmit)) {
                        onSubmit(composedValue);
                    }
                }
                else {
                    const { label } = activeOption;
                    if (!isControlled) {
                        setInternalValue(label);
                    }
                    if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.isFunction)(onSelect)) {
                        onSelect(activeOption);
                    }
                }
                setIsMenuOpen(false);
                setActiveOption(null);
                break;
            }
            case _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.ARROW_DOWN: {
                if (filteredOptions.length <= 0) {
                    return;
                }
                setIsMenuOpen(true);
                const newActiveIndex = activeIndex >= filteredOptions.length - 1 ? 0 : activeIndex + 1;
                setActiveOption(filteredOptions[newActiveIndex]);
                break;
            }
            case _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.ARROW_UP: {
                if (filteredOptions.length <= 0) {
                    return;
                }
                setIsMenuOpen(true);
                const newActiveIndex = activeIndex <= 0 ? filteredOptions.length - 1 : activeIndex - 1;
                setActiveOption(filteredOptions[newActiveIndex]);
            }
        }
    };
    // The window will scroll down to the right place to show the whole menu
    // if space is not enough in current viewport
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        const autocompleteElement = document.getElementById(autocompleteId);
        const menuElement = document.getElementById(menuId);
        if (menuElement && isMenuOpen && autocompleteElement) {
            const { bottom } = menuElement.getBoundingClientRect();
            const { offsetParent, offsetTop } = autocompleteElement;
            if (offsetParent === document.body &&
                bottom > document.documentElement.clientHeight) {
                window.scrollTo({
                    top: Math.min(bottom -
                        document.documentElement.clientHeight +
                        window.scrollY +
                        20, // Add 20 gap between menu bottom and window viewport bottom
                    offsetTop),
                    behavior: 'smooth',
                });
            }
        }
    }, [autocompleteId, isMenuOpen, menuId]);
    // This will make the menu able to scroll with keyboard,
    // and scroll each option into window viewport if necessary
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        const listboxElement = document.getElementById(listboxId);
        const activeOptionElement = (0,_shared_utils_mjs__WEBPACK_IMPORTED_MODULE_4__.strHasLength)(activeOptionId)
            ? document.getElementById(activeOptionId)
            : null;
        if (activeOptionElement && listboxElement) {
            const { scrollTop, clientHeight } = listboxElement;
            const { offsetHeight, offsetTop } = activeOptionElement;
            const { top, bottom } = activeOptionElement.getBoundingClientRect();
            if (scrollTop > offsetTop) {
                listboxElement.scrollTop = offsetTop;
            }
            if (scrollTop + clientHeight < offsetTop + offsetHeight) {
                listboxElement.scrollTop = offsetTop + offsetHeight - clientHeight;
            }
            if (top < 0 || bottom > document.documentElement.clientHeight) {
                activeOptionElement.scrollIntoView({
                    behavior: 'smooth',
                    block: 'nearest',
                });
            }
        }
    }, [activeOptionId, listboxId]);
    return {
        activeOptionId,
        autocompleteId,
        composedValue,
        filteredOptions,
        handleOnBlur,
        handleOnClear,
        handleOnClick,
        handleOnChange,
        handleOnKeyDown,
        isControlled,
        isCustomFiltering,
        isMenuOpen,
        listboxId,
        menuId,
        optionBaseId,
        setActiveOption,
        setIsMenuOpen,
        setInternalValue,
    };
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Avatar/Avatar.mjs":
/*!**********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Avatar/Avatar.mjs ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Avatar: () => (/* binding */ Avatar)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Icon/context/useIcons.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/useIcons.mjs");
/* harmony import */ var _Icon_icons_IconUser_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Icon/icons/IconUser.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconUser.mjs");
/* harmony import */ var _Image_Image_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Image/Image.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Image/Image.mjs");
/* harmony import */ var _Loader_Loader_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Loader/Loader.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Loader/Loader.mjs");











const AvatarPrimitive = ({ className, children, variation, colorTheme, size, src, alt, isLoading, ...rest }, ref) => {
    const icons = (0,_Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_1__.useIcons)('avatar');
    const icon = icons?.user ?? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icon_icons_IconUser_mjs__WEBPACK_IMPORTED_MODULE_2__.IconUser, null);
    const componentClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.ComponentClassName.Avatar, className, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.ComponentClassName.Avatar, variation), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.ComponentClassName.Avatar, size), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.ComponentClassName.Avatar, colorTheme));
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_6__.View, { as: "span", className: componentClasses, ref: ref, ...rest },
        src ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Image_Image_mjs__WEBPACK_IMPORTED_MODULE_7__.Image, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.ComponentClassName.AvatarImage, src: src, alt: alt })) : (children ?? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_6__.View, { as: "span", className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.ComponentClassName.AvatarIcon, "aria-hidden": "true" }, icon))),
        isLoading ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Loader_Loader_mjs__WEBPACK_IMPORTED_MODULE_8__.Loader, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.ComponentClassName.AvatarLoader })) : null));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/avatar)
 */
const Avatar = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_9__.primitiveWithForwardRef)(AvatarPrimitive);
Avatar.displayName = 'Avatar';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Badge/Badge.mjs":
/*!********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Badge/Badge.mjs ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Badge: () => (/* binding */ Badge)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");





const BadgePrimitive = ({ className, children, variation, size, ...rest }, ref) => {
    const componentClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.Badge, className, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.Badge, variation), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.Badge, size));
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_4__.View, { as: "span", className: componentClasses, ref: ref, ...rest }, children));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/badge)
 */
const Badge = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__.primitiveWithForwardRef)(BadgePrimitive);
Badge.displayName = 'Badge';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbContainer.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbContainer.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BreadcrumbContainer: () => (/* binding */ BreadcrumbContainer)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");





const BreadcrumbContainerPrimitive = ({ className, children, ...rest }, ref) => {
    const componentClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.Breadcrumbs, className);
    const ariaLabel = rest['aria-label'] ?? 'Breadcrumb';
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { ...rest, as: "nav", "aria-label": ariaLabel, className: componentClasses, ref: ref },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { as: "ol", className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.BreadcrumbsList }, children)));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/breadcrumbs)
 */
const BreadcrumbContainer = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__.primitiveWithForwardRef)(BreadcrumbContainerPrimitive);
BreadcrumbContainer.displayName = 'Breadcrumbs.Container';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbItem.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbItem.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BreadcrumbItem: () => (/* binding */ BreadcrumbItem)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");





const BreadcrumbItemPrimitive = ({ className, children, as = 'li', ...rest }, ref) => {
    const componentClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.BreadcrumbsItem, className);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { ...rest, as: as, className: componentClasses, ref: ref }, children));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/breadcrumbs)
 */
const BreadcrumbItem = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__.primitiveWithForwardRef)(BreadcrumbItemPrimitive);
BreadcrumbItem.displayName = 'Breadcrumbs.Item';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbLink.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbLink.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BreadcrumbLink: () => (/* binding */ BreadcrumbLink)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _Link_Link_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Link/Link.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Link/Link.mjs");
/* harmony import */ var _Text_Text_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Text/Text.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Text/Text.mjs");






const BreadcrumbLinkPrimitive = ({ className, children, href, isCurrent, ...rest }, ref) => {
    const componentClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.BreadcrumbsLink, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.BreadcrumbsLink, 'current', isCurrent), className);
    if (isCurrent) {
        const ariaCurrent = rest['aria-current'] ?? 'page';
        const as = rest.as ?? 'span';
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_4__.Text, { ...rest, as: as, "aria-current": ariaCurrent, className: componentClasses, ref: ref }, children));
    }
    else {
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Link_Link_mjs__WEBPACK_IMPORTED_MODULE_5__.Link, { ...rest, className: componentClasses, ref: ref, href: href }, children));
    }
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/breadcrumbs)
 */
const BreadcrumbLink = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__.primitiveWithForwardRef)(BreadcrumbLinkPrimitive);
BreadcrumbLink.displayName = 'Breadcrumbs.Link';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbSeparator.mjs":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbSeparator.mjs ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BreadcrumbSeparator: () => (/* binding */ BreadcrumbSeparator)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");





const BreadcrumbSeparatorPrimitive = ({ className, children = '/', as = 'span', ...rest }, ref) => {
    const ariaHidden = rest['aria-hidden'] ?? 'true';
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { ...rest, as: as, ref: ref, "aria-hidden": ariaHidden, className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.BreadcrumbsSeparator, className) }, children));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/breadcrumbs)
 */
const BreadcrumbSeparator = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__.primitiveWithForwardRef)(BreadcrumbSeparatorPrimitive);
BreadcrumbSeparator.displayName = 'Breadcrumbs.Separator';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/Breadcrumbs.mjs":
/*!********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/Breadcrumbs.mjs ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Breadcrumbs: () => (/* binding */ Breadcrumbs)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _BreadcrumbItem_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./BreadcrumbItem.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbItem.mjs");
/* harmony import */ var _BreadcrumbLink_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BreadcrumbLink.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbLink.mjs");
/* harmony import */ var _BreadcrumbSeparator_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BreadcrumbSeparator.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbSeparator.mjs");
/* harmony import */ var _BreadcrumbContainer_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BreadcrumbContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Breadcrumbs/BreadcrumbContainer.mjs");







const BreadcrumbsPrimitive = ({ className, items, separator = react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadcrumbSeparator_mjs__WEBPACK_IMPORTED_MODULE_1__.BreadcrumbSeparator, null), ...rest }, ref) => {
    const ariaLabel = rest['aria-label'] ?? 'Breadcrumb';
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadcrumbContainer_mjs__WEBPACK_IMPORTED_MODULE_2__.BreadcrumbContainer, { ...rest, "aria-label": ariaLabel, className: className, ref: ref }, items?.map(({ href, label }, idx) => {
        const isCurrent = items.length - 1 === idx;
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadcrumbItem_mjs__WEBPACK_IMPORTED_MODULE_3__.BreadcrumbItem, { key: `${href}${idx}` },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_BreadcrumbLink_mjs__WEBPACK_IMPORTED_MODULE_4__.BreadcrumbLink, { href: href, isCurrent: isCurrent }, label),
            isCurrent ? null : separator));
    })));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/breadcrumbs)
 */
const Breadcrumbs = Object.assign((0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__.primitiveWithForwardRef)(BreadcrumbsPrimitive), {
    Item: _BreadcrumbItem_mjs__WEBPACK_IMPORTED_MODULE_3__.BreadcrumbItem,
    Link: _BreadcrumbLink_mjs__WEBPACK_IMPORTED_MODULE_4__.BreadcrumbLink,
    Separator: _BreadcrumbSeparator_mjs__WEBPACK_IMPORTED_MODULE_1__.BreadcrumbSeparator,
    Container: _BreadcrumbContainer_mjs__WEBPACK_IMPORTED_MODULE_2__.BreadcrumbContainer,
});
Breadcrumbs.displayName = 'Breadcrumbs';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs":
/*!**********************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Button: () => (/* binding */ Button)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _Fieldset_useFieldset_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Fieldset/useFieldset.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Fieldset/useFieldset.mjs");
/* harmony import */ var _Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _Loader_Loader_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Loader/Loader.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Loader/Loader.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");








// These variations support colorThemes. 'undefined' accounts for our
// 'default' variation which is not named.
const supportedVariations = ['link', 'primary', undefined];
const ButtonPrimitive = ({ className, children, colorTheme, isFullWidth = false, isDisabled, isLoading, loadingText = '', size, type = 'button', variation, ...rest }, ref) => {
    // Creates our colorTheme modifier string based on if the variation
    // supports colorThemes and a colorTheme is used.
    const colorThemeModifier = supportedVariations.includes(variation) && colorTheme
        ? `${variation ?? 'outlined'}--${colorTheme}`
        : undefined;
    const { isFieldsetDisabled } = (0,_Fieldset_useFieldset_mjs__WEBPACK_IMPORTED_MODULE_1__.useFieldset)();
    const shouldBeDisabled = isFieldsetDisabled
        ? isFieldsetDisabled
        : isDisabled ?? isLoading ?? rest['disabled'];
    const componentClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Button, _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.FieldGroupControl, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Button, variation), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Button, colorThemeModifier), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Button, size), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Button, 'disabled', shouldBeDisabled), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Button, 'loading', isLoading), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Button, 'fullwidth', isFullWidth), className);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__.View, { ref: ref, as: "button", className: componentClasses, isDisabled: shouldBeDisabled, type: type, ...rest }, isLoading ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_6__.Flex, { as: "span", className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.ButtonLoaderWrapper },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Loader_Loader_mjs__WEBPACK_IMPORTED_MODULE_7__.Loader, { size: size }),
        loadingText ? loadingText : null)) : (children)));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/button)
 */
const Button = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_8__.primitiveWithForwardRef)(ButtonPrimitive);
Button.displayName = 'Button';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/ButtonGroup/ButtonGroup.mjs":
/*!********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/ButtonGroup/ButtonGroup.mjs ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ButtonGroup: () => (/* binding */ ButtonGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");





const ButtonGroupPrimitive = ({ className, children, isDisabled: _isDisabled = false, role = 'group', size: _size, variation: _variation, ...rest }, ref) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_1__.Flex, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.ButtonGroup, className), role: role, ref: ref, ...rest }, react__WEBPACK_IMPORTED_MODULE_0__.Children.map(children, (child) => {
    if (react__WEBPACK_IMPORTED_MODULE_0__.isValidElement(child)) {
        const { size = _size, variation = _variation, isDisabled = _isDisabled, } = child.props;
        return react__WEBPACK_IMPORTED_MODULE_0__.cloneElement(child, { isDisabled, size, variation });
    }
    return child;
})));
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/button#buttongroup)
 */
const ButtonGroup = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__.primitiveWithForwardRef)(ButtonGroupPrimitive);
ButtonGroup.displayName = 'ButtonGroup';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Card/Card.mjs":
/*!******************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Card/Card.mjs ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Card: () => (/* binding */ Card)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");





const CardPrimitive = ({ className, children, variation, ...rest }, ref) => {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Card, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Card, variation), className), ref: ref, ...rest }, children));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/card)
 */
const Card = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__.primitiveWithForwardRef)(CardPrimitive);
Card.displayName = 'Card';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Checkbox/Checkbox.mjs":
/*!**************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Checkbox/Checkbox.mjs ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Checkbox: () => (/* binding */ Checkbox)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Icon/context/useIcons.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/useIcons.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _Icon_icons_IconCheck_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../Icon/icons/IconCheck.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconCheck.mjs");
/* harmony import */ var _Icon_icons_IconIndeterminate_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../Icon/icons/IconIndeterminate.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconIndeterminate.mjs");
/* harmony import */ var _Input_Input_mjs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../Input/Input.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Input/Input.mjs");
/* harmony import */ var _Text_Text_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../Text/Text.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Text/Text.mjs");
/* harmony import */ var _VisuallyHidden_VisuallyHidden_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../VisuallyHidden/VisuallyHidden.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/VisuallyHidden/VisuallyHidden.mjs");
/* harmony import */ var _utils_getUniqueComponentId_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/getUniqueComponentId.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/getUniqueComponentId.mjs");
/* harmony import */ var _utils_useStableId_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/useStableId.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/useStableId.mjs");
/* harmony import */ var _utils_splitPrimitiveProps_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/splitPrimitiveProps.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/splitPrimitiveProps.mjs");
/* harmony import */ var _Fieldset_useFieldset_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Fieldset/useFieldset.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Fieldset/useFieldset.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");


















const CheckboxPrimitive = ({ checked: controlledChecked, className, defaultChecked, hasError, isDisabled, isIndeterminate, label, labelHidden, labelPosition, onBlur: _onBlur, onFocus: _onFocus, onChange: _onChange, testId, inputStyles, ..._rest }, ref) => {
    const { styleProps, rest } = (0,_utils_splitPrimitiveProps_mjs__WEBPACK_IMPORTED_MODULE_1__.splitPrimitiveProps)(_rest);
    const [focused, setFocused] = react__WEBPACK_IMPORTED_MODULE_0__.useState(false);
    const icons = (0,_Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_2__.useIcons)('checkbox');
    const { isFieldsetDisabled } = (0,_Fieldset_useFieldset_mjs__WEBPACK_IMPORTED_MODULE_3__.useFieldset)();
    const shouldBeDisabled = isFieldsetDisabled ? isFieldsetDisabled : isDisabled;
    const isControlled = controlledChecked !== undefined;
    const [localChecked, setLocalChecked] = react__WEBPACK_IMPORTED_MODULE_0__.useState(() => 
    // if controlled, initialize to `controlledChecked` else `defaultChecked`
    isControlled ? controlledChecked : defaultChecked);
    const checked = isControlled ? controlledChecked : localChecked;
    const onChange = (e) => {
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.isFunction)(_onChange)) {
            _onChange(e);
        }
        // in controlled mode, `controlledChecked` determines checked state
        if (!isControlled) {
            setLocalChecked(e.target.checked);
        }
    };
    const onFocus = (e) => {
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.isFunction)(_onFocus)) {
            _onFocus(e);
        }
        setFocused(true);
    };
    const onBlur = (e) => {
        if ((0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.isFunction)(_onBlur)) {
            _onBlur(e);
        }
        setFocused(false);
    };
    const dataId = (0,_utils_useStableId_mjs__WEBPACK_IMPORTED_MODULE_5__.useStableId)();
    react__WEBPACK_IMPORTED_MODULE_0__.useEffect(() => {
        const input = document.querySelector(`[data-id="${dataId}"]`);
        if (input && typeof isIndeterminate === 'boolean') {
            // HTMLInputElement does not have an `indeterminate` attribute
            input.indeterminate =
                isIndeterminate;
        }
    }, [dataId, isIndeterminate]);
    const buttonTestId = (0,_utils_getUniqueComponentId_mjs__WEBPACK_IMPORTED_MODULE_6__.getUniqueComponentId)(testId, _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxButton);
    const iconTestId = (0,_utils_getUniqueComponentId_mjs__WEBPACK_IMPORTED_MODULE_6__.getUniqueComponentId)(testId, _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxIcon);
    const labelTestId = (0,_utils_getUniqueComponentId_mjs__WEBPACK_IMPORTED_MODULE_6__.getUniqueComponentId)(testId, _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxLabel);
    const flexClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_8__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxButton, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxButton, 'disabled', shouldBeDisabled), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxButton, 'error', hasError), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxButton, 'focused', focused));
    const iconClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_8__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxIcon, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxIcon, 'checked', checked), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxIcon, 'disabled', shouldBeDisabled), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxIcon, 'indeterminate', isIndeterminate));
    const iconProps = {
        className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_8__.classNames)(iconClasses),
        'data-checked': localChecked,
        'data-disabled': shouldBeDisabled,
        'data-testid': iconTestId,
    };
    const checkedIcon = icons?.checked ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_9__.View, { as: "span", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_8__.classNames)(iconClasses) }, icons.checked)) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icon_icons_IconCheck_mjs__WEBPACK_IMPORTED_MODULE_10__.IconCheck, { ...iconProps }));
    const indeterminateIcon = icons?.indeterminate ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_9__.View, { as: "span", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_8__.classNames)(iconClasses) }, icons.indeterminate)) : (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icon_icons_IconIndeterminate_mjs__WEBPACK_IMPORTED_MODULE_11__.IconIndeterminate, { ...iconProps }));
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_12__.Flex, { as: "label", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_8__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.Checkbox, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.Checkbox, 'disabled', shouldBeDisabled), labelPosition ? `amplify-label-${labelPosition}` : null, className), testId: testId, ...styleProps },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_VisuallyHidden_VisuallyHidden_mjs__WEBPACK_IMPORTED_MODULE_13__.VisuallyHidden, null,
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Input_Input_mjs__WEBPACK_IMPORTED_MODULE_14__.Input, { checked: controlledChecked, className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxInput, "data-id": dataId, defaultChecked: defaultChecked, isDisabled: shouldBeDisabled, onBlur: onBlur, onChange: onChange, onFocus: onFocus, ref: ref, type: "checkbox", ...rest })),
        label && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_15__.Text, { as: "span", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_8__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxLabel, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.CheckboxLabel, `disabled`, shouldBeDisabled), {
                [_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_7__.ComponentClassName.VisuallyHidden]: labelHidden,
            }), "data-disabled": shouldBeDisabled, testId: labelTestId }, label)),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_12__.Flex, { "aria-hidden": "true", as: "span", className: flexClasses, "data-checked": checked, "data-disabled": shouldBeDisabled, "data-focus": focused, "data-error": hasError, testId: buttonTestId, ...inputStyles }, isIndeterminate ? indeterminateIcon : checkedIcon)));
};
const Checkbox = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_16__.primitiveWithForwardRef)(CheckboxPrimitive);
Checkbox.displayName = 'Checkbox';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/CheckboxField/CheckboxField.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/CheckboxField/CheckboxField.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CheckboxField: () => (/* binding */ CheckboxField)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _Checkbox_Checkbox_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Checkbox/Checkbox.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Checkbox/Checkbox.mjs");
/* harmony import */ var _Field_FieldErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Field/FieldErrorMessage.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Field/FieldErrorMessage.mjs");
/* harmony import */ var _utils_getUniqueComponentId_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/getUniqueComponentId.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/getUniqueComponentId.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");











const CheckboxFieldPrimitive = ({ className, errorMessage, hasError = false, labelHidden = false, labelPosition, testId, size, ...rest }, ref) => {
    const checkboxTestId = (0,_utils_getUniqueComponentId_mjs__WEBPACK_IMPORTED_MODULE_1__.getUniqueComponentId)(testId, _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.Checkbox);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_3__.Flex, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.Field, _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.CheckboxField, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.Field, size), className), testId: testId },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Checkbox_Checkbox_mjs__WEBPACK_IMPORTED_MODULE_6__.Checkbox, { hasError: hasError, labelHidden: labelHidden, testId: checkboxTestId, labelPosition: labelPosition, ref: ref, ...rest }),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Field_FieldErrorMessage_mjs__WEBPACK_IMPORTED_MODULE_7__.FieldErrorMessage, { hasError: hasError, errorMessage: errorMessage })));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/checkboxfield)
 */
const CheckboxField = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_8__.primitiveWithForwardRef)(CheckboxFieldPrimitive);
CheckboxField.displayName = 'CheckboxField';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Collection/Collection.mjs":
/*!******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Collection/Collection.mjs ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Collection: () => (/* binding */ Collection)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_debounce_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/debounce.js */ "./node_modules/lodash/debounce.js");
/* harmony import */ var lodash_debounce_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_debounce_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _Grid_Grid_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Grid/Grid.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Grid/Grid.mjs");
/* harmony import */ var _Text_Text_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Text/Text.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Text/Text.mjs");
/* harmony import */ var _Pagination_Pagination_mjs__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../Pagination/Pagination.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Pagination/Pagination.mjs");
/* harmony import */ var _Pagination_usePagination_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../Pagination/usePagination.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Pagination/usePagination.mjs");
/* harmony import */ var _SearchField_SearchField_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../SearchField/SearchField.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/SearchField/SearchField.mjs");
/* harmony import */ var _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../shared/constants.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/constants.mjs");
/* harmony import */ var _shared_utils_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../shared/utils.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/utils.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Collection/utils.mjs");













const DEFAULT_PAGE_SIZE = 10;
const TYPEAHEAD_DELAY_MS = 300;
const ListCollection = ({ children, direction = 'column', items, ...rest }) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_2__.Flex, { direction: direction, ...rest }, Array.isArray(items) ? items.map(children) : null));
const GridCollection = ({ children, items, ...rest }) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Grid_Grid_mjs__WEBPACK_IMPORTED_MODULE_3__.Grid, { ...rest }, Array.isArray(items) ? items.map(children) : null));
const renderCollectionOrNoResultsFound = (collection, items, searchNoResultsFound) => {
    if (items.length) {
        return collection;
    }
    if (searchNoResultsFound) {
        return searchNoResultsFound;
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_2__.Flex, { justifyContent: "center" },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_4__.Text, null, _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_5__.ComponentText.Collection.searchNoResultsFound)));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/collection)
 */
const Collection = ({ className, isSearchable, isPaginated, items, itemsPerPage = DEFAULT_PAGE_SIZE, searchFilter = _utils_mjs__WEBPACK_IMPORTED_MODULE_6__.itemHasText, searchLabel = _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_5__.ComponentText.Collection.searchButtonLabel, searchNoResultsFound, searchPlaceholder, type = 'list', testId, ...rest }) => {
    const [searchText, setSearchText] = react__WEBPACK_IMPORTED_MODULE_0__.useState();
    // eslint-disable-next-line react-hooks/exhaustive-deps
    const onSearch = react__WEBPACK_IMPORTED_MODULE_0__.useCallback(lodash_debounce_js__WEBPACK_IMPORTED_MODULE_1___default()(setSearchText, TYPEAHEAD_DELAY_MS), [setSearchText]);
    // Make sure that items are iterable
    items = Array.isArray(items) ? items : [];
    // Filter items by text
    if (isSearchable && (0,_shared_utils_mjs__WEBPACK_IMPORTED_MODULE_7__.strHasLength)(searchText)) {
        items = items.filter((item) => searchFilter(item, searchText));
    }
    // Pagination
    const pagination = (0,_Pagination_usePagination_mjs__WEBPACK_IMPORTED_MODULE_8__.usePagination)({
        totalPages: (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_6__.getPageCount)(items.length, itemsPerPage),
    });
    if (isPaginated) {
        items = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_6__.getItemsAtPage)(items, pagination.currentPage, itemsPerPage);
    }
    const collection = type === 'list' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(ListCollection, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_9__.ComponentClassName.CollectionItems, items: items, ...rest })) : type === 'grid' ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(GridCollection, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_9__.ComponentClassName.CollectionItems, items: items, ...rest })) : null;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_2__.Flex, { testId: testId, className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_10__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_9__.ComponentClassName.Collection, className) },
        isSearchable ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_2__.Flex, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_9__.ComponentClassName.CollectionSearch },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_SearchField_SearchField_mjs__WEBPACK_IMPORTED_MODULE_11__.SearchField, { label: searchLabel, placeholder: searchPlaceholder, onChange: (e) => onSearch(e.target.value), onClear: () => setSearchText('') }))) : null,
        renderCollectionOrNoResultsFound(collection, items, searchNoResultsFound),
        isPaginated ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_2__.Flex, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_9__.ComponentClassName.CollectionPagination },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Pagination_Pagination_mjs__WEBPACK_IMPORTED_MODULE_12__.Pagination, { ...pagination }))) : null));
};
Collection.displayName = 'Collection';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Collection/utils.mjs":
/*!*************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Collection/utils.mjs ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getItemsAtPage: () => (/* binding */ getItemsAtPage),
/* harmony export */   getPageCount: () => (/* binding */ getPageCount),
/* harmony export */   itemHasText: () => (/* binding */ itemHasText)
/* harmony export */ });
/* harmony import */ var _shared_utils_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../shared/utils.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/utils.mjs");


/**
 * Slice a collection based on page index (starting at 1)
 */
const getItemsAtPage = (items, page, itemsPerPage) => {
    if (page < 1 || itemsPerPage < 1) {
        return [];
    }
    const startIndex = (page - 1) * itemsPerPage;
    return items.slice(startIndex, startIndex + itemsPerPage);
};
/**
 * Recursively find a keyword within an object (case insensitive)
 */
const itemHasText = (item, text) => {
    if ((0,_shared_utils_mjs__WEBPACK_IMPORTED_MODULE_0__.strHasLength)(item)) {
        return item.toLowerCase().includes(text.toLowerCase());
    }
    if (typeof item === 'object' && item !== null) {
        return Object.values(item).some((subItem) => itemHasText(subItem, text));
    }
    return false;
};
/**
 * Computes the amount of available pages
 */
const getPageCount = (totalItems, itemsPerPage) => Math.ceil(totalItems / itemsPerPage);




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Divider/Divider.mjs":
/*!************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Divider/Divider.mjs ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Divider: () => (/* binding */ Divider)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");





const DividerPrimitive = ({ className, orientation = 'horizontal', size, label, ...rest }, ref) => {
    const componentClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.Divider, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.Divider, orientation), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.Divider, size), className);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_4__.View, { "aria-orientation": orientation, as: "hr", className: componentClasses, "data-label": label, ref: ref, ...rest }));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/divider)
 */
const Divider = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__.primitiveWithForwardRef)(DividerPrimitive);
Divider.displayName = 'Divider';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZone.mjs":
/*!**************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZone.mjs ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DropZone: () => (/* binding */ DropZone)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui-react-core */ "./node_modules/@aws-amplify/ui-react-core/dist/esm/hooks/useDropZone.mjs");
/* harmony import */ var _DropZoneProvider_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DropZoneProvider.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneProvider.mjs");
/* harmony import */ var _DropZoneContainer_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DropZoneContainer.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneContainer.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _DropZoneChildren_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DropZoneChildren.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneChildren.mjs");







const DropZonePrimitive = ({ children, testId, isDisabled, acceptedFileTypes, onDropComplete, ...rest }, ref) => {
    const { dragState, onDragEnter, onDragLeave, onDragOver, onDragStart, onDrop, } = (0,_aws_amplify_ui_react_core__WEBPACK_IMPORTED_MODULE_1__["default"])({
        acceptedFileTypes,
        onDropComplete,
        ...rest,
    });
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DropZoneProvider_mjs__WEBPACK_IMPORTED_MODULE_2__.DropZoneProvider, { value: dragState },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_DropZoneContainer_mjs__WEBPACK_IMPORTED_MODULE_3__.DropZoneContainer, { ...rest, testId: testId, isDisabled: isDisabled, onDragStart: onDragStart, onDragEnter: onDragEnter, onDragLeave: onDragLeave, onDrop: onDrop, onDragOver: onDragOver, ref: ref }, children)));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/dropzone)
 */
const DropZone = Object.assign((0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__.primitiveWithForwardRef)(DropZonePrimitive), {
    Accepted: _DropZoneChildren_mjs__WEBPACK_IMPORTED_MODULE_5__.Accepted,
    Rejected: _DropZoneChildren_mjs__WEBPACK_IMPORTED_MODULE_5__.Rejected,
    Default: _DropZoneChildren_mjs__WEBPACK_IMPORTED_MODULE_5__.Default,
});
DropZone.displayName = 'DropZone';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneChildren.mjs":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneChildren.mjs ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Accepted: () => (/* binding */ Accepted),
/* harmony export */   Default: () => (/* binding */ Default),
/* harmony export */   Rejected: () => (/* binding */ Rejected)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DropZoneProvider_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DropZoneProvider.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneProvider.mjs");



/**
 * This component renders when the user is dragging ONLY accepted files on the DropZone.
 */
const Accepted = ({ children }) => {
    const dragState = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_DropZoneProvider_mjs__WEBPACK_IMPORTED_MODULE_1__.DropZoneContext);
    if (!dragState) {
        throw new Error('`DropZone.Accept` must be used inside a DropZone');
    }
    return dragState === 'accept' ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children) : null;
};
/**
 * This component renders when the user is dragging ANY rejected files on the DropZone.
 */
const Rejected = ({ children }) => {
    const dragState = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_DropZoneProvider_mjs__WEBPACK_IMPORTED_MODULE_1__.DropZoneContext);
    if (!dragState) {
        throw new Error('`DropZone.Rejected` must be used inside a DropZone');
    }
    return dragState === 'reject' ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children) : null;
};
/**
 * This component renders by default when the user is not dragging.
 */
const Default = ({ children }) => {
    const dragState = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_DropZoneProvider_mjs__WEBPACK_IMPORTED_MODULE_1__.DropZoneContext);
    if (!dragState) {
        throw new Error('`DropZone.Default` must be used inside a DropZone');
    }
    return dragState === 'inactive' ? react__WEBPACK_IMPORTED_MODULE_0__.createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, children) : null;
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneContainer.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneContainer.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DropZoneContainer: () => (/* binding */ DropZoneContainer)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _DropZoneProvider_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DropZoneProvider.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneProvider.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");






const Container = ({ className, children, testId, isDisabled, onDragEnter, onDragLeave, onDragOver, onDragStart, onDrop, ...rest }, ref) => {
    const dragState = react__WEBPACK_IMPORTED_MODULE_0___default().useContext(_DropZoneProvider_mjs__WEBPACK_IMPORTED_MODULE_1__.DropZoneContext);
    // Don't add drag event handlers if it is disabled.
    const dragProps = isDisabled
        ? {}
        : { onDragEnter, onDragLeave, onDragOver, onDragStart, onDrop };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_2__.View, { ...rest, ...dragProps, isDisabled: isDisabled, className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNames)(className, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.ComponentClassName.DropZone, 'rejected', dragState === 'reject'), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.ComponentClassName.DropZone, 'accepted', dragState === 'accept'), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.ComponentClassName.DropZone, 'disabled', isDisabled), _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.ComponentClassName.DropZone), "data-testid": testId, ref: ref }, children));
};
const DropZoneContainer = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__.primitiveWithForwardRef)(Container);
DropZoneContainer.displayName = 'DropZoneContainer';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneProvider.mjs":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/DropZone/DropZoneProvider.mjs ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DropZoneContext: () => (/* binding */ DropZoneContext),
/* harmony export */   DropZoneProvider: () => (/* binding */ DropZoneProvider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const DropZoneContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext('inactive');
const DropZoneProvider = ({ value, children, }) => {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(DropZoneContext.Provider, { value: value }, children));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Field/FieldClearButton.mjs":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Field/FieldClearButton.mjs ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FieldClearButton: () => (/* binding */ FieldClearButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _FieldGroupIcon_FieldGroupIconButton_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../FieldGroupIcon/FieldGroupIconButton.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/FieldGroupIcon/FieldGroupIconButton.mjs");
/* harmony import */ var _Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Icon/context/useIcons.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/useIcons.mjs");
/* harmony import */ var _Icon_icons_IconClose_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Icon/icons/IconClose.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconClose.mjs");
/* harmony import */ var _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../shared/constants.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/constants.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");












const ariaLabelText = _shared_constants_mjs__WEBPACK_IMPORTED_MODULE_1__.ComponentText.Fields.clearButtonLabel;
const FieldClearButtonPrimitive = ({ ariaLabel = ariaLabelText, size, ...rest }, ref) => {
    const icons = (0,_Icon_context_useIcons_mjs__WEBPACK_IMPORTED_MODULE_2__.useIcons)('field');
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FieldGroupIcon_FieldGroupIconButton_mjs__WEBPACK_IMPORTED_MODULE_3__.FieldGroupIconButton, { ariaLabel: ariaLabel, size: size, ref: ref, ...rest }, icons?.clear ?? react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Icon_icons_IconClose_mjs__WEBPACK_IMPORTED_MODULE_4__.IconClose, null)));
};
const FieldClearButton = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__.primitiveWithForwardRef)(FieldClearButtonPrimitive);
FieldClearButton.displayName = 'FieldClearButton';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Field/FieldDescription.mjs":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Field/FieldDescription.mjs ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FieldDescription: () => (/* binding */ FieldDescription),
/* harmony export */   QA_FIELD_DESCRIPTION: () => (/* binding */ QA_FIELD_DESCRIPTION)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _Text_Text_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Text/Text.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Text/Text.mjs");




const QA_FIELD_DESCRIPTION = 'qa-field-description';
const FieldDescription = ({ descriptiveText, labelHidden, ...rest }) => descriptiveText ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_1__.Text, { "data-testid": QA_FIELD_DESCRIPTION, className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.FieldDescription, {
        [_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.VisuallyHidden]: labelHidden,
    }), ...rest }, descriptiveText)) : null;
FieldDescription.displayName = 'FieldDescription';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Field/FieldErrorMessage.mjs":
/*!********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Field/FieldErrorMessage.mjs ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FieldErrorMessage: () => (/* binding */ FieldErrorMessage)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Text_Text_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Text/Text.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Text/Text.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");




const FieldErrorMessage = ({ errorMessage, hasError, ...rest }) => {
    return hasError && errorMessage ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Text_Text_mjs__WEBPACK_IMPORTED_MODULE_1__.Text, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.ComponentClassName.FieldErrorMessage, ...rest }, errorMessage)) : null;
};
FieldErrorMessage.displayName = 'FieldErrorMessage';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/FieldGroup/FieldGroup.mjs":
/*!******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/FieldGroup/FieldGroup.mjs ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FieldGroup: () => (/* binding */ FieldGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");






const FieldGroupPrimitive = ({ children, className, innerEndComponent, innerStartComponent, orientation = 'horizontal', outerEndComponent, outerStartComponent, variation, ...rest }, ref) => {
    // Don't apply hasInner classnames unless a component was provided
    const hasInnerStartComponent = innerStartComponent != null;
    const hasInnerEndComponent = innerEndComponent != null;
    const fieldGroupHasInnerStartClassName = hasInnerStartComponent
        ? _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroupHasInnerStart
        : null;
    const fieldGroupHasInnerEndClassName = hasInnerEndComponent
        ? _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroupHasInnerEnd
        : null;
    const componentClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroup, fieldGroupHasInnerStartClassName, fieldGroupHasInnerEndClassName, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroup, orientation), className);
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_4__.Flex, { className: componentClasses, ref: ref, ...rest },
        outerStartComponent && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__.View, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroupOuterStart, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroupOuterStart, variation)) }, outerStartComponent)),
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__.View, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroupFieldWrapper, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroupFieldWrapper, orientation)) },
            innerStartComponent && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__.View, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroupInnerStart }, innerStartComponent)),
            children,
            innerEndComponent && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__.View, { className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroupInnerEnd }, innerEndComponent))),
        outerEndComponent && (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_5__.View, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroupOuterEnd, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_1__.ComponentClassName.FieldGroupOuterEnd, variation)) }, outerEndComponent))));
};
const FieldGroup = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__.primitiveWithForwardRef)(FieldGroupPrimitive);
FieldGroup.displayName = 'FieldGroup';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/FieldGroupIcon/FieldGroupIcon.mjs":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/FieldGroupIcon/FieldGroupIcon.mjs ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FieldGroupIcon: () => (/* binding */ FieldGroupIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");





const FieldGroupIconPrimitive = ({ className, children, isVisible = true, excludeFromTabOrder = false, ...rest }, ref) => {
    return isVisible ? (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.FieldGroupIcon, className), ref: ref, tabIndex: excludeFromTabOrder ? -1 : undefined, ...rest }, children)) : null;
};
const FieldGroupIcon = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__.primitiveWithForwardRef)(FieldGroupIconPrimitive);
FieldGroupIcon.displayName = 'FieldGroupIcon';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/FieldGroupIcon/FieldGroupIconButton.mjs":
/*!********************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/FieldGroupIcon/FieldGroupIconButton.mjs ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FieldGroupIconButton: () => (/* binding */ FieldGroupIconButton)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _Button_Button_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Button/Button.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Button/Button.mjs");
/* harmony import */ var _FieldGroupIcon_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./FieldGroupIcon.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/FieldGroupIcon/FieldGroupIcon.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");






const FieldGroupIconButtonPrimitive = ({ children, className, ...rest }, ref) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_FieldGroupIcon_mjs__WEBPACK_IMPORTED_MODULE_1__.FieldGroupIcon, { as: _Button_Button_mjs__WEBPACK_IMPORTED_MODULE_2__.Button, className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.ComponentClassName.FieldGroupIconButton, className), ref: ref, ...rest }, children));
const FieldGroupIconButton = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__.primitiveWithForwardRef)(FieldGroupIconButtonPrimitive);
FieldGroupIconButton.displayName = 'FieldGroupIconButton';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Fieldset/Fieldset.mjs":
/*!**************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Fieldset/Fieldset.mjs ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Fieldset: () => (/* binding */ Fieldset)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");
/* harmony import */ var _Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Flex/Flex.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _VisuallyHidden_VisuallyHidden_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../VisuallyHidden/VisuallyHidden.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/VisuallyHidden/VisuallyHidden.mjs");
/* harmony import */ var _useFieldset_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./useFieldset.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Fieldset/useFieldset.mjs");








const FieldsetPrimitive = ({ children, className, isDisabled, legend, legendHidden, size, testId, variation = 'plain', ...rest }, ref) => {
    const { isFieldsetDisabled } = (0,_useFieldset_mjs__WEBPACK_IMPORTED_MODULE_1__.useFieldset)();
    // Fieldsets that are nested within a disabled Fieldset should
    // also be disabled.
    const shouldBeDisabled = isFieldsetDisabled ? isFieldsetDisabled : isDisabled;
    const value = react__WEBPACK_IMPORTED_MODULE_0__.useMemo(() => ({
        isFieldsetDisabled: shouldBeDisabled,
    }), [shouldBeDisabled]);
    const fieldsetClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Fieldset, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Fieldset, variation), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Fieldset, size), className);
    const legendClasses = (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.FieldsetLegend, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.FieldsetLegend, size), {
        [_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.VisuallyHidden]: legendHidden,
    });
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_useFieldset_mjs__WEBPACK_IMPORTED_MODULE_1__.FieldsetContext.Provider, { value: value },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement(_Flex_Flex_mjs__WEBPACK_IMPORTED_MODULE_5__.Flex, { as: "fieldset", className: fieldsetClasses, ref: ref, disabled: shouldBeDisabled, testId: testId, ...rest },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_VisuallyHidden_VisuallyHidden_mjs__WEBPACK_IMPORTED_MODULE_6__.VisuallyHidden, { as: "legend" }, legend),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_7__.View, { as: "div", "aria-hidden": "true", className: legendClasses }, legend),
            children)));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/fieldset)
 */
const Fieldset = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_8__.primitiveWithForwardRef)(FieldsetPrimitive);
Fieldset.displayName = 'Fieldset';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Fieldset/useFieldset.mjs":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Fieldset/useFieldset.mjs ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FieldsetContext: () => (/* binding */ FieldsetContext),
/* harmony export */   useFieldset: () => (/* binding */ useFieldset)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const FieldsetContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext({
    isFieldsetDisabled: false,
});
/**
 * @description Fieldsets in HTML can be disabled, which disables all child
 * fieldsets and input controls. `useFieldset` passes the disabled state down
 * via context.
 */
const useFieldset = () => react__WEBPACK_IMPORTED_MODULE_0__.useContext(FieldsetContext);




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs":
/*!******************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Flex/Flex.mjs ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Flex: () => (/* binding */ Flex)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");





const FlexPrimitive = ({ className, children, ...rest }, ref) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Flex, className), ref: ref, ...rest }, children));
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/flex)
 */
const Flex = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__.primitiveWithForwardRef)(FlexPrimitive);
Flex.displayName = 'Flex';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Grid/Grid.mjs":
/*!******************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Grid/Grid.mjs ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Grid: () => (/* binding */ Grid)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");





const GridPrimitive = ({ className, children, ...rest }, ref) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Grid, className), ref: ref, ...rest }, children));
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/grid)
 */
const Grid = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__.primitiveWithForwardRef)(GridPrimitive);
Grid.displayName = 'Grid';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs":
/*!************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Heading/Heading.mjs ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Heading: () => (/* binding */ Heading)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/utils.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");





const headingLevels = {
    1: 'h1',
    2: 'h2',
    3: 'h3',
    4: 'h4',
    5: 'h5',
    6: 'h6',
};
const HeadingPrimitive = ({ className, children, isTruncated, level = 6, ...rest }, ref) => (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: headingLevels[level], className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Heading, (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifier)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Heading, level), (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNameModifierByFlag)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Heading, 'truncated', isTruncated), className), ref: ref, ...rest }, children));
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/heading)
 */
const Heading = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_5__.primitiveWithForwardRef)(HeadingPrimitive);
Heading.displayName = 'Heading';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/HighlightMatch/HighlightMatch.mjs":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/HighlightMatch/HighlightMatch.mjs ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   HighlightMatch: () => (/* binding */ HighlightMatch),
/* harmony export */   HighlightMatchPrimitive: () => (/* binding */ HighlightMatchPrimitive)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _shared_utils_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../shared/utils.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/shared/utils.mjs");
/* harmony import */ var _utils_getUniqueComponentId_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/getUniqueComponentId.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/getUniqueComponentId.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");







const HighlightMatchPrimitive = ({ children, className, query, testId, ...rest }, ref) => {
    const matchTestId = (0,_utils_getUniqueComponentId_mjs__WEBPACK_IMPORTED_MODULE_1__.getUniqueComponentId)(testId, 'match');
    const startIndex = children
        ?.toLocaleLowerCase()
        .indexOf(query?.toLocaleLowerCase());
    if ((0,_shared_utils_mjs__WEBPACK_IMPORTED_MODULE_2__.strHasLength)(query) && startIndex !== -1) {
        const match = children.substring(startIndex, startIndex + query.length);
        return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { as: "span", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_4__.classNames)(className, _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.ComponentClassName.HighlightMatch), testId: testId, ref: ref, ...rest },
            children.substring(0, startIndex),
            react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { as: "strong", className: _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_5__.ComponentClassName.HighlightMatchHighlighted, testId: matchTestId }, match),
            children.substring(startIndex + query.length)));
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_3__.View, { as: "span", testId: testId }, children));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/highlightmatch)
 */
const HighlightMatch = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_6__.primitiveWithForwardRef)(HighlightMatchPrimitive);
HighlightMatch.displayName = 'HighlightMatch';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/Icon.mjs":
/*!******************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/Icon.mjs ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Icon: () => (/* binding */ Icon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");
/* harmony import */ var _utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/primitiveWithForwardRef.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/utils/primitiveWithForwardRef.mjs");





const defaultViewBox = { minX: 0, minY: 0, width: 24, height: 24 };
const IconPrimitive = ({ className, 
// as can be used to render other icon react components too
as = 'svg', fill = 'currentColor', pathData, viewBox = defaultViewBox, children, paths, ...rest }, ref) => {
    const minX = viewBox.minX ? viewBox.minX : defaultViewBox.minX;
    const minY = viewBox.minY ? viewBox.minY : defaultViewBox.minY;
    const width = viewBox.width ? viewBox.width : defaultViewBox.width;
    const height = viewBox.height ? viewBox.height : defaultViewBox.height;
    // An icon can be drawn in 3 ways:
    // 1. Pass it children which should be valid SVG elements
    // 2. Pass an array of path-like objects to `paths` prop
    // 3. Supply `pathData` for a simple icons
    let _children;
    if (children) {
        _children = children;
    }
    if (paths) {
        _children = paths.map((path, index) => react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { ...path, key: index }));
    }
    if (pathData) {
        _children = react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: pathData, fill: fill });
    }
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: as, className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ref: ref, viewBox: `${minX} ${minY} ${width} ${height}`, ...rest }, _children));
};
/**
 * [📖 Docs](https://ui.docs.amplify.aws/react/components/icon)
 */
const Icon = (0,_utils_primitiveWithForwardRef_mjs__WEBPACK_IMPORTED_MODULE_4__.primitiveWithForwardRef)(IconPrimitive);
Icon.displayName = 'Icon';




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/IconsContext.mjs":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/IconsContext.mjs ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconsContext: () => (/* binding */ IconsContext)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);


const IconsContext = react__WEBPACK_IMPORTED_MODULE_0__.createContext({});




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/IconsProvider.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/IconsProvider.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconsProvider: () => (/* binding */ IconsProvider)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _IconsContext_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./IconsContext.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/IconsContext.mjs");



function IconsProvider({ children, icons, }) {
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_IconsContext_mjs__WEBPACK_IMPORTED_MODULE_1__.IconsContext.Provider, { value: icons }, children));
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/useIcons.mjs":
/*!******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/useIcons.mjs ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useIcons: () => (/* binding */ useIcons)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _IconsContext_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./IconsContext.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/context/IconsContext.mjs");



function useIcons(component) {
    const context = react__WEBPACK_IMPORTED_MODULE_0__.useContext(_IconsContext_mjs__WEBPACK_IMPORTED_MODULE_1__.IconsContext);
    if (component && context) {
        return context[component];
    }
    return undefined;
}




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconAdd.mjs":
/*!***************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconAdd.mjs ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconAdd: () => (/* binding */ IconAdd)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconAdd = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M19 13H13V19H11V13H5V11H11V5H13V11H19V13Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconCheck.mjs":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconCheck.mjs ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconCheck: () => (/* binding */ IconCheck)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconCheck = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M9.00016 16.1698L4.83016 11.9998L3.41016 13.4098L9.00016 18.9998L21.0002 6.99984L19.5902 5.58984L9.00016 16.1698Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconCheckCircle.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconCheckCircle.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconCheckCircle: () => (/* binding */ IconCheckCircle)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconCheckCircle = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM12 20C7.59 20 4 16.41 4 12C4 7.59 7.59 4 12 4C16.41 4 20 7.59 20 12C20 16.41 16.41 20 12 20ZM16.59 7.58L10 14.17L7.41 11.59L6 13L10 17L18 9L16.59 7.58Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconChevronLeft.mjs":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconChevronLeft.mjs ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconChevronLeft: () => (/* binding */ IconChevronLeft)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconChevronLeft = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M15.41 7.41L14 6L8 12L14 18L15.41 16.59L10.83 12L15.41 7.41Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconChevronRight.mjs":
/*!************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconChevronRight.mjs ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconChevronRight: () => (/* binding */ IconChevronRight)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconChevronRight = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M9.99984 6L8.58984 7.41L13.1698 12L8.58984 16.59L9.99984 18L15.9998 12L9.99984 6Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconClose.mjs":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconClose.mjs ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconClose: () => (/* binding */ IconClose)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconClose = (props) => {
    const { className, size, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: size ?? '1em', height: size ?? '1em', className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg", style: size ? { width: size, height: size } : undefined },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M19 6.41L17.59 5L12 10.59L6.41 5L5 6.41L10.59 12L5 17.59L6.41 19L12 13.41L17.59 19L19 17.59L13.41 12L19 6.41Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconError.mjs":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconError.mjs ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconError: () => (/* binding */ IconError)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconError = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM13 17H11V15H13V17ZM13 13H11V7H13V13Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconExpandMore.mjs":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconExpandMore.mjs ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconExpandMore: () => (/* binding */ IconExpandMore)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconExpandMore = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M16.59 8.58984L12 13.1698L7.41 8.58984L6 9.99984L12 15.9998L18 9.99984L16.59 8.58984Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconIndeterminate.mjs":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconIndeterminate.mjs ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconIndeterminate: () => (/* binding */ IconIndeterminate)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconIndeterminate = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { xmlns: "http://www.w3.org/2000/svg", height: "24", width: "24", viewBox: "0 0 24 24" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("line", { x1: "4", x2: "20", y1: "12", y2: "12", stroke: "currentColor", strokeWidth: "3" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconInfo.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconInfo.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconInfo: () => (/* binding */ IconInfo)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconInfo = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M11 7H13V9H11V7ZM11 11H13V17H11V11ZM12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM12 20C7.59 20 4 16.41 4 12C4 7.59 7.59 4 12 4C16.41 4 20 7.59 20 12C20 16.41 16.41 20 12 20Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconMenu.mjs":
/*!****************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconMenu.mjs ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconMenu: () => (/* binding */ IconMenu)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconMenu = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M3 18H21V16H3V18ZM3 13H21V11H3V13ZM3 6V8H21V6H3Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconRemove.mjs":
/*!******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconRemove.mjs ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconRemove: () => (/* binding */ IconRemove)
/* harmony export */ });
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconRemove = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", width: "1em", height: "1em", className: (0,_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__.classNames)(_aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__.ComponentClassName.Icon, className), ...rest },
        react__WEBPACK_IMPORTED_MODULE_0__.createElement("svg", { width: "24", height: "24", viewBox: "0 0 24 24", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
            react__WEBPACK_IMPORTED_MODULE_0__.createElement("path", { d: "M19 13H5V11H19V13Z", fill: "currentColor" }))));
};




/***/ }),

/***/ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconSearch.mjs":
/*!******************************************************************************************!*\
  !*** ./node_modules/@aws-amplify/ui-react/dist/esm/primitives/Icon/icons/IconSearch.mjs ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   IconSearch: () => (/* binding */ IconSearch)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/utils/classNames.mjs");
/* harmony import */ var _aws_amplify_ui__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @aws-amplify/ui */ "./node_modules/@aws-amplify/ui/dist/esm/types/primitives/componentClassName.mjs");
/* harmony import */ var _View_View_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../View/View.mjs */ "./node_modules/@aws-amplify/ui-react/dist/esm/primitives/View/View.mjs");




/**
 * @internal For internal Amplify UI use only. May be removed in a future release.
 */
const IconSearch = (props) => {
    const { className, ...rest } = props;
    return (react__WEBPACK_IMPORTED_MODULE_0__.createElement(_View_View_mjs__WEBPACK_IMPORTED_MODULE_1__.View, { as: "span", w