/*
 * Copyright (c) Saga Inc.
 * Distributed under the terms of the GNU Affero General Public License v3.0 License.
 */

import React from 'react';

const NucleausIcon: React.FC<{
    height?: number;
    width?: number;
}> = ({
    height = 20,
    width = 20,
}) => (
    <svg width={width} height={height} viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
        <g fill="currentColor">
            <path d="M18.5775 2.50569L17.3933 1.85818C17.3684 1.84329 17.3461 1.82344 17.3337 1.79616L16.6832 0.61281C16.5715 0.404416 16.353 0 16.1171 0C15.8788 0 15.6628 0.404416 15.5485 0.61281L14.9005 1.79616C14.8856 1.82344 14.8658 1.84329 14.8385 1.85818L13.6542 2.50569C13.4456 2.61981 13.0087 2.83564 13.0087 3.07381C13.0087 3.30949 13.4456 3.52781 13.6542 3.64193L14.8385 4.28944C14.8658 4.30184 14.8856 4.32417 14.9005 4.34898L15.5485 5.53232C15.6628 5.74072 15.8788 6.16746 16.1171 6.16746C16.353 6.16746 16.5715 5.74072 16.6832 5.53232L17.3337 4.34898C17.3461 4.32417 17.3684 4.30184 17.3933 4.28944L18.5775 3.64193C18.7861 3.52781 19.2306 3.30949 19.2306 3.07381C19.2306 2.83564 18.7861 2.61981 18.5775 2.50569Z" />
            <path d="M15.4932 9.95234L12.2462 8.17563C12.1781 8.13478 12.1168 8.08032 12.0828 8.00544L10.2993 4.75843C9.99295 4.18661 9.3939 3.07692 8.7472 3.07692C8.0937 3.07692 7.50145 4.18661 7.18832 4.75843L5.4116 8.00544C5.37075 8.08032 5.3163 8.13478 5.24141 8.17563L1.9944 9.95234C1.42258 10.2655 0.224487 10.8577 0.224487 11.5112C0.224487 12.1579 1.42258 12.757 1.9944 13.0701L5.24141 14.8468C5.3163 14.8809 5.37075 14.9421 5.4116 15.0102L7.18832 18.2572C7.50145 18.829 8.0937 20 8.7472 20C9.3939 20 9.99295 18.829 10.2993 18.2572L12.0828 15.0102C12.1168 14.9421 12.1781 14.8809 12.2462 14.8468L15.4932 13.0701C16.065 12.757 17.2837 12.1579 17.2837 11.5112C17.2837 10.8577 16.065 10.2655 15.4932 9.95234Z" />
        </g>
    </svg>
);

export default NucleausIcon;