from importlib import resources

from yaml import safe_load
from jsonschema import validate


def load_schema():
    schema = resources.files(__package__).joinpath("schema.yaml").read_bytes()

    return safe_load(schema)


def validate_layout(layout):
    return validate(instance=layout, schema=load_schema())
