
### Features
* **TimeCopilotForecaster Class**: Introduced the `TimeCopilotForecaster` class to enhance forecasting capabilities. See [#48](https://github.com/AzulGarza/timecopilot/pull/48). Example:

```python
import pandas as pd

from timecopilot import TimeCopilotForecaster
from timecopilot.models.benchmarks import SeasonalNaive
from timecopilot.models.foundational import TimesFM

df = pd.read_csv(
    "https://timecopilot.s3.amazonaws.com/public/data/algeria_exports.csv", 
    parse_dates=["ds"],
)
forecaster = TimeCopilotForecaster(models=[TimesFM(), SeasonalNaive()])
fcsts_df = forecaster.forecast(df=df, h=12, freq="MS")
```

* **Probabilistic Forecasts**: Added support for probabilistic forecasts in the forecaster class. See [#50](https://github.com/AzulGarza/timecopilot/pull/50). Example:

```python
import pandas as pd

from timecopilot import TimeCopilotForecaster
from timecopilot.models.benchmarks import SeasonalNaive, Prophet
from timecopilot.models.foundational import TimesFM

df = pd.read_csv(
    "https://timecopilot.s3.amazonaws.com/public/data/algeria_exports.csv", 
    parse_dates=["ds"],
)
forecaster = TimeCopilotForecaster(models=[TimesFM(), SeasonalNaive()])
fcsts_df_level = forecaster.forecast(
    df=df, 
    h=12, 
    freq="MS", 
    level=[80, 90],
)
fcsts_df_quantiles = forecaster.forecast(
    df=df, 
    h=12, 
    freq="MS", 
    quantiles=[0.1, 0.9],
)
```

* **Integration with External Libraries**:
    - **timesfm**: Added Google's foundation model [TimesFM](https://github.com/google-research/timesfm). See [#55](https://github.com/AzulGarza/timecopilot/pull/55).
    - **chronos**: Added AWS AI Labs's foundation model [Chronos](https://arxiv.org/abs/2403.07815). See [#59](https://github.com/AzulGarza/timecopilot/pull/59).
    - **Prophet**: Added Facebook's [Prophet](https://facebook.github.io/prophet/) to available models. See [#61](https://github.com/AzulGarza/timecopilot/pull/61).


* **Multi-series Support**: Enhanced the agent to handle multiple time series. See [#64](https://github.com/AzulGarza/timecopilot/pull/64).
    - **Example**:
        ```python
        from timecopilot import TimeCopilot
        
        tc = TimeCopilot()
        # now the forecast method can handle multiple time series
        tc.forecast(...)
        ```

* **Agent Integration**: Utilized the TimeCopilotForecaster class within the agent. See [#65](https://github.com/AzulGarza/timecopilot/pull/65).

### Tests
* **Basic Functionality Tests**: Added tests for basic functionality to ensure reliability. See [#43](https://github.com/AzulGarza/timecopilot/pull/43).

### Fixes
* **CI Improvements**: Implemented a fix to cancel concurrent CI runs, optimizing the CI process. See [#63](https://github.com/AzulGarza/timecopilot/pull/63).