### Features

* **TiRex Foundation Model**: Added the [TiRex](https://github.com/NX-AI/tirex) time series foundation model. See [#77](https://github.com/AzulGarza/timecopilot/pull/77). Example:

```python
import pandas as pd
from timecopilot.models.foundational.tirex import TiRex

df = pd.read_csv(
    "https://timecopilot.s3.amazonaws.com/public/data/algeria_exports.csv", 
    parse_dates=["ds"],
)
model = TiRex()
fcst = model.forecast(df, h=12)
```

* **Toto Model**: Added the [Toto](https://github.com/DataDog/toto) time series model. See [#78](https://github.com/AzulGarza/timecopilot/pull/78). Example:

```python
import pandas as pd
from timecopilot.models.foundational.toto import Toto

df = pd.read_csv(
    "https://timecopilot.s3.amazonaws.com/public/data/algeria_exports.csv", 
    parse_dates=["ds"],
)
model = Toto()
fcst = model.forecast(df, h=12)
```

* **Optional `freq` Parameter**: The `freq` parameter is now optional in all forecast and cross-validation methods. If not provided, frequency is inferred automatically from the data. See [#96](https://github.com/AzulGarza/timecopilot/pull/96). Example:

```python
import pandas as pd
from timecopilot.models.benchmarks import SeasonalNaive

df = pd.read_csv(
    "https://timecopilot.s3.amazonaws.com/public/data/algeria_exports.csv", 
    parse_dates=["ds"],
)
model = SeasonalNaive()
# freq is now optional
fcst = model.forecast(df, h=12)
```

* **Improved Model Docstrings**: All foundational and statistical model constructors are now fully documented, with clear parameter explanations and references to official sources. See [#93](https://github.com/AzulGarza/timecopilot/pull/93) and [#94](https://github.com/AzulGarza/timecopilot/pull/94).

* **Comprehensive Module Docstrings**: Added module-level docstrings to improve API documentation and usability. See [#82](https://github.com/AzulGarza/timecopilot/pull/82).

* **TimeCopilotForecaster Documentation**: Documented the `TimeCopilotForecaster` class, including its constructor and methods, to clarify its unified, multi-model forecasting and cross-validation interface. See [#97](https://github.com/AzulGarza/timecopilot/pull/97). Example:


```python
import pandas as pd
from timecopilot.forecaster import TimeCopilotForecaster
from timecopilot.models.benchmarks.prophet import Prophet
from timecopilot.models.benchmarks.stats import AutoARIMA, SeasonalNaive
from timecopilot.models.foundational.toto import Toto

df = pd.read_csv(
    "https://timecopilot.s3.amazonaws.com/public/data/air_passengers.csv",
    parse_dates=["ds"],
)
tcf = TimeCopilotForecaster(
    models=[
        AutoARIMA(),
        SeasonalNaive(),
        Prophet(),
        Toto(context_length=256),
    ]
)

fcst_df = tcf.forecast(df=df, h=12)
cv_df = tcf.cross_validation(df=df, h=12)
```

### Tests
* **Parallel Test Execution**: Added `pytest-xdist` to enable running tests in parallel, speeding up CI and local test runs. See [#75](https://github.com/AzulGarza/timecopilot/pull/75).

### Fixes

* **Documentation Improvements**: Enhanced documentation for all models and constructors, ensuring clarity and consistency across the codebase. See [#93](https://github.com/AzulGarza/timecopilot/pull/93), [#94](https://github.com/AzulGarza/timecopilot/pull/94), and [#82](https://github.com/AzulGarza/timecopilot/pull/82).

* **S3 Data Source**: All example and test data now use S3 URLs for consistency and reproducibility. See [#73](https://github.com/AzulGarza/timecopilot/pull/73).




**Full Changelog**: https://github.com/AzulGarza/timecopilot/compare/v0.0.10...v0.0.11