### Features

* **Custom seasonalitites**. Added `custom_seasonalities` argument to [`get_seasonality`][timecopilot.models.utils.forecaster.get_seasonality]. See [#147](https://github.com/AzulGarza/timecopilot/pull/147).
    ```python
    from timecopilot.models.utils.forecaster import get_seasonality

    print(get_seasonality("D", custom_seasonalities={"D": 7}))
    # 7
    print(get_seasonality("D")) # default seasonalities are used
    # 1
    ```

* **GIFTEval results concatenation**. Added functionality to concatenate results for different datasets when `GIFTEval(...).evaluate_predictor(...)` is used. See [#148](https://github.com/AzulGarza/timecopilot/pull/148). 
    ```python
    import pandas as pd
    from timecopilot.gift_eval.eval import GIFTEval
    from timecopilot.gift_eval.gluonts_predictor import GluonTSPredictor
    from timecopilot.models.benchmarks import SeasonalNaive

    storage_path = ".pytest_cache/gift_eval"
    GIFTEval.download_data(storage_path)

    predictor = GluonTSPredictor(
        forecaster=SeasonalNaive(),
        batch_size=512,
    )

    def evaluate_predictor(
        dataset_name: str,
        term: str,
        overwrite_results: bool = False,
    ):
        gifteval = GIFTEval(
            dataset_name=dataset_name,
            term=term,
            output_path="./seasonal_naive",
            storage_path=storage_path,
        )
        gifteval.evaluate_predictor(
            predictor,
            batch_size=512,
            overwrite_results=overwrite_results,
        )

    combinations = [
        ("m4_weekly", "short"),
        ("m4_hourly", "short"),
    ]

    for i, (dataset_name, term) in enumerate(combinations):
        evaluate_predictor(
            dataset_name=dataset_name,
            term=term,
        )
    eval_df = pd.read_csv("./seasonal_naive/all_results.csv")
    print(eval_df) # it includes eval for the two datasets

    # you can use overwrite_results to generate a new file of results 
    evaluate_predictor(
        dataset_name="m4_weekly",
        term="short",
        overwrite_results=True
    )
    eval_df = pd.read_csv("./seasonal_naive/all_results.csv")
    print(eval_df) # it includes eval just for m4_weekly
    ```

### Refactorings

* **GIFTEval Module**: Refactored the [GIFTEval](https://github.com/SalesforceAIResearch/gift-eval/) module to infer horizon `h` and frequency `freq` directly from the dataset when calling `GIFTEval(...).evaluate_predictor(...)`. See [#147](https://github.com/AzulGarza/timecopilot/pull/147). New usage:
    ```python
    import pandas as pd
    from timecopilot.gift_eval.eval import GIFTEval
    from timecopilot.gift_eval.gluonts_predictor import GluonTSPredictor
    from timecopilot.models.benchmarks import SeasonalNaive

    storage_path = ".pytest_cache/gift_eval"
    GIFTEval.download_data(storage_path)

    predictor = GluonTSPredictor(
        # you can use any forecaster from TimeCopilot
        # and create your own forecaster by subclassing 
        # [Forecaster][timecopilot.models.utils.forecaster.Forecaster]
        forecaster=SeasonalNaive(),
        batch_size=512,
    )
    gift_eval = GIFTEval(
        dataset_name="m4_daily",
        term="short",
        output_path="./seasonal_naive",
        storage_path=storage_path,
    )
    gift_eval.evaluate_predictor(
        predictor,
        batch_size=512,
    )
    eval_df = pd.read_csv("./seasonal_naive/all_results.csv")
    print(eval_df)
    ```

* **Median ensemble**: Now it applies median plus isotonic regression for probabilistic forecasts. See [#149](https://github.com/AzulGarza/timecopilot/pull/149). 

---

**Full Changelog**: https://github.com/AzulGarza/timecopilot/compare/v0.0.12...v0.0.13