/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use std::sync::Arc;

use async_trait::async_trait;
use reqwest;
use serde::de::Error as _;
use serde::{Deserialize, Serialize};

use super::{configuration, Error};
use crate::apis::{ContentType, ResponseContent};
use crate::models;

#[async_trait]
pub trait CatalogApiApi: Send + Sync {
    /// DELETE /v1/{prefix}/namespaces/{namespace}/tables/{table}/plan/{plan_id}
    ///
    /// Cancels scan planning for a plan-id.  This notifies the service that it can release resources held for the scan. Clients should cancel scans that are no longer needed, either while the plan-id returns a \"submitted\" status or while there are remaining plan tasks that have not been fetched.  Cancellation is not necessary when - Scan tasks for each plan task have been fetched using fetchScanTasks - A plan-id has produced a \"failed\" or \"cancelled\" status from   planTableScan or fetchPlanningResult
    async fn cancel_planning<'namespace, 'table, 'plan_id, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        plan_id: &'plan_id str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<CancelPlanningError>>;

    /// POST /v1/{prefix}/transactions/commit
    ///
    ///
    async fn commit_transaction<'commit_transaction_request, 'prefix>(
        &self,
        commit_transaction_request: models::CommitTransactionRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<CommitTransactionError>>;

    /// POST /v1/{prefix}/namespaces
    ///
    /// Create a namespace, with an optional set of properties. The server might also add properties, such as `last_modified_time` etc.
    async fn create_namespace<'create_namespace_request, 'prefix>(
        &self,
        create_namespace_request: models::CreateNamespaceRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::CreateNamespaceResponse, Error<CreateNamespaceError>>;

    /// POST /v1/{prefix}/namespaces/{namespace}/tables
    ///
    /// Create a table or start a create transaction, like atomic CTAS.  If `stage-create` is false, the table is created immediately.  If `stage-create` is true, the table is not created, but table metadata is initialized and returned. The service should prepare as needed for a commit to the table commit endpoint to complete the create transaction. The client uses the returned metadata to begin a transaction. To commit the transaction, the client sends all create and subsequent changes to the table commit route. Changes from the table create operation include changes like AddSchemaUpdate and SetCurrentSchemaUpdate that set the initial table state.
    async fn create_table<
        'namespace,
        'create_table_request,
        'x_iceberg_access_delegation,
        'prefix,
    >(
        &self,
        namespace: &'namespace str,
        create_table_request: models::CreateTableRequest,
        x_iceberg_access_delegation: Option<&'x_iceberg_access_delegation str>,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadTableResult, Error<CreateTableError>>;

    /// POST /v1/{prefix}/namespaces/{namespace}/views
    ///
    /// Create a view in the given namespace.
    async fn create_view<'namespace, 'create_view_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        create_view_request: models::CreateViewRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadViewResult, Error<CreateViewError>>;

    /// DELETE /v1/{prefix}/namespaces/{namespace}
    ///
    ///
    async fn drop_namespace<'namespace, 'prefix>(
        &self,
        namespace: &'namespace str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<DropNamespaceError>>;

    /// DELETE /v1/{prefix}/namespaces/{namespace}/tables/{table}
    ///
    /// Remove a table from the catalog
    async fn drop_table<'namespace, 'table, 'purge_requested, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        purge_requested: Option<bool>,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<DropTableError>>;

    /// DELETE /v1/{prefix}/namespaces/{namespace}/views/{view}
    ///
    /// Remove a view from the catalog
    async fn drop_view<'namespace, 'view, 'prefix>(
        &self,
        namespace: &'namespace str,
        view: &'view str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<DropViewError>>;

    /// GET /v1/{prefix}/namespaces/{namespace}/tables/{table}/plan/{plan_id}
    ///
    /// Fetches the result of scan planning for a plan-id.  Responses must include a valid status - When \"completed\" the planning operation has produced plan-tasks and   file-scan-tasks that must be returned in the response  - When \"submitted\" the planning operation has not completed; the client   should wait to call this endpoint again to fetch a completed response  - When \"failed\" the response must be a valid error response - When \"cancelled\" the plan-id is invalid and should be discarded  The response for a \"completed\" planning operation includes two types of tasks (file scan tasks and plan tasks) and both may be included in the response. Tasks must not be included for any other response status.
    async fn fetch_planning_result<'namespace, 'table, 'plan_id, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        plan_id: &'plan_id str,
        prefix: Option<&'prefix str>,
    ) -> Result<models::FetchPlanningResult, Error<FetchPlanningResultError>>;

    /// POST /v1/{prefix}/namespaces/{namespace}/tables/{table}/tasks
    ///
    /// Fetches result tasks for a plan task.
    async fn fetch_scan_tasks<'namespace, 'table, 'prefix, 'fetch_scan_tasks_request>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        prefix: Option<&'prefix str>,
        fetch_scan_tasks_request: Option<models::FetchScanTasksRequest>,
    ) -> Result<models::FetchScanTasksResult, Error<FetchScanTasksError>>;

    /// GET /v1/{prefix}/namespaces
    ///
    /// List all namespaces at a certain level, optionally starting from a given parent namespace. If table accounting.tax.paid.info exists, using 'SELECT NAMESPACE IN accounting' would translate into `GET /namespaces?parent=accounting` and must return a namespace, [\"accounting\", \"tax\"] only. Using 'SELECT NAMESPACE IN accounting.tax' would translate into `GET /namespaces?parent=accounting%1Ftax` and must return a namespace, [\"accounting\", \"tax\", \"paid\"]. If `parent` is not provided, all top-level namespaces should be listed.
    async fn list_namespaces<'page_token, 'page_size, 'parent, 'prefix>(
        &self,
        page_token: Option<&'page_token str>,
        page_size: Option<i32>,
        parent: Option<&'parent str>,
        prefix: Option<&'prefix str>,
    ) -> Result<models::ListNamespacesResponse, Error<ListNamespacesError>>;

    /// GET /v1/{prefix}/namespaces/{namespace}/tables
    ///
    /// Return all table identifiers under this namespace
    async fn list_tables<'namespace, 'page_token, 'page_size, 'prefix>(
        &self,
        namespace: &'namespace str,
        page_token: Option<&'page_token str>,
        page_size: Option<i32>,
        prefix: Option<&'prefix str>,
    ) -> Result<models::ListTablesResponse, Error<ListTablesError>>;

    /// GET /v1/{prefix}/namespaces/{namespace}/views
    ///
    /// Return all view identifiers under this namespace
    async fn list_views<'namespace, 'page_token, 'page_size, 'prefix>(
        &self,
        namespace: &'namespace str,
        page_token: Option<&'page_token str>,
        page_size: Option<i32>,
        prefix: Option<&'prefix str>,
    ) -> Result<models::ListTablesResponse, Error<ListViewsError>>;

    /// GET /v1/{prefix}/namespaces/{namespace}/tables/{table}/credentials
    ///
    /// Load vended credentials for a table from the catalog.
    async fn load_credentials<'namespace, 'table, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadCredentialsResponse, Error<LoadCredentialsError>>;

    /// GET /v1/{prefix}/namespaces/{namespace}
    ///
    /// Return all stored metadata properties for a given namespace
    async fn load_namespace_metadata<'namespace, 'prefix>(
        &self,
        namespace: &'namespace str,
        prefix: Option<&'prefix str>,
    ) -> Result<models::GetNamespaceResponse, Error<LoadNamespaceMetadataError>>;

    /// GET /v1/{prefix}/namespaces/{namespace}/tables/{table}
    ///
    /// Load a table from the catalog.  The response contains both configuration and table metadata. The configuration, if non-empty is used as additional configuration for the table that overrides catalog configuration. For example, this configuration may change the FileIO implementation to be used for the table.  The response also contains the table's full metadata, matching the table metadata JSON file.  The catalog configuration may contain credentials that should be used for subsequent requests for the table. The configuration key \"token\" is used to pass an access token to be used as a bearer token for table requests. Otherwise, a token may be passed using a RFC 8693 token type as a configuration key. For example, \"urn:ietf:params:oauth:token-type:jwt=<JWT-token>\".
    async fn load_table<
        'namespace,
        'table,
        'x_iceberg_access_delegation,
        'if_none_match,
        'snapshots,
        'prefix,
    >(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        x_iceberg_access_delegation: Option<&'x_iceberg_access_delegation str>,
        if_none_match: Option<&'if_none_match str>,
        snapshots: Option<&'snapshots str>,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadTableResult, Error<LoadTableError>>;

    /// GET /v1/{prefix}/namespaces/{namespace}/views/{view}
    ///
    /// Load a view from the catalog.  The response contains both configuration and view metadata. The configuration, if non-empty is used as additional configuration for the view that overrides catalog configuration.  The response also contains the view's full metadata, matching the view metadata JSON file.  The catalog configuration may contain credentials that should be used for subsequent requests for the view. The configuration key \"token\" is used to pass an access token to be used as a bearer token for view requests. Otherwise, a token may be passed using a RFC 8693 token type as a configuration key. For example, \"urn:ietf:params:oauth:token-type:jwt=<JWT-token>\".
    async fn load_view<'namespace, 'view, 'prefix>(
        &self,
        namespace: &'namespace str,
        view: &'view str,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadViewResult, Error<LoadViewError>>;

    /// HEAD /v1/{prefix}/namespaces/{namespace}
    ///
    /// Check if a namespace exists. The response does not contain a body.
    async fn namespace_exists<'namespace, 'prefix>(
        &self,
        namespace: &'namespace str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<NamespaceExistsError>>;

    /// POST /v1/{prefix}/namespaces/{namespace}/tables/{table}/plan
    ///
    /// Submits a scan for server-side planning.  Point-in-time scans are planned by passing snapshot-id to identify the table snapshot to scan. Incremental scans are planned by passing both start-snapshot-id and end-snapshot-id. Requests that include both point in time config properties and incremental config properties are invalid. If the request does not include either incremental or point-in-time config properties, scan planning should produce a point-in-time scan of the latest snapshot in the table's main branch.  Responses must include a valid status listed below. A \"cancelled\" status is considered invalid for this endpoint.   - When \"completed\" the planning operation has produced plan tasks and   file scan tasks that must be returned in the response (not fetched   later by calling fetchPlanningResult)  - When \"submitted\" the response must include a plan-id used to poll   fetchPlanningResult to fetch the planning result when it is ready  - When \"failed\" the response must be a valid error response The response for a \"completed\" planning operation includes two types of tasks (file scan tasks and plan tasks) and both may be included in the response. Tasks must not be included for any other response status.  Responses that include a plan-id indicate that the service is holding state or performing work for the client.  - Clients should use the plan-id to fetch results from   fetchPlanningResult when the response status is \"submitted\"  - Clients should inform the service if planning results are no longer   needed by calling cancelPlanning. Cancellation is not necessary after   fetchScanTasks has been used to fetch scan tasks for each plan task.
    async fn plan_table_scan<'namespace, 'table, 'prefix, 'plan_table_scan_request>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        prefix: Option<&'prefix str>,
        plan_table_scan_request: Option<models::PlanTableScanRequest>,
    ) -> Result<models::PlanTableScanResult, Error<PlanTableScanError>>;

    /// POST /v1/{prefix}/namespaces/{namespace}/register
    ///
    /// Register a table using given metadata file location.
    async fn register_table<'namespace, 'register_table_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        register_table_request: models::RegisterTableRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadTableResult, Error<RegisterTableError>>;

    /// POST /v1/{prefix}/tables/rename
    ///
    /// Rename a table from one identifier to another. It's valid to move a table across namespaces, but the server implementation is not required to support it.
    async fn rename_table<'rename_table_request, 'prefix>(
        &self,
        rename_table_request: models::RenameTableRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<RenameTableError>>;

    /// POST /v1/{prefix}/views/rename
    ///
    /// Rename a view from one identifier to another. It's valid to move a view across namespaces, but the server implementation is not required to support it.
    async fn rename_view<'rename_table_request, 'prefix>(
        &self,
        rename_table_request: models::RenameTableRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<RenameViewError>>;

    /// POST /v1/{prefix}/namespaces/{namespace}/views/{view}
    ///
    /// Commit updates to a view.
    async fn replace_view<'namespace, 'view, 'commit_view_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        view: &'view str,
        commit_view_request: models::CommitViewRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadViewResult, Error<ReplaceViewError>>;

    /// POST /v1/{prefix}/namespaces/{namespace}/tables/{table}/metrics
    ///
    ///
    async fn report_metrics<'namespace, 'table, 'report_metrics_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        report_metrics_request: models::ReportMetricsRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<ReportMetricsError>>;

    /// HEAD /v1/{prefix}/namespaces/{namespace}/tables/{table}
    ///
    /// Check if a table exists within a given namespace. The response does not contain a body.
    async fn table_exists<'namespace, 'table, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<TableExistsError>>;

    /// POST /v1/{prefix}/namespaces/{namespace}/properties
    ///
    /// Set and/or remove properties on a namespace. The request body specifies a list of properties to remove and a map of key value pairs to update. Properties that are not in the request are not modified or removed by this call. Server implementations are not required to support namespace properties.
    async fn update_properties<'namespace, 'update_namespace_properties_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        update_namespace_properties_request: models::UpdateNamespacePropertiesRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::UpdateNamespacePropertiesResponse, Error<UpdatePropertiesError>>;

    /// POST /v1/{prefix}/namespaces/{namespace}/tables/{table}
    ///
    /// Commit updates to a table.  Commits have two parts, requirements and updates. Requirements are assertions that will be validated before attempting to make and commit changes. For example, `assert-ref-snapshot-id` will check that a named ref's snapshot ID has a certain value. Server implementations are required to fail with a 400 status code if any unknown updates or requirements are received.  Updates are changes to make to table metadata. For example, after asserting that the current main ref is at the expected snapshot, a commit may add a new child snapshot and set the ref to the new snapshot id.  Create table transactions that are started by createTable with `stage-create` set to true are committed using this route. Transactions should include all changes to the table, including table initialization, like AddSchemaUpdate and SetCurrentSchemaUpdate. The `assert-create` requirement is used to ensure that the table was not created concurrently.
    async fn update_table<'namespace, 'table, 'commit_table_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        commit_table_request: models::CommitTableRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::CommitTableResponse, Error<UpdateTableError>>;

    /// HEAD /v1/{prefix}/namespaces/{namespace}/views/{view}
    ///
    /// Check if a view exists within a given namespace. This request does not return a response body.
    async fn view_exists<'namespace, 'view, 'prefix>(
        &self,
        namespace: &'namespace str,
        view: &'view str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<ViewExistsError>>;
}

pub struct CatalogApiApiClient {
    configuration: Arc<configuration::Configuration>,
}

impl CatalogApiApiClient {
    pub fn new(configuration: Arc<configuration::Configuration>) -> Self {
        Self { configuration }
    }
}

#[async_trait]
impl CatalogApiApi for CatalogApiApiClient {
    /// Cancels scan planning for a plan-id.  This notifies the service that it can release resources held for the scan. Clients should cancel scans that are no longer needed, either while the plan-id returns a \"submitted\" status or while there are remaining plan tasks that have not been fetched.  Cancellation is not necessary when - Scan tasks for each plan task have been fetched using fetchScanTasks - A plan-id has produced a \"failed\" or \"cancelled\" status from   planTableScan or fetchPlanningResult
    async fn cancel_planning<'namespace, 'table, 'plan_id, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        plan_id: &'plan_id str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<CancelPlanningError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables/{table}/plan/{plan_id}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            table = crate::apis::urlencode(table),
            plan_id = crate::apis::urlencode(plan_id)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<CancelPlanningError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    async fn commit_transaction<'commit_transaction_request, 'prefix>(
        &self,
        commit_transaction_request: models::CommitTransactionRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<CommitTransactionError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/transactions/commit",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default()
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&commit_transaction_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<CommitTransactionError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Create a namespace, with an optional set of properties. The server might also add properties, such as `last_modified_time` etc.
    async fn create_namespace<'create_namespace_request, 'prefix>(
        &self,
        create_namespace_request: models::CreateNamespaceRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::CreateNamespaceResponse, Error<CreateNamespaceError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default()
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&create_namespace_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::CreateNamespaceResponse`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::CreateNamespaceResponse`")))),
            }
        } else {
            let local_var_entity: Option<CreateNamespaceError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Create a table or start a create transaction, like atomic CTAS.  If `stage-create` is false, the table is created immediately.  If `stage-create` is true, the table is not created, but table metadata is initialized and returned. The service should prepare as needed for a commit to the table commit endpoint to complete the create transaction. The client uses the returned metadata to begin a transaction. To commit the transaction, the client sends all create and subsequent changes to the table commit route. Changes from the table create operation include changes like AddSchemaUpdate and SetCurrentSchemaUpdate that set the initial table state.
    async fn create_table<
        'namespace,
        'create_table_request,
        'x_iceberg_access_delegation,
        'prefix,
    >(
        &self,
        namespace: &'namespace str,
        create_table_request: models::CreateTableRequest,
        x_iceberg_access_delegation: Option<&'x_iceberg_access_delegation str>,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadTableResult, Error<CreateTableError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(local_var_param_value) = x_iceberg_access_delegation {
            local_var_req_builder = local_var_req_builder.header(
                "X-Iceberg-Access-Delegation",
                local_var_param_value.to_string(),
            );
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&create_table_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::LoadTableResult`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::LoadTableResult`")))),
            }
        } else {
            let local_var_entity: Option<CreateTableError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Create a view in the given namespace.
    async fn create_view<'namespace, 'create_view_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        create_view_request: models::CreateViewRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadViewResult, Error<CreateViewError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/views",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&create_view_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::LoadViewResult`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::LoadViewResult`")))),
            }
        } else {
            let local_var_entity: Option<CreateViewError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    async fn drop_namespace<'namespace, 'prefix>(
        &self,
        namespace: &'namespace str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<DropNamespaceError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<DropNamespaceError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Remove a table from the catalog
    async fn drop_table<'namespace, 'table, 'purge_requested, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        purge_requested: Option<bool>,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<DropTableError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables/{table}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            table = crate::apis::urlencode(table)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

        if let Some(ref param_value) = purge_requested {
            local_var_req_builder =
                local_var_req_builder.query(&[("purgeRequested", &param_value.to_string())]);
        }
        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<DropTableError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Remove a view from the catalog
    async fn drop_view<'namespace, 'view, 'prefix>(
        &self,
        namespace: &'namespace str,
        view: &'view str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<DropViewError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/views/{view}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            view = crate::apis::urlencode(view)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<DropViewError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Fetches the result of scan planning for a plan-id.  Responses must include a valid status - When \"completed\" the planning operation has produced plan-tasks and   file-scan-tasks that must be returned in the response  - When \"submitted\" the planning operation has not completed; the client   should wait to call this endpoint again to fetch a completed response  - When \"failed\" the response must be a valid error response - When \"cancelled\" the plan-id is invalid and should be discarded  The response for a \"completed\" planning operation includes two types of tasks (file scan tasks and plan tasks) and both may be included in the response. Tasks must not be included for any other response status.
    async fn fetch_planning_result<'namespace, 'table, 'plan_id, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        plan_id: &'plan_id str,
        prefix: Option<&'prefix str>,
    ) -> Result<models::FetchPlanningResult, Error<FetchPlanningResultError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables/{table}/plan/{plan_id}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            table = crate::apis::urlencode(table),
            plan_id = crate::apis::urlencode(plan_id)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::FetchPlanningResult`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::FetchPlanningResult`")))),
            }
        } else {
            let local_var_entity: Option<FetchPlanningResultError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Fetches result tasks for a plan task.
    async fn fetch_scan_tasks<'namespace, 'table, 'prefix, 'fetch_scan_tasks_request>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        prefix: Option<&'prefix str>,
        fetch_scan_tasks_request: Option<models::FetchScanTasksRequest>,
    ) -> Result<models::FetchScanTasksResult, Error<FetchScanTasksError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables/{table}/tasks",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            table = crate::apis::urlencode(table)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&fetch_scan_tasks_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::FetchScanTasksResult`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::FetchScanTasksResult`")))),
            }
        } else {
            let local_var_entity: Option<FetchScanTasksError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// List all namespaces at a certain level, optionally starting from a given parent namespace. If table accounting.tax.paid.info exists, using 'SELECT NAMESPACE IN accounting' would translate into `GET /namespaces?parent=accounting` and must return a namespace, [\"accounting\", \"tax\"] only. Using 'SELECT NAMESPACE IN accounting.tax' would translate into `GET /namespaces?parent=accounting%1Ftax` and must return a namespace, [\"accounting\", \"tax\", \"paid\"]. If `parent` is not provided, all top-level namespaces should be listed.
    async fn list_namespaces<'page_token, 'page_size, 'parent, 'prefix>(
        &self,
        page_token: Option<&'page_token str>,
        page_size: Option<i32>,
        parent: Option<&'parent str>,
        prefix: Option<&'prefix str>,
    ) -> Result<models::ListNamespacesResponse, Error<ListNamespacesError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default()
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

        if let Some(ref param_value) = page_token {
            local_var_req_builder =
                local_var_req_builder.query(&[("pageToken", &param_value.to_string())]);
        }
        if let Some(ref param_value) = page_size {
            local_var_req_builder =
                local_var_req_builder.query(&[("pageSize", &param_value.to_string())]);
        }
        if let Some(ref param_value) = parent {
            local_var_req_builder =
                local_var_req_builder.query(&[("parent", &param_value.to_string())]);
        }
        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::ListNamespacesResponse`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::ListNamespacesResponse`")))),
            }
        } else {
            let local_var_entity: Option<ListNamespacesError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Return all table identifiers under this namespace
    async fn list_tables<'namespace, 'page_token, 'page_size, 'prefix>(
        &self,
        namespace: &'namespace str,
        page_token: Option<&'page_token str>,
        page_size: Option<i32>,
        prefix: Option<&'prefix str>,
    ) -> Result<models::ListTablesResponse, Error<ListTablesError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

        if let Some(ref param_value) = page_token {
            local_var_req_builder =
                local_var_req_builder.query(&[("pageToken", &param_value.to_string())]);
        }
        if let Some(ref param_value) = page_size {
            local_var_req_builder =
                local_var_req_builder.query(&[("pageSize", &param_value.to_string())]);
        }
        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::ListTablesResponse`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::ListTablesResponse`")))),
            }
        } else {
            let local_var_entity: Option<ListTablesError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Return all view identifiers under this namespace
    async fn list_views<'namespace, 'page_token, 'page_size, 'prefix>(
        &self,
        namespace: &'namespace str,
        page_token: Option<&'page_token str>,
        page_size: Option<i32>,
        prefix: Option<&'prefix str>,
    ) -> Result<models::ListTablesResponse, Error<ListViewsError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/views",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

        if let Some(ref param_value) = page_token {
            local_var_req_builder =
                local_var_req_builder.query(&[("pageToken", &param_value.to_string())]);
        }
        if let Some(ref param_value) = page_size {
            local_var_req_builder =
                local_var_req_builder.query(&[("pageSize", &param_value.to_string())]);
        }
        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::ListTablesResponse`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::ListTablesResponse`")))),
            }
        } else {
            let local_var_entity: Option<ListViewsError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Load vended credentials for a table from the catalog.
    async fn load_credentials<'namespace, 'table, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadCredentialsResponse, Error<LoadCredentialsError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables/{table}/credentials",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            table = crate::apis::urlencode(table)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::LoadCredentialsResponse`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::LoadCredentialsResponse`")))),
            }
        } else {
            let local_var_entity: Option<LoadCredentialsError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Return all stored metadata properties for a given namespace
    async fn load_namespace_metadata<'namespace, 'prefix>(
        &self,
        namespace: &'namespace str,
        prefix: Option<&'prefix str>,
    ) -> Result<models::GetNamespaceResponse, Error<LoadNamespaceMetadataError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::GetNamespaceResponse`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::GetNamespaceResponse`")))),
            }
        } else {
            let local_var_entity: Option<LoadNamespaceMetadataError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Load a table from the catalog.  The response contains both configuration and table metadata. The configuration, if non-empty is used as additional configuration for the table that overrides catalog configuration. For example, this configuration may change the FileIO implementation to be used for the table.  The response also contains the table's full metadata, matching the table metadata JSON file.  The catalog configuration may contain credentials that should be used for subsequent requests for the table. The configuration key \"token\" is used to pass an access token to be used as a bearer token for table requests. Otherwise, a token may be passed using a RFC 8693 token type as a configuration key. For example, \"urn:ietf:params:oauth:token-type:jwt=<JWT-token>\".
    async fn load_table<
        'namespace,
        'table,
        'x_iceberg_access_delegation,
        'if_none_match,
        'snapshots,
        'prefix,
    >(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        x_iceberg_access_delegation: Option<&'x_iceberg_access_delegation str>,
        if_none_match: Option<&'if_none_match str>,
        snapshots: Option<&'snapshots str>,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadTableResult, Error<LoadTableError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables/{table}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            table = crate::apis::urlencode(table)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

        if let Some(ref param_value) = snapshots {
            local_var_req_builder =
                local_var_req_builder.query(&[("snapshots", &param_value.to_string())]);
        }
        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(local_var_param_value) = x_iceberg_access_delegation {
            local_var_req_builder = local_var_req_builder.header(
                "X-Iceberg-Access-Delegation",
                local_var_param_value.to_string(),
            );
        }
        if let Some(local_var_param_value) = if_none_match {
            local_var_req_builder =
                local_var_req_builder.header("If-None-Match", local_var_param_value.to_string());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::LoadTableResult`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::LoadTableResult`")))),
            }
        } else {
            let local_var_entity: Option<LoadTableError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Load a view from the catalog.  The response contains both configuration and view metadata. The configuration, if non-empty is used as additional configuration for the view that overrides catalog configuration.  The response also contains the view's full metadata, matching the view metadata JSON file.  The catalog configuration may contain credentials that should be used for subsequent requests for the view. The configuration key \"token\" is used to pass an access token to be used as a bearer token for view requests. Otherwise, a token may be passed using a RFC 8693 token type as a configuration key. For example, \"urn:ietf:params:oauth:token-type:jwt=<JWT-token>\".
    async fn load_view<'namespace, 'view, 'prefix>(
        &self,
        namespace: &'namespace str,
        view: &'view str,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadViewResult, Error<LoadViewError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/views/{view}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            view = crate::apis::urlencode(view)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::LoadViewResult`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::LoadViewResult`")))),
            }
        } else {
            let local_var_entity: Option<LoadViewError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Check if a namespace exists. The response does not contain a body.
    async fn namespace_exists<'namespace, 'prefix>(
        &self,
        namespace: &'namespace str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<NamespaceExistsError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::HEAD, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<NamespaceExistsError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Submits a scan for server-side planning.  Point-in-time scans are planned by passing snapshot-id to identify the table snapshot to scan. Incremental scans are planned by passing both start-snapshot-id and end-snapshot-id. Requests that include both point in time config properties and incremental config properties are invalid. If the request does not include either incremental or point-in-time config properties, scan planning should produce a point-in-time scan of the latest snapshot in the table's main branch.  Responses must include a valid status listed below. A \"cancelled\" status is considered invalid for this endpoint.   - When \"completed\" the planning operation has produced plan tasks and   file scan tasks that must be returned in the response (not fetched   later by calling fetchPlanningResult)  - When \"submitted\" the response must include a plan-id used to poll   fetchPlanningResult to fetch the planning result when it is ready  - When \"failed\" the response must be a valid error response The response for a \"completed\" planning operation includes two types of tasks (file scan tasks and plan tasks) and both may be included in the response. Tasks must not be included for any other response status.  Responses that include a plan-id indicate that the service is holding state or performing work for the client.  - Clients should use the plan-id to fetch results from   fetchPlanningResult when the response status is \"submitted\"  - Clients should inform the service if planning results are no longer   needed by calling cancelPlanning. Cancellation is not necessary after   fetchScanTasks has been used to fetch scan tasks for each plan task.
    async fn plan_table_scan<'namespace, 'table, 'prefix, 'plan_table_scan_request>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        prefix: Option<&'prefix str>,
        plan_table_scan_request: Option<models::PlanTableScanRequest>,
    ) -> Result<models::PlanTableScanResult, Error<PlanTableScanError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables/{table}/plan",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            table = crate::apis::urlencode(table)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&plan_table_scan_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::PlanTableScanResult`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::PlanTableScanResult`")))),
            }
        } else {
            let local_var_entity: Option<PlanTableScanError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Register a table using given metadata file location.
    async fn register_table<'namespace, 'register_table_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        register_table_request: models::RegisterTableRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadTableResult, Error<RegisterTableError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/register",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&register_table_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::LoadTableResult`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::LoadTableResult`")))),
            }
        } else {
            let local_var_entity: Option<RegisterTableError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Rename a table from one identifier to another. It's valid to move a table across namespaces, but the server implementation is not required to support it.
    async fn rename_table<'rename_table_request, 'prefix>(
        &self,
        rename_table_request: models::RenameTableRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<RenameTableError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/tables/rename",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default()
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&rename_table_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<RenameTableError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Rename a view from one identifier to another. It's valid to move a view across namespaces, but the server implementation is not required to support it.
    async fn rename_view<'rename_table_request, 'prefix>(
        &self,
        rename_table_request: models::RenameTableRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<RenameViewError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/views/rename",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default()
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&rename_table_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<RenameViewError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Commit updates to a view.
    async fn replace_view<'namespace, 'view, 'commit_view_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        view: &'view str,
        commit_view_request: models::CommitViewRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::LoadViewResult, Error<ReplaceViewError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/views/{view}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            view = crate::apis::urlencode(view)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&commit_view_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::LoadViewResult`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::LoadViewResult`")))),
            }
        } else {
            let local_var_entity: Option<ReplaceViewError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    async fn report_metrics<'namespace, 'table, 'report_metrics_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        report_metrics_request: models::ReportMetricsRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<ReportMetricsError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables/{table}/metrics",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            table = crate::apis::urlencode(table)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&report_metrics_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<ReportMetricsError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Check if a table exists within a given namespace. The response does not contain a body.
    async fn table_exists<'namespace, 'table, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<TableExistsError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables/{table}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            table = crate::apis::urlencode(table)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::HEAD, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<TableExistsError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Set and/or remove properties on a namespace. The request body specifies a list of properties to remove and a map of key value pairs to update. Properties that are not in the request are not modified or removed by this call. Server implementations are not required to support namespace properties.
    async fn update_properties<'namespace, 'update_namespace_properties_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        update_namespace_properties_request: models::UpdateNamespacePropertiesRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::UpdateNamespacePropertiesResponse, Error<UpdatePropertiesError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/properties",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&update_namespace_properties_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::UpdateNamespacePropertiesResponse`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::UpdateNamespacePropertiesResponse`")))),
            }
        } else {
            let local_var_entity: Option<UpdatePropertiesError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Commit updates to a table.  Commits have two parts, requirements and updates. Requirements are assertions that will be validated before attempting to make and commit changes. For example, `assert-ref-snapshot-id` will check that a named ref's snapshot ID has a certain value. Server implementations are required to fail with a 400 status code if any unknown updates or requirements are received.  Updates are changes to make to table metadata. For example, after asserting that the current main ref is at the expected snapshot, a commit may add a new child snapshot and set the ref to the new snapshot id.  Create table transactions that are started by createTable with `stage-create` set to true are committed using this route. Transactions should include all changes to the table, including table initialization, like AddSchemaUpdate and SetCurrentSchemaUpdate. The `assert-create` requirement is used to ensure that the table was not created concurrently.
    async fn update_table<'namespace, 'table, 'commit_table_request, 'prefix>(
        &self,
        namespace: &'namespace str,
        table: &'table str,
        commit_table_request: models::CommitTableRequest,
        prefix: Option<&'prefix str>,
    ) -> Result<models::CommitTableResponse, Error<UpdateTableError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/tables/{table}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            table = crate::apis::urlencode(table)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        local_var_req_builder = local_var_req_builder.json(&commit_table_request);

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content_type = local_var_resp
            .headers()
            .get("content-type")
            .and_then(|v| v.to_str().ok())
            .unwrap_or("application/octet-stream");
        let local_var_content_type = super::ContentType::from(local_var_content_type);
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            match local_var_content_type {
                ContentType::Json => serde_json::from_str(&local_var_content).map_err(Error::from),
                ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::CommitTableResponse`"))),
                ContentType::Unsupported(local_var_unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{local_var_unknown_type}` content type response that cannot be converted to `models::CommitTableResponse`")))),
            }
        } else {
            let local_var_entity: Option<UpdateTableError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }

    /// Check if a view exists within a given namespace. This request does not return a response body.
    async fn view_exists<'namespace, 'view, 'prefix>(
        &self,
        namespace: &'namespace str,
        view: &'view str,
        prefix: Option<&'prefix str>,
    ) -> Result<(), Error<ViewExistsError>> {
        let local_var_configuration = &self.configuration;

        let local_var_client = &local_var_configuration.client;

        let local_var_uri_str = format!(
            "{}/v1{prefix}/namespaces/{namespace}/views/{view}",
            local_var_configuration.base_path,
            prefix = prefix
                .map(|p| format!("/{}", crate::apis::urlencode(p)))
                .unwrap_or_default(),
            namespace = crate::apis::urlencode(namespace),
            view = crate::apis::urlencode(view)
        );
        let mut local_var_req_builder =
            local_var_client.request(reqwest::Method::HEAD, local_var_uri_str.as_str());

        if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
            local_var_req_builder = local_var_req_builder
                .header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
        }
        if let Some(ref local_var_token) = local_var_configuration.oauth_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };
        if let Some(ref local_var_token) = local_var_configuration.bearer_access_token {
            local_var_req_builder = local_var_req_builder.bearer_auth(local_var_token.to_owned());
        };

        let local_var_req = local_var_req_builder.build()?;
        let local_var_resp = local_var_client.execute(local_var_req).await?;

        let local_var_status = local_var_resp.status();
        let local_var_content = local_var_resp.text().await?;

        if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
            Ok(())
        } else {
            let local_var_entity: Option<ViewExistsError> =
                serde_json::from_str(&local_var_content).ok();
            let local_var_error = ResponseContent {
                status: local_var_status,
                content: local_var_content,
                entity: local_var_entity,
            };
            Err(Error::ResponseError(local_var_error))
        }
    }
}

/// struct for typed errors of method [`CatalogApiApi::cancel_planning`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CancelPlanningError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::commit_transaction`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CommitTransactionError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status409(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status500(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status502(models::IcebergErrorResponse),
    Status504(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::create_namespace`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateNamespaceError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status406(models::ErrorModel),
    Status409(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::create_table`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateTableError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status409(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::create_view`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum CreateViewError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::ErrorModel),
    Status409(models::ErrorModel),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::drop_namespace`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DropNamespaceError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status409(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::drop_table`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DropTableError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::drop_view`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum DropViewError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::ErrorModel),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::fetch_planning_result`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum FetchPlanningResultError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::fetch_scan_tasks`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum FetchScanTasksError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::list_namespaces`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListNamespacesError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::list_tables`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListTablesError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::list_views`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ListViewsError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::ErrorModel),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::load_credentials`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum LoadCredentialsError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::load_namespace_metadata`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum LoadNamespaceMetadataError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::load_table`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum LoadTableError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::load_view`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum LoadViewError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::ErrorModel),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::namespace_exists`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum NamespaceExistsError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::plan_table_scan`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PlanTableScanError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status406(models::ErrorModel),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::register_table`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RegisterTableError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status409(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::rename_table`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RenameTableError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status406(models::ErrorModel),
    Status409(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::rename_view`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum RenameViewError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::ErrorModel),
    Status406(models::ErrorModel),
    Status409(models::ErrorModel),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::replace_view`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ReplaceViewError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::ErrorModel),
    Status409(models::ErrorModel),
    Status419(models::IcebergErrorResponse),
    Status500(models::ErrorModel),
    Status503(models::IcebergErrorResponse),
    Status502(models::ErrorModel),
    Status504(models::ErrorModel),
    Status5XX(models::ErrorModel),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::report_metrics`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ReportMetricsError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::table_exists`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TableExistsError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::update_properties`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdatePropertiesError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status406(models::ErrorModel),
    Status422(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::update_table`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum UpdateTableError {
    Status400(models::IcebergErrorResponse),
    Status401(models::IcebergErrorResponse),
    Status403(models::IcebergErrorResponse),
    Status404(models::IcebergErrorResponse),
    Status409(models::IcebergErrorResponse),
    Status419(models::IcebergErrorResponse),
    Status500(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status502(models::IcebergErrorResponse),
    Status504(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`CatalogApiApi::view_exists`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ViewExistsError {
    Status400(),
    Status401(),
    Status404(),
    Status419(models::IcebergErrorResponse),
    Status503(models::IcebergErrorResponse),
    Status5XX(models::IcebergErrorResponse),
    UnknownValue(serde_json::Value),
}
