/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

/// AssertCurrentSchemaId : The table's current schema id must match the requirement's `current-schema-id`
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct AssertCurrentSchemaId {
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub r#type: Option<String>,
    #[serde(rename = "current-schema-id")]
    pub current_schema_id: i32,
}

impl AssertCurrentSchemaId {
    /// The table's current schema id must match the requirement's `current-schema-id`
    pub fn new(current_schema_id: i32) -> AssertCurrentSchemaId {
        AssertCurrentSchemaId {
            r#type: None,
            current_schema_id,
        }
    }
}
