/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

/// AssertRefSnapshotId : The table branch or tag identified by the requirement's `ref` must reference the requirement's `snapshot-id`. The `snapshot-id` field is required in this object, but in the case of a `null` the ref must not already exist.
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct AssertRefSnapshotId {
    #[serde(rename = "type", skip_serializing_if = "Option::is_none")]
    pub r#type: Option<String>,
    #[serde(rename = "ref")]
    pub r#ref: String,
    #[serde(rename = "snapshot-id")]
    pub snapshot_id: i64,
}

impl AssertRefSnapshotId {
    /// The table branch or tag identified by the requirement's `ref` must reference the requirement's `snapshot-id`. The `snapshot-id` field is required in this object, but in the case of a `null` the ref must not already exist.
    pub fn new(r#ref: String, snapshot_id: i64) -> AssertRefSnapshotId {
        AssertRefSnapshotId {
            r#type: None,
            r#ref,
            snapshot_id,
        }
    }
}
