/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct AsyncPlanningResult {
    #[serde(rename = "status")]
    pub status: models::PlanStatus,
    /// ID used to track a planning request
    #[serde(rename = "plan-id", skip_serializing_if = "Option::is_none")]
    pub plan_id: Option<String>,
}

impl AsyncPlanningResult {
    pub fn new(status: models::PlanStatus) -> AsyncPlanningResult {
        AsyncPlanningResult {
            status,
            plan_id: None,
        }
    }
}
