/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[serde(tag = "action")]
pub enum BaseUpdate {
    #[serde(rename = "add-encryption-key")]
    AddEncryptionKeyUpdate {},
    #[serde(rename = "add-schema")]
    AddSchemaUpdate {},
    #[serde(rename = "add-snapshot")]
    AddSnapshotUpdate {},
    #[serde(rename = "add-sort-order")]
    AddSortOrderUpdate {},
    #[serde(rename = "add-spec")]
    AddPartitionSpecUpdate {},
    #[serde(rename = "add-view-version")]
    AddViewVersionUpdate {},
    #[serde(rename = "assign-uuid")]
    AssignUuidUpdate {},
    #[serde(rename = "remove-encryption-key")]
    RemoveEncryptionKeyUpdate {},
    #[serde(rename = "remove-partition-specs")]
    RemovePartitionSpecsUpdate {},
    #[serde(rename = "remove-partition-statistics")]
    RemovePartitionStatisticsUpdate {},
    #[serde(rename = "remove-properties")]
    RemovePropertiesUpdate {},
    #[serde(rename = "remove-schemas")]
    RemoveSchemasUpdate {},
    #[serde(rename = "remove-snapshot-ref")]
    RemoveSnapshotRefUpdate {},
    #[serde(rename = "remove-snapshots")]
    RemoveSnapshotsUpdate {},
    #[serde(rename = "remove-statistics")]
    RemoveStatisticsUpdate {},
    #[serde(rename = "set-current-schema")]
    SetCurrentSchemaUpdate {},
    #[serde(rename = "set-current-view-version")]
    SetCurrentViewVersionUpdate {},
    #[serde(rename = "set-default-sort-order")]
    SetDefaultSortOrderUpdate {},
    #[serde(rename = "set-default-spec")]
    SetDefaultSpecUpdate {},
    #[serde(rename = "set-location")]
    SetLocationUpdate {},
    #[serde(rename = "set-partition-statistics")]
    SetPartitionStatisticsUpdate {},
    #[serde(rename = "set-properties")]
    SetPropertiesUpdate {},
    #[serde(rename = "set-snapshot-ref")]
    SetSnapshotRefUpdate {},
    #[serde(rename = "set-statistics")]
    SetStatisticsUpdate {},
    #[serde(rename = "upgrade-format-version")]
    UpgradeFormatVersionUpdate {},
}

impl Default for BaseUpdate {
    fn default() -> Self {
        Self::AddEncryptionKeyUpdate {}
    }
}
