/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct BlobMetadata {
    #[serde(rename = "type")]
    pub r#type: String,
    #[serde(rename = "snapshot-id")]
    pub snapshot_id: i64,
    #[serde(rename = "sequence-number")]
    pub sequence_number: i64,
    #[serde(rename = "fields")]
    pub fields: Vec<i32>,
    #[serde(rename = "properties", skip_serializing_if = "Option::is_none")]
    pub properties: Option<std::collections::HashMap<String, String>>,
}

impl BlobMetadata {
    pub fn new(
        r#type: String,
        snapshot_id: i64,
        sequence_number: i64,
        fields: Vec<i32>,
    ) -> BlobMetadata {
        BlobMetadata {
            r#type,
            snapshot_id,
            sequence_number,
            fields,
            properties: None,
        }
    }
}
