/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

/// CatalogConfig : Server-provided configuration for the catalog.
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct CatalogConfig {
    /// Properties that should be used to override client configuration; applied after defaults and client configuration.
    #[serde(rename = "overrides")]
    pub overrides: std::collections::HashMap<String, String>,
    /// Properties that should be used as default configuration; applied before client configuration.
    #[serde(rename = "defaults")]
    pub defaults: std::collections::HashMap<String, String>,
    /// A list of endpoints that the server supports. The format of each endpoint must be \"<HTTP verb> <resource path from OpenAPI REST spec>\". The HTTP verb and the resource path must be separated by a space character.
    #[serde(rename = "endpoints", skip_serializing_if = "Option::is_none")]
    pub endpoints: Option<Vec<String>>,
}

impl CatalogConfig {
    /// Server-provided configuration for the catalog.
    pub fn new(
        overrides: std::collections::HashMap<String, String>,
        defaults: std::collections::HashMap<String, String>,
    ) -> CatalogConfig {
        CatalogConfig {
            overrides,
            defaults,
            endpoints: None,
        }
    }
}
