/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommitReport {
    #[serde(rename = "table-name")]
    pub table_name: String,
    #[serde(rename = "snapshot-id")]
    pub snapshot_id: i64,
    #[serde(rename = "sequence-number")]
    pub sequence_number: i64,
    #[serde(rename = "operation")]
    pub operation: String,
    #[serde(rename = "metrics")]
    pub metrics: std::collections::HashMap<String, models::MetricResult>,
    #[serde(rename = "metadata", skip_serializing_if = "Option::is_none")]
    pub metadata: Option<std::collections::HashMap<String, String>>,
}

impl CommitReport {
    pub fn new(
        table_name: String,
        snapshot_id: i64,
        sequence_number: i64,
        operation: String,
        metrics: std::collections::HashMap<String, models::MetricResult>,
    ) -> CommitReport {
        CommitReport {
            table_name,
            snapshot_id,
            sequence_number,
            operation,
            metrics,
            metadata: None,
        }
    }
}
