/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct CommitTableRequest {
    /// Table identifier to update; must be present for CommitTransactionRequest
    #[serde(rename = "identifier", skip_serializing_if = "Option::is_none")]
    pub identifier: Option<Box<models::TableIdentifier>>,
    #[serde(rename = "requirements")]
    pub requirements: Vec<models::TableRequirement>,
    #[serde(rename = "updates")]
    pub updates: Vec<models::TableUpdate>,
}

impl CommitTableRequest {
    pub fn new(
        requirements: Vec<models::TableRequirement>,
        updates: Vec<models::TableUpdate>,
    ) -> CommitTableRequest {
        CommitTableRequest {
            identifier: None,
            requirements,
            updates,
        }
    }
}
