/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[serde(tag = "content")]
pub enum ContentFile {
    #[serde(rename = "data")]
    DataFile {
        #[serde(rename = "file-path")]
        file_path: String,
        #[serde(rename = "file-format")]
        file_format: models::FileFormat,
        #[serde(rename = "spec-id")]
        spec_id: i32,
        /// A list of partition field values ordered based on the fields of the partition spec specified by the `spec-id`
        #[serde(rename = "partition")]
        partition: Vec<models::PrimitiveTypeValue>,
        /// Total file size in bytes
        #[serde(rename = "file-size-in-bytes")]
        file_size_in_bytes: i64,
        /// Number of records in the file
        #[serde(rename = "record-count")]
        record_count: i64,
        /// Encryption key metadata blob
        #[serde(rename = "key-metadata", skip_serializing_if = "Option::is_none")]
        key_metadata: Option<String>,
        /// List of splittable offsets
        #[serde(rename = "split-offsets", skip_serializing_if = "Option::is_none")]
        split_offsets: Option<Vec<i64>>,
        #[serde(rename = "sort-order-id", skip_serializing_if = "Option::is_none")]
        sort_order_id: Option<i32>,
    },
    #[serde(rename = "equality-deletes")]
    EqualityDeleteFile {
        #[serde(rename = "file-path")]
        file_path: String,
        #[serde(rename = "file-format")]
        file_format: models::FileFormat,
        #[serde(rename = "spec-id")]
        spec_id: i32,
        /// A list of partition field values ordered based on the fields of the partition spec specified by the `spec-id`
        #[serde(rename = "partition")]
        partition: Vec<models::PrimitiveTypeValue>,
        /// Total file size in bytes
        #[serde(rename = "file-size-in-bytes")]
        file_size_in_bytes: i64,
        /// Number of records in the file
        #[serde(rename = "record-count")]
        record_count: i64,
        /// Encryption key metadata blob
        #[serde(rename = "key-metadata", skip_serializing_if = "Option::is_none")]
        key_metadata: Option<String>,
        /// List of splittable offsets
        #[serde(rename = "split-offsets", skip_serializing_if = "Option::is_none")]
        split_offsets: Option<Vec<i64>>,
        #[serde(rename = "sort-order-id", skip_serializing_if = "Option::is_none")]
        sort_order_id: Option<i32>,
    },
    #[serde(rename = "position-deletes")]
    PositionDeleteFile {
        #[serde(rename = "file-path")]
        file_path: String,
        #[serde(rename = "file-format")]
        file_format: models::FileFormat,
        #[serde(rename = "spec-id")]
        spec_id: i32,
        /// A list of partition field values ordered based on the fields of the partition spec specified by the `spec-id`
        #[serde(rename = "partition")]
        partition: Vec<models::PrimitiveTypeValue>,
        /// Total file size in bytes
        #[serde(rename = "file-size-in-bytes")]
        file_size_in_bytes: i64,
        /// Number of records in the file
        #[serde(rename = "record-count")]
        record_count: i64,
        /// Encryption key metadata blob
        #[serde(rename = "key-metadata", skip_serializing_if = "Option::is_none")]
        key_metadata: Option<String>,
        /// List of splittable offsets
        #[serde(rename = "split-offsets", skip_serializing_if = "Option::is_none")]
        split_offsets: Option<Vec<i64>>,
        #[serde(rename = "sort-order-id", skip_serializing_if = "Option::is_none")]
        sort_order_id: Option<i32>,
    },
}

impl Default for ContentFile {
    fn default() -> Self {
        Self::DataFile {
            file_path: Default::default(),
            file_format: Default::default(),
            spec_id: Default::default(),
            partition: Default::default(),
            file_size_in_bytes: Default::default(),
            record_count: Default::default(),
            key_metadata: Default::default(),
            split_offsets: Default::default(),
            sort_order_id: Default::default(),
        }
    }
}
