/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct CountMap {
    /// List of integer column ids for each corresponding value
    #[serde(rename = "keys", skip_serializing_if = "Option::is_none")]
    pub keys: Option<Vec<i32>>,
    /// List of Long values, matched to 'keys' by index
    #[serde(rename = "values", skip_serializing_if = "Option::is_none")]
    pub values: Option<Vec<i64>>,
}

impl CountMap {
    pub fn new() -> CountMap {
        CountMap {
            keys: None,
            values: None,
        }
    }
}
