/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateTableRequest {
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "location", skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "schema")]
    pub schema: Box<models::Schema>,
    #[serde(rename = "partition-spec", skip_serializing_if = "Option::is_none")]
    pub partition_spec: Option<Box<models::PartitionSpec>>,
    #[serde(rename = "write-order", skip_serializing_if = "Option::is_none")]
    pub write_order: Option<Box<models::SortOrder>>,
    #[serde(rename = "stage-create", skip_serializing_if = "Option::is_none")]
    pub stage_create: Option<bool>,
    #[serde(rename = "properties", skip_serializing_if = "Option::is_none")]
    pub properties: Option<std::collections::HashMap<String, String>>,
}

impl CreateTableRequest {
    pub fn new(name: String, schema: models::Schema) -> CreateTableRequest {
        CreateTableRequest {
            name,
            location: None,
            schema: Box::new(schema),
            partition_spec: None,
            write_order: None,
            stage_create: None,
            properties: None,
        }
    }
}
