/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct CreateViewRequest {
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "location", skip_serializing_if = "Option::is_none")]
    pub location: Option<String>,
    #[serde(rename = "schema")]
    pub schema: Box<models::Schema>,
    /// The view version to create, will replace the schema-id sent within the view-version with the id assigned to the provided schema
    #[serde(rename = "view-version")]
    pub view_version: Box<models::ViewVersion>,
    #[serde(rename = "properties")]
    pub properties: std::collections::HashMap<String, String>,
}

impl CreateViewRequest {
    pub fn new(
        name: String,
        schema: models::Schema,
        view_version: models::ViewVersion,
        properties: std::collections::HashMap<String, String>,
    ) -> CreateViewRequest {
        CreateViewRequest {
            name,
            location: None,
            schema: Box::new(schema),
            view_version: Box::new(view_version),
            properties,
        }
    }
}
