/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct DataFile {
    #[serde(rename = "content")]
    pub content: String,
    /// The first row ID assigned to the first row in the data file
    #[serde(rename = "first-row-id", skip_serializing_if = "Option::is_none")]
    pub first_row_id: Option<i64>,
    /// Map of column id to total count, including null and NaN
    #[serde(rename = "column-sizes", skip_serializing_if = "Option::is_none")]
    pub column_sizes: Option<Box<models::CountMap>>,
    /// Map of column id to null value count
    #[serde(rename = "value-counts", skip_serializing_if = "Option::is_none")]
    pub value_counts: Option<Box<models::CountMap>>,
    /// Map of column id to null value count
    #[serde(rename = "null-value-counts", skip_serializing_if = "Option::is_none")]
    pub null_value_counts: Option<Box<models::CountMap>>,
    /// Map of column id to number of NaN values in the column
    #[serde(rename = "nan-value-counts", skip_serializing_if = "Option::is_none")]
    pub nan_value_counts: Option<Box<models::CountMap>>,
    /// Map of column id to lower bound primitive type values
    #[serde(rename = "lower-bounds", skip_serializing_if = "Option::is_none")]
    pub lower_bounds: Option<Box<models::ValueMap>>,
    /// Map of column id to upper bound primitive type values
    #[serde(rename = "upper-bounds", skip_serializing_if = "Option::is_none")]
    pub upper_bounds: Option<Box<models::ValueMap>>,
    #[serde(rename = "file-path")]
    pub file_path: String,
    #[serde(rename = "file-format")]
    pub file_format: models::FileFormat,
    #[serde(rename = "spec-id")]
    pub spec_id: i32,
    /// A list of partition field values ordered based on the fields of the partition spec specified by the `spec-id`
    #[serde(rename = "partition")]
    pub partition: Vec<models::PrimitiveTypeValue>,
    /// Total file size in bytes
    #[serde(rename = "file-size-in-bytes")]
    pub file_size_in_bytes: i64,
    /// Number of records in the file
    #[serde(rename = "record-count")]
    pub record_count: i64,
    /// Encryption key metadata blob
    #[serde(rename = "key-metadata", skip_serializing_if = "Option::is_none")]
    pub key_metadata: Option<String>,
    /// List of splittable offsets
    #[serde(rename = "split-offsets", skip_serializing_if = "Option::is_none")]
    pub split_offsets: Option<Vec<i64>>,
    #[serde(rename = "sort-order-id", skip_serializing_if = "Option::is_none")]
    pub sort_order_id: Option<i32>,
}

impl DataFile {
    pub fn new(
        content: String,
        file_path: String,
        file_format: models::FileFormat,
        spec_id: i32,
        partition: Vec<models::PrimitiveTypeValue>,
        file_size_in_bytes: i64,
        record_count: i64,
    ) -> DataFile {
        DataFile {
            content,
            first_row_id: None,
            column_sizes: None,
            value_counts: None,
            null_value_counts: None,
            nan_value_counts: None,
            lower_bounds: None,
            upper_bounds: None,
            file_path,
            file_format,
            spec_id,
            partition,
            file_size_in_bytes,
            record_count,
            key_metadata: None,
            split_offsets: None,
            sort_order_id: None,
        }
    }
}
