/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

/// EmptyPlanningResult : Empty server-side planning result
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct EmptyPlanningResult {
    #[serde(rename = "status")]
    pub status: Status,
}

impl EmptyPlanningResult {
    /// Empty server-side planning result
    pub fn new(status: Status) -> EmptyPlanningResult {
        EmptyPlanningResult { status }
    }
}
///
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum Status {
    #[serde(rename = "completed")]
    Completed,
    #[serde(rename = "submitted")]
    Submitted,
    #[serde(rename = "cancelled")]
    Cancelled,
    #[serde(rename = "failed")]
    Failed,
}

impl Default for Status {
    fn default() -> Status {
        Self::Completed
    }
}
