/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};
use serde_with::serde_as;

use crate::models;

#[serde_as]
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct EncryptedKey {
    #[serde(rename = "key-id")]
    pub key_id: String,
    #[serde_as(as = "serde_with::base64::Base64")]
    #[serde(rename = "encrypted-key-metadata")]
    pub encrypted_key_metadata: Vec<u8>,
    #[serde(rename = "encrypted-by-id", skip_serializing_if = "Option::is_none")]
    pub encrypted_by_id: Option<String>,
    #[serde(rename = "properties", skip_serializing_if = "Option::is_none")]
    pub properties: Option<std::collections::HashMap<String, String>>,
}

impl EncryptedKey {
    pub fn new(key_id: String, encrypted_key_metadata: Vec<u8>) -> EncryptedKey {
        EncryptedKey {
            key_id,
            encrypted_key_metadata,
            encrypted_by_id: None,
            properties: None,
        }
    }
}
