/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct EqualityDeleteFile {
    #[serde(rename = "content")]
    pub content: String,
    /// List of equality field IDs
    #[serde(rename = "equality-ids", skip_serializing_if = "Option::is_none")]
    pub equality_ids: Option<Vec<i32>>,
    #[serde(rename = "file-path")]
    pub file_path: String,
    #[serde(rename = "file-format")]
    pub file_format: models::FileFormat,
    #[serde(rename = "spec-id")]
    pub spec_id: i32,
    /// A list of partition field values ordered based on the fields of the partition spec specified by the `spec-id`
    #[serde(rename = "partition")]
    pub partition: Vec<models::PrimitiveTypeValue>,
    /// Total file size in bytes
    #[serde(rename = "file-size-in-bytes")]
    pub file_size_in_bytes: i64,
    /// Number of records in the file
    #[serde(rename = "record-count")]
    pub record_count: i64,
    /// Encryption key metadata blob
    #[serde(rename = "key-metadata", skip_serializing_if = "Option::is_none")]
    pub key_metadata: Option<String>,
    /// List of splittable offsets
    #[serde(rename = "split-offsets", skip_serializing_if = "Option::is_none")]
    pub split_offsets: Option<Vec<i64>>,
    #[serde(rename = "sort-order-id", skip_serializing_if = "Option::is_none")]
    pub sort_order_id: Option<i32>,
}

impl EqualityDeleteFile {
    pub fn new(
        content: String,
        file_path: String,
        file_format: models::FileFormat,
        spec_id: i32,
        partition: Vec<models::PrimitiveTypeValue>,
        file_size_in_bytes: i64,
        record_count: i64,
    ) -> EqualityDeleteFile {
        EqualityDeleteFile {
            content,
            equality_ids: None,
            file_path,
            file_format,
            spec_id,
            partition,
            file_size_in_bytes,
            record_count,
            key_metadata: None,
            split_offsets: None,
            sort_order_id: None,
        }
    }
}
