/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[serde(untagged)]
pub enum Expression {
    TrueExpression(Box<models::TrueExpression>),
    FalseExpression(Box<models::FalseExpression>),
    AndOrExpression(Box<models::AndOrExpression>),
    NotExpression(Box<models::NotExpression>),
    SetExpression(Box<models::SetExpression>),
    LiteralExpression(Box<models::LiteralExpression>),
    UnaryExpression(Box<models::UnaryExpression>),
}

impl Default for Expression {
    fn default() -> Self {
        Self::TrueExpression(Default::default())
    }
}
