/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

/// FetchPlanningResult : Result of server-side scan planning for fetchPlanningResult
#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[serde(tag = "status")]
pub enum FetchPlanningResult {
    #[serde(rename = "completed")]
    Completed(Box<models::CompletedPlanningResult>),
    #[serde(rename = "failed")]
    Failed(Box<models::FailedPlanningResult>),
    #[serde(rename = "submitted")]
    Submitted(Box<models::EmptyPlanningResult>),
}

impl Default for FetchPlanningResult {
    fn default() -> Self {
        Self::Completed(Default::default())
    }
}
