/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

/// FetchScanTasksResult : Response schema for fetchScanTasks
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct FetchScanTasksResult {
    /// Delete files referenced by file scan tasks
    #[serde(rename = "delete-files", skip_serializing_if = "Option::is_none")]
    pub delete_files: Option<Vec<models::DeleteFile>>,
    #[serde(rename = "file-scan-tasks", skip_serializing_if = "Option::is_none")]
    pub file_scan_tasks: Option<Vec<models::FileScanTask>>,
    #[serde(rename = "plan-tasks", skip_serializing_if = "Option::is_none")]
    pub plan_tasks: Option<Vec<String>>,
}

impl FetchScanTasksResult {
    /// Response schema for fetchScanTasks
    pub fn new() -> FetchScanTasksResult {
        FetchScanTasksResult {
            delete_files: None,
            file_scan_tasks: None,
            plan_tasks: None,
        }
    }
}
