/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

///
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum FileFormat {
    #[serde(rename = "avro")]
    Avro,
    #[serde(rename = "orc")]
    Orc,
    #[serde(rename = "parquet")]
    Parquet,
    #[serde(rename = "puffin")]
    Puffin,
}

impl std::fmt::Display for FileFormat {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        match self {
            Self::Avro => write!(f, "avro"),
            Self::Orc => write!(f, "orc"),
            Self::Parquet => write!(f, "parquet"),
            Self::Puffin => write!(f, "puffin"),
        }
    }
}

impl Default for FileFormat {
    fn default() -> FileFormat {
        Self::Avro
    }
}
