/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct FileScanTask {
    #[serde(rename = "data-file")]
    pub data_file: Box<models::DataFile>,
    /// A list of indices in the delete files array (0-based)
    #[serde(
        rename = "delete-file-references",
        skip_serializing_if = "Option::is_none"
    )]
    pub delete_file_references: Option<Vec<i32>>,
    /// An optional filter to be applied to rows in this file scan task. If the residual is not present, the client must produce the residual or use the original filter.
    #[serde(rename = "residual-filter", skip_serializing_if = "Option::is_none")]
    pub residual_filter: Option<Box<models::Expression>>,
}

impl FileScanTask {
    pub fn new(data_file: models::DataFile) -> FileScanTask {
        FileScanTask {
            data_file: Box::new(data_file),
            delete_file_references: None,
            residual_filter: None,
        }
    }
}
