/*
 * Apache Iceberg REST Catalog API
 *
 * Defines the specification for the first version of the REST Catalog API. Implementations should ideally support both Iceberg table specs v1 and v2, with priority given to v2.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use serde::{Deserialize, Serialize};

use crate::models;

/// OAuthTokenResponse : The `oauth/tokens` endpoint and related schemas are **DEPRECATED for REMOVAL** from this spec, see description of the endpoint.
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct OAuthTokenResponse {
    /// The access token, for client credentials or token exchange
    #[serde(rename = "access_token")]
    pub access_token: String,
    /// Access token type for client credentials or token exchange  See https://datatracker.ietf.org/doc/html/rfc6749#section-7.1
    #[serde(rename = "token_type")]
    pub token_type: TokenType,
    /// Lifetime of the access token in seconds for client credentials or token exchange
    #[serde(rename = "expires_in", skip_serializing_if = "Option::is_none")]
    pub expires_in: Option<i32>,
    #[serde(rename = "issued_token_type", skip_serializing_if = "Option::is_none")]
    pub issued_token_type: Option<models::TokenType>,
    /// Refresh token for client credentials or token exchange
    #[serde(rename = "refresh_token", skip_serializing_if = "Option::is_none")]
    pub refresh_token: Option<String>,
    /// Authorization scope for client credentials or token exchange
    #[serde(rename = "scope", skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
}

impl OAuthTokenResponse {
    /// The `oauth/tokens` endpoint and related schemas are **DEPRECATED for REMOVAL** from this spec, see description of the endpoint.
    pub fn new(access_token: String, token_type: TokenType) -> OAuthTokenResponse {
        OAuthTokenResponse {
            access_token,
            token_type,
            expires_in: None,
            issued_token_type: None,
            refresh_token: None,
            scope: None,
        }
    }
}
/// Access token type for client credentials or token exchange  See https://datatracker.ietf.org/doc/html/rfc6749#section-7.1
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum TokenType {
    #[serde(rename = "bearer")]
    Bearer,
    #[serde(rename = "mac")]
    Mac,
    #[serde(rename = "N_A")]
    NA,
}

impl Default for TokenType {
    fn default() -> TokenType {
        Self::Bearer
    }
}
